/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class TreeItem
extends Item {
    Tree parent;
    Font font;
    Font[] cellFont;
    boolean cached;
    boolean grayed;
    static final int EXPANDER_EXTRA_PADDING = 4;

    public TreeItem(Tree parent, int style) {
        this(TreeItem.checkNull(parent), 0L, style, -1, true);
    }

    public TreeItem(Tree parent, int style, int index) {
        this(TreeItem.checkNull(parent), 0L, style, TreeItem.checkIndex(index), true);
    }

    public TreeItem(TreeItem parentItem, int style) {
        this(TreeItem.checkNull((TreeItem)parentItem).parent, parentItem.handle, style, -1, true);
    }

    public TreeItem(TreeItem parentItem, int style, int index) {
        this(TreeItem.checkNull((TreeItem)parentItem).parent, parentItem.handle, style, TreeItem.checkIndex(index), true);
    }

    TreeItem(Tree parent, long parentIter, int style, int index, boolean create) {
        super(parent, style);
        this.parent = parent;
        if (create) {
            parent.createItem(this, parentIter, index);
        } else {
            this.handle = OS.g_malloc(OS.GtkTreeIter_sizeof());
            OS.gtk_tree_model_iter_nth_child(parent.modelHandle, this.handle, parentIter, index);
        }
    }

    static int checkIndex(int index) {
        if (index < 0) {
            SWT.error(6);
        }
        return index;
    }

    static TreeItem checkNull(TreeItem item) {
        if (item == null) {
            SWT.error(4);
        }
        return item;
    }

    static Tree checkNull(Tree control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    Color _getBackground() {
        long[] ptr = new long[1];
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, 4, ptr, -1);
        if (ptr[0] == 0L) {
            return this.parent.getBackground();
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove(gdkColor, ptr[0], (long)GdkColor.sizeof);
        OS.gdk_color_free(ptr[0]);
        return Color.gtk_new(this.display, gdkColor);
    }

    Color _getBackground(int index) {
        int count = Math.max(1, this.parent.columnCount);
        if (0 > index || index > count - 1) {
            return this._getBackground();
        }
        long[] ptr = new long[1];
        int modelIndex = this.parent.columnCount == 0 ? 6 : this.parent.columns[index].modelIndex;
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, modelIndex + 3, ptr, -1);
        if (ptr[0] == 0L) {
            return this._getBackground();
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove(gdkColor, ptr[0], (long)GdkColor.sizeof);
        OS.gdk_color_free(ptr[0]);
        return Color.gtk_new(this.display, gdkColor);
    }

    boolean _getChecked() {
        int[] ptr = new int[1];
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, 1, ptr, -1);
        return ptr[0] != 0;
    }

    Color _getForeground() {
        long[] ptr = new long[1];
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, 3, ptr, -1);
        if (ptr[0] == 0L) {
            return this.parent.getForeground();
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove(gdkColor, ptr[0], (long)GdkColor.sizeof);
        OS.gdk_color_free(ptr[0]);
        return Color.gtk_new(this.display, gdkColor);
    }

    Color _getForeground(int index) {
        int count = Math.max(1, this.parent.columnCount);
        if (0 > index || index > count - 1) {
            return this._getForeground();
        }
        long[] ptr = new long[1];
        int modelIndex = this.parent.columnCount == 0 ? 6 : this.parent.columns[index].modelIndex;
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, modelIndex + 2, ptr, -1);
        if (ptr[0] == 0L) {
            return this._getForeground();
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove(gdkColor, ptr[0], (long)GdkColor.sizeof);
        OS.gdk_color_free(ptr[0]);
        return Color.gtk_new(this.display, gdkColor);
    }

    Image _getImage(int index) {
        int count = Math.max(1, this.parent.getColumnCount());
        if (0 > index || index > count - 1) {
            return null;
        }
        long[] ptr = new long[1];
        int modelIndex = this.parent.columnCount == 0 ? 6 : this.parent.columns[index].modelIndex;
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, modelIndex + 0, ptr, -1);
        if (ptr[0] == 0L) {
            return null;
        }
        ImageList imageList = this.parent.imageList;
        int imageIndex = imageList.indexOf(ptr[0]);
        OS.g_object_unref(ptr[0]);
        if (imageIndex == -1) {
            return null;
        }
        return imageList.get(imageIndex);
    }

    String _getText(int index) {
        int count = Math.max(1, this.parent.getColumnCount());
        if (0 > index || index > count - 1) {
            return "";
        }
        long[] ptr = new long[1];
        int modelIndex = this.parent.columnCount == 0 ? 6 : this.parent.columns[index].modelIndex;
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, modelIndex + 1, ptr, -1);
        if (ptr[0] == 0L) {
            return "";
        }
        int length = OS.strlen(ptr[0]);
        byte[] buffer = new byte[length];
        OS.memmove(buffer, ptr[0], (long)length);
        OS.g_free(ptr[0]);
        return new String(Converter.mbcsToWcs(null, buffer));
    }

    void clear() {
        if (this.parent.currentItem == this) {
            return;
        }
        if (this.cached || (this.parent.style & 0x10000000) == 0) {
            int i;
            int columnCount = OS.gtk_tree_model_get_n_columns(this.parent.modelHandle);
            for (i = 1; i < 3; ++i) {
                OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, i, 0, -1);
            }
            for (i = 3; i < columnCount; ++i) {
                OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, i, 0L, -1);
            }
        }
        this.cached = false;
        this.font = null;
        this.cellFont = null;
    }

    public void clear(int index, boolean all) {
        this.checkWidget();
        this.parent.clear(this.handle, index, all);
    }

    public void clearAll(boolean all) {
        this.checkWidget();
        this.parent.clearAll(all, this.handle);
    }

    void destroyWidget() {
        this.parent.releaseItem(this, false);
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getBackground();
    }

    public Color getBackground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getBackground(index);
    }

    public Rectangle getBounds(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        long parentHandle = this.parent.handle;
        long column = 0L;
        column = index >= 0 && index < this.parent.columnCount ? this.parent.columns[index].handle : OS.gtk_tree_view_get_column(parentHandle, index);
        if (column == 0L) {
            return new Rectangle(0, 0, 0, 0);
        }
        long path = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        OS.gtk_widget_realize(parentHandle);
        GdkRectangle rect = new GdkRectangle();
        OS.gtk_tree_view_get_cell_area(parentHandle, path, column, rect);
        if ((this.parent.getStyle() & 0x8000000) != 0) {
            rect.x = this.parent.getClientWidth() - rect.width - rect.x;
        }
        OS.gtk_tree_path_free(path);
        if (index == 0 && (this.parent.style & 0x20) != 0) {
            int[] x = new int[1];
            int[] w = new int[1];
            OS.gtk_tree_view_column_cell_get_position(column, this.parent.checkRenderer, x, w);
            rect.x += x[0] + w[0];
            rect.width -= x[0] + w[0];
        }
        int width = OS.gtk_tree_view_column_get_visible(column) ? rect.width + 1 : 0;
        return new Rectangle(rect.x, rect.y, width, rect.height + 1);
    }

    public Rectangle getBounds() {
        long parentHandle;
        long column;
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((column = OS.gtk_tree_view_get_column(parentHandle = this.parent.handle, 0)) == 0L) {
            return new Rectangle(0, 0, 0, 0);
        }
        long textRenderer = this.parent.getTextRenderer(column);
        long pixbufRenderer = this.parent.getPixbufRenderer(column);
        if (textRenderer == 0L || pixbufRenderer == 0L) {
            return new Rectangle(0, 0, 0, 0);
        }
        long path = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        OS.gtk_widget_realize(parentHandle);
        boolean isExpander = OS.gtk_tree_model_iter_n_children(this.parent.modelHandle, this.handle) > 0;
        boolean isExpanded = OS.gtk_tree_view_row_expanded(parentHandle, path);
        OS.gtk_tree_view_column_cell_set_cell_data(column, this.parent.modelHandle, this.handle, isExpander, isExpanded);
        GdkRectangle rect = new GdkRectangle();
        OS.gtk_tree_view_get_cell_area(parentHandle, path, column, rect);
        if ((this.parent.getStyle() & 0x8000000) != 0) {
            rect.x = this.parent.getClientWidth() - rect.width - rect.x;
        }
        int right = rect.x + rect.width;
        int[] x = new int[1];
        int[] w = new int[1];
        this.parent.ignoreSize = true;
        this.gtk_cell_renderer_get_preferred_size(textRenderer, parentHandle, w, null);
        this.parent.ignoreSize = false;
        rect.width = w[0];
        int[] buffer = new int[1];
        OS.gtk_tree_path_free(path);
        OS.gtk_widget_style_get(parentHandle, OS.horizontal_separator, buffer, 0L);
        int horizontalSeparator = buffer[0];
        rect.x += horizontalSeparator;
        OS.gtk_tree_view_column_cell_get_position(column, textRenderer, x, null);
        rect.x += x[0];
        if (this.parent.columnCount > 0 && rect.x + rect.width > right) {
            rect.width = Math.max(0, right - rect.x);
        }
        int width = OS.gtk_tree_view_column_get_visible(column) ? rect.width + 1 : 0;
        return new Rectangle(rect.x, rect.y, width, rect.height + 1);
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this._getChecked();
    }

    public boolean getExpanded() {
        this.checkWidget();
        long path = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        boolean answer = OS.gtk_tree_view_row_expanded(this.parent.handle, path);
        OS.gtk_tree_path_free(path);
        return answer;
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.font != null ? this.font : this.parent.getFont();
    }

    public Font getFont(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (0 > index || index > count - 1) {
            return this.getFont();
        }
        if (this.cellFont == null || this.cellFont[index] == null) {
            return this.getFont();
        }
        return this.cellFont[index];
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getForeground();
    }

    public Color getForeground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getForeground(index);
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.getImage(0);
    }

    public Image getImage(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getImage(index);
    }

    public Rectangle getImageBounds(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        long parentHandle = this.parent.handle;
        long column = 0L;
        column = index >= 0 && index < this.parent.getColumnCount() ? this.parent.columns[index].handle : OS.gtk_tree_view_get_column(parentHandle, index);
        if (column == 0L) {
            return new Rectangle(0, 0, 0, 0);
        }
        long pixbufRenderer = this.parent.getPixbufRenderer(column);
        if (pixbufRenderer == 0L) {
            return new Rectangle(0, 0, 0, 0);
        }
        GdkRectangle rect = new GdkRectangle();
        long path = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        OS.gtk_widget_realize(parentHandle);
        OS.gtk_tree_view_get_cell_area(parentHandle, path, column, rect);
        if ((this.parent.getStyle() & 0x8000000) != 0) {
            rect.x = this.parent.getClientWidth() - rect.width - rect.x;
        }
        OS.gtk_tree_path_free(path);
        int[] x = new int[1];
        int[] w = new int[1];
        OS.gtk_tree_view_column_cell_get_position(column, pixbufRenderer, x, w);
        rect.x += x[0];
        rect.width = w[0];
        int width = OS.gtk_tree_view_column_get_visible(column) ? rect.width : 0;
        return new Rectangle(rect.x, rect.y, width, rect.height + 1);
    }

    public int getItemCount() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return OS.gtk_tree_model_iter_n_children(this.parent.modelHandle, this.handle);
    }

    public TreeItem getItem(int index) {
        int itemCount;
        this.checkWidget();
        if (index < 0) {
            this.error(6);
        }
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (index >= (itemCount = OS.gtk_tree_model_iter_n_children(this.parent.modelHandle, this.handle))) {
            this.error(6);
        }
        return this.parent._getItem(this.handle, index);
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.parent.getItems(this.handle);
    }

    String getNameText() {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return "*virtual*";
        }
        return super.getNameText();
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        long path = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        TreeItem item = null;
        int depth = OS.gtk_tree_path_get_depth(path);
        if (depth > 1) {
            OS.gtk_tree_path_up(path);
            long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
            if (OS.gtk_tree_model_get_iter(this.parent.modelHandle, iter, path)) {
                item = this.parent._getItem(iter);
            }
            OS.g_free(iter);
        }
        OS.gtk_tree_path_free(path);
        return item;
    }

    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.getText(0);
    }

    public String getText(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getText(index);
    }

    public Rectangle getTextBounds(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (0 > index || index > count - 1) {
            return new Rectangle(0, 0, 0, 0);
        }
        long parentHandle = this.parent.handle;
        long column = 0L;
        column = index >= 0 && index < this.parent.columnCount ? this.parent.columns[index].handle : OS.gtk_tree_view_get_column(parentHandle, index);
        if (column == 0L) {
            return new Rectangle(0, 0, 0, 0);
        }
        long textRenderer = this.parent.getTextRenderer(column);
        long pixbufRenderer = this.parent.getPixbufRenderer(column);
        if (textRenderer == 0L || pixbufRenderer == 0L) {
            return new Rectangle(0, 0, 0, 0);
        }
        long path = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        OS.gtk_widget_realize(parentHandle);
        boolean isExpander = OS.gtk_tree_model_iter_n_children(this.parent.modelHandle, this.handle) > 0;
        boolean isExpanded = OS.gtk_tree_view_row_expanded(parentHandle, path);
        OS.gtk_tree_view_column_cell_set_cell_data(column, this.parent.modelHandle, this.handle, isExpander, isExpanded);
        GdkRectangle rect = new GdkRectangle();
        OS.gtk_tree_view_get_cell_area(parentHandle, path, column, rect);
        if ((this.parent.getStyle() & 0x8000000) != 0) {
            rect.x = this.parent.getClientWidth() - rect.width - rect.x;
        }
        int right = rect.x + rect.width;
        int[] x = new int[1];
        int[] w = new int[1];
        this.parent.ignoreSize = true;
        this.gtk_cell_renderer_get_preferred_size(textRenderer, parentHandle, w, null);
        this.parent.ignoreSize = false;
        int[] buffer = new int[1];
        OS.gtk_tree_path_free(path);
        OS.gtk_widget_style_get(parentHandle, OS.horizontal_separator, buffer, 0L);
        int horizontalSeparator = buffer[0];
        rect.x += horizontalSeparator;
        OS.gtk_tree_view_column_cell_get_position(column, textRenderer, x, null);
        rect.x += x[0];
        if (this.parent.columnCount > 0 && rect.x + rect.width > right) {
            rect.width = Math.max(0, right - rect.x);
        }
        int width = OS.gtk_tree_view_column_get_visible(column) ? rect.width + 1 : 0;
        return new Rectangle(rect.x, rect.y, width, rect.height + 1);
    }

    public int indexOf(TreeItem item) {
        long indices;
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        int index = -1;
        boolean isParent = false;
        long currentPath = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        long parentPath = OS.gtk_tree_model_get_path(this.parent.modelHandle, item.handle);
        int depth = OS.gtk_tree_path_get_depth(parentPath);
        if (depth > 1 && OS.gtk_tree_path_up(parentPath) && OS.gtk_tree_path_compare(currentPath, parentPath) == 0L) {
            isParent = true;
        }
        OS.gtk_tree_path_free(currentPath);
        OS.gtk_tree_path_free(parentPath);
        if (!isParent) {
            return index;
        }
        long path = OS.gtk_tree_model_get_path(this.parent.modelHandle, item.handle);
        if (depth > 1 && (indices = OS.gtk_tree_path_get_indices(path)) != 0L) {
            int[] temp = new int[depth];
            OS.memmove(temp, indices, (long)(4 * temp.length));
            index = temp[temp.length - 1];
        }
        OS.gtk_tree_path_free(path);
        return index;
    }

    void releaseChildren(boolean destroy) {
        if (destroy) {
            this.parent.releaseItems(this.handle);
        }
        super.releaseChildren(destroy);
    }

    void releaseHandle() {
        if (this.handle != 0L) {
            OS.g_free(this.handle);
        }
        this.handle = 0L;
        super.releaseHandle();
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.font = null;
        this.cellFont = null;
    }

    public void removeAll() {
        this.checkWidget();
        long modelHandle = this.parent.modelHandle;
        int length = OS.gtk_tree_model_iter_n_children(modelHandle, this.handle);
        if (length == 0) {
            return;
        }
        long iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (iter == 0L) {
            this.error(2);
        }
        if (this.parent.fixAccessibility()) {
            this.parent.ignoreAccessibility = true;
        }
        long selection = OS.gtk_tree_view_get_selection(this.parent.handle);
        int[] value = new int[1];
        while (OS.gtk_tree_model_iter_children(modelHandle, iter, this.handle)) {
            Widget item;
            OS.gtk_tree_model_get(modelHandle, iter, 0, value, -1);
            Widget widget = item = value[0] != -1 ? this.parent.items[value[0]] : null;
            if (item != null && !item.isDisposed()) {
                item.dispose();
                continue;
            }
            OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
            OS.gtk_tree_store_remove(modelHandle, iter);
            OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        }
        if (this.parent.fixAccessibility()) {
            this.parent.ignoreAccessibility = false;
            OS.g_object_notify(this.parent.handle, OS.model);
        }
        OS.g_free(iter);
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        if (this._getBackground().equals(color)) {
            return;
        }
        GdkColor gdkColor = color != null ? color.handle : null;
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, 4, gdkColor, -1);
        this.cached = true;
    }

    public void setBackground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        if (this._getBackground(index).equals(color)) {
            return;
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (0 > index || index > count - 1) {
            return;
        }
        int modelIndex = this.parent.columnCount == 0 ? 6 : this.parent.columns[index].modelIndex;
        GdkColor gdkColor = color != null ? color.handle : null;
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, modelIndex + 3, gdkColor, -1);
        this.cached = true;
        if (color != null) {
            boolean customDraw;
            boolean bl = customDraw = this.parent.columnCount == 0 ? this.parent.firstCustomDraw : this.parent.columns[index].customDraw;
            if (!customDraw) {
                if ((this.parent.style & 0x10000000) == 0) {
                    long parentHandle = this.parent.handle;
                    long column = 0L;
                    column = this.parent.columnCount > 0 ? this.parent.columns[index].handle : OS.gtk_tree_view_get_column(parentHandle, index);
                    if (column == 0L) {
                        return;
                    }
                    long textRenderer = this.parent.getTextRenderer(column);
                    long imageRenderer = this.parent.getPixbufRenderer(column);
                    OS.gtk_tree_view_column_set_cell_data_func(column, textRenderer, this.display.cellDataProc, parentHandle, 0L);
                    OS.gtk_tree_view_column_set_cell_data_func(column, imageRenderer, this.display.cellDataProc, parentHandle, 0L);
                }
                if (this.parent.columnCount == 0) {
                    this.parent.firstCustomDraw = true;
                } else {
                    this.parent.columns[index].customDraw = true;
                }
            }
        }
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this._getChecked() == checked) {
            return;
        }
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, 1, checked, -1);
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, 2, !checked ? false : this.grayed, -1);
        this.cached = true;
    }

    public void setExpanded(boolean expanded) {
        this.checkWidget();
        long path = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        if (expanded != OS.gtk_tree_view_row_expanded(this.parent.handle, path)) {
            if (expanded) {
                OS.g_signal_handlers_block_matched(this.parent.handle, 16, 0, 0, 0L, 0L, 51L);
                OS.gtk_tree_view_expand_row(this.parent.handle, path, false);
                OS.g_signal_handlers_unblock_matched(this.parent.handle, 16, 0, 0, 0L, 0L, 51L);
            } else {
                OS.g_signal_handlers_block_matched(this.parent.handle, 16, 0, 0, 0L, 0L, 50L);
                OS.gtk_widget_realize(this.parent.handle);
                OS.gtk_tree_view_collapse_row(this.parent.handle, path);
                OS.g_signal_handlers_unblock_matched(this.parent.handle, 16, 0, 0, 0L, 0L, 50L);
            }
        }
        OS.gtk_tree_path_free(path);
    }

    public void setFont(Font font) {
        Font oldFont;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        if ((oldFont = this.font) == font) {
            return;
        }
        this.font = font;
        if (oldFont != null && oldFont.equals(font)) {
            return;
        }
        long fontHandle = font != null ? font.handle : 0L;
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, 5, fontHandle, -1);
        this.cached = true;
    }

    public void setFont(int index, Font font) {
        Font oldFont;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (0 > index || index > count - 1) {
            return;
        }
        if (this.cellFont == null) {
            if (font == null) {
                return;
            }
            this.cellFont = new Font[count];
        }
        if ((oldFont = this.cellFont[index]) == font) {
            return;
        }
        this.cellFont[index] = font;
        if (oldFont != null && oldFont.equals(font)) {
            return;
        }
        int modelIndex = this.parent.columnCount == 0 ? 6 : this.parent.columns[index].modelIndex;
        long fontHandle = font != null ? font.handle : 0L;
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, modelIndex + 4, fontHandle, -1);
        this.cached = true;
        if (font != null) {
            boolean customDraw;
            boolean bl = customDraw = this.parent.columnCount == 0 ? this.parent.firstCustomDraw : this.parent.columns[index].customDraw;
            if (!customDraw) {
                if ((this.parent.style & 0x10000000) == 0) {
                    long parentHandle = this.parent.handle;
                    long column = 0L;
                    column = this.parent.columnCount > 0 ? this.parent.columns[index].handle : OS.gtk_tree_view_get_column(parentHandle, index);
                    if (column == 0L) {
                        return;
                    }
                    long textRenderer = this.parent.getTextRenderer(column);
                    long imageRenderer = this.parent.getPixbufRenderer(column);
                    OS.gtk_tree_view_column_set_cell_data_func(column, textRenderer, this.display.cellDataProc, parentHandle, 0L);
                    OS.gtk_tree_view_column_set_cell_data_func(column, imageRenderer, this.display.cellDataProc, parentHandle, 0L);
                }
                if (this.parent.columnCount == 0) {
                    this.parent.firstCustomDraw = true;
                } else {
                    this.parent.columns[index].customDraw = true;
                }
            }
        }
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        if (this._getForeground().equals(color)) {
            return;
        }
        GdkColor gdkColor = color != null ? color.handle : null;
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, 3, gdkColor, -1);
        this.cached = true;
    }

    public void setForeground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        if (this._getForeground(index).equals(color)) {
            return;
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (0 > index || index > count - 1) {
            return;
        }
        int modelIndex = this.parent.columnCount == 0 ? 6 : this.parent.columns[index].modelIndex;
        GdkColor gdkColor = color != null ? color.handle : null;
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, modelIndex + 2, gdkColor, -1);
        this.cached = true;
        if (color != null) {
            boolean customDraw;
            boolean bl = customDraw = this.parent.columnCount == 0 ? this.parent.firstCustomDraw : this.parent.columns[index].customDraw;
            if (!customDraw) {
                if ((this.parent.style & 0x10000000) == 0) {
                    long parentHandle = this.parent.handle;
                    long column = 0L;
                    column = this.parent.columnCount > 0 ? this.parent.columns[index].handle : OS.gtk_tree_view_get_column(parentHandle, index);
                    if (column == 0L) {
                        return;
                    }
                    long textRenderer = this.parent.getTextRenderer(column);
                    long imageRenderer = this.parent.getPixbufRenderer(column);
                    OS.gtk_tree_view_column_set_cell_data_func(column, textRenderer, this.display.cellDataProc, parentHandle, 0L);
                    OS.gtk_tree_view_column_set_cell_data_func(column, imageRenderer, this.display.cellDataProc, parentHandle, 0L);
                }
                if (this.parent.columnCount == 0) {
                    this.parent.firstCustomDraw = true;
                } else {
                    this.parent.columns[index].customDraw = true;
                }
            }
        }
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.grayed == grayed) {
            return;
        }
        this.grayed = grayed;
        int[] ptr = new int[1];
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, 1, ptr, -1);
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, 2, ptr[0] == 0 ? false : grayed, -1);
        this.cached = true;
    }

    public void setImage(int index, Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (image != null && image.type == 1 && image.equals(this._getImage(index))) {
            return;
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (0 > index || index > count - 1) {
            return;
        }
        long pixbuf = 0L;
        if (image != null) {
            int imageIndex;
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            if ((imageIndex = imageList.indexOf(image)) == -1) {
                imageIndex = imageList.add(image);
            }
            pixbuf = imageList.getPixbuf(imageIndex);
        }
        int modelIndex = this.parent.columnCount == 0 ? 6 : this.parent.columns[index].modelIndex;
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, modelIndex + 0, pixbuf, -1);
        if ((this.parent.style & 0x10000000) != 0 && this.parent.currentItem == null && image != null) {
            long parentHandle = this.parent.handle;
            long column = OS.gtk_tree_view_get_column(parentHandle, index);
            int[] w = new int[1];
            long pixbufRenderer = this.parent.getPixbufRenderer(column);
            OS.gtk_tree_view_column_cell_get_position(column, pixbufRenderer, null, w);
            if (w[0] < image.getBounds().width && !OS.GTK3) {
                long style = OS.gtk_widget_get_modifier_style(parentHandle);
                this.parent.modifyStyle(parentHandle, style);
            }
        }
        this.cached = true;
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setImage(Image[] images) {
        this.checkWidget();
        if (images == null) {
            this.error(4);
        }
        for (int i = 0; i < images.length; ++i) {
            this.setImage(i, images[i]);
        }
    }

    public void setItemCount(int count) {
        this.checkWidget();
        count = Math.max(0, count);
        this.parent.setItemCount(this.handle, count);
    }

    public void setText(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this._getText(index).equals(string)) {
            return;
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (0 > index || index > count - 1) {
            return;
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        int modelIndex = this.parent.columnCount == 0 ? 6 : this.parent.columns[index].modelIndex;
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, modelIndex + 1, buffer, -1);
        this.cached = true;
    }

    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }

    public void setText(String[] strings) {
        this.checkWidget();
        if (strings == null) {
            this.error(4);
        }
        for (int i = 0; i < strings.length; ++i) {
            String string = strings[i];
            if (string == null) continue;
            this.setText(i, string);
        }
    }
}

