/*
 * Decompiled with CFR 0.152.
 */
package Snmp2;

import Snmp2.LeafSyntax;
import Snmp2.MibException;
import Snmp2.MibModule;
import Snmp2.MibModuleCompliance;
import Snmp2.MibNode;
import Snmp2.MibTrap;
import Snmp2.SnmpOID;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Vector;

public class MibMacro {
    public String name;
    public static boolean isSMIv2;
    boolean syntaxFound = false;
    boolean writeSyntaxFound = false;
    boolean minAccessFound = false;
    private String objectType = "OBJECT-TYPE";
    private String moduleIdentity = "MODULE-IDENTITY";
    private String objectIdentity = "OBJECT-IDENTITY";
    private String notificationType = "NOTIFICATION-TYPE";
    private String moduleCompliance = "MODULE-COMPLIANCE";
    private String objectGroup = "OBJECT-GROUP";
    private String notificationGroup = "NOTIFICATION-GROUP";
    private String agentCapabilities = "AGENT-CAPABILITIES";

    public MibMacro(String nam, Vector toks) {
        this.name = nam;
    }

    public Object parseMacro(String label, String nam, MibModule module, StreamTokenizer tok) throws MibException, IOException {
        isSMIv2 = false;
        if (!this.name.equals(nam)) {
            return null;
        }
        if (this.name.equals("OBJECT-TYPE")) {
            return this.parseObjectType(label, module, tok);
        }
        if (this.name.equals("TRAP-TYPE")) {
            return this.parseTrapType(label, module, tok);
        }
        if (this.name.equals("MODULE-IDENTITY")) {
            return this.parseModuleIdentity(label, module, tok);
        }
        if (this.name.equals("OBJECT-IDENTITY")) {
            return this.parseObjectIdentity(label, module, tok);
        }
        if (this.name.equals("NOTIFICATION-TYPE")) {
            return this.parseNotificationType(label, module, tok);
        }
        if (this.name.equals("MODULE-COMPLIANCE")) {
            return this.parseModuleCompliance(label, module, tok);
        }
        if (this.name.equals("OBJECT-GROUP")) {
            return this.parseObjectGroup(label, module, tok);
        }
        if (this.name.equals("NOTIFICATION-GROUP")) {
            return this.parseNotificationGroup(label, module, tok);
        }
        if (this.name.equals("AGENT-CAPABILITIES")) {
            return this.parseAgentCapabilities(label, module, tok);
        }
        return null;
    }

    public MibNode parseObjectType(String label, MibModule module, StreamTokenizer tok) throws MibException, IOException {
        MibNode node = new MibNode();
        node.macroType = this.objectType;
        isSMIv2 = true;
        node.label = label;
        Vector toks = new Vector();
        String currentToken = null;
        currentToken = module.getToken(tok);
        if (currentToken == null) {
            module.errorToken("OBJECT-TYPE: Unexpected end of data", tok);
        }
        while (!currentToken.equals("::=")) {
            if (currentToken.equals("UNITS")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("OBJECT-TYPE: Unexpected end of data", tok);
                }
                node.units = currentToken;
            } else if (currentToken.equals("SYNTAX")) {
                this.parseOTSyntax(module, tok, node);
            } else if (currentToken.equals("ACCESS") || currentToken.equals("MAX-ACCESS")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("OBJECT-TYPE: Unexpected end of data", tok);
                }
                node.access = this.parseACCESS(module, currentToken);
                if (node.access == -1) {
                    module.errorToken("OBJECT-TYPE, ACCESS, unrecognized.", tok);
                }
            } else if (currentToken.equals("STATUS")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("OBJECT-TYPE: Unexpected end of data", tok);
                }
                node.status = currentToken;
            } else if (currentToken.equals("DESCRIPTION")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("OBJECT-TYPE: Unexpected end of data", tok);
                }
                node.description = currentToken;
            } else if (currentToken.equals("REFERENCE")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("OBJECT-TYPE: Unexpected end of data", tok);
                }
                node.reference = currentToken;
            } else if (currentToken.equals("INDEX") || currentToken.equals("AUGMENTS")) {
                node.indexNames = this.parseINDEX(module, tok);
            } else if (currentToken.equals("DEFVAL")) {
                node.defval = this.parseDEFVAL(module, tok);
            } else {
                module.errorToken("OBJECT-TYPE: Unexpected word in macro", tok);
            }
            currentToken = module.getToken(tok);
            if (currentToken != null) continue;
            module.errorToken("OBJECT-TYPE: Unexpected end of data", tok);
        }
        Vector oid = module.parseOID(tok);
        if (oid == null) {
            module.errorToken("Unable to parse OBJECT IDENTIFIER.", tok);
        }
        try {
            node.subid = new Double((String)oid.lastElement()).longValue();
        }
        catch (NumberFormatException numberFormatException) {
            module.errorToken("OID: Cannot parse Sub-ID", tok);
        }
        oid.removeElement(oid.lastElement());
        node.parent = module.getNode(oid);
        if (node.parent == null) {
            module.errorToken("MIB node has no parent", tok);
        } else {
            int i = 0;
            while (i < node.parent.childList.size()) {
                if (((MibNode)node.parent.childList.elementAt((int)i)).label.equals(label)) {
                    ((MibNode)node.parent.childList.elementAt((int)i)).moduleName = String.valueOf(((MibNode)node.parent.childList.elementAt((int)i)).moduleName) + " " + module.name;
                    module.changeRoot((MibNode)node.parent.childList.elementAt(i), tok);
                    return null;
                }
                ++i;
            }
            if (i == node.parent.childList.size()) {
                node.parent.childList.addElement(node);
            }
        }
        module.changeRoot(node, tok);
        return node;
    }

    public MibTrap parseTrapType(String label, MibModule module, StreamTokenizer tok) throws MibException, IOException {
        MibTrap trap = new MibTrap();
        trap.name = label;
        Vector toks = new Vector();
        String currentToken = null;
        currentToken = module.getToken(tok);
        if (currentToken == null) {
            module.errorToken("TRAP-TYPE: Unexpected end of data", tok);
        }
        while (!currentToken.equals("::=")) {
            if (currentToken.equals("VARIABLES")) {
                this.parseTrapVariables(module, tok, trap);
            } else if (currentToken.equals("ENTERPRISE")) {
                MibNode node;
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("TRAP-TYPE: Unexpected end of data", tok);
                }
                boolean entBraced = false;
                if (currentToken.equals("{")) {
                    entBraced = true;
                    currentToken = module.getToken(tok);
                    if (currentToken == null) {
                        module.errorToken("TRAP-TYPE: Unexpected end of data", tok);
                    }
                }
                if ((node = (MibNode)MibModule.nodeList.get(String.valueOf(module.name) + "::=" + currentToken)) == null) {
                    node = (MibNode)MibModule.nodeList.get("INIT::=" + currentToken);
                }
                if (currentToken.equals("snmp")) {
                    trap.enterprise = new SnmpOID("11");
                } else if (node != null) {
                    trap.enterprise = new SnmpOID(node.getNumberedOIDString());
                }
                trap.enterpriseString = currentToken;
                if (entBraced && (currentToken = module.getToken(tok)) == null) {
                    module.errorToken("TRAP-TYPE: Unexpected end of data", tok);
                }
            } else if (currentToken.equals("DESCRIPTION")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("TRAP-TYPE: Unexpected end of data", tok);
                }
                trap.description = currentToken;
            } else if (currentToken.equals("REFERENCE")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("TRAP-TYPE: Unexpected end of data", tok);
                }
                trap.reference = currentToken;
            } else {
                module.errorToken("TRAP-TYPE: Unexpected word in macro", tok);
            }
            currentToken = module.getToken(tok);
            if (currentToken != null) continue;
            module.errorToken("TRAP-TYPE: Unexpected end of data", tok);
        }
        currentToken = module.getToken(tok);
        if (currentToken == null) {
            module.errorToken("TRAP-TYPE: Unexpected end of data", tok);
        }
        trap.value = new Integer(currentToken);
        return trap;
    }

    public MibNode parseModuleIdentity(String label, MibModule module, StreamTokenizer tok) throws MibException, IOException {
        boolean revisionencountered = false;
        MibNode node = new MibNode();
        node.macroType = this.moduleIdentity;
        isSMIv2 = true;
        node.label = label;
        Vector toks = new Vector();
        String currentToken = null;
        currentToken = module.getToken(tok);
        if (currentToken == null) {
            module.errorToken("MODULE-IDENTITY: Unexpected end of data", tok);
        }
        while (!currentToken.equals("::=")) {
            if (currentToken.equals("LAST-UPDATED")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("MODULE-IDENTITY: Unexpected end of data", tok);
                }
                node.lastupdated = currentToken;
            } else if (currentToken.equals("ORGANIZATION")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("MODULE-IDENTITY: Unexpected end of data", tok);
                }
                node.organization = currentToken;
            } else if (currentToken.equals("CONTACT-INFO")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("MODULE-IDENTITY: Unexpected end of data", tok);
                }
                node.contactinfo = currentToken;
            } else if (currentToken.equals("DESCRIPTION")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("MODULE-IDENTITY: Unexpected end of data", tok);
                }
                if (revisionencountered) {
                    node.revdescription = currentToken;
                    revisionencountered = false;
                } else {
                    node.description = currentToken;
                }
            } else if (currentToken.equals("REVISION")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("MODULE-IDENTITY: Unexpected end of data", tok);
                }
                node.revision = currentToken;
                revisionencountered = true;
            } else {
                module.errorToken("MODULE-IDENTITY: Unexpected word in macro", tok);
            }
            currentToken = module.getToken(tok);
            if (currentToken != null) continue;
            module.errorToken("MODULE-IDENTITY: Unexpected end of data", tok);
        }
        Vector oid = module.parseOID(tok);
        if (oid == null) {
            module.errorToken("Unable to parse OBJECT IDENTIFIER.", tok);
        }
        try {
            node.subid = new Long((String)oid.lastElement());
        }
        catch (NumberFormatException numberFormatException) {
            module.errorToken("OID: Cannot parse Sub-ID", tok);
        }
        oid.removeElement(oid.lastElement());
        node.parent = module.getNode(oid);
        if (node.parent == null) {
            module.errorToken("MIB node has no parent", tok);
        } else {
            int i = 0;
            while (i < node.parent.childList.size()) {
                if (((MibNode)node.parent.childList.elementAt((int)i)).label.equals(label)) {
                    ((MibNode)node.parent.childList.elementAt((int)i)).moduleName = String.valueOf(((MibNode)node.parent.childList.elementAt((int)i)).moduleName) + " " + module.name;
                    module.changeRoot((MibNode)node.parent.childList.elementAt(i), tok);
                    return null;
                }
                ++i;
            }
            if (i == node.parent.childList.size()) {
                node.parent.childList.addElement(node);
            }
        }
        module.changeRoot(node, tok);
        return node;
    }

    public MibNode parseObjectIdentity(String label, MibModule module, StreamTokenizer tok) throws MibException, IOException {
        MibNode node = new MibNode();
        node.macroType = this.objectIdentity;
        isSMIv2 = true;
        node.label = label;
        Vector toks = new Vector();
        String currentToken = null;
        currentToken = module.getToken(tok);
        if (currentToken == null) {
            module.errorToken("OBJECT-IDENTITY: Unexpected end of data", tok);
        }
        while (!currentToken.equals("::=")) {
            if (currentToken.equals("STATUS")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("OBJECT-IDENTITY: Unexpected end of data", tok);
                }
                node.status = currentToken;
            } else if (currentToken.equals("DESCRIPTION")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("OBJECT-IDENTITY: Unexpected end of data", tok);
                }
                node.description = currentToken;
            } else if (currentToken.equals("REFERENCE")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("OBJECT-IDENTITY: Unexpected end of data", tok);
                }
                node.reference = currentToken;
            } else {
                module.errorToken("OBJECT-IDENTITY: Unexpected word in macro", tok);
            }
            currentToken = module.getToken(tok);
            if (currentToken != null) continue;
            module.errorToken("OBJECT-IDENTITY: Unexpected end of data", tok);
        }
        Vector oid = module.parseOID(tok);
        if (oid == null) {
            module.errorToken("Unable to parse OBJECT IDENTIFIER.", tok);
        }
        try {
            node.subid = new Long((String)oid.lastElement());
        }
        catch (NumberFormatException numberFormatException) {
            module.errorToken("OID: Cannot parse Sub-ID", tok);
        }
        oid.removeElement(oid.lastElement());
        node.parent = module.getNode(oid);
        if (node.parent == null) {
            module.errorToken("MIB node has no parent", tok);
        } else {
            int i = 0;
            while (i < node.parent.childList.size()) {
                if (((MibNode)node.parent.childList.elementAt((int)i)).label.equals(label)) {
                    ((MibNode)node.parent.childList.elementAt((int)i)).moduleName = String.valueOf(((MibNode)node.parent.childList.elementAt((int)i)).moduleName) + " " + module.name;
                    module.changeRoot((MibNode)node.parent.childList.elementAt(i), tok);
                    return null;
                }
                ++i;
            }
            if (i == node.parent.childList.size()) {
                node.parent.childList.addElement(node);
            }
        }
        module.changeRoot(node, tok);
        return node;
    }

    public MibNode parseNotificationType(String label, MibModule module, StreamTokenizer tok) throws MibException, IOException {
        MibNode node = new MibNode();
        node.macroType = this.notificationType;
        isSMIv2 = true;
        node.label = label;
        Vector toks = new Vector();
        String currentToken = null;
        currentToken = module.getToken(tok);
        if (currentToken == null) {
            module.errorToken("NOTIFICATION-TYPE: Unexpected end of data", tok);
        }
        while (!currentToken.equals("::=")) {
            if (currentToken.equals("OBJECTS")) {
                node.objectNames = this.parseOBJECTS(module, tok);
            } else if (currentToken.equals("STATUS")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("NOTIFICATION-TYPE: Unexpected end of data", tok);
                }
                node.status = currentToken;
            } else if (currentToken.equals("DESCRIPTION")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("NOTIFICATION-TYPE: Unexpected end of data", tok);
                }
                node.description = currentToken;
            } else if (currentToken.equals("REFERENCE")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("OBJECT-TYPE: Unexpected end of data", tok);
                }
                node.reference = currentToken;
            } else {
                module.errorToken("NOTIFICATION-TYPE: Unexpected word in macro", tok);
            }
            currentToken = module.getToken(tok);
            if (currentToken != null) continue;
            module.errorToken("NOTIFICATION-TYPE: Unexpected end of data", tok);
        }
        Vector oid = module.parseOID(tok);
        if (oid == null) {
            module.errorToken("Unable to parse OBJECT IDENTIFIER.", tok);
        }
        try {
            node.subid = new Long((String)oid.lastElement());
        }
        catch (NumberFormatException numberFormatException) {
            module.errorToken("OID: Cannot parse Sub-ID", tok);
        }
        oid.removeElement(oid.lastElement());
        node.parent = module.getNode(oid);
        if (node.parent == null) {
            module.errorToken("MIB node has no parent", tok);
        } else {
            int i = 0;
            while (i < node.parent.childList.size()) {
                if (((MibNode)node.parent.childList.elementAt((int)i)).label.equals(label)) {
                    ((MibNode)node.parent.childList.elementAt((int)i)).moduleName = String.valueOf(((MibNode)node.parent.childList.elementAt((int)i)).moduleName) + " " + module.name;
                    module.changeRoot((MibNode)node.parent.childList.elementAt(i), tok);
                    return null;
                }
                ++i;
            }
            if (i == node.parent.childList.size()) {
                node.parent.childList.addElement(node);
            }
        }
        module.changeRoot(node, tok);
        return node;
    }

    public MibNode parseModuleCompliance(String label, MibModule module, StreamTokenizer tok) throws MibException, IOException {
        MibNode node = new MibNode();
        node.macroType = this.moduleCompliance;
        isSMIv2 = true;
        node.label = label;
        Vector toks = new Vector();
        String currentToken = null;
        currentToken = module.getToken(tok);
        if (currentToken == null) {
            module.errorToken("MODULE-COMPLIANCE: Unexpected end of data", tok);
        }
        while (!currentToken.equals("::=")) {
            if (currentToken.equals("STATUS")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("MODULE-COMPLIANCE: Unexpected end of data", tok);
                }
                node.status = currentToken;
            } else if (currentToken.equals("DESCRIPTION")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("MODULE-COMPLIANCE: Unexpected end of data", tok);
                }
                node.description = currentToken;
            } else if (currentToken.equals("REFERENCE")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("MODULE-COMPLIANCE: Unexpected end of data", tok);
                }
                node.reference = currentToken;
            } else if (currentToken.equals("MODULE")) {
                node.moduleCompliance.addElement(this.parseMODULE(module, tok));
            } else {
                module.errorToken("MODULE-COMPLIANCE: Unexpected word in macro", tok);
            }
            currentToken = module.getToken(tok);
            if (currentToken != null) continue;
            module.errorToken("MODULE-COMPLIANCE: Unexpected end of data", tok);
        }
        Vector oid = module.parseOID(tok);
        if (oid == null) {
            module.errorToken("Unable to parse OBJECT IDENTIFIER.", tok);
        }
        try {
            node.subid = new Long((String)oid.lastElement());
        }
        catch (NumberFormatException numberFormatException) {
            module.errorToken("OID: Cannot parse Sub-ID", tok);
        }
        oid.removeElement(oid.lastElement());
        node.parent = module.getNode(oid);
        if (node.parent == null) {
            module.errorToken("MIB node has no parent", tok);
        } else {
            int i = 0;
            while (i < node.parent.childList.size()) {
                if (((MibNode)node.parent.childList.elementAt((int)i)).label.equals(label)) {
                    ((MibNode)node.parent.childList.elementAt((int)i)).moduleName = String.valueOf(((MibNode)node.parent.childList.elementAt((int)i)).moduleName) + " " + module.name;
                    module.changeRoot((MibNode)node.parent.childList.elementAt(i), tok);
                    return null;
                }
                ++i;
            }
            if (i == node.parent.childList.size()) {
                node.parent.childList.addElement(node);
            }
        }
        module.changeRoot(node, tok);
        return node;
    }

    public MibNode parseObjectGroup(String label, MibModule module, StreamTokenizer tok) throws MibException, IOException {
        MibNode node = new MibNode();
        node.macroType = this.objectGroup;
        isSMIv2 = true;
        node.label = label;
        Vector toks = new Vector();
        String currentToken = null;
        currentToken = module.getToken(tok);
        if (currentToken == null) {
            module.errorToken("OBJECT-GROUP: Unexpected end of data", tok);
        }
        while (!currentToken.equals("::=")) {
            if (currentToken.equals("OBJECTS")) {
                node.objectNames = this.parseOBJECTS(module, tok);
            } else if (currentToken.equals("STATUS")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("OBJECT-GROUP: Unexpected end of data", tok);
                }
                node.status = currentToken;
            } else if (currentToken.equals("DESCRIPTION")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("OBJECT-GROUP: Unexpected end of data", tok);
                }
                node.description = currentToken;
            } else if (currentToken.equals("REFERENCE")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("OBJECT-GROUP: Unexpected end of data", tok);
                }
                node.reference = currentToken;
            } else {
                module.errorToken("OBJECT-GROUP: Unexpected word in macro", tok);
            }
            currentToken = module.getToken(tok);
            if (currentToken != null) continue;
            module.errorToken("OBJECT-GROUP: Unexpected end of data", tok);
        }
        Vector oid = module.parseOID(tok);
        if (oid == null) {
            module.errorToken("Unable to parse OBJECT IDENTIFIER.", tok);
        }
        try {
            node.subid = new Long((String)oid.lastElement());
        }
        catch (NumberFormatException numberFormatException) {
            module.errorToken("OID: Cannot parse Sub-ID", tok);
        }
        oid.removeElement(oid.lastElement());
        node.parent = module.getNode(oid);
        if (node.parent == null) {
            module.errorToken("MIB node has no parent", tok);
        } else {
            int i = 0;
            while (i < node.parent.childList.size()) {
                if (((MibNode)node.parent.childList.elementAt((int)i)).label.equals(label)) {
                    ((MibNode)node.parent.childList.elementAt((int)i)).moduleName = String.valueOf(((MibNode)node.parent.childList.elementAt((int)i)).moduleName) + " " + module.name;
                    module.changeRoot((MibNode)node.parent.childList.elementAt(i), tok);
                    return null;
                }
                ++i;
            }
            if (i == node.parent.childList.size()) {
                node.parent.childList.addElement(node);
            }
        }
        module.changeRoot(node, tok);
        return node;
    }

    public MibNode parseNotificationGroup(String label, MibModule module, StreamTokenizer tok) throws MibException, IOException {
        MibNode node = new MibNode();
        node.macroType = this.notificationGroup;
        isSMIv2 = true;
        node.label = label;
        Vector toks = new Vector();
        String currentToken = null;
        currentToken = module.getToken(tok);
        if (currentToken == null) {
            module.errorToken("NOTIFICATION-GROUP: Unexpected end of data", tok);
        }
        while (!currentToken.equals("::=")) {
            if (currentToken.equals("NOTIFICATIONS")) {
                node.notificationsNames = this.parseNOTIFICATIONS(module, tok);
            } else if (currentToken.equals("STATUS")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("NOTIFICATION-GROUP: Unexpected end of data", tok);
                }
                node.status = currentToken;
            } else if (currentToken.equals("DESCRIPTION")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("NOTIFICATION-GROUP: Unexpected end of data", tok);
                }
                node.description = currentToken;
            } else if (currentToken.equals("REFERENCE")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("NOTIFICATION-GROUP: Unexpected end of data", tok);
                }
                node.reference = currentToken;
            } else {
                module.errorToken("NOTIFICATION-GROUP: Unexpected word in macro", tok);
            }
            currentToken = module.getToken(tok);
            if (currentToken != null) continue;
            module.errorToken("NOTIFICATION-GROUP: Unexpected end of data", tok);
        }
        Vector oid = module.parseOID(tok);
        if (oid == null) {
            module.errorToken("Unable to parse OBJECT IDENTIFIER.", tok);
        }
        try {
            node.subid = new Long((String)oid.lastElement());
        }
        catch (NumberFormatException numberFormatException) {
            module.errorToken("OID: Cannot parse Sub-ID", tok);
        }
        oid.removeElement(oid.lastElement());
        node.parent = module.getNode(oid);
        if (node.parent == null) {
            module.errorToken("MIB node has no parent", tok);
        } else {
            int i = 0;
            while (i < node.parent.childList.size()) {
                if (((MibNode)node.parent.childList.elementAt((int)i)).label.equals(label)) {
                    ((MibNode)node.parent.childList.elementAt((int)i)).moduleName = String.valueOf(((MibNode)node.parent.childList.elementAt((int)i)).moduleName) + " " + module.name;
                    module.changeRoot((MibNode)node.parent.childList.elementAt(i), tok);
                    return null;
                }
                ++i;
            }
            if (i == node.parent.childList.size()) {
                node.parent.childList.addElement(node);
            }
        }
        module.changeRoot(node, tok);
        return node;
    }

    public MibNode parseAgentCapabilities(String label, MibModule module, StreamTokenizer tok) throws MibException, IOException {
        MibNode node = new MibNode();
        node.macroType = this.agentCapabilities;
        isSMIv2 = true;
        node.label = label;
        Vector toks = new Vector();
        String currentToken = null;
        currentToken = module.getToken(tok);
        if (currentToken == null) {
            module.errorToken("AGENT-CAPABILITIES: Unexpected end of data", tok);
        }
        while (!currentToken.equals("::=")) {
            if (currentToken.equals("PRODUCT-RELEASE")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("AGENT-CAPABILITIES: Unexpected end of data", tok);
                }
                node.productrelease = currentToken;
            } else if (currentToken.equals("STATUS")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("AGENT-CAPABILITIES: Unexpected end of data", tok);
                }
                node.status = currentToken;
            } else if (currentToken.equals("DESCRIPTION")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("AGENT-CAPABILITIES: Unexpected end of data", tok);
                }
                node.description = currentToken;
            } else if (currentToken.equals("REFERENCE")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("AGENT-CAPABILITIES: Unexpected end of data", tok);
                }
                node.reference = currentToken;
            } else if (currentToken.equals("SUPPORTS")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("AGENT-CAPABILITIES : Unexpected end of data", tok);
                }
                node.supports.addElement(currentToken);
            } else if (currentToken.equals("INCLUDES")) {
                node.includes.addElement(this.parseMODULEMANDATORYGROUPS(module, tok));
            } else if (currentToken.equals("VARIATION")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("AGENT-CAPABILITIES : Unexpected end of data", tok);
                }
                node.variation.addElement(currentToken);
            } else if (currentToken.equals("SYNTAX")) {
                this.parseACSyntax(module, tok, node);
            } else if (currentToken.equals("WRITE-SYNTAX")) {
                this.parseACWriteSyntax(module, tok, node);
            } else if (currentToken.equals("ACCESS")) {
                int temp;
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("OBJECT-TYPE: Unexpected end of data", tok);
                }
                if ((temp = this.parseACCESS(module, currentToken)) == -1) {
                    module.errorToken("OBJECT-TYPE, ACCESS, unrecognized.", tok);
                } else {
                    node.acAccess.addElement(new Integer(temp));
                }
            } else if (currentToken.equals("CREATION-REQUIRES")) {
                node.creation.addElement(this.parseMODULEMANDATORYGROUPS(module, tok));
            } else if (currentToken.equals("DEFVAL")) {
                node.acDefval.addElement(this.parseDEFVAL(module, tok));
            } else if (currentToken.equals("DESCRIPTION")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("AGENT-CAPABILITIES : Unexpected end of data", tok);
                }
                node.acDescription.addElement(currentToken);
            } else {
                module.errorToken("AGENT-CAPABILITIES: Unexpected word in macro", tok);
            }
            currentToken = module.getToken(tok);
            if (currentToken != null) continue;
            module.errorToken("AGENT-CAPABILITIES: Unexpected end of data", tok);
        }
        Vector oid = module.parseOID(tok);
        if (oid == null) {
            module.errorToken("Unable to parse OBJECT IDENTIFIER.", tok);
        }
        try {
            node.subid = new Double((String)oid.lastElement()).longValue();
        }
        catch (NumberFormatException numberFormatException) {
            module.errorToken("OID: Cannot parse Sub-ID", tok);
        }
        oid.removeElement(oid.lastElement());
        node.parent = module.getNode(oid);
        if (node.parent == null) {
            module.errorToken("MIB node has no parent", tok);
        } else {
            int i = 0;
            while (i < node.parent.childList.size()) {
                if (((MibNode)node.parent.childList.elementAt((int)i)).label.equals(label)) {
                    ((MibNode)node.parent.childList.elementAt((int)i)).moduleName = String.valueOf(((MibNode)node.parent.childList.elementAt((int)i)).moduleName) + " " + module.name;
                    module.changeRoot((MibNode)node.parent.childList.elementAt(i), tok);
                    return null;
                }
                ++i;
            }
            if (i == node.parent.childList.size()) {
                node.parent.childList.addElement(node);
            }
        }
        module.changeRoot(node, tok);
        return node;
    }

    void parseOTSyntax(MibModule module, StreamTokenizer tok, MibNode node) throws MibException, IOException {
        Vector toks = module.parseSyntax(tok);
        String first = (String)toks.firstElement();
        if (first.equals("SEQUENCE OF")) {
            String currentToken = module.getToken(tok);
            if (currentToken == null) {
                module.errorToken("OBJECT-TYPE: Unexpected end of data", tok);
            }
            node.tableSequence = currentToken;
            return;
        }
        LeafSyntax syntax = (LeafSyntax)module.syntaxList.get(first);
        if (syntax == null) {
            node.rowName = first;
        } else {
            node.syntax = toks.size() > 1 ? new LeafSyntax("Node", toks, syntax) : syntax;
        }
    }

    protected int parseACCESS(MibModule module, String access) {
        if (access.equals("read-only")) {
            return 43690;
        }
        if (access.equals("write-only")) {
            return 43691;
        }
        if (access.equals("read-write")) {
            return 43706;
        }
        if (access.equals("not-accessible")) {
            return 0;
        }
        if (access.equals("read-create")) {
            return 43708;
        }
        if (access.equals("accessible-for-notify")) {
            return 1;
        }
        return -1;
    }

    protected Vector parseINDEX(MibModule module, StreamTokenizer tok) throws IOException, MibException {
        String currentToken = null;
        Vector<String> toks = new Vector<String>();
        currentToken = module.getToken(tok);
        if (currentToken == null) {
            module.errorToken("OID: Unexpected end of data", tok);
        }
        if (!currentToken.equals("{")) {
            module.errorToken("OID: Bad parse, expecting { ", tok);
        }
        if ((currentToken = module.getToken(tok)) == null) {
            module.errorToken("INDEX: Unexpected end of data", tok);
        }
        while (!currentToken.equals("}")) {
            if (!currentToken.equals(",")) {
                currentToken = currentToken.replace(',', ' ').trim();
                toks.addElement(currentToken);
            }
            if ((currentToken = module.getToken(tok)) != null) continue;
            module.errorToken("Sequence: Unexpected end of data", tok);
        }
        return toks;
    }

    String parseDEFVAL(MibModule module, StreamTokenizer tok) throws IOException, MibException {
        String currentToken = null;
        StringBuffer ret = new StringBuffer();
        currentToken = module.getToken(tok);
        if (currentToken == null) {
            module.errorToken("OBJECT-TYPE,DEFVAL: Unexpected end of data", tok);
        }
        if (currentToken.equals("{")) {
            currentToken = module.getToken(tok);
            if (currentToken == null) {
                module.errorToken("Trap Vars: Unexpected end of data", tok);
            }
            while (!currentToken.equals("}")) {
                if (currentToken.charAt(currentToken.length() - 1) == ',') {
                    currentToken = currentToken.substring(0, currentToken.length() - 1);
                }
                ret.append(currentToken);
                currentToken = module.getToken(tok);
                if (currentToken != null) continue;
                module.errorToken("Trap Vars: Unexpected end of data", tok);
            }
        } else {
            ret.append(currentToken);
        }
        String rs = ret.toString();
        if (rs.length() > 1 && rs.startsWith("\"") && rs.endsWith("\"")) {
            return rs.substring(1, rs.length() - 1);
        }
        return rs;
    }

    void parseTrapVariables(MibModule module, StreamTokenizer tok, MibTrap trap) throws MibException, IOException {
        String currentToken = null;
        trap.variables = new Vector();
        currentToken = module.getToken(tok);
        if (currentToken == null) {
            module.errorToken("Trap Vars: Unexpected end of data", tok);
        }
        if (!currentToken.equals("{")) {
            module.errorToken("Trap Vars: Bad parse, expecting { ", tok);
        }
        if ((currentToken = module.getToken(tok)) == null) {
            module.errorToken("Trap Vars: Unexpected end of data", tok);
        }
        while (!currentToken.equals("}")) {
            if (currentToken.charAt(currentToken.length() - 1) == ',') {
                currentToken.substring(0, currentToken.length() - 2);
            }
            trap.variables.addElement(currentToken);
            currentToken = module.getToken(tok);
            if (currentToken == null) {
                module.errorToken("Trap Vars: Unexpected end of data", tok);
            }
            if (!currentToken.equals(",") || (currentToken = module.getToken(tok)) != null) continue;
            module.errorToken("Trap Vars: Unexpected end of data", tok);
        }
    }

    MibModuleCompliance parseMODULE(MibModule module, StreamTokenizer tok) throws IOException, MibException {
        module.fromModuleCompliance = true;
        MibModuleCompliance mcVar = new MibModuleCompliance();
        String currentToken = null;
        currentToken = module.getToken(tok);
        if (currentToken == null) {
            module.errorToken("MODULE: Unexpected end of data", tok);
        }
        while (!currentToken.equals("::=")) {
            if (currentToken.equals("MANDATORY-GROUPS")) {
                mcVar.mandatoryGroups = this.parseMODULEMANDATORYGROUPS(module, tok);
            } else if (currentToken.equals("GROUP")) {
                this.parseMODULEGROUP(module, tok, mcVar);
            } else if (currentToken.equals("OBJECT")) {
                this.parseMODULEOBJECT(module, tok, mcVar);
            } else {
                if (currentToken.equals("MODULE")) break;
                mcVar.module = currentToken;
            }
            currentToken = module.getToken(tok);
            if (currentToken != null) continue;
            module.errorToken("MODULE: Unexpected end of data", tok);
        }
        tok.pushBack();
        module.fromModuleCompliance = false;
        return mcVar;
    }

    String parseMODULEMANDATORYGROUPS(MibModule module, StreamTokenizer tok) throws IOException, MibException {
        String currentToken = null;
        Vector toks = new Vector();
        currentToken = module.getToken(tok);
        if (currentToken == null) {
            module.errorToken("OID: Unexpected end of data", tok);
        }
        if (!currentToken.equals("{")) {
            module.errorToken("OID: Bad parse, expecting { ", tok);
        }
        if ((currentToken = module.getToken(tok)) == null) {
            module.errorToken("MANDATORY-GROUPS: Unexpected end of data", tok);
        }
        StringBuffer s = new StringBuffer();
        while (!currentToken.equals("}")) {
            s.append(String.valueOf(currentToken) + " ");
            currentToken = module.getToken(tok);
            if (currentToken != null) continue;
            module.errorToken("MANDATORY-GROUPS: Unexpected end of data", tok);
        }
        return s.toString();
    }

    void parseMODULEGROUP(MibModule module, StreamTokenizer tok, MibModuleCompliance mcVar) throws IOException, MibException {
        String currentToken = null;
        currentToken = module.getToken(tok);
        if (currentToken == null) {
            module.errorToken("OID: Unexpected end of data", tok);
        }
        mcVar.group.addElement(currentToken);
        currentToken = module.getToken(tok);
        if (currentToken == null) {
            module.errorToken("OID: Unexpected end of data", tok);
        }
        while (!currentToken.equals("::=")) {
            if (currentToken.equals("DESCRIPTION")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("OBJECT-TYPE: Unexpected end of data", tok);
                }
                mcVar.groupDescription.addElement(currentToken);
            } else {
                if (currentToken.equals("OBJECT") || currentToken.equals("GROUP") || currentToken.equals("MODULE")) break;
                module.errorToken("OBJECT-TYPE: Unexpected word in macro", tok);
            }
            currentToken = module.getToken(tok);
            if (currentToken != null) continue;
            module.errorToken("OBJECT-TYPE: Unexpected end of data", tok);
        }
        tok.pushBack();
    }

    void parseMODULEOBJECT(MibModule module, StreamTokenizer tok, MibModuleCompliance mcVar) throws IOException, MibException {
        String currentToken = null;
        currentToken = module.getToken(tok);
        if (currentToken == null) {
            module.errorToken("OID: Unexpected end of data", tok);
        }
        mcVar.object.addElement(currentToken);
        currentToken = module.getToken(tok);
        if (currentToken == null) {
            module.errorToken("OID: Unexpected end of data", tok);
        }
        while (!currentToken.equals("::=")) {
            if (currentToken.equals("SYNTAX")) {
                this.parseModuleComplianceObjectSyntax(module, tok, mcVar);
                this.syntaxFound = true;
            } else if (currentToken.equals("WRITE-SYNTAX")) {
                this.parseModuleComplianceObjectWriteSyntax(module, tok, mcVar);
                this.writeSyntaxFound = true;
            } else if (currentToken.equals("MIN-ACCESS")) {
                int temp;
                this.minAccessFound = true;
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("MODDULE-COMPLIANCEOBJECT: Unexpected end of data", tok);
                }
                if ((temp = this.parseModuleComplianceObjectACCESS(module, currentToken)) == -1) {
                    module.errorToken("MODULE-COMPLIANCE_OBJECT, ACCESS, unrecognized.", tok);
                } else {
                    mcVar.objectAccess.addElement(new Integer(temp));
                }
            } else if (currentToken.equals("DESCRIPTION")) {
                currentToken = module.getToken(tok);
                if (currentToken == null) {
                    module.errorToken("OBJECT-TYPE: Unexpected end of data", tok);
                }
                mcVar.objectDescription.addElement(currentToken);
            } else {
                if (currentToken.equals("OBJECT") || currentToken.equals("GROUP") || currentToken.equals("MODULE")) break;
                module.errorToken("OBJECT-TYPE: Unexpected word in macro", tok);
            }
            currentToken = module.getToken(tok);
            if (currentToken != null) continue;
            module.errorToken("OBJECT-TYPE: Unexpected end of data", tok);
        }
        if (!this.syntaxFound) {
            mcVar.objectSyntax.addElement(" ");
        }
        if (!this.writeSyntaxFound) {
            mcVar.objectWriteSyntax.addElement(" ");
        }
        if (!this.minAccessFound) {
            mcVar.objectAccess.addElement("777");
        }
        this.syntaxFound = false;
        this.writeSyntaxFound = false;
        this.minAccessFound = false;
        tok.pushBack();
    }

    void parseModuleComplianceObjectSyntax(MibModule module, StreamTokenizer tok, MibModuleCompliance mcVar) throws MibException, IOException {
        Vector toks = module.parseSyntax(tok);
        String first = (String)toks.firstElement();
        LeafSyntax syntax = (LeafSyntax)module.syntaxList.get(first);
        if (syntax == null) {
            module.errorToken("MODULE-COMPLIANCE: Unexpected Syntax type", tok);
        } else if (toks.size() > 1) {
            mcVar.objectSyntax.addElement(new LeafSyntax("Node", toks, syntax));
        } else {
            mcVar.objectSyntax.addElement(syntax);
        }
    }

    void parseModuleComplianceObjectWriteSyntax(MibModule module, StreamTokenizer tok, MibModuleCompliance mcVar) throws MibException, IOException {
        Vector toks = module.parseSyntax(tok);
        String first = (String)toks.firstElement();
        LeafSyntax syntax = (LeafSyntax)module.syntaxList.get(first);
        if (syntax == null) {
            module.errorToken("MODULE-COMPLIANCE: Unexpected Syntax type", tok);
        } else if (toks.size() > 1) {
            mcVar.objectWriteSyntax.addElement(new LeafSyntax("Node", toks, syntax));
        } else {
            mcVar.objectWriteSyntax.addElement(syntax);
        }
    }

    int parseModuleComplianceObjectACCESS(MibModule module, String access) {
        if (access.equals("read-only")) {
            return 43690;
        }
        if (access.equals("read-write")) {
            return 43706;
        }
        if (access.equals("not-accessible")) {
            return 0;
        }
        if (access.equals("read-create")) {
            return 43708;
        }
        return -1;
    }

    String parseOBJECTS(MibModule module, StreamTokenizer tok) throws IOException, MibException {
        String currentToken = null;
        Vector toks = new Vector();
        currentToken = module.getToken(tok);
        if (currentToken == null) {
            module.errorToken("OID: Unexpected end of data", tok);
        }
        if (!currentToken.equals("{")) {
            module.errorToken("OID: Bad parse, expecting { ", tok);
        }
        if ((currentToken = module.getToken(tok)) == null) {
            module.errorToken("OBJECTS: Unexpected end of data", tok);
        }
        StringBuffer s = new StringBuffer();
        while (!currentToken.equals("}")) {
            s.append(String.valueOf(currentToken) + " ");
            currentToken = module.getToken(tok);
            if (currentToken != null) continue;
            module.errorToken("OBJECTS: Unexpected end of data", tok);
        }
        return s.toString();
    }

    String parseNOTIFICATIONS(MibModule module, StreamTokenizer tok) throws IOException, MibException {
        String currentToken = null;
        Vector toks = new Vector();
        currentToken = module.getToken(tok);
        if (currentToken == null) {
            module.errorToken("OID: Unexpected end of data", tok);
        }
        if (!currentToken.equals("{")) {
            module.errorToken("OID: Bad parse, expecting { ", tok);
        }
        if ((currentToken = module.getToken(tok)) == null) {
            module.errorToken("NOTIFICATIONS: Unexpected end of data", tok);
        }
        StringBuffer s = new StringBuffer();
        while (!currentToken.equals("}")) {
            s.append(String.valueOf(currentToken) + " ");
            currentToken = module.getToken(tok);
            if (currentToken != null) continue;
            module.errorToken("NOTIFICATIONS: Unexpected end of data", tok);
        }
        return s.toString();
    }

    void parseACSyntax(MibModule module, StreamTokenizer tok, MibNode node) throws MibException, IOException {
        Vector toks = module.parseSyntax(tok);
        String first = (String)toks.firstElement();
        LeafSyntax syntax = (LeafSyntax)module.syntaxList.get(first);
        if (syntax == null) {
            module.errorToken("AGENT-CAPABILITIES: Unexpected Syntax type", tok);
        } else if (toks.size() > 1) {
            node.acSyntax.addElement(new LeafSyntax("Node", toks, syntax));
        } else {
            node.acSyntax.addElement(syntax);
        }
    }

    void parseACWriteSyntax(MibModule module, StreamTokenizer tok, MibNode node) throws MibException, IOException {
        Vector toks = module.parseSyntax(tok);
        String first = (String)toks.firstElement();
        LeafSyntax syntax = (LeafSyntax)module.syntaxList.get(first);
        if (syntax == null) {
            module.errorToken("AGENT-CAPABILITIES: Unexpected Syntax type", tok);
        } else if (toks.size() > 1) {
            node.acWriteSyntax.addElement(new LeafSyntax("Node", toks, syntax));
        } else {
            node.acWriteSyntax.addElement(syntax);
        }
    }
}

