/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.ndssdk.jndi.ldap.ext;

import com.novell.service.ndssdk.jndi.ldap.ext.LDAPExtendedResponse;
import com.sun.jndi.ldap.BerEncoder;
import java.io.IOException;
import javax.naming.NamingException;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;

public class NamingContextSyncRequest
implements ExtendedRequest {
    private int delay;
    private String namingContextDN;
    private String serverDN;

    public NamingContextSyncRequest() {
    }

    public NamingContextSyncRequest(String serverDN, String namingContextDN, int delay) {
        this.namingContextDN = namingContextDN;
        this.serverDN = serverDN;
        this.delay = delay;
    }

    public ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
        if (!id.equals("2.16.840.1.113719.1.27.100.26")) {
            throw new NamingException("Request and response OIDs do not match.");
        }
        return new LDAPExtendedResponse(id, berValue, offset, length);
    }

    public int getDelay() {
        return this.delay;
    }

    public byte[] getEncodedValue() {
        BerEncoder ber = new BerEncoder();
        try {
            ber.encodeString(this.serverDN, true);
            ber.encodeString(this.namingContextDN, true);
            ber.encodeInt(this.delay);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("BerEncoder error:" + ioe.toString());
        }
        return ber.getTrimmedBuf();
    }

    public String getID() {
        return "2.16.840.1.113719.1.27.100.25";
    }

    public String getNamingContextDN() {
        return this.namingContextDN;
    }

    public String getServerDN() {
        return this.serverDN;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void setNamingContextDN(String namingContextDN) {
        this.namingContextDN = namingContextDN;
    }

    public void setServerDN(String serverDN) {
        this.serverDN = serverDN;
    }
}

