/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.ndssdk.jndi.ldap.ssl;

import com.novell.service.ndssdk.jndi.ldap.ssl.LdapSecureSocket;
import com.novell.service.security.net.SecureServerSocket;
import com.novell.service.security.net.SecureServerSocketFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import javax.net.ssl.SSLServerSocket;

public class LdapSecureServerSocket
extends SSLServerSocket {
    private SecureServerSocket Socket;

    LdapSecureServerSocket(int Port) throws IOException {
        super(0);
        super.close();
        this.Socket = SecureServerSocketFactory.getDefault().createServerSocket(Port);
    }

    LdapSecureServerSocket(int Port, int Log) throws IOException {
        super(0);
        super.close();
        this.Socket = SecureServerSocketFactory.getDefault().createServerSocket(Port, Log);
    }

    LdapSecureServerSocket(int Port, int Log, InetAddress Addr) throws IOException {
        super(0);
        super.close();
        this.Socket = SecureServerSocketFactory.getDefault().createServerSocket(Port, Log, Addr);
    }

    public Socket accept() throws IOException {
        return this.Socket.accept();
    }

    public void close() throws IOException {
        this.Socket.close();
    }

    public boolean getEnableSessionCreation() {
        return true;
    }

    public String[] getEnabledCipherSuites() {
        return LdapSecureSocket.CIPHERSUITES;
    }

    public InetAddress getInetAddress() {
        return this.Socket.getInetAddress();
    }

    public int getLocalPort() {
        return this.Socket.getLocalPort();
    }

    public boolean getNeedClientAuth() {
        return false;
    }

    public int getSoTimeout() throws IOException {
        return this.Socket.getSoTimeout();
    }

    public String[] getSupportedCipherSuites() {
        return LdapSecureSocket.CIPHERSUITES;
    }

    public boolean getUseClientMode() {
        return false;
    }

    public void setEnableSessionCreation(boolean b) {
        throw new IllegalArgumentException("setEnableSessionCreation");
    }

    public void setEnabledCipherSuites(String[] Ciphers) {
        int i = 0;
        while (i < Ciphers.length) {
            if (!Ciphers[i].equals("UNKNOWN_CIPHERSUITE")) {
                throw new IllegalArgumentException(String.valueOf(Ciphers[i]) + " not supported");
            }
            ++i;
        }
    }

    public void setNeedClientAuth(boolean b) {
        throw new IllegalArgumentException("setNeedClientAuth");
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.Socket.setSoTimeout(timeout);
    }

    public void setUseClientMode(boolean b) {
        throw new IllegalArgumentException("setUseClientMode");
    }
}

