/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.debug;

import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;

public class DumpResourcesTask
extends Task {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean execute(TaskContext context, Properties resultStrings) {
        HttpServletRequest req = context.getRequest();
        String nextState = req.getParameter("nextState");
        Locale loc = context.getLocale();
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            this.setUIPage("debug/DumpResources.jsp");
            req.setAttribute("DumpRes_LocaleCode", (Object)loc.toString());
            req.setAttribute("DumpRes_LocaleName", (Object)loc.getDisplayName());
            return true;
        }
        this.setUIPage("debug/DumpResourcesOutput.jsp");
        String resFile = req.getParameter("ResFile");
        if (resFile.equalsIgnoreCase("NSIClientResourceBundle")) {
            resFile = "com.novell.admin.common.exceptions.NSIClientResourceBundle";
        } else if (resFile.equalsIgnoreCase("NDSResourceBundle")) {
            resFile = "com.novell.admin.ns.nds.NDSResourceBundle";
        } else if (resFile.equalsIgnoreCase("NSResourceBundle")) {
            resFile = "com.novell.admin.ns.NSResourceBundle";
        } else if (resFile.equalsIgnoreCase("LDAPResourceBundle")) {
            resFile = "com.novell.admin.ns.ldap.LDAPResourceBundle";
        }
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle(resFile, loc);
        }
        catch (Exception e) {
            this.setUIPage("GenErr.jsp");
            eMFrameUtils.setMessage("error", null, "Cannot locate resource: " + resFile, context);
            return false;
        }
        loc = rb.getLocale();
        String lcode = loc.toString();
        if (lcode == null || lcode.length() == 0) {
            lcode = "Default";
        }
        req.setAttribute("DumpRes_LocaleCode", (Object)lcode);
        req.setAttribute("DumpRes_LocaleName", (Object)loc.getDisplayName());
        req.setAttribute("DumpRes_ResFile", (Object)resFile);
        Enumeration<String> keyEnum = rb.getKeys();
        ArrayList<String> errList = new ArrayList<String>();
        while (keyEnum.hasMoreElements()) {
            String key = keyEnum.nextElement();
            try {
                String msg = rb.getString(key);
                errList.add(key + "=" + msg);
            }
            catch (Exception e) {
                String[] msgArray = rb.getStringArray(key);
                errList.add(key + "=" + msgArray[0]);
            }
        }
        Collections.sort(errList);
        req.setAttribute("DumpRes_Values", errList);
        req.setAttribute("DumpRes_Size", (Object)String.valueOf(errList.size()));
        return true;
    }
}

