/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.debug;

import com.novell.emframe.dev.GlobalRegistry;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.webaccess.common.I18NServletRequest;
import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;

public class LaunchPrintersTask
extends Task {
    private static final long serialVersionUID = 1L;
    HttpServletRequest req;
    TaskContext context;
    Properties resultStrings;

    @Override
    public boolean execute(TaskContext context, Properties resultStrings) {
        this.context = context;
        this.resultStrings = resultStrings;
        this.req = context.getRequest();
        String nextState = this.req.getParameter("nextState");
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            ArrayList printerTasks = GlobalRegistry.getGatewayConfigPlugins();
            resultStrings.put("Printer.Task.count", Integer.toString(printerTasks.size()));
            for (int i = 0; i < printerTasks.size(); ++i) {
                Document doc = (Document)printerTasks.get(i);
                Element root = doc.getRootElement();
                String name = eMFrameUtils.getDisplayName(doc, (MContext)context);
                String taskId = root.getChildTextTrim("id");
                resultStrings.put("Printer.Task." + i + ".name", name);
                resultStrings.put("Printer.Task." + i + ".taskId", taskId);
            }
        } else if (nextState.equalsIgnoreCase("done")) {
            System.out.println("LaunchPrinterTask called with nextState==done");
            String taskCancelledStr = this.req.getParameter("taskCancelled");
            if (taskCancelledStr != null && taskCancelledStr.equals("true")) {
                System.out.println("Printer task was cancelled");
                ((I18NServletRequest)this.req).setParameter("merge", "fw.GoHome");
                return true;
            }
        }
        return true;
    }
}

