/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.debug;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class OSTask
extends Task {
    private static final long serialVersionUID = 1L;
    public static final String HTMLPARAM_FORMNAME = "CreateUserForm";
    public static final String HTMLPARAM_USERCONTEXT = "CreateUserContext";
    public static final String HTMLPARAM_USERNAME = "CreateUserName";
    public static final String HTMLPARAM_USERSURNAME = "CreateUserSurName";
    public static final String HTMLPARAM_SELECTEDCLASS = "SelectedClass";
    public static final String HTMLPARAM_TRANSLATEDCLASS = "TranslatedClass";
    public static final String HTMLPARAM_GIFNAME = "GifName";
    HttpServletRequest req;
    TaskContext context;
    Properties resultStrings;
    String objectClass = null;

    @Override
    public boolean execute(TaskContext context, Properties resultStrings) {
        D.log("CreateUserTask::execute start");
        this.context = context;
        this.resultStrings = resultStrings;
        this.req = context.getRequest();
        String scripting = this.req.getParameter("scripting");
        if (scripting != null && scripting.equalsIgnoreCase("true")) {
            String userContext = this.req.getParameter("scriptParam1");
            String id = this.req.getParameter("scriptParam2");
            String surname = this.req.getParameter("scriptParam3");
            this.objectClass = this.req.getParameter(HTMLPARAM_SELECTEDCLASS);
            if (this.objectClass == "") {
                this.objectClass = "User";
            }
            return this.doCreateUser(this.objectClass, userContext, id, surname);
        }
        String nextState = this.req.getParameter("nextState");
        D.log("nextState = " + nextState);
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("doCreateUser")) {
            try {
                D.log("doCreateUser");
                String userContext = this.req.getParameter(HTMLPARAM_USERCONTEXT);
                String id = this.req.getParameter(HTMLPARAM_USERNAME);
                String surname = this.req.getParameter(HTMLPARAM_USERSURNAME);
                return this.doCreateUser(this.objectClass, userContext, id, surname);
            }
            catch (Exception e) {
                D.log(e);
                return false;
            }
        }
        D.log("Task received invalid state " + nextState);
        return this.showInitialForm();
    }

    private boolean showInitialForm() {
        this.objectClass = this.req.getParameter(HTMLPARAM_SELECTEDCLASS);
        if (this.objectClass == null || this.objectClass.length() == 0) {
            this.objectClass = "User";
        }
        this.resultStrings.put(HTMLPARAM_TRANSLATEDCLASS, this.context.getDirUtils().getObjectTypeDisplayName(this.objectClass, this.context));
        this.resultStrings.put(HTMLPARAM_GIFNAME, this.context.getDirUtils().getObjectTypeImageName(this.objectClass));
        return true;
    }

    private boolean doCreateUser(String objectClass, String strContext, String strUserName, String strSurName) {
        String strFailure;
        AuthenticationBroker broker = this.context.getAuthenticationBroker();
        ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        NDSNamespace namespace = (NDSNamespace)treeOE.getNamespace();
        String newUserName = strUserName;
        if (strUserName.indexOf(".") != -1) {
            newUserName = namespace.escapeTheRDNDot(strUserName);
        }
        if (0 == strContext.indexOf("\\")) {
            strContext = strContext.substring(1);
        }
        D.log("CreateUserTask: Creating: Name: " + newUserName + ", Surname: " + strSurName + ", Context: " + strContext);
        ObjectEntry parentEntry = null;
        try {
            parentEntry = namespace.getObjectEntry(treeOE, strContext);
        }
        catch (SPIException e) {
            String strFailure2 = eMFrameUtils.getLocalizedString("BaseResources", "CreateUser.Failure", this.context);
            String strContainerNotFound = eMFrameUtils.getLocalizedString("BaseResources", "Common.ContainerNotFound", this.context);
            this.resultStrings.put("GeneralMsg.MsgTitle", strFailure2);
            this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.formatMessage(strContainerNotFound, new String[]{strContext}));
            return false;
        }
        String strType = parentEntry.getObjectType().getName();
        if (0 != strType.compareTo("Organization") && 0 != strType.compareTo("Organizational Unit")) {
            String strFailure3 = eMFrameUtils.getLocalizedString("BaseResources", "CreateUser.Failure", this.context);
            String strNotAContainer = eMFrameUtils.getLocalizedString("BaseResources", "Common.NotAContainer", this.context);
            this.resultStrings.put("GeneralMsg.MsgTitle", strFailure3);
            this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.formatMessage(strNotAContainer, new String[]{strContext}));
            return false;
        }
        String strException = null;
        try {
            DirUtils.createUser(objectClass, parentEntry, newUserName, strSurName);
        }
        catch (NamespaceException nse) {
            D.log(nse);
            strException = eMFrameUtils.getExceptionMessage((Exception)((Object)nse), this.context);
        }
        catch (SPIException spie) {
            D.log(spie);
            strException = eMFrameUtils.getExceptionMessage((Exception)((Object)spie), this.context);
        }
        catch (SnapinVetoException sve) {
            D.log(sve);
            strException = eMFrameUtils.getExceptionMessage((Exception)((Object)sve), this.context);
        }
        if (null != strException) {
            strFailure = eMFrameUtils.getLocalizedString("BaseResources", "CreateUser.Failure", this.context);
            String strCommonError = eMFrameUtils.getLocalizedString("BaseResources", "Common.FailureExplain", this.context);
            this.resultStrings.put("GeneralMsg.MsgTitle", strFailure);
            this.resultStrings.put("GeneralMsg.MsgBody", strCommonError + " " + strException);
            return false;
        }
        try {
            namespace.setPassword(namespace.getObjectEntry(parentEntry, newUserName), "");
        }
        catch (SPIException spie) {
            D.log(spie);
            strException = eMFrameUtils.getExceptionMessage((Exception)((Object)spie), this.context);
        }
        if (null != strException) {
            strFailure = eMFrameUtils.getLocalizedString("BaseResources", "CreateUser.CredentialFailureE", this.context);
            String strCommonError = eMFrameUtils.getLocalizedString("BaseResources", "CreateUser.CredentialFailureExplain", this.context);
            this.resultStrings.put("GeneralMsg.MsgTitle", strFailure);
            this.resultStrings.put("GeneralMsg.MsgBody", strCommonError + " " + strException);
            return false;
        }
        String strSuccess = eMFrameUtils.getLocalizedString("BaseResources", "CreateUser.Success", this.context);
        String strSuccessForUser = eMFrameUtils.getLocalizedString("BaseResources", "CreateUser.SuccessForUser", this.context);
        String strUserName2 = newUserName + "." + parentEntry.getFullName();
        this.resultStrings.put("GeneralMsg.MsgTitle", strSuccess);
        this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.formatMessage(strSuccessForUser, new String[]{strUserName2}));
        D.log("CreateUserTask::CreateUser Create user succeeded");
        return true;
    }
}

