/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.dev;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthBrokerAuthenticator;
import com.novell.emframe.dev.AuthBrokerEvent;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthBrokerListener;
import com.novell.emframe.dev.AuthBrokerReport;
import com.novell.emframe.dev.AuthBrokerWrappedRuntimeException;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.LazyAuthBrokerAuthenticator;
import com.novell.emframe.dev.ManagementServiceSet;
import com.novell.emframe.dev.MappingObject;
import com.novell.emframe.dev.authenticator.iMgrAuthenticator;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.NDSNamespaceAuthenticator;
import com.novell.emframe.fw.authenticator.DirAuthenticator;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.servlet.http.HttpSession;

public class AuthenticationBroker {
    public static final String PROTOCOL_ADMINNAMESPACE = "AdminNamespace";
    public static final String PROTOCOL_NDSNAMESPACE = "NDSNamespace";
    public static final String PROTOCOL_LDAPNAMESPACE = "LDAPNamespace";
    public static final String PROTOCOL_NDPS = "NDPS";
    public static final String PROTOCOL_JNDI_LDAP = "JndiLdap";
    public static final String PROTOCOL_NAAS = "NAAS";
    public static final String PROTOCOL_NSS = "NSS";
    public static final String PROTOCOL_NCS = "NCS";
    public static final String PROTOCOL_ECB = "ECB";
    public static final String PROTOCOL_PORTALCONNECTION = "PortalConnection";
    public static final String PROTOCOL_NPSFILE = "NPSFile";
    public static final String PROTOCOL_ALLPROTOCOLS = "ALLPROTOCOLS";
    private static final int CT_UNKNOWN = 0;
    private static final int CT_LDAP = 1;
    private static final int CT_NDAP = 2;
    private static final String DEF_LDAPCLEARPORT = "389";
    private static final String DEF_LDAPSSLPORT = "636";
    private int PrimaryAdminNamespaceType = 0;
    private static final String[][] protocol_Information = new String[][]{{"NDSNamespace", "com.novell.emframe.fw.NDSNamespaceAuthenticator", "true", "ndap"}, {"LDAPNamespace", "com.novell.emframe.fw.LDAPNamespaceAuthenticator", "true", "ldap"}, {"JndiLdap", "com.novell.emframe.fw.ldap.JndiLdapAuthenticator", "true", "ldap"}, {"NDPS", "com.novell.service.ndps.eMFrameStartup", "false", "ndap"}, {"NAAS", "com.novell.imanage.naas.audit.Tasks.NaasAuthenticator", "true", "ndap"}, {"NSS", "com.novell.nss.managelib.NSSAuthenticator", "false", "ndap"}, {"NCS", "com.novell.ncs.managelib.NCSAuthenticator", "false", "ndap"}, {"ECB", "com.novell.emframe.fw.ECBAuthenticator", "true", "ldap"}, {"PortalConnection", "com.novell.emframe.fw.PortalConnectionAuthenticator", "true", "ldap"}, {"NPSFile", "com.novell.emframe.fw.NPSFileAuthenticator", "true", "ndap"}};
    private static Hashtable staticProtoHash = new Hashtable();
    private Hashtable activeProtoHash = new Hashtable();
    private AuthBrokerListener[] authListenerList = null;
    private static final int FIRELOGINEVENT = 1;
    private static final int FIREPRELOGOUTEVENT = 2;
    private DirAuthenticator m_dirAuth;
    private boolean m_useLdapSSL;
    private String p_ldapClearPort = null;
    private String p_ldapSSLPort = null;
    private String p_treeName = null;
    private String p_ldapName;
    private String p_ndapName;
    private String p_ldapAccessDomain;
    private String p_ndapAccessDomain;
    private transient String p_pidentity;
    private InitialLdapContext sharedLDAPcontext = null;

    private AuthenticationBroker(String ldapName, String ndapName, String password, String ldapAccessDomain, String ndapAccessDomain, boolean useLdapSSL, DirAuthenticator dirAuth) {
        this.p_ldapName = ldapName;
        boolean typedName = false;
        if (ndapName != null) {
            for (int i = 0; i < ndapName.length(); ++i) {
                if (ndapName.charAt(i) == '\\') {
                    ++i;
                    continue;
                }
                if (ndapName.charAt(i) != '=') continue;
                typedName = true;
                break;
            }
        }
        this.p_ndapName = typedName ? this.getTypelessNdapName(ndapName) : ndapName;
        this.p_pidentity = password;
        this.p_ldapAccessDomain = ldapAccessDomain;
        this.p_ndapAccessDomain = ndapAccessDomain;
        this.m_useLdapSSL = useLdapSSL;
        this.m_dirAuth = dirAuth;
        if (ndapAccessDomain != null && ldapAccessDomain == null) {
            this.PrimaryAdminNamespaceType = 2;
        } else if (ndapAccessDomain == null && ldapAccessDomain != null) {
            this.PrimaryAdminNamespaceType = 1;
        }
    }

    private String getTypelessNdapName(String typedName) {
        StringBuffer sb = new StringBuffer();
        int p = 0;
        boolean scanningAttr = true;
        block5: for (int i = 0; i < typedName.length(); ++i) {
            switch (typedName.charAt(i)) {
                case '\\': {
                    ++i;
                    continue block5;
                }
                case '=': {
                    if (!scanningAttr) continue block5;
                    p = i + 1;
                    scanningAttr = false;
                    continue block5;
                }
                case '.': {
                    sb.append(typedName.substring(p, i + 1));
                    p = i + 1;
                    scanningAttr = true;
                    continue block5;
                }
            }
        }
        sb.append(typedName.substring(p, typedName.length()));
        return sb.toString();
    }

    public static AuthenticationBroker createAuthenticationBroker(String ldapName, String ndapName, String password, String ldapAccessDomain, String ndapAccessDomain, boolean useLdapSSL, iMgrAuthenticator dirAuth) {
        return new AuthenticationBroker(ldapName, ndapName, password, ldapAccessDomain, ndapAccessDomain, useLdapSSL, (DirAuthenticator)dirAuth);
    }

    public static AuthenticationBroker createAuthenticationBroker(String ldapName, String ndapName, String password, String ldapAccessDomain, String ndapAccessDomain, boolean useLdapSSL, ManagementServiceSet manageSS, String portalTreename) {
        return AuthenticationBroker.createAuthenticationBroker(ldapName, ndapName, password, ldapAccessDomain, ndapAccessDomain, useLdapSSL, manageSS);
    }

    public static AuthenticationBroker createAuthenticationBroker(String ldapName, String ndapName, String password, String ldapAccessDomain, String ndapAccessDomain, boolean useLdapSSL, ManagementServiceSet manageSS) {
        return new AuthenticationBroker(ldapName, ndapName, password, ldapAccessDomain, ndapAccessDomain, useLdapSSL, DirAuthenticator.getDirAuth(FwUtils.getRequest((HttpSession)manageSS.getSession())));
    }

    protected void finalize() throws Throwable {
        this.logoutAll();
        super.finalize();
    }

    public String getAuthLdapName() throws AuthBrokerException {
        if (this.p_ldapName == null || this.m_dirAuth.getSwitchOrLogin()) {
            try {
                ObjectEntry treeOE = (ObjectEntry)this.getAPIObject(PROTOCOL_NDSNAMESPACE);
                NDSNamespace ndsns = (NDSNamespace)treeOE.getNamespace();
                ObjectEntry nameOE = ndsns.getObjectEntry(treeOE, this.p_ndapName);
                this.p_ldapName = this.m_dirAuth.getDirUtils().getMappingObject().NDSNameToLDAPName(nameOE);
            }
            catch (AuthBrokerWrappedRuntimeException wrapped_abe) {
                throw wrapped_abe.getException();
            }
            catch (SPIException spe) {
                throw new AuthBrokerException((Exception)((Object)spe));
            }
        }
        return this.p_ldapName;
    }

    public String getAuthNdapName() throws AuthBrokerException {
        if (this.p_ndapName == null) {
            this.p_ndapName = MappingObject.LDAPNameToNDSName(this.p_ldapName);
        }
        return this.p_ndapName;
    }

    public String getAuthLdapDefaultClearPort() {
        if (this.p_ldapClearPort == null) {
            int ldapClearPort = this.m_dirAuth.getDirUtils().getMappingObject().getLDAPClearPort();
            this.p_ldapClearPort = ldapClearPort > 0 ? Integer.toString(ldapClearPort) : DEF_LDAPCLEARPORT;
        }
        return this.p_ldapClearPort;
    }

    public String getAuthLdapDefaultSSLPort() {
        if (this.p_ldapSSLPort == null) {
            int ldapSSLPort = this.m_dirAuth.getDirUtils().getMappingObject().getLDAPSSLPort();
            this.p_ldapSSLPort = ldapSSLPort > 0 ? Integer.toString(ldapSSLPort) : DEF_LDAPSSLPORT;
        }
        return this.p_ldapSSLPort;
    }

    public String getAuthLdapAccessDomain() {
        String defaultServerIp1;
        String serverDN1;
        NDSNamespace ns1;
        if (this.p_ldapAccessDomain == null) {
            try {
                ObjectEntry treeOE = (ObjectEntry)this.getAPIObject(PROTOCOL_NDSNAMESPACE);
                NDSNamespace ns = (NDSNamespace)treeOE.getAdminNamespace();
                String ncpServer = ns.getDefaultServerDN(treeOE);
                ObjectEntry ncpServerOE = ns.getObjectEntry(ncpServer);
                ObjectAttribute objAttr = ns.getAttribute(ncpServerOE, "LDAP Server");
                Enumeration en = objAttr.getValueComponents();
                String ldapServer = ((StringValue)en.nextElement()).getValue();
                ObjectEntry ldapServerOE = ns.getObjectEntry(ldapServer);
                objAttr = ns.getAttribute(ldapServerOE, "ldapInterfaces");
                en = objAttr.getValueComponents();
                String ldapInterface = null;
                boolean useLdapSsl = this.getAuthUseLdapSSL();
                String LDAPparam = useLdapSsl ? "ldaps://" : "ldap://";
                while (en.hasMoreElements()) {
                    ldapInterface = ((StringValue)en.nextElement()).getValue();
                    if (!this.isIPv6Enabled() && null != ldapInterface && ldapInterface.indexOf("[") != -1 && ldapInterface.indexOf("]") != -1 || null == ldapInterface || ldapInterface.toLowerCase().indexOf(LDAPparam) < 0) continue;
                    this.p_ldapAccessDomain = ldapInterface;
                    break;
                }
                if (this.p_ldapAccessDomain != null && this.p_ldapAccessDomain.length() == 0 || this.p_ldapAccessDomain.equalsIgnoreCase("ldaps://639") || this.p_ldapAccessDomain.equalsIgnoreCase("ldap://639")) {
                    this.p_ldapAccessDomain = null;
                }
            }
            catch (Exception treeOE) {
                // empty catch block
            }
            if (this.p_ldapAccessDomain == null) {
                InetAddress na;
                String hostAddress;
                boolean tryNDSNamespaceLookup = false;
                if (this.p_ndapAccessDomain.indexOf(91) != -1 && this.p_ndapAccessDomain.indexOf(93) != -1 && this.p_ndapAccessDomain.indexOf(58) != -1) {
                    try {
                        int closeBrace = this.p_ndapAccessDomain.indexOf(93);
                        hostAddress = closeBrace >= 0 ? this.p_ndapAccessDomain.substring(0, closeBrace + 1) : this.p_ndapAccessDomain;
                        na = InetAddress.getByName(hostAddress);
                        this.p_ldapAccessDomain = '[' + na.getHostAddress() + ']';
                    }
                    catch (UnknownHostException uhe) {
                        tryNDSNamespaceLookup = true;
                    }
                } else if (this.p_ndapAccessDomain.indexOf(46) != -1) {
                    try {
                        int colonOff = this.p_ndapAccessDomain.indexOf(58);
                        hostAddress = colonOff >= 0 ? this.p_ndapAccessDomain.substring(0, colonOff) : this.p_ndapAccessDomain;
                        na = InetAddress.getByName(hostAddress);
                        this.p_ldapAccessDomain = na.getHostAddress();
                    }
                    catch (UnknownHostException uhe) {
                        tryNDSNamespaceLookup = true;
                    }
                } else {
                    tryNDSNamespaceLookup = true;
                }
                if (tryNDSNamespaceLookup) {
                    ObjectEntry treeOE = (ObjectEntry)this.getAPIObject(PROTOCOL_NDSNAMESPACE);
                    this.p_ldapAccessDomain = NDSNamespaceAuthenticator.getDefaultIPAddress(treeOE);
                }
            }
            if (this.p_ldapAccessDomain == null) {
                this.p_ldapAccessDomain = this.p_ndapAccessDomain;
            }
        }
        if (this.p_ldapAccessDomain.toLowerCase().contains("ldaps://:")) {
            ObjectEntry treeOE1 = (ObjectEntry)this.getAPIObject(PROTOCOL_NDSNAMESPACE);
            ns1 = (NDSNamespace)treeOE1.getAdminNamespace();
            try {
                serverDN1 = ns1.getDefaultServerDN(treeOE1);
                defaultServerIp1 = ns1.getDefaultIpAddress(treeOE1);
                this.p_ldapAccessDomain = "ldaps://" + defaultServerIp1 + ":" + this.p_ldapAccessDomain.substring(this.p_ldapAccessDomain.lastIndexOf(":") + 1);
            }
            catch (Exception ee) {
                D.log(ee);
            }
        }
        if (this.p_ldapAccessDomain.toLowerCase().contains("ldap://:")) {
            ObjectEntry treeOE1 = (ObjectEntry)this.getAPIObject(PROTOCOL_NDSNAMESPACE);
            ns1 = (NDSNamespace)treeOE1.getAdminNamespace();
            try {
                serverDN1 = ns1.getDefaultServerDN(treeOE1);
                defaultServerIp1 = ns1.getDefaultIpAddress(treeOE1);
                this.p_ldapAccessDomain = "ldap://" + defaultServerIp1 + ":" + this.p_ldapAccessDomain.substring(this.p_ldapAccessDomain.lastIndexOf(":") + 1);
            }
            catch (Exception ee) {
                D.log(ee);
            }
        }
        return this.p_ldapAccessDomain;
    }

    private boolean isIPv6Enabled() {
        String preferIPv4StackEnabled = System.getProperty("java.net.preferIPv4Stack");
        String preferIPv4AddressesEnabled = System.getProperty("java.net.preferIPv4Addresses");
        if (null != preferIPv4StackEnabled && preferIPv4StackEnabled.equalsIgnoreCase("true")) {
            if (null != preferIPv4AddressesEnabled && preferIPv4AddressesEnabled.equalsIgnoreCase("true")) {
                return false;
            }
            if (null != preferIPv4AddressesEnabled && preferIPv4AddressesEnabled.equalsIgnoreCase("false")) {
                return false;
            }
        } else if (null != preferIPv4StackEnabled && preferIPv4StackEnabled.equalsIgnoreCase("false")) {
            if (null != preferIPv4AddressesEnabled && preferIPv4AddressesEnabled.equalsIgnoreCase("true")) {
                return true;
            }
            if (null != preferIPv4AddressesEnabled && preferIPv4AddressesEnabled.equalsIgnoreCase("false")) {
                return true;
            }
        }
        return true;
    }

    public String getAuthNdapAccessDomain() {
        if (this.p_ndapAccessDomain == null) {
            try {
                int colonOff = this.p_ldapAccessDomain.indexOf(58);
                String hostAddress = colonOff >= 0 ? this.p_ldapAccessDomain.substring(0, colonOff) : this.p_ldapAccessDomain;
                InetAddress na = InetAddress.getByName(hostAddress);
                this.p_ndapAccessDomain = na.getHostAddress();
            }
            catch (UnknownHostException uhe) {
                this.p_ndapAccessDomain = this.p_ldapAccessDomain;
            }
        }
        return this.p_ndapAccessDomain;
    }

    public boolean getAuthUseLdapSSL() throws AuthBrokerException {
        return this.m_useLdapSSL;
    }

    public String getAuthPIdentity() {
        return this.p_pidentity;
    }

    public void resetAuthPIdentity(String new_PIdentity) throws AuthBrokerException {
        this.p_pidentity = new_PIdentity;
    }

    public String getAuthTreeName() {
        if (this.p_treeName == null) {
            this.getStaticProtoItem(PROTOCOL_NDSNAMESPACE);
            this.p_treeName = NDSNamespaceAuthenticator.getTreeNameFromID(this.getAuthNdapAccessDomain());
            if (this.p_treeName == null) {
                this.p_treeName = this.getAuthNdapAccessDomain();
            }
        }
        return this.p_treeName;
    }

    public static void staticDestroyAll() {
        Enumeration spEnum = staticProtoHash.elements();
        while (spEnum.hasMoreElements()) {
            StaticProtoItem spItem = (StaticProtoItem)spEnum.nextElement();
            spItem.sp_destroy();
        }
        staticProtoHash.clear();
    }

    public void addAuthBrokerListener(AuthBrokerListener newListener) throws AuthBrokerException {
        if (newListener == null) {
            AuthBrokerException ae = new AuthBrokerException(eMFrameUtils.getLocalizedString("FwResources", "AuthenticateFailed.AuthBrokerListener", this.m_dirAuth.getLocale()));
            throw ae;
        }
        if (newListener instanceof AuthBrokerListener) {
            if (this.authListenerList == null) {
                this.authListenerList = new AuthBrokerListener[]{newListener};
            } else {
                int olen = this.authListenerList.length;
                AuthBrokerListener[] tlist = new AuthBrokerListener[olen + 1];
                System.arraycopy(this.authListenerList, 0, tlist, 0, olen);
                tlist[olen] = newListener;
                this.authListenerList = tlist;
            }
        } else {
            AuthBrokerException ae = new AuthBrokerException(eMFrameUtils.getLocalizedString("FwResources", "AuthenticateFailed.AuthBrokerListener", this.m_dirAuth.getLocale()));
            throw ae;
        }
    }

    public void removeAuthBrokerListener(AuthBrokerListener oldListener) throws AuthBrokerException {
        if (oldListener == null) {
            AuthBrokerException ae = new AuthBrokerException(eMFrameUtils.getLocalizedString("FwResources", "AuthenticateFailed.AuthBrokerListener", this.m_dirAuth.getLocale()));
            throw ae;
        }
        if (oldListener instanceof AuthBrokerListener) {
            if (this.authListenerList == null) {
                return;
            }
            int fndindex = -1;
            for (int icnt = this.authListenerList.length - 1; icnt >= 0; --icnt) {
                if (this.authListenerList[icnt] != oldListener) continue;
                fndindex = icnt;
                break;
            }
            if (fndindex != -1) {
                int newlen = this.authListenerList.length - 1;
                if (newlen <= 0) {
                    this.authListenerList = null;
                } else {
                    AuthBrokerListener[] tlist = new AuthBrokerListener[newlen];
                    if (fndindex != 0) {
                        System.arraycopy(this.authListenerList, 0, tlist, 0, fndindex);
                    }
                    if (fndindex != newlen) {
                        System.arraycopy(this.authListenerList, fndindex + 1, tlist, fndindex, newlen - fndindex);
                    }
                    this.authListenerList = tlist;
                }
            }
        } else {
            AuthBrokerException ae = new AuthBrokerException(eMFrameUtils.getLocalizedString("FwResources", "AuthenticateFailed.AuthBrokerListener", this.m_dirAuth.getLocale()));
            throw ae;
        }
    }

    private void fireAuthBrokerEvent(int abeId, String protocolId) {
        if (this.authListenerList != null) {
            AuthBrokerEvent abEvent = new AuthBrokerEvent(this, this.m_dirAuth, protocolId);
            for (int icnt = this.authListenerList.length - 1; icnt >= 0; --icnt) {
                if (abeId == 1) {
                    this.authListenerList[icnt].loginEvent(abEvent);
                    continue;
                }
                if (abeId != 2) continue;
                this.authListenerList[icnt].preLogoutEvent(abEvent);
            }
        }
    }

    public String[] getIdentity() {
        String[] identity;
        try {
            identity = new String[]{this.getAuthNdapName(), this.getAuthPIdentity(), this.getAuthNdapAccessDomain()};
        }
        catch (AuthBrokerException abe) {
            identity = new String[]{abe.getMessage(), this.getAuthPIdentity(), this.getAuthNdapAccessDomain()};
        }
        return identity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logoutAll() {
        Hashtable hashtable = this.activeProtoHash;
        synchronized (hashtable) {
            this.fireAuthBrokerEvent(2, PROTOCOL_ALLPROTOCOLS);
            this.authListenerList = null;
            Enumeration apEnum = this.activeProtoHash.elements();
            while (apEnum.hasMoreElements()) {
                ActiveProtoItem apItem = (ActiveProtoItem)apEnum.nextElement();
                apItem.apItemLogout();
            }
            this.activeProtoHash.clear();
        }
    }

    public Object getProtocolObject(String protocolId) throws AuthBrokerException {
        if (protocolId.equals(PROTOCOL_ADMINNAMESPACE)) {
            if (this.PrimaryAdminNamespaceType == 2) {
                protocolId = PROTOCOL_NDSNAMESPACE;
            } else if (this.PrimaryAdminNamespaceType == 1) {
                protocolId = PROTOCOL_LDAPNAMESPACE;
            } else {
                ActiveProtoItem apTemp = (ActiveProtoItem)this.activeProtoHash.get(PROTOCOL_NDSNAMESPACE);
                if (apTemp != null) {
                    protocolId = PROTOCOL_NDSNAMESPACE;
                    this.PrimaryAdminNamespaceType = 2;
                } else {
                    apTemp = (ActiveProtoItem)this.activeProtoHash.get(PROTOCOL_LDAPNAMESPACE);
                    if (apTemp != null) {
                        protocolId = PROTOCOL_LDAPNAMESPACE;
                        this.PrimaryAdminNamespaceType = 1;
                    } else {
                        protocolId = PROTOCOL_NDSNAMESPACE;
                        this.PrimaryAdminNamespaceType = 2;
                    }
                }
            }
        }
        ActiveProtoItem apItem = this.getActiveProtoItem(protocolId);
        if (apItem.ap_SuccessFlag) {
            return apItem.ap_loginAPIObject;
        }
        throw new AuthBrokerException(apItem.ap_abException);
    }

    public Object getAPIObject(String protocolId) throws AuthBrokerWrappedRuntimeException {
        ActiveProtoItem apItem = this.getActiveProtoItem(protocolId);
        if (apItem.ap_SuccessFlag) {
            return apItem.ap_loginAPIObject;
        }
        throw new AuthBrokerWrappedRuntimeException(apItem.ap_abException);
    }

    public Object checkAPIObject(String protocolId) throws AuthBrokerException {
        ActiveProtoItem apItem = (ActiveProtoItem)this.activeProtoHash.get(protocolId);
        if (apItem != null && apItem.ap_SuccessFlag) {
            return apItem.ap_loginAPIObject;
        }
        return null;
    }

    public AuthBrokerReport getAPIReport(String protocolId) throws AuthBrokerException {
        ActiveProtoItem apItem = this.getActiveProtoItem(protocolId);
        if (apItem.ap_SuccessFlag) {
            if (apItem.ap_APIReport != null) {
                return apItem.ap_APIReport;
            }
            return new AuthBrokerReport(0, protocolId, apItem.ap_loginAPIObject, null, null);
        }
        throw apItem.ap_abException;
    }

    public LdapContext getSharedJndiLdapContext(Properties properties) throws AuthBrokerException {
        try {
            if (this.sharedLDAPcontext == null) {
                this.sharedLDAPcontext = (InitialLdapContext)this.getAPIObject(PROTOCOL_JNDI_LDAP, properties);
                LdapContext newLdapCon = this.sharedLDAPcontext.newInstance(this.sharedLDAPcontext.getRequestControls());
                return newLdapCon;
            }
            if (this.isConnectionAlive()) {
                LdapContext newLdapCon = this.sharedLDAPcontext.newInstance(this.sharedLDAPcontext.getRequestControls());
                return newLdapCon;
            }
            this.sharedLDAPcontext = (InitialLdapContext)this.getAPIObject(PROTOCOL_JNDI_LDAP, properties);
            LdapContext newLdapCon = this.sharedLDAPcontext.newInstance(this.sharedLDAPcontext.getRequestControls());
            return newLdapCon;
        }
        catch (NamingException e) {
            throw new AuthBrokerException("Not able to create new LDAP connection instance");
        }
    }

    private boolean isConnectionAlive() {
        String name;
        Hashtable<?, ?> env = null;
        try {
            env = this.sharedLDAPcontext.getEnvironment();
            name = (String)env.get("java.naming.security.principal");
        }
        catch (NamingException e) {
            D.log(e);
            return false;
        }
        try {
            this.sharedLDAPcontext.getAttributes(name);
            return true;
        }
        catch (NamingException e) {
            D.log(e);
            return false;
        }
    }

    public Object getAPIObject(String protocolId, Properties properties) throws AuthBrokerException {
        ActiveProtoItem apItem = this.getActiveProtoItem(protocolId);
        if (apItem.ap_SuccessFlag) {
            if (apItem.ap_abAuthInstance instanceof LazyAuthBrokerAuthenticator) {
                String loginAccessDomain;
                String loginPassword;
                String loginUser;
                if (((ActiveProtoItem)apItem).ap_staticProtoItem.sp_credentialType == 1) {
                    loginUser = this.getAuthLdapName();
                    loginPassword = this.getAuthPIdentity();
                    loginAccessDomain = this.getAuthLdapAccessDomain();
                } else {
                    loginUser = this.getAuthNdapName();
                    loginPassword = this.getAuthPIdentity();
                    loginAccessDomain = this.getAuthNdapAccessDomain();
                }
                Object lazyAuthObj = ((LazyAuthBrokerAuthenticator)apItem.ap_abAuthInstance).authenticate(loginUser, loginPassword, loginAccessDomain, properties);
                if (lazyAuthObj != null) {
                    return lazyAuthObj;
                }
                String errorMsg = eMFrameUtils.getLocalizedString("FwResources", "AuthenticateFailed.NullLazyAuthenticator", this.m_dirAuth.getLocale());
                throw new AuthBrokerException(null, errorMsg, protocolId);
            }
            String errorMsg = eMFrameUtils.getLocalizedString("FwResources", "AuthenticateFailed.BadLazyAuthenticatorImplementation", this.m_dirAuth.getLocale());
            throw new AuthBrokerException(null, errorMsg, protocolId);
        }
        throw apItem.ap_abException;
    }

    public boolean isUsingNPSTree() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActiveProtoItem getActiveProtoItem(String protocolId) {
        ActiveProtoItem apItem = (ActiveProtoItem)this.activeProtoHash.get(protocolId);
        if (apItem == null) {
            StaticProtoItem spItem = this.getStaticProtoItem(protocolId);
            boolean do_fireLoginEvent = false;
            Hashtable hashtable = this.activeProtoHash;
            synchronized (hashtable) {
                apItem = (ActiveProtoItem)this.activeProtoHash.get(protocolId);
                if (apItem == null) {
                    apItem = new ActiveProtoItem(spItem, this.m_dirAuth);
                    if (spItem.sp_SuccessFlag) {
                        try {
                            String loginAccessDomain;
                            String loginPassword;
                            String loginUser;
                            if (((ActiveProtoItem)apItem).ap_staticProtoItem.sp_credentialType == 1) {
                                loginUser = this.getAuthLdapName();
                                loginPassword = this.getAuthPIdentity();
                                loginAccessDomain = this.getAuthLdapAccessDomain();
                            } else {
                                loginUser = this.getAuthNdapName();
                                loginPassword = this.getAuthPIdentity();
                                loginAccessDomain = this.getAuthNdapAccessDomain();
                            }
                            apItem.apItemLogin(loginUser, loginPassword, loginAccessDomain);
                            if (apItem.ap_SuccessFlag) {
                                do_fireLoginEvent = true;
                            }
                        }
                        catch (AuthBrokerException abe) {
                            apItem.apSetAuthBrokerException(abe);
                        }
                    } else {
                        apItem.apSetAuthBrokerException(spItem.sp_abException);
                    }
                    this.activeProtoHash.put(protocolId, apItem);
                }
            }
            if (do_fireLoginEvent) {
                this.fireAuthBrokerEvent(1, protocolId);
            }
        }
        return apItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StaticProtoItem createStaticProtoItem(String protocolId, DirAuthenticator dirAuth) {
        Hashtable hashtable = staticProtoHash;
        synchronized (hashtable) {
            StaticProtoItem spItem = (StaticProtoItem)staticProtoHash.get(protocolId);
            if (spItem == null) {
                for (int i = 0; i < protocol_Information.length; ++i) {
                    String[] info = protocol_Information[i];
                    if (!protocolId.equalsIgnoreCase(info[0])) continue;
                    boolean allowIp = Boolean.valueOf(info[2]);
                    int credentialType = info[3].equalsIgnoreCase("ldap") ? 1 : 2;
                    spItem = new StaticProtoItem(info[0], info[1], allowIp, credentialType);
                    spItem.sp_init();
                    break;
                }
                if (spItem == null) {
                    String errorMsg = eMFrameUtils.getLocalizedString("FwResources", "AuthenticateFailed.InvalidProtocolRequested", dirAuth.getLocale());
                    AuthBrokerException ae = new AuthBrokerException(null, errorMsg, protocolId);
                    spItem = new StaticProtoItem(protocolId, protocolId + " ?", true, 2, ae);
                    D.log(ae.toString());
                }
                staticProtoHash.put(protocolId, spItem);
            }
            return spItem;
        }
    }

    private StaticProtoItem getStaticProtoItem(String protocolId) {
        StaticProtoItem spItem = (StaticProtoItem)staticProtoHash.get(protocolId);
        if (spItem == null) {
            spItem = this.createStaticProtoItem(protocolId, this.m_dirAuth);
        }
        return spItem;
    }

    private AuthBrokerException resolveStaticProtoItemInitError(Throwable te, String javaClass) {
        String errorMsg;
        if (te == null) {
            errorMsg = eMFrameUtils.getLocalizedString("FwResources", "AuthenticateFailed.UnknownInitializeFailure", this.m_dirAuth.getLocale());
        } else if (te instanceof ClassNotFoundException || te instanceof NoClassDefFoundError) {
            errorMsg = eMFrameUtils.getLocalizedString("FwResources", "AuthenticateFailed.ClassFileNotFound", this.m_dirAuth.getLocale());
        } else if (te instanceof UnsatisfiedLinkError) {
            errorMsg = eMFrameUtils.getLocalizedString("FwResources", "AuthenticateFailed.NoNativeLibraries", this.m_dirAuth.getLocale());
        } else {
            errorMsg = eMFrameUtils.getLocalizedString("FwResources", "AuthenticateFailed.ThrownInitializeError", this.m_dirAuth.getLocale());
            errorMsg = errorMsg + "  " + te.toString();
        }
        AuthBrokerException retae = new AuthBrokerException(null, errorMsg, javaClass);
        return retae;
    }

    class ActiveProtoItem {
        public boolean ap_SuccessFlag = false;
        public AuthBrokerException ap_abException = null;
        public Object ap_loginAPIObject = null;
        public AuthBrokerReport ap_APIReport = null;
        public AuthBrokerAuthenticator ap_abAuthInstance = null;
        private StaticProtoItem ap_staticProtoItem;
        private DirAuthenticator ap_manageSS;

        public ActiveProtoItem(StaticProtoItem spItem, DirAuthenticator dirAuth) {
            this.ap_staticProtoItem = spItem;
            this.ap_manageSS = dirAuth;
        }

        public void apSetAuthBrokerException(AuthBrokerException abException) {
            this.ap_staticProtoItem.sp_SuccessFlag = false;
            this.ap_abException = abException;
        }

        public void apItemLogin(String name, String password, String inaccessDomain) {
            try {
                String loginAccessDomain = inaccessDomain;
                if (!this.ap_staticProtoItem.sp_allowIP) {
                    loginAccessDomain = AuthenticationBroker.this.getAuthTreeName();
                }
                this.ap_abAuthInstance = this.createAuthProtocolInstance();
                this.ap_loginAPIObject = this.ap_abAuthInstance.login(name, password, loginAccessDomain, this.ap_manageSS.getManagementServicesSet());
                if (this.ap_loginAPIObject != null) {
                    if (this.ap_loginAPIObject instanceof AuthBrokerReport) {
                        this.ap_APIReport = (AuthBrokerReport)this.ap_loginAPIObject;
                        this.ap_loginAPIObject = this.ap_APIReport.getLoginAPIObject();
                    }
                    this.ap_SuccessFlag = true;
                } else {
                    String errorMsg = eMFrameUtils.getLocalizedString("FwResources", "AuthenticateFailed.NullLoginApiObject", this.ap_manageSS.getLocale());
                    this.ap_abException = new AuthBrokerException(null, errorMsg, this.ap_staticProtoItem.sp_javaClass);
                }
            }
            catch (Throwable te) {
                if (te instanceof AuthBrokerException) {
                    this.ap_abException = (AuthBrokerException)te;
                } else {
                    String errorMsg = eMFrameUtils.getLocalizedString("FwResources", "AuthenticateFailed.ThrownLoginError", this.ap_manageSS.getLocale());
                    errorMsg = errorMsg + "  " + te.toString();
                    this.ap_abException = new AuthBrokerException(null, errorMsg, this.ap_staticProtoItem.sp_javaClass);
                }
                D.log(this.ap_abException.toString());
            }
        }

        public void apItemLogout() {
            if (this.ap_SuccessFlag) {
                try {
                    if (this.ap_APIReport != null) {
                        this.ap_abAuthInstance.logout(this.ap_APIReport);
                    } else {
                        this.ap_abAuthInstance.logout(this.ap_loginAPIObject);
                    }
                }
                catch (Throwable t) {
                    D.log("Could not successfully log out of " + this.ap_staticProtoItem.sp_javaClass);
                    D.log(t);
                }
            }
        }

        private AuthBrokerAuthenticator createAuthProtocolInstance() throws AuthBrokerException {
            try {
                Object obj_inst = this.ap_staticProtoItem.sp_classObject.newInstance();
                if (obj_inst instanceof AuthBrokerAuthenticator) {
                    return (AuthBrokerAuthenticator)obj_inst;
                }
                String errorMsg = eMFrameUtils.getLocalizedString("FwResources", "AuthenticateFailed.BadAuthenticatorImplementation", this.ap_manageSS.getLocale());
                AuthBrokerException retae = new AuthBrokerException(null, errorMsg, this.ap_staticProtoItem.sp_javaClass);
                throw retae;
            }
            catch (Throwable e) {
                String errorMsg = eMFrameUtils.getLocalizedString("FwResources", "AuthenticateFailed.UnableToCreateInstance", this.ap_manageSS.getLocale());
                errorMsg = errorMsg + "  " + e.toString();
                AuthBrokerException retae = new AuthBrokerException(null, errorMsg, this.ap_staticProtoItem.sp_javaClass);
                throw retae;
            }
        }
    }

    class StaticProtoItem {
        public boolean sp_SuccessFlag = false;
        public AuthBrokerException sp_abException = null;
        public Class sp_classObject;
        public String sp_protocolId;
        public String sp_javaClass;
        public boolean sp_allowIP;
        public int sp_credentialType;

        public StaticProtoItem(String inprotocolId, String injavaClass, boolean inallowIP, int credentialType) {
            this.sp_protocolId = inprotocolId;
            this.sp_javaClass = injavaClass;
            this.sp_allowIP = inallowIP;
            this.sp_credentialType = credentialType;
        }

        public StaticProtoItem(String inprotocolId, String injavaClass, boolean inallowIP, int credentialType, AuthBrokerException inabExcept) {
            this.sp_protocolId = inprotocolId;
            this.sp_javaClass = injavaClass;
            this.sp_allowIP = inallowIP;
            this.sp_credentialType = credentialType;
            this.sp_abException = inabExcept;
        }

        public void sp_init() {
            try {
                this.sp_classObject = Class.forName(this.sp_javaClass);
                Method initMethod = this.sp_classObject.getMethod("init", new Class[0]);
                Object retobj = initMethod.invoke(null, new Object[0]);
                if (((Boolean)retobj).booleanValue()) {
                    this.sp_SuccessFlag = true;
                } else {
                    this.sp_abException = AuthenticationBroker.this.resolveStaticProtoItemInitError(null, this.sp_javaClass);
                    D.log("Static init method returned false for: " + this.sp_javaClass);
                }
            }
            catch (Throwable te) {
                this.sp_abException = AuthenticationBroker.this.resolveStaticProtoItemInitError(te, this.sp_javaClass);
                D.log(te.toString());
            }
        }

        public void sp_destroy() {
            if (this.sp_SuccessFlag) {
                try {
                    Method destroyMethod = this.sp_classObject.getMethod("destroy", new Class[0]);
                    destroyMethod.invoke(null, new Object[0]);
                }
                catch (Throwable e) {
                    D.log(e);
                }
            }
        }
    }
}

