/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.dev;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.MOOManager;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.ObjectOperation;
import com.novell.admin.ns.Rights;
import com.novell.admin.ns.SchemaUtil;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DataHandler;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.TargetObjects;
import com.novell.emframe.dev.XmlUtils;
import com.novell.emframe.dev.eDirAccessServiceException;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.dev.rights.eDirRightsObject;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.iManager;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ListIterator;
import org.jdom.CDATA;
import org.jdom.Document;
import org.jdom.Element;

public abstract class DataHandlerHelper
extends DataHandler {
    private String oldProfileDN = null;
    private ArrayList addedValues = null;
    private ArrayList removedValues = null;

    protected abstract void valueComponentToXml(ValueComponent var1, StringBuffer var2, String var3, Syntax var4) throws eDirAccessServiceException;

    protected abstract ValueComponent xmlToValueComponent(AttributeDefinition var1, Element var2, MContext var3) throws Exception;

    @Override
    public String getString(Object theObj, String attrName, MContext context) throws eDirAccessServiceException {
        Syntax syntax;
        StringBuffer resultValue = new StringBuffer(25);
        boolean isRefresh = false;
        if (context.getRequest().getAttribute("isRefresh") != null) {
            isRefresh = context.getRequest().getAttribute("isRefresh").equals("true");
        }
        ObjectEntry objectEntry = theObj instanceof MOOManager ? ((MOOManager)theObj).getTreeObjectEntry() : (!isRefresh ? ((NSObject)theObj).getObjectEntry() : ((TargetObjects)context.getRequest().getAttribute("targetObjects")).getObjectEntry());
        AdminNamespace ns = objectEntry.getAdminNamespace();
        try {
            AttributeDefinition attributeDef = ns.getAttributeDefinition(objectEntry, attrName);
            syntax = attributeDef.getSyntax();
        }
        catch (Exception e) {
            D.log("EDAS: Unrecognized Attribute:" + attrName);
            throw new eDirAccessServiceException(e);
        }
        resultValue.append("<");
        resultValue.append(FwUtils.getSafeName(attrName));
        Enumeration valuesEnum = null;
        if (theObj instanceof MOOManager) {
            ObjectOperation objectOperation = ((MOOManager)theObj).getObjectOperation(attrName);
            if (objectOperation != null) {
                String op = DataHandler.getOperationAsString(objectOperation.getMode());
                resultValue.append(" mode='").append(op).append("'>");
                valuesEnum = objectOperation.getValueComponents();
            } else {
                resultValue.append(" mode='ignore'>");
            }
        } else {
            ObjectAttribute objectAttribute = null;
            if (!isRefresh) {
                objectAttribute = ((NSObject)theObj).getAttribute(attrName);
            } else {
                ObjectEntry treeOE = null;
                try {
                    treeOE = (ObjectEntry)context.getAuthenticationBroker().getProtocolObject("AdminNamespace");
                }
                catch (AuthBrokerException e) {
                    e.printStackTrace();
                }
                AdminNamespace ns1 = (AdminNamespace)treeOE.getNamespace();
                try {
                    TargetObjects targetObjects = (TargetObjects)context.getRequest().getAttribute("targetObjects");
                    objectAttribute = ns1.getAttribute(targetObjects.getObjectEntry(), attrName);
                }
                catch (SPIException e) {
                    e.printStackTrace();
                }
            }
            resultValue.append(">");
            if (objectAttribute != null) {
                valuesEnum = objectAttribute.getValueComponents();
            }
        }
        if (valuesEnum != null) {
            while (valuesEnum.hasMoreElements()) {
                ValueComponent vc = (ValueComponent)valuesEnum.nextElement();
                this.valueComponentToXml(vc, resultValue, attrName, syntax);
            }
        }
        resultValue.append("</").append(FwUtils.getSafeName(attrName)).append(">");
        String value = resultValue.toString();
        try {
            new CDATA(XmlUtils.xmlEncode(value));
        }
        catch (Exception e) {
            D.log(attrName + " contains illegal XML data, write AttributeHandler to access data.");
            value = "";
        }
        return value;
    }

    @Override
    public void setString(Object theObj, String attributeName, String value, MContext context) throws eDirAccessServiceException {
        block20: {
            AttributeDefinition attributeDef;
            ObjectEntry objectEntry = theObj instanceof MOOManager ? ((MOOManager)theObj).getTreeObjectEntry() : ((NSObject)theObj).getObjectEntry();
            AdminNamespace namespace = objectEntry.getAdminNamespace();
            try {
                attributeDef = namespace.getAttributeDefinition(objectEntry, attributeName);
                if (theObj instanceof NSObject && !((NSObject)theObj).getShadowSign() && attributeDef.isReadOnly()) {
                    String strBody = eMFrameUtils.getLocalizedString("FwResources", "EDASReadOnlyAttribute", context);
                    throw new eDirAccessServiceException(new Exception(eMFrameUtils.formatMessage(strBody, new String[]{attributeName})));
                }
            }
            catch (Exception e) {
                D.log(e);
                D.log("Unrecognized Attribute:" + attributeName);
                throw new eDirAccessServiceException(e);
            }
            Document doc = null;
            try {
                doc = iManager.getSaxBuilder().build((Reader)new StringReader(value));
            }
            catch (Exception e) {
                D.log("Bad XML or invalid control character for " + attributeName);
                throw new eDirAccessServiceException(e);
            }
            Element root = doc.getRootElement();
            String mode = root.getAttributeValue("mode");
            if (mode == null) {
                mode = theObj instanceof MOOManager ? "ignore" : "set";
            }
            try {
                String groupMembership = SchemaUtil.translateNDAPAttr((ObjectEntry)objectEntry, (String)"Group Membership");
                String securityEquals = SchemaUtil.translateNDAPAttr((ObjectEntry)objectEntry, (String)"Security Equals");
                String member = SchemaUtil.translateNDAPAttr((ObjectEntry)objectEntry, (String)"Member");
                String equivalentToMe = SchemaUtil.translateNDAPAttr((ObjectEntry)objectEntry, (String)"Equivalent To Me");
                if (theObj instanceof MOOManager) {
                    MOOManager mooManager = (MOOManager)theObj;
                    ObjectOperation objectOperation = this.writeToMoo(root, attributeDef, mode, context, mooManager);
                    mooManager.addObjectOperation(objectOperation);
                    if (attributeName.equals(groupMembership)) {
                        ObjectOperation syncObjectOperation = DataHandlerHelper.syncWithSelf(securityEquals, namespace, objectEntry, mode, objectOperation);
                        mooManager.addObjectOperation(syncObjectOperation);
                    } else if (attributeName.equals(member)) {
                        ObjectOperation syncObjectOperation = DataHandlerHelper.syncWithSelf(equivalentToMe, namespace, objectEntry, mode, objectOperation);
                        mooManager.addObjectOperation(syncObjectOperation);
                    }
                    break block20;
                }
                NSObject nsObj = (NSObject)theObj;
                if (attributeName.equals(groupMembership)) {
                    this.writeToNSObjectWithSync(nsObj, attributeName, securityEquals, attributeDef, root, context, namespace);
                    break block20;
                }
                if (attributeName.equals(member)) {
                    this.writeToNSObjectWithSync(nsObj, attributeName, equivalentToMe, attributeDef, root, context, namespace);
                    break block20;
                }
                if (attributeName.equals("Profile")) {
                    try {
                        ObjectAttribute tmpProfAttr = nsObj.getAttribute("Profile");
                        if (tmpProfAttr != null) {
                            ValueComponent attrvc = (ValueComponent)tmpProfAttr.getValueComponents().nextElement();
                            this.oldProfileDN = attrvc.toString();
                        }
                    }
                    catch (Exception e) {
                        this.oldProfileDN = "";
                    }
                    this.writeToNSObject(nsObj, attributeDef, root, context);
                    break block20;
                }
                this.writeToNSObject(nsObj, attributeDef, root, context);
            }
            catch (Exception e) {
                D.log(e);
                if (e instanceof NamespaceException && e == NamespaceException.VALUE_NOT_WITHIN_BOUNDS) {
                    D.log("The attribute value is out of bounds!!!");
                    String body = eMFrameUtils.getLocalizedString("FwResources", "EDASAttributeOutOfBounds", context);
                    String title = eMFrameUtils.getLocalizedString("FwResources", "Error", context);
                    throw new eDirAccessServiceException(title, eMFrameUtils.formatMessage(body, new String[]{attributeName}));
                }
                if (e instanceof ComponentCreationException) {
                    String body = eMFrameUtils.getLocalizedString("FwResources", "EDAS.InvalidAttributeValue", context);
                    String title = eMFrameUtils.getLocalizedString("FwResources", "Error", context);
                    throw new eDirAccessServiceException(title, eMFrameUtils.formatMessage(body, new String[]{attributeName}));
                }
                throw new eDirAccessServiceException(e);
            }
        }
    }

    private static ObjectOperation syncWithSelf(String attributeName, AdminNamespace ns, ObjectEntry theOE, String mode, ObjectOperation objectOperation) throws SPIException, NamespaceException {
        AttributeDefinition syncAttrDef = ns.getAttributeDefinition(theOE, attributeName);
        ObjectAttribute oa = new ObjectAttribute(syncAttrDef);
        ObjectOperation syncObjectOperation = new ObjectOperation(oa, DataHandlerHelper.getOperationType(mode));
        Enumeration myenum = objectOperation.getValueComponents();
        while (myenum.hasMoreElements()) {
            ValueComponent valueComponent = (ValueComponent)myenum.nextElement();
            syncObjectOperation.addComponent(valueComponent);
        }
        if (DataHandlerHelper.getOperationType(mode) == 3) {
            int i;
            ValueComponent[] vcs = objectOperation.getObjectAttribute().getDeletedComponents();
            for (i = 0; i < vcs.length; ++i) {
                syncObjectOperation.getObjectAttribute().addComponent(vcs[i]);
            }
            syncObjectOperation.getObjectAttribute().resetBeginningAttributeValues();
            for (i = 0; i < vcs.length; ++i) {
                syncObjectOperation.getObjectAttribute().removeComponent(vcs[i]);
            }
        }
        return syncObjectOperation;
    }

    private void writeToNSObjectWithSync(NSObject nsObj, String attrName, String syncAttributeName, AttributeDefinition attributeDef, Element root, MContext context, AdminNamespace ns) throws Exception {
        ValueComponent vc;
        ObjectAttribute attribute = nsObj.getAttribute(attrName);
        ArrayList<String> oldValues = new ArrayList<String>();
        if (attribute != null) {
            Enumeration myenum = attribute.getValueComponents();
            while (myenum.hasMoreElements()) {
                oldValues.add(myenum.nextElement().toString());
            }
        }
        this.writeToNSObject(nsObj, attributeDef, root, context);
        attribute = nsObj.getAttribute(attrName);
        ArrayList<String> newValues = new ArrayList<String>();
        if (attribute != null) {
            Enumeration myenum = attribute.getValueComponents();
            while (myenum.hasMoreElements()) {
                newValues.add(myenum.nextElement().toString());
            }
        }
        ArrayList addList = new ArrayList(newValues);
        addList.removeAll(oldValues);
        ArrayList removeList = new ArrayList(oldValues);
        removeList.removeAll(newValues);
        ObjectAttribute syncAttribute = nsObj.getAttribute(syncAttributeName);
        boolean needToAddSyncAttr = false;
        if (syncAttribute == null) {
            ObjectEntry treeOE = (ObjectEntry)context.getAuthenticationBroker().getProtocolObject("AdminNamespace");
            AttributeDefinition ad = ns.getAttributeDefinition(treeOE, syncAttributeName);
            syncAttribute = new ObjectAttribute(ad);
            needToAddSyncAttr = addList.size() > 0;
        }
        Syntax syn = syncAttribute.getAttributeDefinition().getSyntax();
        Iterator iter = addList.iterator();
        while (iter.hasNext()) {
            vc = syn.createValueComponent(iter.next());
            syncAttribute.addComponent(vc);
        }
        iter = removeList.iterator();
        while (iter.hasNext()) {
            vc = syn.createValueComponent(iter.next());
            syncAttribute.removeComponent(vc);
        }
        try {
            if (needToAddSyncAttr) {
                nsObj.addAttribute(syncAttribute);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void writeToNSObject(NSObject nsObj, AttributeDefinition attributeDef, Element root, MContext context) throws Exception {
        String attributeName = attributeDef.getName();
        ObjectAttribute attribute = nsObj.getAttribute(attributeName);
        boolean isEmpty = root.getChildren().size() <= 0;
        boolean needToAdd = false;
        String removeExistingValues = root.getAttributeValue("removeExistingValues");
        if (attribute == null) {
            if (isEmpty) {
                return;
            }
            attribute = new ObjectAttribute(attributeDef);
            needToAdd = true;
        } else if (removeExistingValues == null || removeExistingValues.equalsIgnoreCase("true")) {
            attribute.removeAllComponents();
        }
        if (!isEmpty) {
            this.addValuesToAttribute(root, attributeDef, attribute, context);
        }
        if (needToAdd && attribute.getComponentCount() != 0) {
            nsObj.addAttribute(attribute);
        }
        if (attribute != null && attribute.getComponentCount() == 0 && (attributeName.equals("Login Script") || attributeDef.getSyntax() == NDSSyntax.SYN_COUNTER)) {
            nsObj.deleteAttribute(attributeName);
        }
        try {
            if (attribute != null && attributeName.equals("Profile")) {
                ObjectEntry tmpObj = nsObj.getObjectEntry();
                AdminNamespace ns = tmpObj.getAdminNamespace();
                NDSNamespace ndsNS = null;
                if (ns instanceof NDSNamespace) {
                    ndsNS = (NDSNamespace)ns;
                }
                ObjectAttribute profAttr = nsObj.getAttribute("Profile");
                String profDN = "";
                if (profAttr != null && ndsNS != null) {
                    Enumeration vcEnum = profAttr.getValueComponents();
                    if (vcEnum.hasMoreElements()) {
                        ValueComponent attrvc = (ValueComponent)vcEnum.nextElement();
                        profDN = attrvc.toString();
                    }
                    ObjectEntry profileObj = null;
                    Rights rgt = null;
                    eDirRightsObject eDirRt = null;
                    if (profDN != null && !profDN.equals("")) {
                        profileObj = ns.getObjectEntry(profDN);
                        rgt = ndsNS.getPropertyEffectiveRights(profileObj, tmpObj, "Login Script");
                        if (!rgt.hasReadRights()) {
                            eDirRt = new eDirRightsObject(ndsNS.getDetails(profileObj));
                            eDirRt.setPropertyRights("Login Script", tmpObj.getFullName(), 2, 2);
                            eDirRt.updateData();
                        } else {
                            D.log("read rights already exist");
                        }
                    } else {
                        profileObj = ns.getObjectEntry(this.oldProfileDN);
                        rgt = ndsNS.getPropertyEffectiveRights(profileObj, tmpObj, "Login Script");
                        if (rgt.hasAddRights() || rgt.hasDeleteRights() || rgt.hasWriteRights()) {
                            D.log("Additional Rights exist on the Profile");
                        } else {
                            eDirRt = new eDirRightsObject(ndsNS.getDetails(profileObj));
                            boolean result = eDirRt.deleteACL(tmpObj.getFullName(), "Login Script", 2);
                            if (!result) {
                                result = eDirRt.deleteTrustee(tmpObj.getFullName());
                            }
                            if (result) {
                                eDirRt.updateData();
                            } else {
                                D.log("Read Rights cannot be removed");
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            D.log(e);
        }
    }

    private void addValuesToAttribute(Element root, AttributeDefinition attributeDef, ObjectAttribute attribute, MContext context) throws Exception {
        if (attributeDef.isSingleValued()) {
            ValueComponent vc;
            Element child = root.getChild("value");
            if (child != null && child.getTextTrim() != null && (vc = this.xmlToValueComponent(attributeDef, child, context)) != null) {
                String action = child.getAttributeValue("action");
                if (action == null || action == "add") {
                    attribute.addComponent(vc);
                } else {
                    attribute.removeComponent(vc);
                }
            }
        } else {
            ListIterator values = root.getChildren("value").listIterator();
            while (values.hasNext()) {
                Element child = (Element)values.next();
                ValueComponent vc = this.xmlToValueComponent(attributeDef, child, context);
                if (vc == null) continue;
                String action = child.getAttributeValue("action");
                if (action == null || action.equals("add")) {
                    attribute.addComponent(vc);
                    continue;
                }
                attribute.removeComponent(vc);
            }
        }
    }

    private ObjectOperation writeToMoo(Element root, AttributeDefinition attributeDef, String mode, MContext context, Object mooObj) throws Exception {
        ValueComponent vc;
        ArrayList vcObjs;
        TargetObjects targetObjs;
        int dsMode = DataHandlerHelper.getOperationType(mode);
        ObjectOperation objectOperation = new ObjectOperation(new ObjectAttribute(attributeDef), dsMode);
        if (!this.isPostalAttr(attributeDef.getName()) && dsMode == 3 && !attributeDef.isSingleValued()) {
            targetObjs = (TargetObjects)context.getRequest().getAttribute("targetObjects");
            ObjectOperation prevObjOp = ((MOOManager)mooObj).getObjectOperation(attributeDef.getName());
            ArrayList vcObjs2 = DirUtils.getCommonValues(context, mooObj, targetObjs, attributeDef.getName());
            if (vcObjs2 != null) {
                int i;
                ArrayList<Object> delValues = new ArrayList(vcObjs2);
                ArrayList<ValueComponent> values = new ArrayList<ValueComponent>();
                ListIterator theElements = root.getChildren("value").listIterator();
                while (theElements.hasNext()) {
                    ValueComponent vc2 = this.xmlToValueComponent(attributeDef, (Element)theElements.next(), context);
                    if (vc2 == null) continue;
                    values.add(vc2);
                }
                ArrayList addValues = new ArrayList(values);
                delValues.removeAll(values);
                for (i = 0; i < vcObjs2.size(); ++i) {
                    objectOperation.getObjectAttribute().addComponent((ValueComponent)vcObjs2.get(i));
                }
                for (i = 0; i < values.size(); ++i) {
                    objectOperation.getObjectAttribute().addComponent((ValueComponent)values.get(i));
                }
                objectOperation.getObjectAttribute().resetBeginningAttributeValues();
                if (delValues.size() > 0) {
                    for (i = 0; i < delValues.size(); ++i) {
                        objectOperation.getObjectAttribute().removeComponent((ValueComponent)delValues.get(i));
                    }
                }
                if (prevObjOp != null) {
                    ArrayList<Object> prevAddedValues = new ArrayList<Object>(Arrays.asList(prevObjOp.getObjectAttribute().getValueComponentsAsArray()));
                    ArrayList newlyAddedValues = new ArrayList(values);
                    addValues = new ArrayList(newlyAddedValues);
                    delValues = new ArrayList<Object>(prevAddedValues);
                    addValues.removeAll(prevAddedValues);
                    delValues.removeAll(newlyAddedValues);
                    this.addedValues = addValues;
                    this.removedValues = delValues;
                }
                return objectOperation;
            }
        }
        if (this.isPostalAttr(attributeDef.getName()) && dsMode == 3 && !attributeDef.isSingleValued() && (vcObjs = DirUtils.getAllValues(context, mooObj, targetObjs = (TargetObjects)context.getRequest().getAttribute("targetObjects"), attributeDef.getName())) != null) {
            int i;
            ArrayList<ValueComponent> values = new ArrayList<ValueComponent>();
            ListIterator theElements = root.getChildren("value").listIterator();
            while (theElements.hasNext()) {
                ValueComponent vc3 = this.xmlToValueComponent(attributeDef, (Element)theElements.next(), context);
                if (vc3 == null) continue;
                values.add(vc3);
            }
            for (i = 0; i < vcObjs.size(); ++i) {
                objectOperation.getObjectAttribute().addComponent((ValueComponent)vcObjs.get(i));
            }
            for (i = 0; i < values.size(); ++i) {
                objectOperation.getObjectAttribute().addComponent((ValueComponent)values.get(i));
            }
            objectOperation.getObjectAttribute().resetBeginningAttributeValues();
            if (vcObjs.size() > 0) {
                for (i = 0; i < vcObjs.size(); ++i) {
                    objectOperation.getObjectAttribute().removeComponent((ValueComponent)vcObjs.get(i));
                }
            }
            return objectOperation;
        }
        if (attributeDef.isSingleValued()) {
            Element child = root.getChild("value");
            if (child != null && child.getTextTrim() != null && (vc = this.xmlToValueComponent(attributeDef, child, context)) != null) {
                objectOperation.addComponent(vc);
            }
        } else {
            ListIterator theElements = root.getChildren("value").listIterator();
            while (theElements.hasNext()) {
                vc = this.xmlToValueComponent(attributeDef, (Element)theElements.next(), context);
                if (vc == null) continue;
                objectOperation.addComponent(vc);
            }
        }
        return objectOperation;
    }

    private boolean isPostalAttr(String name) {
        String[] postalAttr = new String[]{"SA", "Postal Office Box", "Physical Delivery Office Name", "S", "Postal Code"};
        ArrayList<String> postalAttrList = new ArrayList<String>(Arrays.asList(postalAttr));
        return postalAttrList.contains(name);
    }
}

