/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.dev;

import com.novell.admin.ns.MOOManager;
import com.novell.admin.ns.NSObject;
import com.novell.emframe.dev.DirPropertyBook;
import com.novell.emframe.dev.PageException;
import com.novell.emframe.dev.PluginContext;
import com.novell.emframe.dev.PropertyBookPage;
import com.novell.emframe.dev.PropertyPageContext;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eDirAccessServiceException;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.Target;
import com.novell.emframe.fw.TargetCollection;
import java.util.Properties;
import org.jdom.Document;
import org.jdom.Element;

public class DirPropertyBookPage
extends PropertyBookPage {
    protected NSObject m_nsobj = null;
    protected MOOManager m_mooManager = null;
    protected boolean m_mooEnabled = false;
    private String[] m_attributesForEdas = new String[0];
    private Properties m_customHandlers = new Properties();

    public DirPropertyBook getDirPropertyBook() {
        return (DirPropertyBook)this.m_propertyBook;
    }

    @Override
    public void init(TaskContext context, Document doc) {
        super.init(context, doc);
    }

    @Override
    public void init(PluginContext context, Document doc) {
        super.init(context, doc);
        Element root = doc.getRootElement();
        if (root.getChild("moo-enabled") != null) {
            this.m_mooEnabled = true;
        }
        this.m_attributesForEdas = FwUtils.extractAttributesForEDAS(root);
        if (this.m_attributesForEdas == null || this.m_attributesForEdas.length == 0) {
            this.m_attributesForEdas = context.getDirUtils().getSortedAttrs();
        }
        FwUtils.extractCustomDataHandlers(this.m_customHandlers, doc);
    }

    @Override
    public void save(TaskContext context, Properties resultStrings) throws PageException {
        try {
            this.getDirPropertyBook().m_targets.write(this.m_customHandlers, context);
        }
        catch (eDirAccessServiceException e) {
            throw new PageException(e);
        }
    }

    @Override
    public void show(TaskContext context, Properties resultStrings) throws PageException {
        try {
            TargetCollection targets = this.getDirPropertyBook().m_targets;
            Target primaryTarget = targets.getTarget("target");
            primaryTarget.read("target", this.getAttributesForEDAS((PropertyPageContext)context), this.m_customHandlers, false, context);
            context.getRequest().setAttribute("edasRights", (Object)targets.getEdasRightsData());
        }
        catch (eDirAccessServiceException e) {
            throw new PageException(e);
        }
    }

    protected boolean doesSupportMoo() {
        return this.m_mooEnabled;
    }

    public String[] getAttributesForEDAS(PropertyPageContext context) {
        return this.m_attributesForEdas;
    }
}

