/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.dev;

import com.novell.admin.event.DirectoryEvent;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.fw.FwAttr;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.authenticator.DirAuthenticator;
import com.novell.nps.sessionManager.PortalSession;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ManagementServiceSet {
    protected DirAuthenticator m_dirAuth = null;
    protected HttpSession m_session = null;

    protected ManagementServiceSet(DirAuthenticator dirAuth) {
        this.m_dirAuth = dirAuth;
    }

    private ManagementServiceSet() {
    }

    public Hashtable getSessionCache() {
        return this.m_dirAuth.getAuthContext();
    }

    public boolean isAuthenticated(HttpServletRequest req) {
        return this.m_dirAuth.isAuthenticated(req);
    }

    public boolean login(HttpServletRequest req, HttpServletResponse res) {
        return this.m_dirAuth.handleLogin(req, res);
    }

    public Locale getLocale() {
        return FwUtils.getCurrentLocale(this.m_session);
    }

    public final PortalSession getSession() {
        return (PortalSession)FwAttr.getFwAuthAttribute("Session", this.m_dirAuth);
    }

    public Object getAttribute(Object attrKey) {
        return this.m_dirAuth.getAttribute(attrKey);
    }

    public void setAttribute(Object attrKey, Object attrValue) {
        this.m_dirAuth.setAttribute(attrKey, attrValue);
    }

    public void removeAttribute(Object attrKey) {
        this.m_dirAuth.removeAttribute(attrKey);
    }

    public DirUtils getDirUtils() {
        return this.m_dirAuth.getDirUtils();
    }

    public AuthenticationBroker getAuthenticationBroker() {
        return this.m_dirAuth.getAuthenticationBroker();
    }

    public LinkedHashMap getAuthenticationBrokers() {
        return this.m_dirAuth.getAuthenticationBrokers();
    }

    public void resetPIdentity(String new_PIdentity) throws AuthBrokerException {
        this.m_dirAuth.resetPIdentity(new_PIdentity);
    }

    public boolean isPrimaryDataStore() {
        return this.m_dirAuth.isPrimaryDataStore();
    }

    public void setDisconnected(boolean isDisconnected) {
    }

    public boolean isDisconnected() {
        return false;
    }

    public final String getGlobalVar(String varName) {
        return (String)this.getAttribute(varName);
    }

    public final void setGlobalVar(String varName, String val) {
        this.setAttribute(varName, val);
    }

    public final void removeGlobalVar(String varName) {
        this.removeAttribute(varName);
    }

    public static ManagementServiceSet getManagementServiceSet(HttpSession session) {
        return DirAuthenticator.getManagementServiceSet(session);
    }

    public String handleDirectoryEvent(DirectoryEvent event, Object userData) {
        return this.m_dirAuth.handleDirectoryEvent(event);
    }
}

