/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.dev;

import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.LazyAuthBrokerAuthenticator;
import com.novell.emframe.dev.ManagementServiceSet;
import com.novell.nps.file.NPSFile;
import java.util.Properties;

public class NPSFileAuthenticator
extends LazyAuthBrokerAuthenticator {
    public static final String NPSFILE_USERNAME = "NPSFILEAUTH_USERNAME";
    public static final String NPSFILE_PASSWORD = "NPSFILEAUTH_PASSWORD";
    public static final String NPSFILE_URI = "NPSFILEAUTH_URI";
    public static final String NPSFILETYPE_LOCALACCESS = "NPSFILEAUTH_USELOCALACCESS";
    private ManagementServiceSet m_manageSS;

    @Override
    public Object login(String name, String password, String accessDomain, ManagementServiceSet manageSS) throws AuthBrokerException {
        this.m_manageSS = manageSS;
        return this;
    }

    @Override
    public void logout(Object apiObject) {
        this.m_manageSS = null;
    }

    @Override
    public Object authenticate(String ndapName, String password, String ndapAccessDomain, Properties properties) throws AuthBrokerException {
        String fileUsername = null;
        String filePassword = null;
        String fileURI = null;
        if (properties != null) {
            fileUsername = properties.getProperty(NPSFILE_USERNAME);
            filePassword = properties.getProperty(NPSFILE_PASSWORD);
            fileURI = properties.getProperty(NPSFILE_URI);
        }
        if (fileUsername == null) {
            StringBuffer userBuff = new StringBuffer(32);
            int ulen = ndapName.length();
            for (int chkPos = 0; chkPos < ulen; ++chkPos) {
                char chkChar = ndapName.charAt(chkPos);
                if (ndapName.charAt(chkPos) == '.') break;
                if (ndapName.charAt(chkPos) == '\\') {
                    if (++chkPos >= ulen) break;
                    chkChar = ndapName.charAt(chkPos);
                }
                userBuff.append(chkChar);
            }
            fileUsername = userBuff.toString();
        } else if (fileUsername == NPSFILETYPE_LOCALACCESS) {
            fileUsername = null;
        }
        if (filePassword == null) {
            filePassword = password;
        } else if (filePassword == NPSFILETYPE_LOCALACCESS) {
            filePassword = null;
        }
        if (fileURI == null) {
            AuthenticationBroker ab = this.m_manageSS.getAuthenticationBroker();
            fileURI = ab.getAuthLdapAccessDomain();
            int colonOff = fileURI.indexOf(58);
            if (colonOff >= 0) {
                fileURI = fileURI.substring(0, colonOff);
            }
            fileURI = "//" + fileURI + "/sys";
        }
        NPSFile abNPSFile = new NPSFile(fileUsername, filePassword, fileURI);
        return abNPSFile;
    }
}

