/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.dev;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.FilterResultModifier;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.ValueComponent;
import com.novell.application.console.snapin.CountableObjectEntryEnumeration;
import com.novell.application.console.snapin.DefaultObjectEntryEnumeration;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.ObjectType;
import com.novell.application.console.snapin.ResultModifier;
import com.novell.application.console.snapin.ResultModifierFilterEntry;
import com.novell.application.console.snapin.SnapinException;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.PluginException;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class TargetObjects {
    private boolean m_multiple;
    private ObjectEntryEnumeration m_oee;
    private ObjectEntry m_oe;
    private int m_count = -1;
    private String m_queryString = null;
    private int m_countReliability = 5;
    private Locale m_locale = null;
    private ArrayList m_errors = new ArrayList();
    private ArrayList m_badObjectNames = new ArrayList();
    private ObjectEntry[] m_objectEntryArray = null;

    public static TargetObjects createInstance(String id, TaskContext context) throws PluginException, SPIException {
        String paramName = "TC_" + id;
        return new TargetObjects(context.getRequest().getParameter(paramName), context);
    }

    public TargetObjects(String pack, TaskContext context) throws SPIException, PluginException {
        this.m_queryString = pack;
        this.m_locale = context.getLocale();
        try {
            this.init(context);
        }
        catch (JDOMException e) {
            throw new PluginException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new PluginException(e);
        }
        if (this.m_count == 0 && this.m_countReliability == 1) {
            String header = eMFrameUtils.getLocalizedString("FwResources", "TargetObjects.noObjectsFound", context);
            String body = eMFrameUtils.getLocalizedString("FwResources", "TargetObjects.noObjectsFoundDetails", context);
            throw new PluginException(header, body);
        }
    }

    public void reset(TaskContext context) throws SPIException, JDOMException {
        try {
            this.init(context);
        }
        catch (Exception e) {
            D.log(e);
        }
    }

    private void init(TaskContext context) throws JDOMException, PluginException, IOException {
        D.assrt(this.m_queryString != null, "DirUtils.unpackDNs - null is not a valid value for the pack");
        String pack = this.m_queryString;
        if (pack.length() > 0 && pack.charAt(0) == '<') {
            SAXBuilder builder = new SAXBuilder();
            builder.setFeature("http://xml.org/sax/features/external-general-entities", false);
            builder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            XMLOutputter outputter = new XMLOutputter();
            ByteArrayInputStream istream = new ByteArrayInputStream(pack.getBytes());
            Document doc = builder.build((InputStream)istream);
            Element root = doc.getRootElement();
            String strContainer = root.getChildTextTrim("container");
            String subContainerSearch = root.getChildTextTrim("sub-container-search");
            boolean bSearchSubContainer = subContainerSearch != null && subContainerSearch.equals("true");
            Element selectionCriterion = root.getChild("selection-criterion");
            String subClasses = root.getChildTextTrim("subclasses");
            boolean bSubClasses = subClasses != null && subClasses.equals("true");
            String strFilter = null;
            if (selectionCriterion != null) {
                strFilter = outputter.outputString(selectionCriterion);
            }
            ArrayList<String> typesList = new ArrayList<String>();
            for (Element element : root.getChildren("objectTypeFilter")) {
                typesList.add(element.getTextTrim());
            }
            String[] objectTypeNames = typesList.toArray(new String[typesList.size()]);
            FilterResultModifier rm = new FilterResultModifier("PreviewObjectFilter", 0, null, bSearchSubContainer, bSubClasses);
            if (strFilter != null && strFilter.length() > 0) {
                context.getDirUtils().addASXMLFilterInfoToRM(rm, strFilter, context);
            } else if (objectTypeNames != null && objectTypeNames.length > 0 && !objectTypeNames[0].equals("*")) {
                rm.addFilter(new ResultModifierFilterEntry(null, objectTypeNames));
                for (int k = 0; k < objectTypeNames.length; ++k) {
                    if (!context.getDirUtils().isAuxClass(objectTypeNames[k])) continue;
                    rm.setIncludeAuxClasses(true);
                }
            }
            ObjectEntryEnumeration myenum = null;
            try {
                AuthenticationBroker broker = context.getAuthenticationBroker();
                ObjectEntry treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
                AdminNamespace ns = treeOE.getAdminNamespace();
                ObjectEntry container = strContainer.equalsIgnoreCase("[root]") || strContainer.equalsIgnoreCase("") ? treeOE : ns.getObjectEntry(strContainer);
                context.addToHistory(container);
                D.log("search container = " + container.getName());
                this.dumpRM((ResultModifier)rm);
                myenum = ns.getChildren(container, (ResultModifier)rm);
            }
            catch (SPIException e) {
                D.log(e);
                String title = eMFrameUtils.getLocalizedString("FwResources", "TC.invalidAdvancedSelection", context);
                String body = eMFrameUtils.getLocalizedString("FwResources", "FwConsts.RES_COMMON_CONTAINERNOTFOUND", context) + " " + strContainer;
                throw new PluginException(title, body);
            }
            this.initImpl(myenum);
        } else {
            String[] objectNames = eMFrameUtils.unpack(pack, context);
            if (objectNames == null || objectNames.length == 0) {
                this.initImpl();
            } else {
                AuthenticationBroker broker = context.getAuthenticationBroker();
                ObjectEntry treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
                AdminNamespace ns = treeOE.getAdminNamespace();
                if (objectNames.length == 1) {
                    ObjectEntry oe = null;
                    try {
                        oe = ns.getObjectEntry(objectNames[0]);
                        context.addToHistory(oe);
                        this.initImpl(oe);
                    }
                    catch (SPIException e) {
                        D.log(e);
                        this.m_badObjectNames.add(objectNames[0]);
                        this.m_errors.add(e);
                    }
                } else {
                    ArrayList<ObjectEntry> validObjects = new ArrayList<ObjectEntry>();
                    for (int i = 0; i < objectNames.length; ++i) {
                        try {
                            ObjectEntry objectEntry = ns.getObjectEntry(objectNames[i]);
                            validObjects.add(objectEntry);
                            if (i >= 10) continue;
                            context.addToHistory(objectEntry);
                            continue;
                        }
                        catch (SPIException e) {
                            D.log(e);
                            this.m_badObjectNames.add(objectNames[i]);
                            this.m_errors.add(e);
                        }
                    }
                    ObjectEntry[] objectEntries = validObjects.toArray(new ObjectEntry[validObjects.size()]);
                    this.initImpl(objectEntries);
                }
            }
        }
    }

    private void initImpl() {
        this.m_multiple = false;
        this.m_oe = null;
        this.m_oee = null;
        this.m_count = 0;
        this.m_countReliability = 1;
    }

    private void initImpl(ObjectEntry oe) {
        this.m_multiple = false;
        this.m_oe = oe;
        this.m_oee = new DefaultObjectEntryEnumeration(oe);
        this.m_count = 1;
        this.m_countReliability = 1;
    }

    private void initImpl(ObjectEntry[] oea) {
        this.m_oee = new DefaultObjectEntryEnumeration(oea);
        this.m_oe = null;
        this.m_multiple = true;
        this.m_count = oea.length;
        this.m_countReliability = 1;
        this.m_objectEntryArray = oea;
    }

    private void initImpl(ObjectEntryEnumeration oee) {
        D.assrt(oee instanceof CountableObjectEntryEnumeration, "All ObjectEntryEnumerations (JCLIENT) should implement CountableObjectEntryEnumeration");
        CountableObjectEntryEnumeration countable = (CountableObjectEntryEnumeration)oee;
        this.m_multiple = true;
        this.m_oee = oee;
        this.m_oe = null;
        try {
            this.m_count = countable.getCount();
            this.m_countReliability = countable.getCountReliability();
        }
        catch (SnapinException e) {
            D.assrt(false, "Exception thrown in m_count");
            this.m_count = -1;
            this.m_countReliability = 5;
        }
    }

    public Exception[] getErrors() {
        return this.m_errors.toArray(new Exception[this.m_errors.size()]);
    }

    public String[] getBadObjectNames() {
        return this.m_badObjectNames.toArray(new String[this.m_badObjectNames.size()]);
    }

    public int getCount() {
        return this.m_count;
    }

    public int getCountReliability() {
        return this.m_countReliability;
    }

    public boolean isMultiple() {
        return this.m_multiple;
    }

    public ObjectEntryEnumeration getObjectEntryEnumeration() {
        return this.m_oee;
    }

    public ObjectEntry getObjectEntry() {
        return this.m_oe;
    }

    public String getCountReliablityMessage() {
        int countReliability = ((CountableObjectEntryEnumeration)this.m_oee).getCountReliability();
        String message = null;
        switch (countReliability) {
            case 1: {
                break;
            }
            case 2: {
                message = eMFrameUtils.getLocalizedString("FwResources", "General.countApproximate", this.m_locale);
                break;
            }
            case 3: 
            case 4: {
                message = eMFrameUtils.getLocalizedString("FwResources", "General.countTruncated", this.m_locale);
            }
        }
        return message;
    }

    boolean isQuery() {
        return this.m_objectEntryArray == null;
    }

    public ObjectEntry[] getOEArray() {
        return this.m_objectEntryArray;
    }

    public void setOEArray(ObjectEntry[] OEArray) {
        this.m_objectEntryArray = OEArray;
    }

    String[] getCommonObjectClasses(TaskContext context) throws UnsupportedOperationException, SPIException {
        if (this.m_objectEntryArray == null) {
            throw new UnsupportedOperationException();
        }
        DirUtils dirUtils = context.getDirUtils();
        ObjectEntry treeOE = null;
        try {
            treeOE = (ObjectEntry)context.getAuthenticationBroker().getProtocolObject("AdminNamespace");
        }
        catch (AuthBrokerException e) {
            D.log(e);
        }
        AdminNamespace ns = treeOE.getAdminNamespace();
        NSObject firstNSObject = null;
        firstNSObject = ns.getDetails(this.m_objectEntryArray[0]);
        ArrayList classNames = FwUtils.getAllClassesInOrder(firstNSObject);
        for (int i = 1; i < this.m_objectEntryArray.length; ++i) {
            ObjectType objectType = this.m_objectEntryArray[i].getObjectType();
            Iterator iter = classNames.iterator();
            while (iter.hasNext()) {
                String className = (String)iter.next();
                if (!dirUtils.isAuxClass(className)) {
                    if (DirUtils.isOfType(objectType, className, true)) continue;
                    iter.remove();
                    continue;
                }
                if (dirUtils.isOfAuxClass(this.m_objectEntryArray[i], className)) continue;
                iter.remove();
            }
        }
        return classNames.toArray(new String[classNames.size()]);
    }

    public static boolean detectPackageAssociation(String eDirTarget, TaskContext context, StringBuffer packageName) {
        try {
            TargetObjects targetObjects = new TargetObjects(eDirTarget, context);
            ObjectEntryEnumeration objectEntryEnumeration = targetObjects.getObjectEntryEnumeration();
            while (objectEntryEnumeration.hasMoreElements()) {
                ObjectEntry oe = objectEntryEnumeration.next();
                if (!TargetObjects.isPackageManagedObject(oe, packageName)) continue;
                return true;
            }
        }
        catch (SPIException e) {
            e.getLocalizedMessage();
        }
        catch (PluginException e) {
            e.getLocalizedMessage();
        }
        return false;
    }

    public static boolean isPackageManagedObject(ObjectEntry objectOE, StringBuffer packageName) {
        try {
            NSObject theNSObject = objectOE.getAdminNamespace().getDetails(objectOE);
            ObjectAttribute objAttribute = theNSObject.getAttribute("DirXML-pkgGUID");
            if (objAttribute != null) {
                Enumeration valueEnumeration = objAttribute.getValueComponents();
                while (valueEnumeration.hasMoreElements()) {
                    ValueComponent valueComp = (ValueComponent)valueEnumeration.nextElement();
                    String valueString = valueComp.toString();
                    String[] valueStringArr = valueString.split(";");
                    packageName.append(valueStringArr[1]);
                }
                return true;
            }
        }
        catch (SPIException e) {
            e.printStackTrace();
        }
        return false;
    }

    private void dumpRM(ResultModifier rm) {
        if (!D.isDebugEnabled()) {
            return;
        }
        if (rm != null) {
            FilterResultModifier.Filter[] rmfa;
            D.log(rm.getDescriptiveName());
            D.log("      RM subcontainer search = " + rm.isSubContainerSearch());
            D.log("      RM matchAdvCrit = " + rm.getSimpleAndOpAdvanced());
            D.log("      RM showGlue = " + rm.getShowGlue());
            ResultModifierFilterEntry[] rmfe = rm.getFilters();
            if (rmfe != null && rmfe.length > 0) {
                for (int i = 0; i < rmfe.length; ++i) {
                    D.log("      RM FilterEntry[" + i + "]");
                    D.log("         nameFilter = <" + rmfe[i].getNameFilter() + ">");
                    String[] tf = rmfe[i].getTypeFilter();
                    if (tf == null || tf.length <= 0) continue;
                    for (int j = 0; j < tf.length; ++j) {
                        D.log("         typeFilter[" + j + "] = " + tf[j]);
                    }
                }
            }
            if (rm instanceof FilterResultModifier && (rmfa = ((FilterResultModifier)rm).getFRMFilters()) != null && rmfa.length > 0) {
                for (int i = 0; i < rmfa.length; ++i) {
                    FilterResultModifier.Filter f = rmfa[i];
                    D.log("      FRM Filter[" + i + "] type = " + f.getFilterTypeName());
                    FilterResultModifier.Filter.FilterItemGroupPair[] figp = f.getFilterItemGroupPairs();
                    if (figp == null || figp.length <= 0) continue;
                    for (int g = 0; g < figp.length; ++g) {
                        FilterResultModifier.FilterItemGroup.FilterItem[] fi;
                        D.log("         FRM FilterGroup[" + g + "]  <" + figp[g].getLogicalFilter() + ">");
                        FilterResultModifier.FilterItemGroup fig = figp[g].getFilterItemGroup();
                        if (fig == null || (fi = fig.getFilterItems()) == null || fi.length <= 0) continue;
                        for (int r = 0; r < fi.length; ++r) {
                            String crit = fi[r].getAttributeName() + " " + fi[r].getCompareFilter() + " " + fi[r].getAttributeValue() + "  <" + fi[r].getLogicalFilter() + ">";
                            D.log("            FRM criterion[" + r + "] => " + crit);
                        }
                    }
                }
            }
        }
    }
}

