/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.dev;

import com.novell.admin.ns.AttributeDefinition;
import com.novell.emframe.dev.UiHandlerActionTrigger;
import com.novell.emframe.fw.FwUtils;

public class UiHandlerContext {
    protected String m_syntaxName = null;
    protected String m_attributeName = null;
    protected String m_client = null;
    protected String m_encodedAttributeName = null;
    protected boolean m_forceReadOnly = false;
    protected boolean m_forceSingleValued = false;
    protected boolean m_forceMandatory = false;
    protected boolean m_isSingleValued = false;
    boolean m_isSized = false;
    long m_upperBound = 0L;
    long m_lowerBound = 0L;
    private String m_id = null;
    private boolean m_useDirectoryRights = false;
    private String m_fieldPrefix = null;
    private UiHandlerActionTrigger[] m_actionTriggers = null;
    protected String m_eDasRights = null;
    protected String m_eDasRightsStandard = null;
    protected String m_eDasName = null;
    protected String m_xPathValue = null;
    protected String m_xPathSet = null;
    protected String m_firstValue = null;
    private boolean m_hideColon = false;

    public UiHandlerContext(AttributeDefinition attributeDefinition, String client, String id, boolean forceReadOnly, boolean forceSingleValued, boolean forceMandatory) {
        this.m_client = client;
        this.m_forceReadOnly = false;
        this.m_forceSingleValued = false;
        this.m_id = id;
        this.m_fieldPrefix = "eDir$target";
        this.m_actionTriggers = null;
        this.m_forceMandatory = forceMandatory;
        this.m_forceReadOnly = forceReadOnly;
        this.m_forceSingleValued = forceSingleValued;
        if (attributeDefinition != null) {
            this.m_useDirectoryRights = true;
            this.m_syntaxName = attributeDefinition.getSyntax().getName();
            this.m_attributeName = attributeDefinition.getName();
            if (attributeDefinition.isReadOnly()) {
                this.m_forceReadOnly = true;
            }
            if (attributeDefinition.isSingleValued()) {
                this.m_forceSingleValued = true;
            }
            this.m_isSized = attributeDefinition.isSized();
            if (this.m_isSized) {
                this.m_lowerBound = attributeDefinition.getLowerBound();
                this.m_upperBound = attributeDefinition.getUpperBound();
            }
            this.m_isSingleValued = attributeDefinition.isSingleValued();
            this.m_encodedAttributeName = FwUtils.getSafeName(this.m_attributeName);
        }
        this.initHelperParams(false);
    }

    public UiHandlerContext(String attrName, String safeAttrName, String syntaxName, String client, boolean forceReadOnly, boolean forceSingleValued, boolean isSized, long upperBound, long lowerBound, boolean useDirectoryRights, String fieldPrefix, UiHandlerActionTrigger[] actionTriggers, boolean forceMandatory) {
        this.m_syntaxName = syntaxName;
        this.m_attributeName = attrName;
        this.m_client = client;
        this.m_forceReadOnly = forceReadOnly;
        this.m_forceSingleValued = forceSingleValued;
        this.m_encodedAttributeName = safeAttrName;
        this.m_isSized = isSized;
        this.m_upperBound = upperBound;
        this.m_lowerBound = lowerBound;
        this.m_useDirectoryRights = useDirectoryRights;
        this.m_fieldPrefix = fieldPrefix;
        this.m_actionTriggers = actionTriggers;
        this.m_forceMandatory = forceMandatory;
        this.initHelperParams(true);
    }

    private void initHelperParams(boolean isDMI) {
        this.m_eDasName = this.m_fieldPrefix + "$" + this.m_encodedAttributeName;
        if (this.m_useDirectoryRights) {
            this.m_eDasRights = "edasRights.target." + this.m_encodedAttributeName + ".writeable";
            this.m_eDasRightsStandard = "<c:if test=\"${!" + this.m_eDasRights + "}\">DISABLED</c:if>";
        } else {
            this.m_eDasRights = "true";
            this.m_eDasRightsStandard = "";
        }
        this.m_hideColon = this.m_encodedAttributeName == null;
        this.m_xPathValue = "$edasXml/edas/" + this.m_encodedAttributeName + "/value";
        this.m_xPathSet = "$edasXml/edas/" + this.m_encodedAttributeName;
        this.m_firstValue = "<x:out select=\"" + this.m_xPathValue + "\"/>";
    }

    public boolean useDirectoryRights() {
        return this.m_useDirectoryRights;
    }

    public UiHandlerActionTrigger[] getActionTriggers() {
        return this.m_actionTriggers;
    }

    public long getLowerBound() {
        return this.m_lowerBound;
    }

    public boolean isForceReadOnly() {
        return this.m_forceReadOnly;
    }

    public boolean isForceSingleValued() {
        return this.m_forceSingleValued;
    }

    public boolean isSized() {
        return this.m_isSized;
    }

    public long getUpperBound() {
        return this.m_upperBound;
    }

    public String getAttributeName() {
        return this.m_attributeName;
    }

    public String getSyntaxName() {
        return this.m_syntaxName;
    }

    public String getClient() {
        return this.m_attributeName;
    }

    public String getEncodedAttributeName() {
        return this.m_encodedAttributeName;
    }

    public String getId() {
        return this.m_id;
    }

    public boolean isForceMandatory() {
        return this.m_forceMandatory;
    }

    public String getFieldPrefix() {
        return this.m_fieldPrefix;
    }

    public String geteDasRights() {
        return this.m_eDasRights;
    }

    public String geteDasRightsStandard() {
        return this.m_eDasRightsStandard;
    }

    public String geteDasName() {
        return this.m_eDasName;
    }

    public String getxPathValue() {
        return this.m_xPathValue;
    }

    public String getxPathSet() {
        return this.m_xPathSet;
    }

    public String getFirstValue() {
        return this.m_firstValue;
    }

    public boolean isHideColon() {
        return this.m_hideColon;
    }

    public boolean isSingleValued() {
        return this.m_isSingleValued;
    }
}

