/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.dev;

import com.novell.emframe.dev.XmlElementAttribute;
import java.util.Enumeration;
import java.util.Vector;

public class XmlElement {
    public String name = null;
    public String text = null;
    protected Vector children = new Vector();
    Vector attributes = new Vector();

    public XmlElement() {
    }

    public XmlElement(String s, String t) {
        this.name = s;
        this.text = t;
    }

    public void add(XmlElement element) {
        this.children.addElement(element);
    }

    public String toString() {
        int i;
        String str = "<" + this.name;
        if (this.attributes != null && this.attributes.size() > 0) {
            for (i = 0; i < this.attributes.size(); ++i) {
                str = str + " " + this.getAttributes()[i].getKey() + "='" + this.getAttributes()[i].getValue() + "'";
            }
        }
        str = str + ">";
        if (this.children != null && this.children.size() > 0) {
            for (i = 0; i < this.children.size(); ++i) {
                str = str + this.children.elementAt(i).toString();
            }
        } else if (this.text != null) {
            str = str + this.text;
        }
        str = str + "</" + this.name + ">";
        return str;
    }

    public String getName() {
        return this.name;
    }

    public String getText() {
        return this.text;
    }

    public String getChildTextTrim(String s) {
        String matchingChildText = null;
        if (s != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                XmlElement tempEl = (XmlElement)this.children.elementAt(i);
                if (!tempEl.getName().equals(s)) continue;
                matchingChildText = tempEl.getText();
                break;
            }
        }
        return matchingChildText;
    }

    public Vector getChildren() {
        return (Vector)this.children.clone();
    }

    public Vector getChildren(String s) {
        Vector<XmlElement> matchingChildren = new Vector<XmlElement>();
        Enumeration aEnum = this.children.elements();
        XmlElement tempEl = null;
        while (aEnum.hasMoreElements()) {
            tempEl = (XmlElement)aEnum.nextElement();
            if (!tempEl.getName().equalsIgnoreCase(s)) continue;
            matchingChildren.addElement(tempEl);
        }
        return matchingChildren;
    }

    public XmlElementAttribute getAttribute(String k) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            XmlElementAttribute tempAt = (XmlElementAttribute)this.attributes.elementAt(i);
            if (!tempAt.getKey().equalsIgnoreCase(k)) continue;
            return tempAt;
        }
        return null;
    }

    public XmlElementAttribute[] getAttributes() {
        Object[] returnArray = new XmlElementAttribute[this.attributes.size()];
        if (this.attributes != null) {
            this.attributes.copyInto(returnArray);
        }
        return returnArray;
    }

    public void addAttribute(String k, String v) {
        XmlElementAttribute attrib = new XmlElementAttribute(k, v);
        this.attributes.addElement(attrib);
    }

    public static XmlElement parseXml(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        XmlElement xml = XmlElement.createElement(s);
        if (s.charAt(s.indexOf(">") + 1) == '<') {
            String[] children = XmlElement.separateChildren(s);
            for (int i = 0; i < children.length; ++i) {
                xml.add(XmlElement.parseXml(children[i]));
            }
        }
        return xml;
    }

    private static String[] separateChildren(String s) {
        String child;
        Vector<String> children = new Vector<String>();
        for (s = s.substring(s.indexOf(">") + 1, s.lastIndexOf("<")); s != null && s.length() > 1; s = s.substring(child.length(), s.length())) {
            int count = 0;
            boolean done = false;
            int curPos = 0;
            boolean countChanged = false;
            while (!done) {
                if (s.charAt(curPos) == '<') {
                    ++count;
                    countChanged = true;
                } else if (s.charAt(curPos) == '/' && s.charAt(curPos - 1) == '<') {
                    count -= 2;
                }
                if (count == 0 && countChanged) {
                    done = true;
                    curPos = s.indexOf(">", curPos);
                }
                ++curPos;
            }
            child = s.substring(0, curPos);
            children.addElement(child);
        }
        Object[] returnArray = new String[children.size()];
        children.copyInto(returnArray);
        return returnArray;
    }

    private static XmlElement createElement(String s) {
        int end;
        XmlElement element = new XmlElement();
        int start = s.indexOf("<");
        boolean ha = false;
        if (s.indexOf(" ") != -1 && s.indexOf(" ") < s.indexOf(">")) {
            ha = true;
            end = s.indexOf(" ");
        } else {
            end = s.indexOf(">");
        }
        element.name = s.substring(start + 1, end);
        if (ha) {
            String attribString = s.substring(s.indexOf(" ") + 1, s.indexOf(">"));
            String[] attribs = XmlElement.split(attribString, "' ");
            for (int i = 0; i < attribs.length; ++i) {
                if (attribs[i].length() <= 0) continue;
                String[] thisAttrib = XmlElement.split(attribs[i], "='");
                element.addAttribute(thisAttrib[0], thisAttrib[1]);
            }
        }
        start = s.indexOf(">");
        end = s.indexOf("<", start);
        element.text = s.charAt(start + 1) != '<' ? s.substring(start + 1, end) : "";
        return element;
    }

    private static String[] split(String s, String delimiter) {
        Vector<String> items = new Vector<String>();
        int delLen = delimiter.length();
        if (s == null) {
            return null;
        }
        int curPos = 0;
        boolean done = false;
        while (!done) {
            curPos = s.indexOf(delimiter);
            if (curPos == -1) {
                items.addElement(s);
                done = true;
                continue;
            }
            String curSelection = s.substring(0, curPos);
            items.addElement(curSelection);
            s = s.substring(curPos + delLen, s.length());
        }
        Object[] returnArray = new String[items.size()];
        items.copyInto(returnArray);
        return returnArray;
    }
}

