/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.dev.config;

import com.novell.emframe.dev.config.ConfigException;
import com.novell.emframe.fw.config.SystemConfigManager;
import com.novell.nps.configManager.GUID;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class GeneralConfig {
    private String m_sGenConfigID = null;

    public GeneralConfig(String sGenConfigID) {
        this.m_sGenConfigID = sGenConfigID;
    }

    public String[] getSettingNames() {
        return SystemConfigManager.getSettingNames(this.m_sGenConfigID);
    }

    public String getSetting(String sName) {
        return SystemConfigManager.getSingleSetting(this.m_sGenConfigID, sName);
    }

    public Object getObjectSetting(String sName) {
        byte[] ba;
        Object oRet = null;
        String sRet = this.getSetting(sName);
        if (sRet != null && (ba = GUID.HexStringAsByte((String)sRet)) != null && ba.length != 0) {
            ByteArrayInputStream bais = new ByteArrayInputStream(ba);
            try {
                ObjectInputStream ois = new ObjectInputStream(bais);
                oRet = ois.readObject();
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return oRet;
    }

    public Object[] getObjectSettings(String sName) {
        Object[] oaRet = null;
        String[] saRet = this.getSettings(sName);
        if (saRet != null) {
            oaRet = new Object[saRet.length];
            for (int i = 0; i < saRet.length; ++i) {
                byte[] ba = GUID.HexStringAsByte((String)saRet[i]);
                if (ba == null || ba.length == 0) continue;
                ByteArrayInputStream bais = new ByteArrayInputStream(ba);
                try {
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    oaRet[i] = ois.readObject();
                    continue;
                }
                catch (IOException ioe) {
                    oaRet[i] = null;
                    continue;
                }
                catch (ClassNotFoundException cnfe) {
                    oaRet[i] = null;
                }
            }
        }
        return oaRet;
    }

    public String getSetting(String sName, String sDefaultValue) {
        return SystemConfigManager.getSingleSetting(this.m_sGenConfigID, sName, sDefaultValue);
    }

    public String[] getSettings(String sName) {
        return SystemConfigManager.getSetting(this.m_sGenConfigID, sName);
    }

    public void setSetting(String sName, String sValue) throws ConfigException {
        SystemConfigManager.setSetting(this.m_sGenConfigID, sName, sValue);
    }

    public void setSetting(String sName, String[] saValues) throws ConfigException {
        SystemConfigManager.setSetting(this.m_sGenConfigID, sName, saValues);
    }

    public void setObjectSetting(String sName, Object oValue) throws ConfigException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(oValue);
            oos.flush();
        }
        catch (IOException oos) {
            // empty catch block
        }
        byte[] ba = baos.toByteArray();
        StringBuffer sb = new StringBuffer(ba.length * 2 + 1);
        for (int i = 0; i < ba.length; ++i) {
            sb.append(GUID.byteAsHexString((int)ba[i]));
        }
        SystemConfigManager.setSetting(this.m_sGenConfigID, sName, sb.toString());
    }

    public void setObjectSetting(String sName, Object[] oaValues) throws ConfigException {
        String[] saValues = new String[oaValues.length];
        for (int count = 0; count < oaValues.length; ++count) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(oaValues[count]);
                oos.flush();
            }
            catch (IOException oos) {
                // empty catch block
            }
            byte[] ba = baos.toByteArray();
            StringBuffer sb = new StringBuffer(ba.length * 2 + 1);
            for (int i = 0; i < ba.length; ++i) {
                sb.append(GUID.byteAsHexString((int)ba[i]));
            }
            saValues[count] = sb.toString();
        }
        SystemConfigManager.setSetting(this.m_sGenConfigID, sName, saValues);
    }

    public void addSettingValue(String sName, String sValue) throws ConfigException {
        SystemConfigManager.addSettingValue(this.m_sGenConfigID, sName, sValue);
    }

    public void removeSettingValue(String sName, String sValue) throws ConfigException {
        SystemConfigManager.removeSettingValue(this.m_sGenConfigID, sName, sValue);
    }

    public void removeSetting(String sName) throws ConfigException {
        SystemConfigManager.removeSetting(this.m_sGenConfigID, sName);
    }

    public void writeSettings() throws ConfigException {
        SystemConfigManager.writeSettings(this.m_sGenConfigID);
    }
}

