/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.dev.rights;

import com.novell.emframe.dev.rights.eDirRightsData;

public class eDirObjectRightsData
extends eDirRightsData {
    public static final int RIGHTS_BROWSE = 1;
    public static final int RIGHTS_ADD = 2;
    public static final int RIGHTS_DELETE = 4;
    public static final int RIGHTS_RENAME = 8;
    public static final int RIGHTS_SUPERVISOR = 16;
    public static final int RIGHTS_INHERITABLE = 64;
    public static final int RIGHTS_DYNAMIC = 0x20000000;
    public static final int RIGHTS_NESTED = Integer.MIN_VALUE;
    private int rights;

    public eDirObjectRightsData(int rights) {
        this.rights = rights;
    }

    @Override
    public int getRights() {
        return this.rights;
    }

    public boolean hasBrowseRights() {
        return (this.rights & 1) != 0;
    }

    public boolean hasAddRights() {
        return (this.rights & 2) != 0;
    }

    public boolean hasDeleteRights() {
        return (this.rights & 4) != 0;
    }

    public boolean hasRenameRights() {
        return (this.rights & 8) != 0;
    }

    public boolean hasSupervisorRights() {
        return (this.rights & 0x10) != 0;
    }

    public boolean hasDynamicRights() {
        return (this.rights & 0x20000000) != 0;
    }

    @Override
    public boolean hasInheritableRights() {
        return (this.rights & 0x40) == 0;
    }

    public boolean hasNestedRights() {
        return (this.rights & Integer.MIN_VALUE) != 0;
    }

    public void setBrowse(boolean set) {
        if (set) {
            if (!this.hasBrowseRights()) {
                this.rights |= 1;
                this.setDirty();
            }
        } else if (this.hasBrowseRights()) {
            this.rights &= 0xFFFFFFFE;
            this.setDirty();
        }
    }

    public void setAdd(boolean set) {
        if (set) {
            if (!this.hasAddRights()) {
                this.rights |= 2;
                this.setDirty();
            }
        } else if (this.hasAddRights()) {
            this.rights &= 0xFFFFFFFD;
            this.setDirty();
        }
    }

    public void setDelete(boolean set) {
        if (set) {
            if (!this.hasDeleteRights()) {
                this.rights |= 4;
                this.setDirty();
            }
        } else if (this.hasDeleteRights()) {
            this.rights &= 0xFFFFFFFB;
            this.setDirty();
        }
    }

    public void setRename(boolean set) {
        if (set) {
            if (!this.hasRenameRights()) {
                this.rights |= 8;
                this.setDirty();
            }
        } else if (this.hasRenameRights()) {
            this.rights &= 0xFFFFFFF7;
            this.setDirty();
        }
    }

    public void setSupervisor(boolean set) {
        if (set) {
            if (!this.hasSupervisorRights()) {
                this.rights |= 0x10;
                this.setDirty();
            }
        } else if (this.hasSupervisorRights()) {
            this.rights &= 0xFFFFFFEF;
            this.setDirty();
        }
    }

    public void setDynamic(boolean set) {
        if (set) {
            if (!this.hasDynamicRights()) {
                this.rights |= 0x20000000;
                this.setDirty();
            }
        } else if (this.hasDynamicRights()) {
            this.rights &= 0xDFFFFFFF;
            this.setDirty();
        }
    }

    public void setInheritable(boolean set) {
        if (set) {
            if (!this.hasInheritableRights()) {
                this.rights &= 0xFFFFFFBF;
                this.setDirty();
            }
        } else if (this.hasInheritableRights()) {
            this.rights |= 0x40;
            this.setDirty();
        }
    }

    public void setNestedRights(boolean set) {
        if (set) {
            if (!this.hasNestedRights()) {
                this.rights |= Integer.MIN_VALUE;
                this.setDirty();
            }
        } else if (this.hasNestedRights()) {
            this.rights &= Integer.MAX_VALUE;
            this.setDirty();
        }
    }
}

