/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.AdvSelTypeInfo;
import com.novell.emframe.dev.AdvSelTypeInfoCallback;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.iManager;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;

public class AdvancedSelection
extends Task {
    private static final long serialVersionUID = 1L;
    private HttpServletRequest m_req;
    private TaskContext m_context;
    private Properties m_resultStrings;
    private AdvSelTypeInfo m_attributeInfo = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(TaskContext context, Properties resultStrings) {
        try {
            this.m_context = context;
            this.m_resultStrings = resultStrings;
            this.m_req = this.m_context.getRequest();
            String nextState = this.m_req.getParameter("nextState");
            if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
                boolean bl = this.showInitialForm();
                return bl;
            }
            if (nextState.equalsIgnoreCase("doReturnCriterion")) {
                boolean bl = this.doReturnCriterion();
                return bl;
            }
            boolean bl = this.showInitialForm();
            return bl;
        }
        finally {
            D.log("execute: clearing memory references...");
            this.m_context = null;
            this.m_req = null;
            this.m_resultStrings = null;
            this.m_attributeInfo = null;
        }
    }

    private boolean showInitialForm() {
        int i;
        String tmp;
        boolean bHaveCriterion;
        ArrayList typeIds = new ArrayList();
        ArrayList auxTypeIds = new ArrayList();
        String initialCriterion = this.m_req.getParameter("AS.InitialCriterion");
        boolean bl = bHaveCriterion = initialCriterion != null && initialCriterion.length() > 0;
        if (bHaveCriterion) {
            typeIds = this.readXMLIds(initialCriterion, "AS.XML.types");
            auxTypeIds = this.readXMLIds(initialCriterion, "AS.XML.auxTypes");
            D.log("showInitialForm: Retrieving type and auxtype info from initial criterion.");
            tmp = eMFrameUtils.commaSepStr(typeIds);
            this.m_resultStrings.setProperty("AS.Types", tmp);
            D.log("showInitialForm:    Setting AS.Types to '" + tmp + "'");
            tmp = eMFrameUtils.commaSepStr(auxTypeIds);
            this.m_resultStrings.setProperty("AS.AuxTypes", tmp);
            D.log("showInitialForm:    Setting AS.AuxTypes to '" + tmp + "'");
        } else {
            tmp = this.m_req.getParameter("AS.Types");
            typeIds = eMFrameUtils.commaSplit(tmp);
            tmp = this.m_req.getParameter("AS.AuxTypes");
            auxTypeIds = eMFrameUtils.commaSplit(tmp);
            D.log("showInitialForm: Retrieving type and auxtype info from AS.Types and AS.AuxTypes.");
        }
        D.log("showInitialForm: type[]    = " + typeIds.toString());
        D.log("showInitialForm: auxtype[] = " + auxTypeIds.toString());
        int count = 0;
        String typeId = "";
        String typeDname = "";
        for (int i2 = 0; i2 < typeIds.size(); ++i2) {
            typeId = (String)typeIds.get(i2);
            if (typeId == null || typeId.length() <= 0) continue;
            this.m_resultStrings.put("AS.Types." + count + ".id", typeId);
            typeDname = typeId.equals("*") ? eMFrameUtils.getLocalizedString("FwResources", "OS.All", this.m_context) : this.m_context.getDirUtils().getObjectTypeDisplayName(typeId, this.m_context);
            if (typeDname == null || typeDname.length() == 0) {
                typeDname = eMFrameUtils.getLocalizedString("FwResources", "ObjectType.Unknown", this.m_context);
            }
            this.m_resultStrings.put("AS.Types." + count + ".dname", typeDname);
            ++count;
        }
        this.m_resultStrings.put("AS.Types.count", "" + count);
        if (count == 0) {
            D.log("showInitialForm: ERROR -- No types specified.");
            return false;
        }
        count = 0;
        String auxTypeId = "";
        for (int i3 = 0; i3 < auxTypeIds.size(); ++i3) {
            auxTypeId = (String)auxTypeIds.get(i3);
            if (auxTypeId == null || auxTypeId.length() <= 0) continue;
            this.m_resultStrings.put("AS.AuxTypes." + i3 + ".id", auxTypeId);
            ++count;
        }
        this.m_resultStrings.put("AS.AuxTypes.count", "" + count);
        String typeInfoCallback = this.m_req.getParameter("AS.TypeInfoCallBack");
        if (typeInfoCallback == null || typeInfoCallback.length() == 0) {
            D.log("showInitialForm: No AdvSelTypeInfoCallback specified. Using NDS default.");
            typeInfoCallback = "com.novell.emframe.fw.NDSTypeInfoCallback";
        }
        D.log("showInitialForm: InfoCallback=" + typeInfoCallback);
        boolean bErr = false;
        try {
            this.m_attributeInfo = null;
            Class<?> objClass = Class.forName(typeInfoCallback);
            Object callback = objClass.newInstance();
            String[] saTyp = typeIds.toArray(new String[typeIds.size()]);
            String[] saAux = auxTypeIds.toArray(new String[auxTypeIds.size()]);
            this.m_attributeInfo = ((AdvSelTypeInfoCallback)callback).getInfo(this.m_context, saTyp, saAux);
        }
        catch (Throwable t) {
            D.log("showInitialForm: couldn't call callback.getInfo(). reason=" + t.toString());
            bErr = true;
        }
        if (bErr || this.m_attributeInfo == null || this.m_attributeInfo.length() < 1) {
            eMFrameUtils.setMessage("error", eMFrameUtils.getLocalizedString("FwResources", "AS.Browser.AdvSel", this.m_context), eMFrameUtils.getLocalizedString("FwResources", "AS.Browser.StartupError", this.m_context), typeIds.toString() + "+" + auxTypeIds.toString(), this.m_context);
            return false;
        }
        count = this.m_attributeInfo.length();
        this.m_resultStrings.put("AS.Attrib.count", "" + count);
        for (int i4 = 0; i4 < count; ++i4) {
            this.m_resultStrings.put("AS.Attrib." + i4, this.m_attributeInfo.getAttributeName(i4));
        }
        String[] ops = this.m_attributeInfo.getAllOps();
        String resBundle = this.m_attributeInfo.getOpResourceBundle();
        count = ops.length;
        this.m_resultStrings.put("AS.Ops.count", "" + count);
        for (int i5 = 0; i5 < count; ++i5) {
            this.m_resultStrings.put("AS.Ops." + i5 + ".id", ops[i5]);
            this.m_resultStrings.put("AS.Ops." + i5 + ".dname", eMFrameUtils.getLocalizedString(resBundle, ops[i5], this.m_context));
        }
        String[] uniOps = this.m_attributeInfo.getUniOps();
        count = uniOps.length;
        this.m_resultStrings.put("AS.UniOps.count", "" + count);
        for (i = 0; i < count; ++i) {
            this.m_resultStrings.put("AS.UniOps." + i + ".id", uniOps[i]);
        }
        this.m_resultStrings.put("AS.AttribOps.0.key", this.m_attributeInfo.getDefaultName());
        this.m_resultStrings.put("AS.AttribOps.0.count", "" + this.m_attributeInfo.getDefaultOpsLength());
        ops = this.m_attributeInfo.getDefaultOps();
        if (ops != null) {
            for (int j = 0; j < ops.length; ++j) {
                this.m_resultStrings.put("AS.AttribOps.0." + j, ops[j]);
            }
        }
        count = 1;
        for (i = 0; i < this.m_attributeInfo.length(); ++i) {
            ops = this.m_attributeInfo.getAttributeOps(i);
            if (ops == null) continue;
            this.m_resultStrings.put("AS.AttribOps." + count + ".key", this.m_attributeInfo.getAttributeName(i));
            this.m_resultStrings.put("AS.AttribOps." + count + ".count", "" + ops.length);
            for (int j = 0; j < ops.length; ++j) {
                this.m_resultStrings.put("AS.AttribOps." + count + "." + j, ops[j]);
            }
            ++count;
        }
        this.m_resultStrings.put("AS.AttribOps.count", "" + count);
        count = 0;
        for (int i6 = 0; i6 < this.m_attributeInfo.length(); ++i6) {
            String[] values = this.m_attributeInfo.getAttributeValues(i6);
            if (values == null) continue;
            this.m_resultStrings.put("AS.AttribVals." + count + ".key", this.m_attributeInfo.getAttributeName(i6));
            this.m_resultStrings.put("AS.AttribVals." + count + ".count", "" + values.length);
            for (int j = 0; j < values.length; ++j) {
                this.m_resultStrings.put("AS.AttribVals." + count + "." + j, values[j]);
            }
            ++count;
        }
        this.m_resultStrings.put("AS.AttribVals.count", "" + count);
        String[] auxClasses = this.m_attributeInfo.getAuxClasses();
        if (auxClasses != null) {
            String auxClassId = null;
            String auxClassDname = null;
            count = 0;
            for (int i7 = 0; i7 < auxClasses.length; ++i7) {
                auxClassId = auxClasses[i7];
                if (auxClassId == null) continue;
                this.m_resultStrings.put("AS.AllAuxTypes." + count + ".id", auxClassId);
                auxClassDname = this.m_context.getDirUtils().getObjectTypeDisplayName(auxClassId, this.m_context);
                if (auxClassDname == null || auxClassDname.length() == 0) {
                    auxClassDname = eMFrameUtils.getLocalizedString("FwResources", "ObjectType.Unknown", this.m_context);
                }
                this.m_resultStrings.put("AS.AllAuxTypes." + i7 + ".dname", auxClassDname);
                ++count;
            }
            this.m_resultStrings.put("AS.AllAuxTypes.count", "" + count);
            D.log("showInitialForm: Number of defined AuxTypes = " + auxClasses.length);
        }
        return true;
    }

    private boolean doReturnCriterion() {
        return true;
    }

    private ArrayList readXMLIds(String c, String grpTagId) {
        String GRP_TAG = eMFrameUtils.getLocalizedString("FwResources", grpTagId, this.m_context);
        ArrayList<String> ids = new ArrayList<String>();
        try {
            StringReader r = new StringReader(c);
            Document doc = iManager.getSaxBuilder().build((Reader)r);
            Element root = doc.getRootElement();
            Element grp = root.getChild(GRP_TAG);
            List idTags = grp.getChildren();
            Iterator i = idTags.iterator();
            Element id = null;
            while (i.hasNext()) {
                id = (Element)i.next();
                ids.add(id.getTextTrim());
            }
        }
        catch (Exception e) {
            D.log("readXMLIds: Unable to read <id> values for " + grpTagId + ".  Returning empty array.");
            if (grpTagId.equals("AS.XML.types")) {
                ids.add("*");
                return ids;
            }
            return new ArrayList();
        }
        return ids;
    }
}

