/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.MTask;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.iManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class AttributeNamer
extends MTask {
    private static final String[] langs = FwUtils.getAvailableLanguages();
    private Hashtable propertyObject = null;

    @Override
    public void execute(MContext context) {
        HttpServletRequest req;
        String nextState;
        if (this.propertyObject == null) {
            this.propertyObject = this.readAllFiles(context);
        }
        if ((nextState = (req = context.getRequest()).getParameter("nextState")) == null || nextState.equals("initialState")) {
            this.doInitialState(context);
        } else if (nextState.equals("write")) {
            this.writeOutAllFiles(context);
            String title = eMFrameUtils.getLocalizedString("FwResources", "Success", context);
            String body = eMFrameUtils.getLocalizedString("FwResources", "ChangesSaved", context);
            eMFrameUtils.setMessage("success", title, body, context);
            this.setUIPage("dev/GenConf.jsp");
        } else if (nextState.equals("setDisplayName")) {
            String type = req.getParameter("type");
            String prefix = type.equals("attribute") ? "Attribute." : "ObjectType.";
            String attributeName = req.getParameter("attributeName");
            String key = prefix + FwUtils.getSafeName(attributeName);
            String defaultDisplayName = req.getParameter("default");
            Properties defaultProperties = (Properties)this.propertyObject.get("default");
            if (defaultDisplayName != null && !defaultDisplayName.trim().equals("")) {
                defaultProperties.setProperty(key, defaultDisplayName);
            } else {
                defaultProperties.remove(key);
            }
            for (int i = 0; i < langs.length; ++i) {
                String xlang = langs[i];
                String displayName = req.getParameter(xlang);
                Properties properties = (Properties)this.propertyObject.get(langs[i]);
                if (displayName != null && !displayName.trim().equals("")) {
                    properties.put(key, displayName);
                    continue;
                }
                properties.remove(key);
            }
            this.setUIPage("fw/Close.jsp");
        } else if (nextState.equals("showEditDlg")) {
            String type = req.getParameter("type");
            String prefix = type.equals("attribute") ? "Attribute." : "ObjectType.";
            String attributeName = req.getParameter("attributeName");
            this.outputValues(req, prefix, attributeName);
            this.setUIPage("fw/AttributeNamer_addValueDlg.jsp");
        } else {
            eMFrameUtils.setMessage("error", "System Error", "Invalid state.", context);
        }
    }

    private void doInitialState(MContext context) {
        DirUtils dirUtils = context.getDirUtils();
        String[] attrs = dirUtils.getSortedAttrs();
        String[] classes = dirUtils.getSortedClasses();
        context.getRequest().setAttribute("attributes", (Object)attrs);
        context.getRequest().setAttribute("classes", (Object)classes);
        String[] customizedAttributes = this.findCustomizedDisplays("attribute", attrs);
        String[] customizedClasses = this.findCustomizedDisplays("objects", classes);
        context.getRequest().setAttribute("customizedAttributes", (Object)customizedAttributes);
        context.getRequest().setAttribute("customizedClasses", (Object)customizedClasses);
    }

    private static final Properties getCustomResources(MContext context) {
        Properties customResources = null;
        customResources = (Properties)context.getSession().getAttribute("CustomResources");
        String lang = (String)context.getRequest().getSession().getAttribute("ClientLocale");
        Properties langCustomResources = AttributeNamer.readPropertiesFile(context, "/custom/CustomResources_" + lang + ".properties");
        Properties defaultCustomResources = AttributeNamer.readPropertiesFile(context, "/custom/CustomResources.properties");
        customResources = defaultCustomResources != null ? new Properties(defaultCustomResources) : new Properties();
        if (langCustomResources != null) {
            customResources.putAll((Map<?, ?>)langCustomResources);
        }
        context.getSession().setAttribute("CustomResources", (Object)customResources);
        return customResources;
    }

    public static final String getCustomResourcesValue(String key, MContext context) {
        Properties p = AttributeNamer.getCustomResources(context);
        return p.getProperty(key);
    }

    private Hashtable readAllFiles(MContext context) {
        Hashtable<String, Properties> hashtable = new Hashtable<String, Properties>();
        Properties properites = AttributeNamer.readPropertiesFile(context, "/custom/CustomResources.properties");
        if (properites == null) {
            properites = new Properties();
        }
        hashtable.put("default", properites);
        for (int i = 0; i < langs.length; ++i) {
            properites = AttributeNamer.readPropertiesFile(context, "/custom/CustomResources_" + langs[i] + ".properties");
            if (properites == null) {
                properites = new Properties();
            }
            hashtable.put(langs[i], properites);
        }
        return hashtable;
    }

    private void writeOutAllFiles(MContext context) {
        context.getSession().removeAttribute("CustomResources");
        File directory = new File(iManager.getAbsModulesPath() + "/custom");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        Properties properties = (Properties)this.propertyObject.get("default");
        this.writePropertiesFile(properties, "/custom/CustomResources.properties", context);
        for (int i = 0; i < langs.length; ++i) {
            properties = (Properties)this.propertyObject.get(langs[i]);
            this.writePropertiesFile(properties, "/custom/CustomResources_" + langs[i] + ".properties", context);
        }
    }

    private void writePropertiesFile(Properties properites, String path, MContext context) {
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(iManager.getAbsModulesPath() + path));
            properites.store(out, null);
            ((OutputStream)out).close();
        }
        catch (FileNotFoundException e) {
            D.log(e);
        }
        catch (IOException e) {
            D.log(e);
        }
    }

    private String[] findCustomizedDisplays(String type, String[] objects) {
        ArrayList<String> list = new ArrayList<String>();
        String prefix = type.equals("attribute") ? "Attribute." : "ObjectType.";
        block0: for (int x = 0; x < objects.length; ++x) {
            Properties properties = (Properties)this.propertyObject.get("default");
            String displayName = properties.getProperty(prefix + FwUtils.getSafeName(objects[x]));
            if (displayName != null) {
                list.add(objects[x]);
                continue;
            }
            for (int y = 0; y < langs.length; ++y) {
                properties = (Properties)this.propertyObject.get(langs[y]);
                displayName = properties.getProperty(prefix + FwUtils.getSafeName(objects[x]));
                if (displayName == null) continue;
                list.add(objects[x]);
                continue block0;
            }
        }
        String[] rv = new String[list.size()];
        Iterator itr = list.iterator();
        for (int i = 0; i < list.size(); ++i) {
            rv[i] = (String)itr.next();
        }
        return rv;
    }

    private void outputValues(HttpServletRequest req, String prefix, String attributeName) {
        this.outputValuesImpl((Properties)this.propertyObject.get("default"), prefix, attributeName, req, "default");
        String attributeDisplayName = FwUtils.getAttributeDisplayName(attributeName, new Locale(""), attributeName);
        req.setAttribute("defaultFromFw", (Object)attributeDisplayName);
        for (int i = 0; i < langs.length; ++i) {
            Properties properties = (Properties)this.propertyObject.get(langs[i]);
            this.outputValuesImpl(properties, prefix, attributeName, req, langs[i]);
            attributeDisplayName = FwUtils.getAttributeDisplayName(attributeName, FwUtils.instantiateLocale(langs[i]), attributeName);
            req.setAttribute(langs[i] + "FromFw", (Object)attributeDisplayName);
        }
    }

    private void outputValuesImpl(Properties properties, String prefix, String attributeName, HttpServletRequest req, String lang) {
        String displayName;
        if (properties != null && (displayName = properties.getProperty(prefix + FwUtils.getSafeName(attributeName))) != null) {
            req.setAttribute(lang + "DisplayName", (Object)displayName);
        }
    }

    private static Properties readPropertiesFile(MContext context, String resourceFilename) {
        Properties customResources = null;
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(iManager.getAbsModulesPath() + resourceFilename));
            customResources = new Properties();
            customResources.load(in);
            ((InputStream)in).close();
        }
        catch (FileNotFoundException in) {
        }
        catch (Throwable e) {
            D.log(e);
        }
        return customResources;
    }
}

