/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.imanager.logging.naudit.NauditEvent;
import com.novell.naudit.LogEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class AuditLog {
    public static long LOGEVENT_SYSTEM_STARTED;
    public static long LOGEVENT_SYSTEM_SHUTDOWN;
    public static long LOGEVENT_PORTAL_AUTHENTICATION_SUCCEEDED;
    public static long LOGEVENT_IMANAGER_AUTHENTICATION_SUCCEEDED;
    public static long LOGEVENT_PORTAL_AUTHENTICATION_FAILED;
    public static long LOGEVENT_IMANAGER_AUTHENTICATION_FAILED;
    public static long LOGEVENT_PORTAL_LOGOUT;
    public static long LOGEVENT_IMANAGER_LOGOUT;
    public static long LOGEVENT_MODULE_INSTALL;
    public static long LOGEVENT_MODULE_INSTALL_FAILED;
    public static long LOGEVENT_FAILED_SSL_CONNECTION;
    public static long LOGEVENT_SYSTEM_CONFIGURATION_CHANGED;
    public static long LOGEVENT_AUTHORIZED_USER_ADDED;
    public static long LOGEVENT_AUTHORIZED_USER_REMOVED;
    public static long LOGEVENT_MODULE_UPLOAD;
    public static final String ENABLE_NSURE_AUDIT_LOG = "Audit.EnableNSureAuditLog";
    public static final String LOG_ITEM_AUTHORIZED_USERS = "Audit.AuthorizedUsers";
    public static final String LOG_ITEM_FAILED_SSL_CONNECTION = "Audit.FailedSSLConnection";
    public static final String LOG_ITEM_LOGIN_FAILED = "Audit.LoginFailed";
    public static final String LOG_ITEM_LOGIN_SUCCESS = "Audit.LoginSuccess";
    public static final String LOG_ITEM_LOGOUT = "Audit.Logout";
    public static final String LOG_ITEM_NPM_FAILED_INSTALL = "Audit.NPMFailedInstall";
    public static final String LOG_ITEM_NPM_INSTALLED = "Audit.NPMInstalled";
    public static final String LOG_ITEM_CHANGED_CONFIGURATION = "Audit.ChangedConfiguration";
    public static final String LOG_ITEM_SYSTEM_STARTUP = "Audit.Startup";
    public static final String LOG_ITEM_SYSTEM_SHUTDOWN = "Audit.Shutdown";
    public static final String LOG_ITEM_NPM_UPLOADED = "Audit.NPMUploaded";
    public static final String XDAS_LOG_ITEM_AUTHORIZED_USERS = "XDAS.Audit.AuthorizedUsers";
    public static final String XDAS_LOG_ITEM_FAILED_SSL_CONNECTION = "XDAS.Audit.FailedSSLConnection";
    public static final String XDAS_LOG_ITEM_LOGIN_FAILED = "XDAS.Audit.LoginFailed";
    public static final String XDAS_LOG_ITEM_LOGIN_SUCCESS = "XDAS.Audit.LoginSuccess";
    public static final String XDAS_LOG_ITEM_LOGOUT = "XDAS.Audit.Logout";
    public static final String XDAS_LOG_ITEM_NPM_FAILED_INSTALL = "XDAS.Audit.NPMFailedInstall";
    public static final String XDAS_LOG_ITEM_NPM_INSTALLED = "XDAS.Audit.NPMInstalled";
    public static final String XDAS_LOG_ITEM_CHANGED_CONFIGURATION = "XDAS.Audit.ChangedConfiguration";
    public static final String XDAS_LOG_ITEM_SYSTEM_STARTUP = "XDAS.Audit.Startup";
    public static final String XDAS_LOG_ITEM_SYSTEM_SHUTDOWN = "XDAS.Audit.Shutdown";
    public static final String XDAS_LOG_ITEM_NPM_UPLOADED = "XDAS.Audit.NPMUploaded";
    public static final String CEF_LOG_ITEM_AUTHORIZED_USERS = "CEF.Audit.AuthorizedUsers";
    public static final String CEF_LOG_ITEM_FAILED_SSL_CONNECTION = "CEF.Audit.FailedSSLConnection";
    public static final String CEF_LOG_ITEM_LOGIN_FAILED = "CEF.Audit.LoginFailed";
    public static final String CEF_LOG_ITEM_LOGIN_SUCCESS = "CEF.Audit.LoginSuccess";
    public static final String CEF_LOG_ITEM_LOGOUT = "CEF.Audit.Logout";
    public static final String CEF_LOG_ITEM_NPM_FAILED_INSTALL = "CEF.Audit.NPMFailedInstall";
    public static final String CEF_LOG_ITEM_NPM_INSTALLED = "CEF.Audit.NPMInstalled";
    public static final String CEF_LOG_ITEM_CHANGED_CONFIGURATION = "CEF.Audit.ChangedConfiguration";
    public static final String CEF_LOG_ITEM_SYSTEM_STARTUP = "CEF.Audit.Startup";
    public static final String CEF_LOG_ITEM_SYSTEM_SHUTDOWN = "CEF.Audit.Shutdown";
    public static final String CEF_LOG_ITEM_NPM_UPLOADED = "CEF.Audit.NPMUploaded";
    private static LogEvent m_logEvent;
    private static boolean m_bNSureAuditAvailable;
    public static final String linuxCertFilePath = "/etc/imanicert.pem";
    public static final String linuxKeyFilePath = "/etc/imanipkey.pem";
    public static final String windowsCertFilePath = "c:\\windows\\imanicert.pem";
    public static final String windowsKeyFilePath = "c:\\windows\\imanipkey.pem";
    public static final String netwareCertFilePath = "sys:\\system\\imanicert.pem";
    public static final String netwareKeyFilePath = "sys:\\system\\imanipkey.pem";
    public static final String solarisCertFilePath = "/etc/imanicert.pem";
    public static final String solarisKeyFilePath = "/etc/imanipkey.pem";
    public static final String app_name = "iManager";
    public static Logger LOGGER;
    public static final String ENABLE_XDAS_AUDIT_LOG = "Audit.EnableXDASAuditLog";
    public static final String ENABLE_CEF_AUDIT_LOG = "Audit.EnableCEFAuditLog";
    public static boolean isXDASAuditEnabled;
    public static boolean isCEFAuditEnabled;
    private static Appender sysLogAppender;
    private static Appender sysLogCEFAppender;
    private static Appender rollingFileAppender;
    private static Appender rollingCEFFileAppender;
    private static Appender nAuditAppender;

    public static void logEvent(String sComponent, long lEventID) {
        block3: {
            LogEvent le = AuditLog.getLogEvent();
            if (le != null) {
                try {
                    NauditEvent nEvent = new NauditEvent();
                    nEvent.setParams(new Object[]{sComponent, (int)lEventID, 7L, 0, 0, "", 2, null, 0, null, null, "", null, 0, 0, 0, 0, 0, null, null, null});
                    LOGGER.info((Object)nEvent);
                }
                catch (Throwable t) {
                    if (!D.isDebugEnabled(1)) break block3;
                    D.log("Problem with LogEventDirect to NSure Audit.", 1);
                    D.log(t);
                }
            }
        }
    }

    public static void logEvent(String eventName, String a, String b, long eventKey) {
        block3: {
            LogEvent le = AuditLog.getLogEvent();
            if (le != null) {
                try {
                    NauditEvent nEvent = new NauditEvent();
                    nEvent.setParams(new Object[]{eventName, (int)eventKey, 7L, 0, 0, a, 2, null, 0, null, null, b, null, 0, 0, 0, 0, 0, null, null, null});
                    LOGGER.info((Object)nEvent);
                }
                catch (Throwable t) {
                    if (!D.isDebugEnabled(1)) break block3;
                    D.log("Problem with LogEventDirect to NSure Audit.", 1);
                    D.log(t);
                }
            }
        }
    }

    public static void logAuthEvent(String eventName, String a, String b, String clientHost, long eventKey) {
        block3: {
            LogEvent le = AuditLog.getLogEvent();
            if (le != null) {
                try {
                    NauditEvent nEvent = new NauditEvent();
                    nEvent.setParams(new Object[]{eventName, (int)eventKey, 7L, 0, 0, a, 2, null, 0, null, null, b, null, 0, 0, 0, 0, 0, null, null, clientHost});
                    LOGGER.info((Object)nEvent);
                }
                catch (Throwable t) {
                    if (!D.isDebugEnabled(1)) break block3;
                    D.log("Problem with LogEventDirect to NSure Audit.", 1);
                    D.log(t);
                }
            }
        }
    }

    public static void logModuleEvent(String eventName, String a, String b, String Host, long eventKey) {
        block3: {
            LogEvent le = AuditLog.getLogEvent();
            if (le != null) {
                try {
                    NauditEvent nEvent = new NauditEvent();
                    nEvent.setParams(new Object[]{eventName, (int)eventKey, 7L, 0, 0, a, 2, null, 0, b, null, null, null, 0, 0, 0, 0, 0, null, null, Host});
                    LOGGER.info((Object)nEvent);
                }
                catch (Throwable t) {
                    if (!D.isDebugEnabled(1)) break block3;
                    D.log("Problem with LogEventDirect to NSure Audit.", 1);
                    D.log(t);
                }
            }
        }
    }

    public static void logEvent(String eventName, String a, String b, String c, long eventKey) {
        block3: {
            LogEvent le = AuditLog.getLogEvent();
            if (le != null) {
                try {
                    NauditEvent nEvent = new NauditEvent();
                    nEvent.setParams(new Object[]{eventName, (int)eventKey, 7L, 0, 0, a, 2, b, 2, null, null, c, null, 0, 0, 0, 0, 0, null, null, null});
                    LOGGER.info((Object)nEvent);
                }
                catch (Throwable t) {
                    if (!D.isDebugEnabled(1)) break block3;
                    D.log("Problem with LogEventExt to NSure Audit.", 1);
                    D.log(t);
                }
            }
        }
    }

    public static void logEvent(String eventName, String a, String b, String c, String clientHost, long eventKey) {
        block3: {
            LogEvent le = AuditLog.getLogEvent();
            if (le != null) {
                try {
                    NauditEvent nEvent = new NauditEvent();
                    nEvent.setParams(new Object[]{eventName, (int)eventKey, 7L, 0, 0, a, 2, b, 2, null, null, c, null, 0, 0, 0, 0, 0, null, null, clientHost});
                    LOGGER.info((Object)nEvent);
                }
                catch (Throwable t) {
                    if (!D.isDebugEnabled(1)) break block3;
                    D.log("Problem with LogEventExt to NSure Audit.", 1);
                    D.log(t);
                }
            }
        }
    }

    public static void logSuccessfulLogin(String userName, String host, boolean bPortal) {
        String sEnableNSureAuditLog = new SystemConfig().getSetting(LOG_ITEM_LOGIN_SUCCESS, "false");
        String sEnableXDASLoginSuccessLog = new SystemConfig().getSetting(XDAS_LOG_ITEM_LOGIN_SUCCESS, "false");
        String sEnableCEFLoginSuccessLog = new SystemConfig().getSetting(CEF_LOG_ITEM_LOGIN_SUCCESS, "false");
        if (sEnableNSureAuditLog.equalsIgnoreCase("false") && sEnableXDASLoginSuccessLog.equalsIgnoreCase("false") && sEnableCEFLoginSuccessLog.equalsIgnoreCase("false")) {
            return;
        }
        if (bPortal) {
            AuditLog.logEvent("Authentication", userName, host, LOGEVENT_PORTAL_AUTHENTICATION_SUCCEEDED);
        } else {
            AuditLog.logEvent("Authentication", userName, host, LOGEVENT_IMANAGER_AUTHENTICATION_SUCCEEDED);
        }
    }

    public static void logSuccessfulLogin(String userName, String host, boolean bPortal, String clientHost) {
        String sEnableNSureAuditLog = new SystemConfig().getSetting(LOG_ITEM_LOGIN_SUCCESS, "false");
        String sEnableXDASLoginSuccessLog = new SystemConfig().getSetting(XDAS_LOG_ITEM_LOGIN_SUCCESS, "false");
        String sEnableCEFLoginSuccessLog = new SystemConfig().getSetting(CEF_LOG_ITEM_LOGIN_SUCCESS, "false");
        if (sEnableNSureAuditLog.equalsIgnoreCase("false") && sEnableXDASLoginSuccessLog.equalsIgnoreCase("false") && sEnableCEFLoginSuccessLog.equalsIgnoreCase("false")) {
            return;
        }
        if (bPortal) {
            AuditLog.logAuthEvent("Authentication", userName, host, clientHost, LOGEVENT_PORTAL_AUTHENTICATION_SUCCEEDED);
        } else {
            AuditLog.logAuthEvent("Authentication", userName, host, clientHost, LOGEVENT_IMANAGER_AUTHENTICATION_SUCCEEDED);
        }
    }

    public static void logFailedLogin(String userName, String host, boolean bPortal) {
        String sEnableNSureAuditLog = new SystemConfig().getSetting(LOG_ITEM_LOGIN_FAILED, "false");
        String sEnableXDASLoginFailedLog = new SystemConfig().getSetting(XDAS_LOG_ITEM_LOGIN_FAILED, "false");
        String sEnableCEFLoginFailedLog = new SystemConfig().getSetting(CEF_LOG_ITEM_LOGIN_FAILED, "false");
        if (sEnableNSureAuditLog.equalsIgnoreCase("false") && sEnableXDASLoginFailedLog.equalsIgnoreCase("false") && sEnableCEFLoginFailedLog.equalsIgnoreCase("false")) {
            return;
        }
        if (bPortal) {
            AuditLog.logEvent("Authentication", userName, host, LOGEVENT_PORTAL_AUTHENTICATION_FAILED);
        } else {
            AuditLog.logEvent("Authentication", userName, host, LOGEVENT_IMANAGER_AUTHENTICATION_FAILED);
        }
    }

    public static void logFailedLogin(String userName, String host, boolean bPortal, String clientHostIP) {
        String sEnableNSureAuditLog = new SystemConfig().getSetting(LOG_ITEM_LOGIN_FAILED, "false");
        String sEnableXDASLoginFailedLog = new SystemConfig().getSetting(XDAS_LOG_ITEM_LOGIN_FAILED, "false");
        String sEnableCEFLoginFailedLog = new SystemConfig().getSetting(CEF_LOG_ITEM_LOGIN_FAILED, "false");
        if (sEnableNSureAuditLog.equalsIgnoreCase("false") && sEnableXDASLoginFailedLog.equalsIgnoreCase("false") && sEnableCEFLoginFailedLog.equalsIgnoreCase("false")) {
            return;
        }
        if (bPortal) {
            AuditLog.logAuthEvent("Authentication", userName, host, clientHostIP, LOGEVENT_PORTAL_AUTHENTICATION_FAILED);
        } else {
            AuditLog.logAuthEvent("Authentication", userName, host, clientHostIP, LOGEVENT_IMANAGER_AUTHENTICATION_FAILED);
        }
    }

    public static void logLogout(String userName, String host, String clientHost, boolean bPortal) {
        String sEnableNSureAuditLog = new SystemConfig().getSetting(LOG_ITEM_LOGOUT, "false");
        String sEnableXDASLogOutLog = new SystemConfig().getSetting(XDAS_LOG_ITEM_LOGOUT, "false");
        String sEnableCEFLogOutLog = new SystemConfig().getSetting(CEF_LOG_ITEM_LOGOUT, "false");
        if (sEnableNSureAuditLog.equalsIgnoreCase("false") && sEnableXDASLogOutLog.equalsIgnoreCase("false") && sEnableCEFLogOutLog.equalsIgnoreCase("false")) {
            return;
        }
        if (bPortal) {
            AuditLog.logAuthEvent("Authentication", userName, host, clientHost, LOGEVENT_PORTAL_LOGOUT);
        } else {
            AuditLog.logAuthEvent("Authentication", userName, host, clientHost, LOGEVENT_IMANAGER_LOGOUT);
        }
    }

    public static void logLogout(String userName, String host, boolean bPortal) {
        String sEnableNSureAuditLog = new SystemConfig().getSetting(LOG_ITEM_LOGOUT, "false");
        String sEnableXDASLogOutLog = new SystemConfig().getSetting(XDAS_LOG_ITEM_LOGOUT, "false");
        String sEnableCEFLogOutLog = new SystemConfig().getSetting(CEF_LOG_ITEM_LOGOUT, "false");
        if (sEnableNSureAuditLog.equalsIgnoreCase("false") && sEnableXDASLogOutLog.equalsIgnoreCase("false") && sEnableCEFLogOutLog.equalsIgnoreCase("false")) {
            return;
        }
        if (bPortal) {
            AuditLog.logEvent("Authentication", userName, host, LOGEVENT_PORTAL_LOGOUT);
        } else {
            AuditLog.logEvent("Authentication", userName, host, LOGEVENT_IMANAGER_LOGOUT);
        }
    }

    public static void logModuleInstall(String sModuleTitle, String sPackageName) {
        String sEnableNSureAuditLog = new SystemConfig().getSetting(LOG_ITEM_NPM_INSTALLED, "false");
        String sEnableXDASModuleInstallLog = new SystemConfig().getSetting(XDAS_LOG_ITEM_NPM_INSTALLED, "false");
        String sEnableCEFModuleInstallLog = new SystemConfig().getSetting(CEF_LOG_ITEM_NPM_INSTALLED, "false");
        if (sEnableNSureAuditLog.equalsIgnoreCase("false") && sEnableXDASModuleInstallLog.equalsIgnoreCase("false") && sEnableCEFModuleInstallLog.equalsIgnoreCase("false")) {
            return;
        }
        AuditLog.logEvent("ModuleInstall", sModuleTitle, sPackageName, LOGEVENT_MODULE_INSTALL);
    }

    public static void logModuleInstall(String sPackageName, String userName, String host) {
        String sEnableNSureAuditLog = new SystemConfig().getSetting(LOG_ITEM_NPM_INSTALLED, "false");
        String sEnableXDASModuleInstallLog = new SystemConfig().getSetting(XDAS_LOG_ITEM_NPM_INSTALLED, "false");
        String sEnableCEFModuleInstallLog = new SystemConfig().getSetting(CEF_LOG_ITEM_NPM_INSTALLED, "false");
        if (sEnableNSureAuditLog.equalsIgnoreCase("false") && sEnableXDASModuleInstallLog.equalsIgnoreCase("false") && sEnableCEFModuleInstallLog.equalsIgnoreCase("false")) {
            return;
        }
        AuditLog.logModuleEvent("ModuleInstall", userName, sPackageName, host, LOGEVENT_MODULE_INSTALL);
    }

    public static void logModuleUpload(String userName, String moduleName, String Host) {
        String sEnableNSureAuditLog = new SystemConfig().getSetting(LOG_ITEM_NPM_UPLOADED, "false");
        String sEnableXDASModuleUploadLog = new SystemConfig().getSetting(XDAS_LOG_ITEM_NPM_UPLOADED, "false");
        String sEnableCEFModuleUploadLog = new SystemConfig().getSetting(CEF_LOG_ITEM_NPM_UPLOADED, "false");
        if (sEnableNSureAuditLog.equalsIgnoreCase("false") && sEnableXDASModuleUploadLog.equalsIgnoreCase("false") && sEnableCEFModuleUploadLog.equalsIgnoreCase("false")) {
            return;
        }
        AuditLog.logModuleEvent("ModuleUpload", userName, moduleName, Host, LOGEVENT_MODULE_UPLOAD);
    }

    public static void logModuleInstallFailed(String sModuleTitle, String sPackageName) {
        String sEnableNSureAuditLog = new SystemConfig().getSetting(LOG_ITEM_NPM_FAILED_INSTALL, "false");
        String sEnableXDASNPMFailedInstallLog = new SystemConfig().getSetting(XDAS_LOG_ITEM_NPM_FAILED_INSTALL, "false");
        String sEnableCEFNPMFailedInstallLog = new SystemConfig().getSetting(CEF_LOG_ITEM_NPM_FAILED_INSTALL, "false");
        if (sEnableNSureAuditLog.equalsIgnoreCase("false") && sEnableXDASNPMFailedInstallLog.equalsIgnoreCase("false") && sEnableCEFNPMFailedInstallLog.equalsIgnoreCase("false")) {
            return;
        }
        AuditLog.logEvent("ModuleInstallFailed", sModuleTitle, sPackageName, LOGEVENT_MODULE_INSTALL_FAILED);
    }

    public static void logModuleInstallFailed(String sPackageName, String userName, String Host) {
        String sEnableNSureAuditLog = new SystemConfig().getSetting(LOG_ITEM_NPM_FAILED_INSTALL, "false");
        String sEnableXDASNPMFailedInstallLog = new SystemConfig().getSetting(XDAS_LOG_ITEM_NPM_FAILED_INSTALL, "false");
        String sEnableCEFNPMFailedInstallLog = new SystemConfig().getSetting(CEF_LOG_ITEM_NPM_FAILED_INSTALL, "false");
        if (sEnableNSureAuditLog.equalsIgnoreCase("false") && sEnableXDASNPMFailedInstallLog.equalsIgnoreCase("false") && sEnableCEFNPMFailedInstallLog.equalsIgnoreCase("false")) {
            return;
        }
        AuditLog.logModuleEvent("ModuleInstallFailed", userName, sPackageName, Host, LOGEVENT_MODULE_INSTALL_FAILED);
    }

    public static void logAuthorizedUserAdded(String originator, String userName, String host, String clientHost) {
        String sEnableNSureAuditLog = new SystemConfig().getSetting(LOG_ITEM_AUTHORIZED_USERS, "false");
        String sEnableXDASAuthUserAddedLog = new SystemConfig().getSetting(XDAS_LOG_ITEM_AUTHORIZED_USERS, "false");
        String sEnableCEFAuthUserAddedLog = new SystemConfig().getSetting(CEF_LOG_ITEM_AUTHORIZED_USERS, "false");
        if (sEnableNSureAuditLog.equalsIgnoreCase("false") && sEnableXDASAuthUserAddedLog.equalsIgnoreCase("false") && sEnableCEFAuthUserAddedLog.equalsIgnoreCase("false")) {
            return;
        }
        AuditLog.logEvent("AuthorizedUserAdded", originator, userName, host, clientHost, LOGEVENT_AUTHORIZED_USER_ADDED);
    }

    public static void logAuthorizedUserRemoved(String userName, String host) {
        String sEnableNSureAuditLog = new SystemConfig().getSetting(LOG_ITEM_AUTHORIZED_USERS, "false");
        String sEnableXDASAuthUserRemovedLog = new SystemConfig().getSetting(XDAS_LOG_ITEM_AUTHORIZED_USERS, "false");
        String sEnableCEFAuthUserRemovedLog = new SystemConfig().getSetting(CEF_LOG_ITEM_AUTHORIZED_USERS, "false");
        if (sEnableNSureAuditLog.equalsIgnoreCase("false") && sEnableXDASAuthUserRemovedLog.equalsIgnoreCase("false") && sEnableCEFAuthUserRemovedLog.equalsIgnoreCase("false")) {
            return;
        }
        AuditLog.logEvent("AuthorizedUserRemoved", userName, host, LOGEVENT_AUTHORIZED_USER_REMOVED);
    }

    public static void logSystemStartup() {
        String sEnableNSureAuditLog = new SystemConfig().getSetting(LOG_ITEM_SYSTEM_STARTUP, "false");
        String sEnableXDASSysStartLog = new SystemConfig().getSetting(XDAS_LOG_ITEM_SYSTEM_STARTUP, "false");
        String sEnableCEFSysStartLog = new SystemConfig().getSetting(CEF_LOG_ITEM_SYSTEM_STARTUP, "false");
        if (sEnableNSureAuditLog.equalsIgnoreCase("false") && sEnableXDASSysStartLog.equalsIgnoreCase("false") && sEnableCEFSysStartLog.equalsIgnoreCase("false")) {
            return;
        }
        AuditLog.logEvent("Servlet", LOGEVENT_SYSTEM_STARTED);
    }

    public static void logSystemShutdown() {
        String sEnableNSureAuditLog = new SystemConfig().getSetting(LOG_ITEM_SYSTEM_SHUTDOWN, "false");
        String sEnableXDASSysShutLog = new SystemConfig().getSetting(XDAS_LOG_ITEM_SYSTEM_SHUTDOWN, "false");
        String sEnableCEFSysShutLog = new SystemConfig().getSetting(CEF_LOG_ITEM_SYSTEM_SHUTDOWN, "false");
        if (sEnableNSureAuditLog.equalsIgnoreCase("false") && sEnableXDASSysShutLog.equalsIgnoreCase("false") && sEnableCEFSysShutLog.equalsIgnoreCase("false")) {
            return;
        }
        AuditLog.logEvent("Servlet", LOGEVENT_SYSTEM_SHUTDOWN);
    }

    public static void logFailedSSLConnection(String userName, String host) {
        String sEnableNSureAuditLog = new SystemConfig().getSetting(LOG_ITEM_FAILED_SSL_CONNECTION, "false");
        String sEnableXDASSysLog = new SystemConfig().getSetting(XDAS_LOG_ITEM_FAILED_SSL_CONNECTION, "false");
        String sEnableCEFSysLog = new SystemConfig().getSetting(CEF_LOG_ITEM_FAILED_SSL_CONNECTION, "false");
        if (sEnableNSureAuditLog.equalsIgnoreCase("false") && sEnableXDASSysLog.equalsIgnoreCase("false") && sEnableCEFSysLog.equalsIgnoreCase("false")) {
            return;
        }
        AuditLog.logEvent("FailedSSLConnection", userName, host, LOGEVENT_FAILED_SSL_CONNECTION);
    }

    public static void logSystemConfigurationChanged(String userName, String host) {
        String sEnableNSureAuditLog = new SystemConfig().getSetting(LOG_ITEM_CHANGED_CONFIGURATION, "false");
        String sEnableXDASSysConfChangeLog = new SystemConfig().getSetting(XDAS_LOG_ITEM_CHANGED_CONFIGURATION, "false");
        String sEnableCEFSysConfChangeLog = new SystemConfig().getSetting(CEF_LOG_ITEM_CHANGED_CONFIGURATION, "false");
        if (sEnableNSureAuditLog.equalsIgnoreCase("false") && sEnableXDASSysConfChangeLog.equalsIgnoreCase("false") && sEnableCEFSysConfChangeLog.equalsIgnoreCase("false")) {
            return;
        }
        AuditLog.logEvent("SystemConfigurationChanged", userName, host, LOGEVENT_SYSTEM_CONFIGURATION_CHANGED);
    }

    public static LogEvent getLogEvent() {
        long rv = 0L;
        String sEnableXDASAuditLog = new SystemConfig().getSetting(ENABLE_XDAS_AUDIT_LOG, "false");
        if (sEnableXDASAuditLog.equalsIgnoreCase("true")) {
            isXDASAuditEnabled = true;
        }
        if (isXDASAuditEnabled) {
            AuditLog.configureXDASLogs(true);
        } else {
            AuditLog.configureXDASLogs(false);
        }
        String sEnableCEFAuditLog = new SystemConfig().getSetting(ENABLE_CEF_AUDIT_LOG, "false");
        if (sEnableCEFAuditLog.equalsIgnoreCase("true")) {
            isCEFAuditEnabled = true;
        }
        if (isCEFAuditEnabled) {
            AuditLog.configureCEFLogs(true);
        } else {
            AuditLog.configureCEFLogs(false);
        }
        String sEnableNSureAuditLog = new SystemConfig().getSetting(ENABLE_NSURE_AUDIT_LOG, "false");
        if (sEnableNSureAuditLog.equalsIgnoreCase("true")) {
            AuditLog.configureNSureAudit(true);
        } else {
            AuditLog.configureNSureAudit(false);
        }
        if (m_logEvent != null) {
            if (sEnableNSureAuditLog.equalsIgnoreCase("false") && !isXDASAuditEnabled && !isCEFAuditEnabled) {
                return null;
            }
            return m_logEvent;
        }
        if (sEnableNSureAuditLog.equalsIgnoreCase("false") && !isXDASAuditEnabled && !isCEFAuditEnabled) {
            return null;
        }
        if (!m_bNSureAuditAvailable) {
            return null;
        }
        File certFile = null;
        File keyFile = null;
        String sCertificate = "";
        String sKey = "";
        String osname = System.getProperty("os.name").toLowerCase();
        if (osname.indexOf("linux") != -1) {
            certFile = new File("/etc/imanicert.pem");
            keyFile = new File("/etc/imanipkey.pem");
        } else if (osname.indexOf("windows") != -1) {
            certFile = new File(windowsCertFilePath);
            keyFile = new File(windowsKeyFilePath);
        } else if (osname.indexOf("netware") != -1) {
            certFile = new File(netwareCertFilePath);
            keyFile = new File(netwareKeyFilePath);
        } else if (osname.indexOf("solaris") != -1) {
            certFile = new File("/etc/imanicert.pem");
            keyFile = new File("/etc/imanipkey.pem");
        }
        if (certFile != null && keyFile != null && certFile.exists() && keyFile.exists()) {
            sCertificate = AuditLog.getContentFromPemFile(certFile);
            sKey = AuditLog.getContentFromPemFile(keyFile);
        }
        try {
            m_logEvent = new LogEvent();
            rv = m_logEvent.LogOpen(app_name, sCertificate, sKey, 0L);
        }
        catch (Throwable t) {
            if (D.isDebugEnabled(1)) {
                D.log("NSure Audit is not available.", 1);
                D.log(t);
            }
            m_bNSureAuditAvailable = false;
            return null;
        }
        if (rv > 0L) {
            if (D.isDebugEnabled(1)) {
                D.log("NSure Audit is not available.", 1);
            }
            m_bNSureAuditAvailable = false;
            if (isXDASAuditEnabled) {
                return m_logEvent;
            }
            return null;
        }
        m_bNSureAuditAvailable = true;
        return m_logEvent;
    }

    private static void configureNSureAudit(boolean enabled) {
        if (enabled) {
            Enumeration allCurrentLoggers = LogManager.getCurrentLoggers();
            while (allCurrentLoggers.hasMoreElements()) {
                Appender nAppender;
                Logger log = (Logger)allCurrentLoggers.nextElement();
                if (!log.getName().equalsIgnoreCase("com.novell.emframe.fw.AuditLog") || null != (nAppender = log.getAppender("NAUDIT_APPENDER")) || nAuditAppender == null) continue;
                log.getParent().addAppender(nAuditAppender);
            }
        } else {
            Enumeration allCurrentLoggers = LogManager.getCurrentLoggers();
            while (allCurrentLoggers.hasMoreElements()) {
                Logger log = (Logger)allCurrentLoggers.nextElement();
                Appender tmp = log.getAppender("NAUDIT_APPENDER");
                if (tmp == null) continue;
                log.removeAppender("NAUDIT_APPENDER");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentFromPemFile(File pemFile) {
        StringBuffer contents = new StringBuffer();
        BufferedReader input = null;
        try {
            input = new BufferedReader(new FileReader(pemFile));
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return contents.toString();
    }

    private static void configureXDASLogs(boolean enable) {
        if (enable) {
            Enumeration allCurrentLoggers = LogManager.getCurrentLoggers();
            while (allCurrentLoggers.hasMoreElements()) {
                Appender fileRollingApp;
                Logger log = (Logger)allCurrentLoggers.nextElement();
                if (!log.getName().equalsIgnoreCase("com.novell.emframe.fw.AuditLog")) continue;
                Appender sysApp = log.getParent().getAppender("Syslog");
                if (null == sysApp && null != sysLogAppender) {
                    log.getParent().addAppender(sysLogAppender);
                }
                if (null != (fileRollingApp = log.getParent().getAppender("Syslog")) || null == rollingFileAppender) continue;
                log.getParent().addAppender(rollingFileAppender);
            }
        } else {
            Enumeration allCurrentLoggers = LogManager.getCurrentLoggers();
            while (allCurrentLoggers.hasMoreElements()) {
                Logger log = (Logger)allCurrentLoggers.nextElement();
                Appender tmp = log.getAppender("Syslog");
                if (tmp != null) {
                    log.removeAppender("Syslog");
                }
                if ((tmp = log.getAppender("FILE_APPENDER")) != null) {
                    log.removeAppender("FILE_APPENDER");
                }
                if ((tmp = log.getParent().getAppender("Syslog")) != null) {
                    log.getParent().removeAppender("Syslog");
                }
                if ((tmp = log.getParent().getAppender("FILE_APPENDER")) == null) continue;
                log.getParent().removeAppender("FILE_APPENDER");
            }
        }
    }

    private static void configureCEFLogs(boolean enable) {
        if (enable) {
            Enumeration allCurrentLoggers = LogManager.getCurrentLoggers();
            while (allCurrentLoggers.hasMoreElements()) {
                Appender fileRollingApp;
                Logger log = (Logger)allCurrentLoggers.nextElement();
                if (!log.getName().equalsIgnoreCase("com.novell.emframe.fw.AuditLog")) continue;
                Appender sysApp = log.getParent().getAppender("CEFSyslog");
                if (null == sysApp && null != sysLogCEFAppender) {
                    log.getParent().addAppender(sysLogCEFAppender);
                }
                if (null != (fileRollingApp = log.getParent().getAppender("CEFSyslog")) || null == rollingCEFFileAppender) continue;
                log.getParent().addAppender(rollingCEFFileAppender);
            }
        } else {
            Enumeration allCurrentLoggers = LogManager.getCurrentLoggers();
            while (allCurrentLoggers.hasMoreElements()) {
                Logger log = (Logger)allCurrentLoggers.nextElement();
                Appender tmp = log.getAppender("CEFSyslog");
                if (tmp != null) {
                    log.removeAppender("CEFSyslog");
                }
                if ((tmp = log.getAppender("CEF_FILE_APPENDER")) != null) {
                    log.removeAppender("CEF_FILE_APPENDER");
                }
                if ((tmp = log.getParent().getAppender("CEFSyslog")) != null) {
                    log.getParent().removeAppender("CEFSyslog");
                }
                if ((tmp = log.getParent().getAppender("CEF_FILE_APPENDER")) == null) continue;
                log.getParent().removeAppender("CEF_FILE_APPENDER");
            }
        }
    }

    static {
        Appender rollingApp;
        Appender sysApp;
        Logger log;
        LOGEVENT_SYSTEM_STARTED = 0x150001L;
        LOGEVENT_SYSTEM_SHUTDOWN = 1376258L;
        LOGEVENT_PORTAL_AUTHENTICATION_SUCCEEDED = 1376259L;
        LOGEVENT_IMANAGER_AUTHENTICATION_SUCCEEDED = 1376260L;
        LOGEVENT_PORTAL_AUTHENTICATION_FAILED = 0x150005L;
        LOGEVENT_IMANAGER_AUTHENTICATION_FAILED = 1376262L;
        LOGEVENT_PORTAL_LOGOUT = 1376263L;
        LOGEVENT_IMANAGER_LOGOUT = 1376264L;
        LOGEVENT_MODULE_INSTALL = 1376265L;
        LOGEVENT_MODULE_INSTALL_FAILED = 0x150010L;
        LOGEVENT_FAILED_SSL_CONNECTION = 0x150011L;
        LOGEVENT_SYSTEM_CONFIGURATION_CHANGED = 1376274L;
        LOGEVENT_AUTHORIZED_USER_ADDED = 1376275L;
        LOGEVENT_AUTHORIZED_USER_REMOVED = 1376276L;
        LOGEVENT_MODULE_UPLOAD = 0x150015L;
        m_logEvent = null;
        m_bNSureAuditAvailable = true;
        LOGGER = Logger.getLogger((String)AuditLog.class.getName());
        isXDASAuditEnabled = false;
        isCEFAuditEnabled = false;
        sysLogAppender = null;
        sysLogCEFAppender = null;
        rollingFileAppender = null;
        rollingCEFFileAppender = null;
        nAuditAppender = null;
        String sEnableXDASAuditLog = new SystemConfig().getSetting(ENABLE_XDAS_AUDIT_LOG, "false");
        String sEnableCEFAuditLog = new SystemConfig().getSetting(ENABLE_CEF_AUDIT_LOG, "false");
        Enumeration allCurrentLoggers = LogManager.getCurrentLoggers();
        while (allCurrentLoggers.hasMoreElements()) {
            log = (Logger)allCurrentLoggers.nextElement();
            if (log.getParent().getAppender("Syslog") != null) {
                sysLogAppender = log.getParent().getAppender("Syslog");
            }
            if (log.getParent().getAppender("CEFSyslog") != null) {
                sysLogCEFAppender = log.getParent().getAppender("CEFSyslog");
            }
            if (log.getParent().getAppender("FILE_APPENDER") != null) {
                rollingFileAppender = log.getParent().getAppender("FILE_APPENDER");
            }
            if (log.getParent().getAppender("CEF_FILE_APPENDER") != null) {
                rollingCEFFileAppender = log.getParent().getAppender("CEF_FILE_APPENDER");
            }
            if (log.getParent().getAppender("NAUDIT_APPENDER") == null) continue;
            nAuditAppender = log.getParent().getAppender("NAUDIT_APPENDER");
        }
        if (sEnableXDASAuditLog.equalsIgnoreCase("true")) {
            isXDASAuditEnabled = true;
        } else {
            allCurrentLoggers = LogManager.getCurrentLoggers();
            while (allCurrentLoggers.hasMoreElements()) {
                log = (Logger)allCurrentLoggers.nextElement();
                sysApp = log.getAppender("Syslog");
                if (null != sysApp) {
                    log.getParent().removeAppender("Syslog");
                }
                if (null == (rollingApp = log.getAppender("FILE_APPENDER"))) continue;
                log.getParent().removeAppender("FILE_APPENDER");
            }
        }
        if (sEnableCEFAuditLog.equalsIgnoreCase("true")) {
            isCEFAuditEnabled = true;
        } else {
            allCurrentLoggers = LogManager.getCurrentLoggers();
            while (allCurrentLoggers.hasMoreElements()) {
                log = (Logger)allCurrentLoggers.nextElement();
                sysApp = log.getAppender("CEFSyslog");
                if (null != sysApp) {
                    log.getParent().removeAppender("CEFSyslog");
                }
                if (null == (rollingApp = log.getAppender("CEF_FILE_APPENDER"))) continue;
                log.getParent().removeAppender("CEF_FILE_APPENDER");
            }
        }
        allCurrentLoggers = LogManager.getCurrentLoggers();
        String sEnableNSureAuditLog = new SystemConfig().getSetting(ENABLE_NSURE_AUDIT_LOG, "false");
        if (sEnableNSureAuditLog.equalsIgnoreCase("false")) {
            while (allCurrentLoggers.hasMoreElements()) {
                Logger log2 = (Logger)allCurrentLoggers.nextElement();
                Appender app = log2.getAppender("NAUDIT_APPENDER");
                if (app == null) continue;
                log2.removeAppender("NAUDIT_APPENDER");
            }
        }
    }
}

