/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.fw.FwTaskContext;
import com.novell.emframe.fw.FwUtils;
import com.novell.webaccess.common.I18NServletRequest;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class AuthenticateFormTask
extends Task {
    private static final long serialVersionUID = 1L;
    Properties resultStrings;
    TaskContext context;

    @Override
    public boolean execute(TaskContext context, Properties resultStrings) {
        String cookie;
        this.resultStrings = resultStrings;
        this.context = context;
        I18NServletRequest req = (I18NServletRequest)context.getRequest();
        String strContext = null;
        String strTree = null;
        String strUsername = null;
        String treeMode = SystemConfig.getSystemConfig(context).getSetting("Provider.eMFrame.Authentication.Tree.mode");
        if (!this.isValidContextOrTreeMode(treeMode)) {
            treeMode = "initial";
        }
        if (D.isDebugEnabled()) {
            resultStrings.put("eMFrame.Debug.enable", "true");
        }
        resultStrings.put("Authenticate.Form.TreeMode", treeMode);
        if (treeMode.equals("constrain")) {
            this.populateForceArray("Tree");
        }
        if ((cookie = FwUtils.getCookie((HttpServletRequest)req, "l")) != null && cookie.length() > 0) {
            StringTokenizer st = new StringTokenizer(cookie, "|", true);
            try {
                strUsername = st.nextToken();
                if (strUsername.equals("|")) {
                    strUsername = "";
                } else {
                    st.nextToken();
                }
                strContext = st.nextToken();
                if (strContext.equals("|")) {
                    strContext = "";
                } else {
                    st.nextToken();
                }
                strTree = st.nextToken();
            }
            catch (NoSuchElementException e) {
                D.log(e);
            }
        }
        boolean loginCookieSet = true;
        if (strContext == null || strTree == null) {
            loginCookieSet = false;
            SystemConfig providerProperties = SystemConfig.getSystemConfig(context);
            strContext = providerProperties.getSetting("Provider.eMFrame.Authentication.Context.0");
            strTree = providerProperties.getSetting("Provider.eMFrame.Authentication.Tree.0");
        }
        if (strUsername != null && strUsername.length() > 0) {
            resultStrings.put("Authenticate.Form.UserNameInitialValue", strUsername);
        }
        if (strContext != null && strContext.length() > 0) {
            resultStrings.put("Authenticate.Form.ContextInitialValue", strContext);
        }
        if (strTree != null && strTree.length() > 0) {
            resultStrings.put("Authenticate.Form.TreeInitialValue", strTree);
        }
        if (loginCookieSet && ((FwTaskContext)((Object)context)).getUserInfo().getHtmlDirectory().equals("pocket") && !FwUtils.isParamTrue("ShowAdvanced", context) && strTree != null && strTree.length() != 0) {
            resultStrings.put("Authenticate.Form.TreeMode", "invisible");
            resultStrings.put("Authenticate.Form.ContextMode", "invisible");
        }
        return true;
    }

    public void populateForceArray(String type) {
        ArrayList<String> validNames = new ArrayList<String>();
        boolean done = false;
        int i = 0;
        while (!done) {
            String name = SystemConfig.getSystemConfig(this.context).getSetting("Provider.eMFrame.Authentication." + type + "." + i);
            if (name == null) {
                done = true;
                continue;
            }
            validNames.add(name);
            ++i;
        }
        this.resultStrings.put("Authenticate.Form." + type + "Value.Count", Integer.toString(i));
        for (int j = 0; j < validNames.size(); ++j) {
            this.resultStrings.put("Authenticate.Form." + type + "Value." + j, validNames.get(j));
        }
    }

    public boolean isValidContextOrTreeMode(String mode) {
        if (mode == null) {
            return false;
        }
        return mode.equals("initial") || mode.equals("constrain") || mode.equals("invisible");
    }
}

