/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.ns.MOOManager;
import com.novell.admin.ns.MOOManagerCallBack;
import com.novell.admin.ns.MOOManagerImpl;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.ObjectOperation;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSObjectOperation;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.application.console.snapin.DefaultObjectEntryCollection;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.PageException;
import com.novell.emframe.fw.GroupPageMooCallback;
import java.util.ArrayList;
import java.util.Arrays;

public class BackLinkUtils {
    public static void updateBacklinks(ArrayList targetNames, String attributeName, String value, int operation, ObjectEntry treeObjectEntry) throws PageException {
        String[] values = new String[]{value};
        String[] attributes = new String[]{attributeName};
        BackLinkUtils.updateBacklinks(targetNames, attributes, values, operation, treeObjectEntry);
    }

    public static void updateBacklinks(ArrayList targetNames, String[] attributeName, String[] values, int operation, ObjectEntry treeObjectEntry) throws PageException {
        NDSNamespace ns = (NDSNamespace)treeObjectEntry.getNamespace();
        if (targetNames.size() == 0) {
            return;
        }
        try {
            MOOManager moo = BackLinkUtils.createMOOManager(targetNames, treeObjectEntry);
            for (int i = 0; i < attributeName.length; ++i) {
                ObjectEntry oe = ns.getObjectEntry((String)targetNames.get(0));
                ObjectAttribute attribute = ns.getAttribute(oe, attributeName[i]);
                String[] valueComponents = null;
                if (attribute != null && attribute.getValueComponentsAsArray() != null) {
                    valueComponents = BackLinkUtils.makeString(attribute.getValueComponentsAsArray());
                }
                if (attribute != null && (valueComponents == null || BackLinkUtils.areEqual(valueComponents, values)) && operation != 2) continue;
                NDSAttributeDefinition attributeDefinition = (NDSAttributeDefinition)ns.getAttributeDefinition(treeObjectEntry, attributeName[i]);
                NDSObjectOperation oo = new NDSObjectOperation(attributeDefinition, operation);
                for (int j = 0; j < values.length; ++j) {
                    oo.addComponent(NDSSyntax.SYN_DIST_NAME.createValueComponent((Object)values[j]));
                }
                moo.addObjectOperation((ObjectOperation)oo);
            }
            GroupPageMooCallback callback = new GroupPageMooCallback();
            moo.updateObjects((MOOManagerCallBack)callback);
            if (callback.m_exception != null) {
                if (!(callback.m_exception instanceof UniqueSPIException) || ((UniqueSPIException)callback.m_exception).getErrorCode() == -608) {
                    // empty if block
                }
                throw new PageException(callback.m_exception);
            }
        }
        catch (Exception e) {
            throw new PageException(e);
        }
    }

    private static boolean areEqual(String[] value1, String[] value2) {
        Arrays.sort(value1);
        Arrays.sort(value2);
        return Arrays.equals(value1, value2);
    }

    private static String[] makeString(Object[] value) {
        String[] res = new String[value.length];
        for (int i = 0; i < value.length; ++i) {
            res[i] = value[i].toString();
        }
        return res;
    }

    private static MOOManager createMOOManager(ArrayList list, ObjectEntry treeOE) throws SPIException {
        NDSNamespace ns = (NDSNamespace)treeOE.getNamespace();
        ArrayList<ObjectEntry> oeList = new ArrayList<ObjectEntry>();
        for (String groupName : list) {
            ObjectEntry oe = ns.getObjectEntry(treeOE, groupName);
            oeList.add(oe);
        }
        ObjectEntry[] oeArray = oeList.toArray(new ObjectEntry[oeList.size()]);
        DefaultObjectEntryCollection oc = new DefaultObjectEntryCollection(oeArray);
        return new MOOManagerImpl(treeOE, oc.elements());
    }
}

