/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.MOOManager;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.ObjectOperation;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.CaseIgnoreListFacade;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSObjectAttribute;
import com.novell.admin.ns.nds.NDSObjectOperation;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DataHandler;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.TargetObjects;
import com.novell.emframe.dev.XmlUtils;
import com.novell.emframe.dev.eDirAccessServiceException;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.DefaultSyntaxHandler;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.iManager;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import org.jdom.Document;
import org.jdom.Element;

public class CIListSyntaxHandler
extends DataHandler {
    @Override
    public String getString(Object theObj, String attrName, MContext context) throws eDirAccessServiceException {
        Enumeration myenum = null;
        boolean isSingleValued = false;
        boolean isRefresh = false;
        if (context.getRequest().getAttribute("isRefresh") != null) {
            isRefresh = context.getRequest().getAttribute("isRefresh").equals("true");
        }
        String[] strList = null;
        StringBuffer resultValue = new StringBuffer();
        ValueComponent vc = null;
        resultValue.append("<" + FwUtils.getSafeName(attrName));
        if (theObj instanceof MOOManager) {
            ObjectOperation oo = ((MOOManager)theObj).getObjectOperation(attrName);
            resultValue.append(" mode='");
            switch (oo.getMode()) {
                case 1: {
                    resultValue.append("add'>");
                    break;
                }
                case 2: {
                    resultValue.append("remove'>");
                    break;
                }
                case 3: {
                    resultValue.append("set'>");
                    break;
                }
                case 5: {
                    resultValue.append("ignore'>");
                }
            }
            isSingleValued = oo.getAttributeDefinition().isSingleValued();
            myenum = oo.getValueComponents();
        } else {
            ObjectAttribute oa = null;
            if (!isRefresh) {
                oa = ((NSObject)theObj).getAttribute(attrName);
            } else {
                ObjectEntry treeOE = null;
                try {
                    treeOE = (ObjectEntry)context.getAuthenticationBroker().getProtocolObject("AdminNamespace");
                }
                catch (AuthBrokerException e) {
                    e.printStackTrace();
                }
                AdminNamespace ns1 = (AdminNamespace)treeOE.getNamespace();
                try {
                    TargetObjects targetObjects = (TargetObjects)context.getRequest().getAttribute("targetObjects");
                    oa = ns1.getAttribute(targetObjects.getObjectEntry(), attrName);
                }
                catch (SPIException e) {
                    e.printStackTrace();
                }
            }
            isSingleValued = oa.getAttributeDefinition().isSingleValued();
            resultValue.append(">");
            if (oa != null) {
                myenum = oa.getValueComponents();
            }
        }
        if (isSingleValued) {
            while (myenum != null && myenum.hasMoreElements()) {
                vc = (ValueComponent)myenum.nextElement();
                strList = ((CaseIgnoreListFacade)((ValueList)vc).createFacade()).getStrings();
                for (int i = 0; i < strList.length; ++i) {
                    resultValue.append("<value>");
                    resultValue.append(XmlUtils.xmlEncode(strList[i]));
                    resultValue.append("</value>");
                }
            }
        } else {
            while (myenum != null && myenum.hasMoreElements()) {
                vc = (ValueComponent)myenum.nextElement();
                strList = ((CaseIgnoreListFacade)((ValueList)vc).createFacade()).getStrings();
                resultValue.append("<value>");
                for (int i = 0; i < strList.length; ++i) {
                    strList[i] = XmlUtils.xmlEncode(strList[i]);
                }
                resultValue.append(eMFrameUtils.pack(strList, context));
                resultValue.append("</value>");
            }
        }
        resultValue.append("</" + FwUtils.getSafeName(attrName) + ">");
        return resultValue.toString();
    }

    @Override
    public void setString(Object theObj, String attrName, String value, MContext context) throws eDirAccessServiceException {
        ObjectEntry theOE = null;
        NDSNamespace ns = null;
        NDSAttributeDefinition ad = null;
        boolean isSingleValued = false;
        String mode = null;
        theOE = theObj instanceof MOOManager ? ((MOOManager)theObj).getTreeObjectEntry() : ((NSObject)theObj).getObjectEntry();
        ns = (NDSNamespace)theOE.getNamespace();
        try {
            ad = (NDSAttributeDefinition)ns.getAttributeDefinition(theOE, attrName);
        }
        catch (Exception e) {
            D.log(e);
            D.log("EDAS: Unrecognized Attribute:" + attrName);
            throw new eDirAccessServiceException(e);
        }
        Document doc = null;
        try {
            doc = iManager.getSaxBuilder().build((Reader)new StringReader(value));
        }
        catch (Exception e) {
            D.log(e);
            D.log("Bad XML for " + attrName);
            D.log("XML: " + value);
            throw new eDirAccessServiceException(e);
        }
        Element root = doc.getRootElement();
        boolean isEmpty = !root.hasChildren();
        mode = root.getAttributeValue("mode");
        if (mode == null) {
            mode = new String("set");
        }
        try {
            if (theObj instanceof MOOManager) {
                int dsMode = DefaultSyntaxHandler.getOperationType(mode);
                MOOManager mm = (MOOManager)theObj;
                NDSObjectOperation oo = new NDSObjectOperation(ad, dsMode);
                List theElements = root.getChildren("value");
                ListIterator iter = theElements.listIterator();
                Element tempElem = null;
                int size = theElements.size();
                if (size > 0) {
                    String[] items = new String[theElements.size()];
                    int i = 0;
                    while (iter.hasNext()) {
                        tempElem = (Element)iter.next();
                        items[i++] = new String(tempElem.getText());
                    }
                    oo.addComponent((ValueComponent)CaseIgnoreListFacade.createValueList((String[])items));
                }
                if (size > 0 || dsMode != 5) {
                    mm.addObjectOperation((ObjectOperation)oo);
                }
            } else {
                int i;
                String[] items;
                Element tempElem;
                ListIterator iter;
                List theElements;
                NSObject nsObj = (NSObject)theObj;
                NDSObjectAttribute oa = (NDSObjectAttribute)nsObj.getAttribute(attrName);
                if (oa != null) {
                    isSingleValued = oa.getAttributeDefinition().isSingleValued();
                }
                boolean needToAdd = false;
                if (null == oa) {
                    if (isEmpty) {
                        return;
                    }
                    oa = new NDSObjectAttribute(ad);
                    if (oa != null) {
                        isSingleValued = oa.getAttributeDefinition().isSingleValued();
                    }
                    needToAdd = true;
                } else if (isEmpty) {
                    if (mode.equalsIgnoreCase("set")) {
                        nsObj.deleteAttribute(attrName);
                    }
                } else if (mode.equalsIgnoreCase("remove")) {
                    theElements = root.getChildren("value");
                    iter = theElements.listIterator();
                    tempElem = null;
                    items = new String[theElements.size()];
                    i = 0;
                    while (iter.hasNext()) {
                        tempElem = (Element)iter.next();
                        items[i++] = new String(tempElem.getText());
                    }
                    oa.removeComponent((ValueComponent)CaseIgnoreListFacade.createValueList((String[])items));
                } else if (mode.equalsIgnoreCase("set")) {
                    oa.removeAllComponents();
                }
                if (!isEmpty) {
                    theElements = root.getChildren("value");
                    iter = theElements.listIterator();
                    tempElem = null;
                    items = new String[theElements.size()];
                    i = 0;
                    while (iter.hasNext()) {
                        tempElem = (Element)iter.next();
                        items[i++] = new String(tempElem.getText());
                    }
                    if (isSingleValued) {
                        oa.addComponent((ValueComponent)CaseIgnoreListFacade.createValueList((String[])items));
                    } else {
                        for (int count = 0; count < items.length; ++count) {
                            String[] tempArr = eMFrameUtils.unpack(XmlUtils.xmlDecode(items[count]), context);
                            oa.addComponent((ValueComponent)CaseIgnoreListFacade.createValueList((String[])tempArr));
                        }
                    }
                }
                if (needToAdd && oa.getComponentCount() != 0) {
                    nsObj.addAttribute((ObjectAttribute)oa);
                }
            }
        }
        catch (Exception e) {
            D.log(e);
            D.log("Attibute Name: " + attrName);
            D.log("Attibute Value: " + value);
            throw new eDirAccessServiceException(e);
        }
    }
}

