/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.CfgWizUtil;
import com.novell.webaccess.common.I18NServletRequest;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class CfgWizPanelInfo {
    public AuthenticationBroker m_authBroker;
    public HttpServletRequest m_httpRequest;
    public AdminNamespace m_ndsNS;
    public ObjectEntry m_treeOE;
    public ObjectEntry m_rootOE;
    public ObjectEntry m_userOE;
    public Properties m_providerProperties;
    public Properties m_requestProperties;
    public TaskContext m_taskContext;

    public CfgWizPanelInfo(HttpServletRequest httpRequest, TaskContext taskContext, Properties requestProperties) throws SPIException {
        this.initializeDataMembers(httpRequest, taskContext, requestProperties);
    }

    public static CfgWizPanelInfo buildPanelInfo(TaskContext taskContext, Properties requestProperties) throws SPIException {
        return new CfgWizPanelInfo(taskContext.getRequest(), taskContext, requestProperties);
    }

    public static void setGenErrException(Properties requestProperties, Throwable t, TaskContext context) {
        requestProperties.put("error", "dev.GenErr");
        eMFrameUtils.setErrorMessage(t, context);
    }

    public void clearError() {
        if (null != this.m_requestProperties) {
            this.m_requestProperties.put("CfgWiz.ErrorStatus", "CfgWiz.NoError");
            this.m_requestProperties.put("CfgWiz.ErrorMsgVar", "");
        }
    }

    public void closeTask(Task task) {
        task.taskCompleteFlag = true;
        if (null != this.m_requestProperties) {
            this.m_requestProperties.put("Task.frameLevel", "1");
        }
    }

    public boolean errorSet() {
        if (null == this.m_requestProperties) {
            return false;
        }
        String error = (String)this.m_requestProperties.get("CfgWiz.ErrorStatus");
        return CfgWizUtil.hasString(error) && error.equalsIgnoreCase("Error");
    }

    public void passAlong(String tag) {
        this.passAlong(tag, tag);
    }

    public void passAlong(String httpTag, String rpTag) {
        if (null != this.m_httpRequest && null != this.m_requestProperties) {
            String value = this.m_httpRequest.getParameter(httpTag);
            this.m_requestProperties.put(rpTag, null == value ? "" : value);
        }
    }

    public void setError(String errorMsgID) {
        this.setError(errorMsgID, (String[])null);
    }

    public void setError(String errorMsgID, String patch) {
        this.setError(errorMsgID, new String[]{patch});
    }

    public void setErrorMsg(String errMsg) {
        if (!CfgWizUtil.hasString(errMsg)) {
            this.clearError();
            return;
        }
        this.m_requestProperties.put("CfgWiz.ErrorMsg", errMsg);
        this.m_requestProperties.put("CfgWiz.ErrorStatus", "Error");
    }

    public void setError(String errorMsgID, String[] patches) {
        if (!CfgWizUtil.hasString(errorMsgID)) {
            this.clearError();
            return;
        }
        if (null != this.m_requestProperties) {
            int patchCount = null == patches ? 0 : patches.length;
            this.m_requestProperties.put("CfgWiz.ErrorMsgVar", errorMsgID);
            this.m_requestProperties.put("CfgWiz.ErrorStatus", "Error");
            this.m_requestProperties.put("CfgWiz.ErrorMsgArgsVar", new Integer(patchCount).toString());
            for (int i = 0; i < patchCount; ++i) {
                String patch = patches[i];
                if (null == patch) {
                    patch = "";
                }
                this.m_requestProperties.put("CfgWiz.ErrorMsgVar.Patch." + new Integer(i).toString(), patch);
            }
        }
    }

    public static Hashtable getSessionCache(CfgWizPanelInfo pi) {
        return null == pi || null == pi.m_taskContext ? null : pi.m_taskContext.getAuthenticator().getAuthContext();
    }

    public boolean isTaskClosing(String tag, String value, Task task) {
        boolean reply;
        boolean bl = reply = null != tag && null != value;
        if (reply) {
            reply = tag.equalsIgnoreCase("merge") && value.equalsIgnoreCase("fw.WizClose");
        }
        return reply;
    }

    public void writeServletRequest(String tag, String value) {
        if (null != this.m_httpRequest) {
            ((I18NServletRequest)this.m_httpRequest).setParameter(tag, value);
        }
    }

    private void initializeDataMembers(HttpServletRequest httpRequest, TaskContext taskContext, Properties requestProperties) throws SPIException {
        this.m_httpRequest = httpRequest;
        this.m_taskContext = taskContext;
        this.m_requestProperties = requestProperties;
        this.m_authBroker = taskContext.getAuthenticationBroker();
        try {
            this.m_treeOE = (ObjectEntry)this.m_authBroker.getProtocolObject("AdminNamespace");
        }
        catch (AuthBrokerException e) {
            D.log(e);
        }
        this.m_ndsNS = this.m_treeOE.getAdminNamespace();
        this.m_userOE = this.m_ndsNS.getAuthenticatedIdentity(this.m_treeOE);
        this.m_rootOE = null == this.m_userOE ? null : this.m_userOE.getRoot();
    }
}

