/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.fw.CollectionsReportClass;
import java.text.Collator;
import java.util.Comparator;
import java.util.Date;

public class CollectionsReportSort
implements Comparator {
    public static final String SORT_DESCENDING = "descending";
    public static final String SORT_ASCENDING = "ascending";
    public static final String SORT_COLLECTION_OBJECT = "sortCollectionObject";
    public static final String SORT_OWNER_OBJECT = "sortOwnerObject";
    public static final String SORT_CREATOR_OBJECT = "sortCreatorObject";
    public static final String SORT_DATE = "sortDate";
    public static final String SORT_VERSION = "sortVersion";
    Collator m_collator = null;
    TaskContext m_context = null;
    String m_sortColumn = null;
    String m_sortDirection = null;

    public CollectionsReportSort(TaskContext context, String sortColumn, String sortDirection) {
        this.m_context = context;
        this.m_sortColumn = sortColumn;
        this.m_sortDirection = sortDirection;
        this.m_collator = Collator.getInstance(this.m_context.getLocale());
    }

    public int compare(Object object1, Object object2) {
        int compare = 0;
        if (this.m_sortColumn.equalsIgnoreCase(SORT_COLLECTION_OBJECT)) {
            String collectionObject1 = ((CollectionsReportClass)object1).getCollectionFDN();
            String collectionObject2 = ((CollectionsReportClass)object2).getCollectionFDN();
            compare = this.compareString(this.m_sortDirection, collectionObject1, collectionObject2);
        } else if (this.m_sortColumn.equalsIgnoreCase(SORT_OWNER_OBJECT)) {
            String ownerObject1 = ((CollectionsReportClass)object1).getOwnerFDN();
            String ownerObject2 = ((CollectionsReportClass)object2).getOwnerFDN();
            compare = this.compareString(this.m_sortDirection, ownerObject1, ownerObject2);
        } else if (this.m_sortColumn.equalsIgnoreCase(SORT_CREATOR_OBJECT)) {
            String creatorObject1 = ((CollectionsReportClass)object1).getCreatorFDN();
            String creatorObject2 = ((CollectionsReportClass)object2).getCreatorFDN();
            compare = this.compareString(this.m_sortDirection, creatorObject1, creatorObject2);
        } else if (this.m_sortColumn.equalsIgnoreCase(SORT_DATE)) {
            Date date1 = ((CollectionsReportClass)object1).getDate();
            Date date2 = ((CollectionsReportClass)object2).getDate();
            compare = this.compareDate(this.m_sortDirection, date1, date2);
        } else if (this.m_sortColumn.equalsIgnoreCase(SORT_VERSION)) {
            int version1 = ((CollectionsReportClass)object1).getVersion();
            int version2 = ((CollectionsReportClass)object2).getVersion();
            compare = this.compareInt(this.m_sortDirection, version1, version2);
        }
        return compare;
    }

    private int compareString(String sortDirection, String object1, String object2) {
        int compare = 0;
        compare = sortDirection.equals(SORT_DESCENDING) ? this.m_collator.compare(object1, object2) : this.m_collator.compare(object2, object1);
        return compare;
    }

    private int compareDate(String sortDirection, Date date1, Date date2) {
        int compare = 0;
        compare = sortDirection.equals(SORT_DESCENDING) ? date1.compareTo(date2) : date2.compareTo(date1);
        return compare;
    }

    private int compareInt(String sortDirection, int version1, int version2) {
        int compare = 0;
        Integer ver1 = new Integer(version1);
        Integer ver2 = new Integer(version2);
        compare = sortDirection.equals(SORT_DESCENDING) ? ver1.compareTo(ver2) : ver2.compareTo(ver1);
        return compare;
    }
}

