/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.NamespaceException;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.CfgWizConstants;
import com.novell.emframe.fw.CfgWizPanelInfo;
import com.novell.emframe.fw.CfgWizUtil;
import com.novell.emframe.fw.CollectionInfo;
import com.novell.emframe.fw.ConfigWizardInfo;
import com.novell.emframe.fw.DirRoleList;
import com.novell.emframe.fw.FwDirUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.InstallXMLInfo;
import com.novell.emframe.fw.MigrateRoleAssociations;
import com.novell.emframe.fw.MigrateRoleReport;
import com.novell.emframe.fw.RBSUtil;
import com.novell.emframe.fw.util.eMFrameComponentInstall;
import com.novell.emframe.fw.util.iManagerJDOMFactory;
import com.novell.rbs.RBSAssociatedObject;
import com.novell.rbs.RBSCollection;
import com.novell.rbs.RBSModule;
import com.novell.rbs.RBSRole;
import com.novell.rbs.RBSSchemaVerifier;
import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.JDOMFactory;
import org.jdom.input.SAXBuilder;

public class ConfigWizardTask
extends Task {
    private static final long serialVersionUID = 1L;
    private boolean m_opActive = false;
    private Vector m_progressInfo = new Vector();
    private String m_threadFatalError = null;
    private Vector m_vModulesWithErrors = new Vector();
    private boolean m_needsExtendSchema = false;
    private boolean m_needsCreateCollection = false;
    private Vector m_vCollections = new Vector();
    private int m_collectionIndex = 0;
    private ConfigWizardInfo m_cfgWizInfo = null;
    private String m_taskDelegate;
    private boolean m_needToMigrateRoleAssociations = false;
    private boolean m_onlyMigrateRoleAssociations = false;
    private boolean m_showDebug = true;
    private boolean m_rbsInstalledCheckedForRefresh = false;
    private boolean m_firstTime = true;
    private String m_skipToOption = null;
    private boolean m_collectionCreated = false;
    private MigrateRoleReport m_migrateRoleReport = new MigrateRoleReport();
    private String m_collectionOneName;

    @Override
    public boolean execute(TaskContext taskContext, Properties requestProperties) {
        CfgWizPanelInfo pi;
        if (this.m_firstTime) {
            this.m_taskDelegate = taskContext.getRequest().getParameter("RBSAdmin_TaskDelegate");
            if (this.m_taskDelegate != null && this.m_taskDelegate.equals("taskDelegateMigrate")) {
                this.m_collectionOneName = taskContext.getRequest().getParameter("RBSCollectionOneName");
            }
            this.m_firstTime = false;
        }
        if (!this.m_rbsInstalledCheckedForRefresh) {
            this.m_rbsInstalledCheckedForRefresh = false;
            if (!FwUtils.isRBSEnabled(taskContext)) {
                taskContext.setAuthAttribute("fw.ConfigWizard.refresh", "true");
            } else {
                taskContext.setAuthAttribute("fw.ConfigWizard.refresh", "false");
            }
        }
        String mergeFile = null;
        String mergeTag = "merge";
        String panelName = taskContext.getRequest().getParameter("Hidden_PanelID");
        boolean havePanelName = CfgWizUtil.hasString(panelName);
        try {
            pi = CfgWizPanelInfo.buildPanelInfo(taskContext, requestProperties);
        }
        catch (SPIException e) {
            D.log(e);
            CfgWizPanelInfo.setGenErrException(requestProperties, e, taskContext);
            return false;
        }
        pi.clearError();
        String navButton = pi.m_httpRequest.getParameter("Hidden_PBNavigation");
        boolean haveNavButton = CfgWizUtil.hasString(navButton);
        int panelID = CfgWizConstants.panelNameToID(panelName);
        String skipToPage = pi.m_httpRequest.getParameter("skipToOption");
        if (skipToPage != null) {
            this.m_skipToOption = skipToPage;
        }
        if (haveNavButton && navButton.equalsIgnoreCase("WizPB_Back")) {
            switch (panelID) {
                case 8: {
                    mergeFile = "fw.WizClose";
                    break;
                }
                case 3: {
                    mergeFile = this.handleBack_Options(pi, panelName);
                    break;
                }
                case 7: {
                    mergeFile = this.handleBack_Modules(pi);
                    break;
                }
                case 2: {
                    mergeFile = this.handleBack_Progress(pi);
                    break;
                }
                case 4: 
                case 10: 
                case 11: {
                    mergeFile = this.handleBack_Options(pi, panelName);
                }
            }
        } else if (haveNavButton && navButton.equalsIgnoreCase("WizPB_Close")) {
            mergeFile = "fw.WizClose";
        } else {
            switch (panelID) {
                case 0: {
                    mergeFile = this.handlePanel_Empty(pi);
                    break;
                }
                case 8: {
                    mergeFile = this.handlePanel_Schema(pi);
                    break;
                }
                case 9: {
                    mergeFile = this.handlePanel_Options(pi);
                    break;
                }
                case 3: {
                    mergeFile = this.handlePanel_Collection(pi);
                    break;
                }
                case 10: {
                    mergeFile = this.handlePanel_MigrateToNewCollection(pi);
                    break;
                }
                case 11: {
                    mergeFile = this.handlePanel_MigrateToExistingCollection(pi);
                    break;
                }
                case 4: {
                    mergeFile = this.handlePanel_Collections_To_Update(pi);
                    break;
                }
                case 7: {
                    mergeFile = this.handlePanel_Modules(pi);
                    break;
                }
                case 2: {
                    mergeFile = this.handlePanel_Progress(pi, this.m_opActive);
                    break;
                }
                default: {
                    if (havePanelName) break;
                    mergeTag = "Wiz.MergeFile";
                    mergeFile = "fw.WizEmpty";
                }
            }
        }
        if (null == mergeFile && null == (mergeFile = pi.m_httpRequest.getParameter(mergeTag))) {
            pi.setError("CfgWiz.ErrMsg.MissingMergeFile");
            mergeFile = this.setTemplateToCollection(pi);
        }
        if (pi.isTaskClosing(mergeTag, mergeFile, this)) {
            pi.closeTask(this);
        } else {
            pi.writeServletRequest(mergeTag, mergeFile);
        }
        return true;
    }

    private String handlePanel_Empty(CfgWizPanelInfo pi) {
        boolean isSchemaValid = this.isSchemaValid(pi);
        String merge = "fw.CfgWizOptions";
        if (!isSchemaValid) {
            this.m_needsExtendSchema = true;
            merge = "fw.CfgWizSchema";
        } else {
            this.setOwnedCollectionTypes(pi);
            pi.m_requestProperties.put("Hidden_RadioButtonNumber", "0");
        }
        if (this.m_taskDelegate != null && this.m_taskDelegate.equals("taskDelegate")) {
            pi.m_requestProperties.put("Hidden_RBSAdmin_TaskDelegate", this.m_taskDelegate);
            if (!isSchemaValid) {
                return merge;
            }
            return this.setTemplateToCollection(pi);
        }
        if (this.m_taskDelegate != null && this.m_taskDelegate.equals("taskDelegateMigrate")) {
            this.m_onlyMigrateRoleAssociations = true;
            pi.m_requestProperties.put("Hidden_CollectionOne_Name", this.m_collectionOneName);
            pi.m_requestProperties.put("Hidden_RBSAdmin_TaskDelegate", this.m_taskDelegate);
            return "fw.CfgWizMigrateToExistingCollection";
        }
        if (this.m_skipToOption == null) {
            return merge;
        }
        return this.handlePanel_Options(pi);
    }

    private void setOwnedCollectionTypes(CfgWizPanelInfo pi) {
        boolean oneCollOwner = false;
        boolean twoCollOwner = false;
        try {
            RBSAssociatedObject rbsAssociatedObject = new RBSAssociatedObject(pi.m_userOE);
            if (rbsAssociatedObject.getOwnedCollections() != null) {
                oneCollOwner = true;
            }
            if (rbsAssociatedObject.getAllOwnedCollections2() != null) {
                twoCollOwner = true;
            }
        }
        catch (Exception ex) {
            D.log(ex);
            this.showDebugInfo("rbsAssociatedObject.getOwnedCollections returns error (" + ex.toString() + ")");
        }
        Boolean oneCollOwnerB = new Boolean(oneCollOwner);
        Boolean twoCollOwnerB = new Boolean(twoCollOwner);
        Boolean bothCollOwnerB = null;
        bothCollOwnerB = oneCollOwner && twoCollOwner ? new Boolean(true) : new Boolean(false);
        pi.m_requestProperties.put("CfgWiz.Option.Selection.2", oneCollOwnerB.toString());
        pi.m_requestProperties.put("CfgWiz.Option.Selection.3", bothCollOwnerB.toString());
        pi.m_requestProperties.put("CfgWiz.Option.Selection.4", twoCollOwnerB.toString());
    }

    private String handlePanel_Schema(CfgWizPanelInfo pi) {
        if (this.m_needsExtendSchema) {
            this.showDebugInfo("Calling rbsVerifier.extendSchema()");
            try {
                RBSSchemaVerifier rbsVerifier = new RBSSchemaVerifier(pi.m_treeOE);
                rbsVerifier.extendSchema();
            }
            catch (Exception exc) {
                D.log(exc);
                this.showDebugInfo("rbsVerifier.extendSchema() returns error (" + exc.toString() + ")");
                pi.setErrorMsg(exc.toString());
                return "fw.CfgWizSchema";
            }
            this.showDebugInfo("Returned from rbsVerifier.extendSchema() OK");
        }
        this.setOwnedCollectionTypes(pi);
        pi.m_requestProperties.put("Hidden_RadioButtonNumber", "0");
        if (this.m_taskDelegate != null && this.m_taskDelegate.equals("taskDelegate")) {
            return this.setTemplateToCollection(pi);
        }
        return "fw.CfgWizOptions";
    }

    private String handlePanel_Options(CfgWizPanelInfo pi) {
        ConfigWizardInfo configWizardInfo;
        String optionSelected = null;
        this.m_needToMigrateRoleAssociations = false;
        this.m_onlyMigrateRoleAssociations = false;
        this.m_needsCreateCollection = false;
        optionSelected = this.m_skipToOption != null ? this.m_skipToOption : pi.m_httpRequest.getParameter("OptionSelected");
        if (optionSelected.equalsIgnoreCase("selectionFour")) {
            ConfigWizardInfo configWizardInfo2;
            try {
                configWizardInfo2 = this.getAllOwnedCollectionInformation(pi);
            }
            catch (Exception ex) {
                D.log(ex);
                pi.setErrorMsg(ex.toString());
                return "fw.CfgWizErr";
            }
            this.m_vCollections.clear();
            pi.m_taskContext.setAuthAttribute("configWizardInfo", configWizardInfo2);
            this.getSessionCacheVars(pi);
            this.passCollectionInfo(pi);
            pi.m_requestProperties.put("Hidden_RadioButtonNumber", "3");
            CollectionInfo[] ci = configWizardInfo2.getAllCollectionInfo();
            if (ci == null || ci.length == 0) {
                return "fw.CfgWizNothingToDo";
            }
            return "fw.CfgWizCollectionsToUpdate";
        }
        if (optionSelected.equalsIgnoreCase("selectionThree")) {
            this.m_onlyMigrateRoleAssociations = true;
            pi.m_requestProperties.put("Hidden_RadioButtonNumber", "2");
            return "fw.CfgWizMigrateToExistingCollection";
        }
        try {
            configWizardInfo = this.getAllAvailableModulesForNewCollection(pi.m_taskContext, pi.m_ndsNS);
        }
        catch (Exception ex) {
            D.log(ex);
            pi.setErrorMsg(ex.toString());
            return "fw.CfgWizErr";
        }
        pi.m_taskContext.setAuthAttribute("configWizardInfo", configWizardInfo);
        this.m_needsCreateCollection = true;
        if (optionSelected.equalsIgnoreCase("selectionTwo")) {
            this.m_needToMigrateRoleAssociations = true;
            pi.m_requestProperties.put("Hidden_RadioButtonNumber", "1");
            return "fw.CfgWizMigrateToNewCollection";
        }
        pi.m_requestProperties.put("Hidden_RadioButtonNumber", "0");
        return this.setTemplateToCollection(pi);
    }

    private String handlePanel_Collection(CfgWizPanelInfo pi) {
        if (this.m_taskDelegate != null && this.m_taskDelegate.equals("taskDelegate")) {
            this.m_needsCreateCollection = true;
        }
        String colCxt = pi.m_httpRequest.getParameter("Hidden_CollectionContext");
        String colName = pi.m_httpRequest.getParameter("Hidden_CollectionName");
        boolean isLDAP = pi.m_ndsNS.getUniqueID().equalsIgnoreCase("LDAP");
        if (isLDAP) {
            colName = RBSUtil.formatLDAPString(colName);
        }
        if (!CfgWizUtil.hasString(colCxt)) {
            pi.setErrorMsg(eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.Collection.MissingCxt", pi.m_taskContext));
            return this.setTemplateToCollection(pi);
        }
        try {
            ObjectEntry col = pi.m_ndsNS.getObjectEntry(colCxt);
            pi.m_taskContext.addToHistory(col);
        }
        catch (Exception e) {
            D.log(e);
            Object[] args = new Object[]{colCxt};
            pi.setErrorMsg(MessageFormat.format(eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.Error.ContextInvalid", pi.m_taskContext), args));
            return this.setTemplateToCollection(pi);
        }
        if (!CfgWizUtil.hasString(colName)) {
            pi.setErrorMsg(eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.Collection.MissingName", pi.m_taskContext));
            return this.setTemplateToCollection(pi);
        }
        boolean doesExist = false;
        try {
            doesExist = pi.m_ndsNS.doesExist(pi.m_treeOE, RBSUtil.concatStr(pi.m_ndsNS, colName, colCxt));
        }
        catch (Exception e) {
            D.log(e);
            Object[] args = new Object[]{colCxt};
            pi.setErrorMsg(MessageFormat.format(eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.Error.ContextInvalid", pi.m_taskContext), args));
            return this.setTemplateToCollection(pi);
        }
        if (doesExist) {
            Object[] args = new Object[]{RBSUtil.concatStr(pi.m_ndsNS, colName, colCxt)};
            pi.setErrorMsg(MessageFormat.format(eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.Error.CollectionExist", pi.m_taskContext), args));
            return this.setTemplateToCollection(pi);
        }
        this.getSessionCacheVars(pi);
        this.m_collectionIndex = 0;
        if (this.m_cfgWizInfo == null) {
            ConfigWizardInfo configWizardInfo;
            try {
                configWizardInfo = this.getAllAvailableModulesForNewCollection(pi.m_taskContext, pi.m_ndsNS);
            }
            catch (Exception ex) {
                D.log(ex);
                pi.setErrorMsg(ex.toString());
                return "fw.CfgWizErr";
            }
            pi.m_taskContext.setAuthAttribute("configWizardInfo", configWizardInfo);
            this.m_cfgWizInfo = (ConfigWizardInfo)pi.m_taskContext.getAuthAttribute("configWizardInfo");
            this.m_needsCreateCollection = true;
        }
        this.m_vCollections.clear();
        CollectionInfo[] ci = this.m_cfgWizInfo.getAllCollectionInfo();
        if (ci != null && ci.length > 0) {
            this.m_vCollections.addElement(new CfgWizCollectionInfo(pi.m_taskContext, RBSUtil.concatStr(pi.m_ndsNS, colName, colCxt), ci[0].getAllInstallXMLInfoInstalls(), ci[0].getAllInstallXMLInfoUpgrades(), true));
        } else {
            this.m_vCollections.addElement(new CfgWizCollectionInfo(pi.m_taskContext, RBSUtil.concatStr(pi.m_ndsNS, colName, colCxt), null, null, true));
        }
        try {
            this.passModuleInfoForCollection(pi, (CfgWizCollectionInfo)this.m_vCollections.elementAt(0));
        }
        catch (Exception e) {
            D.log(e);
            pi.setErrorMsg(e.toString());
            return this.setTemplateToCollection(pi);
        }
        return "fw.CfgWizModules";
    }

    private String handlePanel_MigrateToExistingCollection(CfgWizPanelInfo pi) {
        String colOneName = pi.m_httpRequest.getParameter("Hidden_CollectionOne_Name");
        String colTwoName = pi.m_httpRequest.getParameter("Hidden_CollectionTwo_Name");
        try {
            pi.m_ndsNS.getObjectEntry(colOneName);
        }
        catch (Exception e) {
            D.log(e);
            Object[] args = new Object[]{colOneName};
            pi.setErrorMsg(MessageFormat.format(eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.Error.ContextOneInvalid", pi.m_taskContext), args));
            return "fw.CfgWizMigrateToExistingCollection";
        }
        try {
            pi.m_ndsNS.getObjectEntry(colTwoName);
        }
        catch (Exception e) {
            D.log(e);
            Object[] args = new Object[]{colTwoName};
            pi.setErrorMsg(MessageFormat.format(eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.Error.ContextTwoInvalid", pi.m_taskContext), args));
            return "fw.CfgWizMigrateToExistingCollection";
        }
        this.kickOffUpdate(pi);
        return this.handlePanel_Progress(pi, this.m_opActive);
    }

    private String handlePanel_MigrateToNewCollection(CfgWizPanelInfo pi) {
        String colOneName = pi.m_httpRequest.getParameter("Hidden_CollectionOne_Name");
        String colCxt = pi.m_httpRequest.getParameter("Hidden_CollectionContext");
        String colName = pi.m_httpRequest.getParameter("Hidden_CollectionName");
        boolean isLDAP = pi.m_ndsNS.getUniqueID().equalsIgnoreCase("LDAP");
        if (isLDAP) {
            colName = RBSUtil.formatLDAPString(colName);
        }
        if (!CfgWizUtil.hasString(colCxt)) {
            pi.setErrorMsg(eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.Collection.MissingCxt", pi.m_taskContext));
            return "fw.CfgWizMigrateToNewCollection";
        }
        try {
            pi.m_ndsNS.getObjectEntry(colOneName);
        }
        catch (Exception e) {
            D.log(e);
            Object[] args = new Object[]{colOneName};
            pi.setErrorMsg(MessageFormat.format(eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.Error.ContextOneInvalid", pi.m_taskContext), args));
            return "fw.CfgWizMigrateToNewCollection";
        }
        try {
            pi.m_ndsNS.getObjectEntry(colCxt);
        }
        catch (Exception e) {
            D.log(e);
            Object[] args = new Object[]{colCxt};
            pi.setErrorMsg(MessageFormat.format(eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.Error.ContextInvalid", pi.m_taskContext), args));
            return "fw.CfgWizMigrateToNewCollection";
        }
        if (!CfgWizUtil.hasString(colName)) {
            pi.setErrorMsg(eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.Collection.MissingName", pi.m_taskContext));
            return "fw.CfgWizMigrateToNewCollection";
        }
        boolean doesExist = false;
        try {
            doesExist = pi.m_ndsNS.doesExist(pi.m_treeOE, RBSUtil.concatStr(pi.m_ndsNS, colName, colCxt));
        }
        catch (Exception e) {
            D.log(e);
            Object[] args = new Object[]{colCxt};
            pi.setErrorMsg(MessageFormat.format(eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.Error.ContextInvalid", pi.m_taskContext), args));
            return "fw.CfgWizMigrateToNewCollection";
        }
        if (doesExist) {
            Object[] args = new Object[]{RBSUtil.concatStr(pi.m_ndsNS, colName, colCxt)};
            pi.setErrorMsg(MessageFormat.format(eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.Error.CollectionExist", pi.m_taskContext), args));
            return "fw.CfgWizMigrateToNewCollection";
        }
        this.getSessionCacheVars(pi);
        this.m_collectionIndex = 0;
        CollectionInfo ci = this.m_cfgWizInfo.getAllCollectionInfo()[0];
        this.m_vCollections.clear();
        this.m_vCollections.addElement(new CfgWizCollectionInfo(pi.m_taskContext, RBSUtil.concatStr(pi.m_ndsNS, colName, colCxt), ci.getAllInstallXMLInfoInstalls(), ci.getAllInstallXMLInfoUpgrades(), true));
        try {
            this.passModuleInfoForCollection(pi, (CfgWizCollectionInfo)this.m_vCollections.elementAt(0));
        }
        catch (Exception e) {
            D.log(e);
            pi.setErrorMsg(e.toString());
            return "fw.CfgWizMigrateToNewCollection";
        }
        return "fw.CfgWizModules";
    }

    private String handlePanel_Modules(CfgWizPanelInfo pi) {
        CfgWizCollectionInfo ci = (CfgWizCollectionInfo)this.m_vCollections.elementAt(this.m_collectionIndex);
        if (!this.saveModuleSettings(pi, ci, true)) {
            try {
                this.passModuleInfoForCollection(pi, ci);
            }
            catch (Exception e) {
                D.log(e);
                pi.setErrorMsg(e.toString());
            }
            return "fw.CfgWizModules";
        }
        CfgWizCollectionInfo ciNext = this.getNextSelectedCollection(this.m_collectionIndex);
        if (ciNext != null) {
            try {
                this.passModuleInfoForCollection(pi, ciNext);
            }
            catch (Exception e) {
                D.log(e);
                pi.setErrorMsg(e.toString());
            }
            return "fw.CfgWizModules";
        }
        this.kickOffUpdate(pi);
        return this.handlePanel_Progress(pi, this.m_opActive);
    }

    private String handleBack_Options(CfgWizPanelInfo pi, String currentTemplate) {
        pi.m_requestProperties.put("Hidden_CollectionContext", "");
        pi.m_requestProperties.put("Hidden_CollectionName", "");
        pi.m_requestProperties.put("Hidden_CollectionOne_Name", "");
        pi.m_requestProperties.put("Hidden_CollectionTwo_Name", "");
        this.m_needToMigrateRoleAssociations = false;
        this.m_onlyMigrateRoleAssociations = false;
        this.m_needsCreateCollection = false;
        this.setOwnedCollectionTypes(pi);
        if (this.m_skipToOption != null) {
            return currentTemplate;
        }
        return "fw.CfgWizOptions";
    }

    private String handleBack_Modules(CfgWizPanelInfo pi) {
        CfgWizCollectionInfo ci = (CfgWizCollectionInfo)this.m_vCollections.elementAt(this.m_collectionIndex);
        this.saveModuleSettings(pi, ci, false);
        CfgWizCollectionInfo ciPrev = this.getPreviousSelectedCollection(this.m_collectionIndex);
        if (ciPrev != null) {
            try {
                this.passModuleInfoForCollection(pi, ciPrev);
            }
            catch (Exception e) {
                D.log(e);
                pi.setErrorMsg(e.toString());
            }
            return "fw.CfgWizModules";
        }
        if (this.m_needToMigrateRoleAssociations) {
            return "fw.CfgWizMigrateToNewCollection";
        }
        if (this.m_onlyMigrateRoleAssociations) {
            return "fw.CfgWizMigrateToExistingCollection";
        }
        if (this.m_needsCreateCollection) {
            return this.setTemplateToCollection(pi);
        }
        this.passCollectionInfo(pi);
        return "fw.CfgWizCollectionsToUpdate";
    }

    private String handlePanel_Collections_To_Update(CfgWizPanelInfo pi) {
        String packedCollections = pi.m_httpRequest.getParameter("SelectedCollectionsToUpdate");
        if (CfgWizUtil.hasString(packedCollections)) {
            String[] selectedCollectionIndexes = eMFrameUtils.unpack(packedCollections, pi.m_taskContext);
            for (int x = 0; x < this.m_vCollections.size(); ++x) {
                boolean bFoundMatch = false;
                for (int i = 0; i < selectedCollectionIndexes.length; ++i) {
                    int index = new Integer(selectedCollectionIndexes[i]);
                    if (index != x) continue;
                    bFoundMatch = true;
                    break;
                }
                ((CfgWizCollectionInfo)this.m_vCollections.elementAt((int)x)).m_collectionSelected = bFoundMatch;
            }
        }
        CfgWizCollectionInfo ci = this.getNextSelectedCollection(-1);
        try {
            this.passModuleInfoForCollection(pi, ci);
        }
        catch (Exception e) {
            D.log(e);
            pi.setErrorMsg(e.toString());
            return "fw.CfgWizCollectionsToUpdate";
        }
        return "fw.CfgWizModules";
    }

    private String handleBack_Progress(CfgWizPanelInfo pi) {
        this.m_threadFatalError = null;
        try {
            CfgWizCollectionInfo ci = (CfgWizCollectionInfo)this.m_vCollections.elementAt(this.m_collectionIndex);
            this.passModuleInfoForCollection(pi, ci);
        }
        catch (Exception e) {
            D.log(e);
            pi.setErrorMsg(e.toString());
            return "fw.WizProgress";
        }
        return "fw.CfgWizModules";
    }

    private String handlePanel_Progress(CfgWizPanelInfo pi, boolean opActive) {
        int numMsgs;
        if (!this.m_opActive && this.m_collectionCreated) {
            RBSUtil.setRBSInstalledGlobalFlag(pi.m_taskContext, pi.m_treeOE.getName());
            RBSUtil.setTreeNameInConfig(pi.m_taskContext, pi.m_treeOE.getName());
            DirRoleList roleList = RBSUtil.getDirRoleList(pi.m_taskContext);
            roleList.setCollectionOwner(true);
            FwDirUtils.updateAccessMode(pi.m_taskContext);
        }
        int n = numMsgs = null == this.m_progressInfo ? 0 : this.m_progressInfo.size();
        if (0 == numMsgs) {
            numMsgs = 1;
            pi.m_requestProperties.put("CfgWiz.Response.0", eMFrameUtils.getLocalizedString("FwResources", this.m_opActive ? "CfgWiz.OP_ACTIVE" : "CfgWiz.OP_SUCCESS", pi.m_taskContext));
        } else {
            for (int i = 0; i < numMsgs; ++i) {
                pi.m_requestProperties.put("CfgWiz.Response." + new Integer(i).toString(), (String)this.m_progressInfo.elementAt(i));
            }
        }
        if (this.m_threadFatalError != null) {
            pi.setErrorMsg(this.m_threadFatalError);
        }
        pi.m_requestProperties.put("Operation.Active", opActive ? "true" : "false");
        String timeout = pi.m_httpRequest.getParameter("Hidden_UpdateInterval");
        if (CfgWizUtil.hasString(timeout)) {
            pi.m_requestProperties.put("CfgWiz.UpdateInterval", timeout);
        }
        if (!opActive && this.m_vModulesWithErrors.size() > 0) {
            String errorList = "";
            for (int i = 0; i < this.m_vModulesWithErrors.size(); ++i) {
                errorList = errorList + "\n\t";
                errorList = errorList + (String)this.m_vModulesWithErrors.elementAt(i);
            }
            pi.setError("CfgWiz.Error.ModuleUpdateFailedPartialSpecifics", errorList);
            this.m_vModulesWithErrors.removeAllElements();
        }
        pi.m_requestProperties.put("CfgWiz.Response.Count", new Integer(numMsgs).toString());
        return "fw.WizProgress";
    }

    private int getSelectedCollectionCount() {
        int selectedCount = 0;
        for (int i = 0; i < this.m_vCollections.size(); ++i) {
            CfgWizCollectionInfo ci = (CfgWizCollectionInfo)this.m_vCollections.elementAt(i);
            if (!ci.m_collectionSelected) continue;
            ++selectedCount;
        }
        return selectedCount;
    }

    private int getXofTotalSelectedCollection(CfgWizCollectionInfo ci) {
        int i;
        CfgWizCollectionInfo[] sel = new CfgWizCollectionInfo[this.getSelectedCollectionCount()];
        int index = 0;
        for (i = 0; i < this.m_vCollections.size(); ++i) {
            CfgWizCollectionInfo cur = (CfgWizCollectionInfo)this.m_vCollections.elementAt(i);
            if (!cur.m_collectionSelected) continue;
            sel[index++] = cur;
        }
        for (i = 0; i < sel.length; ++i) {
            if (ci != sel[i]) continue;
            return i + 1;
        }
        return -1;
    }

    private String getPackedSelectedCollectionIndexes(CfgWizPanelInfo pi) {
        String[] selIndexes = new String[this.getSelectedCollectionCount()];
        int index = 0;
        for (int i = 0; i < this.m_vCollections.size(); ++i) {
            CfgWizCollectionInfo ci = (CfgWizCollectionInfo)this.m_vCollections.elementAt(i);
            if (!ci.m_collectionSelected) continue;
            selIndexes[index++] = new Integer(i).toString();
        }
        return eMFrameUtils.pack(selIndexes, pi.m_taskContext);
    }

    private CfgWizCollectionInfo getNextSelectedCollection(int curIndex) {
        CfgWizCollectionInfo next = null;
        for (int i = curIndex + 1; i < this.m_vCollections.size(); ++i) {
            CfgWizCollectionInfo ci = (CfgWizCollectionInfo)this.m_vCollections.elementAt(i);
            if (!ci.m_collectionSelected) continue;
            next = ci;
            this.m_collectionIndex = i;
            break;
        }
        return next;
    }

    private CfgWizCollectionInfo getPreviousSelectedCollection(int curIndex) {
        CfgWizCollectionInfo prev = null;
        for (int i = curIndex - 1; i >= 0; --i) {
            CfgWizCollectionInfo ci = (CfgWizCollectionInfo)this.m_vCollections.elementAt(i);
            if (!ci.m_collectionSelected) continue;
            prev = ci;
            this.m_collectionIndex = i;
            break;
        }
        return prev;
    }

    private boolean saveModuleSettings(CfgWizPanelInfo pi, CfgWizCollectionInfo ci, boolean bGoingForward) {
        String packedModules;
        boolean retVal = true;
        if (null == ci) {
            return true;
        }
        String assignRights = pi.m_httpRequest.getParameter("DoAssignRights");
        if (CfgWizUtil.hasString(assignRights)) {
            ci.m_assignRights = assignRights.equals("true");
        }
        if (CfgWizUtil.hasString(packedModules = pi.m_httpRequest.getParameter("SelectedModulesToInstall"))) {
            String[] moduleIndexesToInstall = eMFrameUtils.unpack(packedModules, pi.m_taskContext);
            int[] iIndexes = new int[moduleIndexesToInstall.length];
            for (int i = 0; i < moduleIndexesToInstall.length; ++i) {
                iIndexes[i] = new Integer(moduleIndexesToInstall[i]);
            }
            ci.m_selectedInstallIndexes = iIndexes;
        }
        String scope = pi.m_httpRequest.getParameter("Scope");
        String scopeInherited = pi.m_httpRequest.getParameter("ScopeIsInherited");
        boolean bScopeInherited = false;
        if (CfgWizUtil.hasString(scope)) {
            if (bGoingForward) {
                try {
                    if (scope.equalsIgnoreCase("[root]")) {
                        pi.m_ndsNS.getObjectEntry(pi.m_treeOE.getName());
                    } else {
                        ObjectEntry scopeOE = pi.m_ndsNS.getObjectEntry(scope);
                        pi.m_taskContext.addToHistory(scopeOE);
                    }
                }
                catch (Exception e) {
                    D.log(e);
                    Object[] args = new Object[]{scope};
                    pi.setErrorMsg(MessageFormat.format(eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.ErrMsg.InvalidScope", pi.m_taskContext), args));
                    retVal = false;
                }
            }
            if (CfgWizUtil.hasString(scopeInherited)) {
                bScopeInherited = scopeInherited.equals("true");
            }
            ci.m_scope = scope;
            ci.m_scopeInherited = bScopeInherited;
        } else {
            ci.m_scope = null;
            ci.m_scopeInherited = true;
        }
        return retVal;
    }

    private void kickOffUpdate(CfgWizPanelInfo pi) {
        this.m_threadFatalError = null;
        this.m_progressInfo.removeAllElements();
        this.m_opActive = true;
        ProgressThread progThread = new ProgressThread(pi);
        progThread.start();
    }

    public void getSessionCacheVars(CfgWizPanelInfo pi) {
        this.m_cfgWizInfo = (ConfigWizardInfo)pi.m_taskContext.getAuthAttribute("configWizardInfo");
        Vector vCollections = null;
        if (null != this.m_cfgWizInfo && null != (vCollections = this.m_cfgWizInfo.getAllCollectionInfoVector())) {
            for (int i = 0; i < vCollections.size(); ++i) {
                CollectionInfo ci = (CollectionInfo)vCollections.elementAt(i);
                this.m_vCollections.addElement(new CfgWizCollectionInfo(pi.m_taskContext, ci.getCollectionName(), ci.getAllInstallXMLInfoInstalls(), ci.getAllInstallXMLInfoUpgrades(), true));
            }
        }
    }

    private void passCollectionInfo(CfgWizPanelInfo pi) {
        for (int i = 0; i < this.m_vCollections.size(); ++i) {
            CfgWizCollectionInfo ci = (CfgWizCollectionInfo)this.m_vCollections.elementAt(i);
            pi.m_requestProperties.put("CfgWiz.Collection." + new Integer(i).toString(), ci.m_collectionName);
        }
        pi.m_requestProperties.put("CfgWiz.Collection.Count", new Integer(this.m_vCollections.size()).toString());
        pi.m_requestProperties.put("CfgWiz.SelectedCollectionsToUpdate", this.getPackedSelectedCollectionIndexes(pi));
    }

    private void passModuleInfoForCollection(CfgWizPanelInfo pi, CfgWizCollectionInfo ci) throws Exception {
        if (ci == null) {
            return;
        }
        try {
            String msg = eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.Modules.CollectionType", pi.m_taskContext);
            int xOfTotal = this.getXofTotalSelectedCollection(ci);
            int totalSelectedCollections = this.getSelectedCollectionCount();
            Object[] args = new Object[]{new Integer(xOfTotal).toString(), new Integer(totalSelectedCollections).toString()};
            pi.m_requestProperties.put("CfgWiz.CollectionXofY", MessageFormat.format(msg, args));
            pi.m_requestProperties.put("CfgWiz.CurrentCollection.Name", ci.m_collectionName);
            if (xOfTotal == totalSelectedCollections) {
                pi.m_requestProperties.put("CfgWiz.LastCollection", "true");
            }
            InstallXMLInfo[] xmlFilesToUpdateForCollection = ci.m_xmlUpdates;
            for (int j = 0; j < xmlFilesToUpdateForCollection.length; ++j) {
                pi.m_requestProperties.put("CfgWiz.ModulesToUpdate." + new Integer(j).toString(), xmlFilesToUpdateForCollection[j].getDisplayName());
            }
            pi.m_requestProperties.put("CfgWiz.ModulesToUpdate.Count", new Integer(xmlFilesToUpdateForCollection.length).toString());
            InstallXMLInfo[] xmlFilesToInstallForCollection = ci.m_xmlInstalls;
            for (int j = 0; j < xmlFilesToInstallForCollection.length; ++j) {
                pi.m_requestProperties.put("CfgWiz.ModulesToInstall." + new Integer(j).toString(), xmlFilesToInstallForCollection[j].getDisplayName());
            }
            pi.m_requestProperties.put("CfgWiz.ModulesToInstall.Count", new Integer(xmlFilesToInstallForCollection.length).toString());
            pi.m_requestProperties.put("CfgWiz.SelectedInstallModules", ci.getPackedSelectedInstallFiles(pi.m_taskContext));
            pi.m_requestProperties.put("CfgWiz.InstallModulesScope", null == ci.m_scope ? "" : ci.m_scope);
            pi.m_requestProperties.put("CfgWiz.InstallModulesScopeInherited", ci.m_scopeInherited ? "true" : "false");
            pi.m_requestProperties.put("CfgWiz.InstallModulesAssignRights", ci.m_assignRights ? "true" : "false");
        }
        catch (Exception e) {
            D.log(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdate(CfgWizPanelInfo pi) throws Exception {
        this.m_threadFatalError = null;
        String dynamicGroupSearchType = FwUtils.getDynamicSearchType(pi.m_taskContext);
        if (this.m_onlyMigrateRoleAssociations) {
            String colOneName = pi.m_httpRequest.getParameter("Hidden_CollectionOne_Name");
            String colTwoName = pi.m_httpRequest.getParameter("Hidden_CollectionTwo_Name");
            this.m_progressInfo.addElement(eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.Operation.MigratingRoleAssoications", pi.m_taskContext));
            this.showDebugInfo("Calling MigrateRoleAssociations.migrateRoleAssociations)");
            MigrateRoleAssociations mra = new MigrateRoleAssociations(pi.m_treeOE, pi.m_taskContext, this.m_migrateRoleReport);
            try {
                String[] tasks;
                mra.migrateRoleAssociations(colOneName, colTwoName, dynamicGroupSearchType);
                this.showDebugInfo("Returning from MigrateRoleAssociations.migrateRoleAssociations)");
                String[] pages = this.m_migrateRoleReport.getPages();
                if (pages != null) {
                    this.m_progressInfo.addElement(eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.Operation.MigratingMissingPages", pi.m_taskContext));
                    for (int i = 0; i < pages.length; ++i) {
                        this.m_progressInfo.addElement("     " + pages[i]);
                        this.showDebugInfo("Missing page: " + pages[i]);
                    }
                }
                if ((tasks = this.m_migrateRoleReport.getTasks()) != null) {
                    this.m_progressInfo.addElement(eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.Operation.MigratingMissingTasks", pi.m_taskContext));
                    for (int i = 0; i < tasks.length; ++i) {
                        this.m_progressInfo.addElement("     " + tasks[i]);
                        this.showDebugInfo("Missing task: " + tasks[i]);
                    }
                }
            }
            catch (Exception ex) {
                D.log(ex);
            }
            return;
        }
        eMFrameComponentInstall installer = new eMFrameComponentInstall(pi.m_rootOE, pi.m_taskContext);
        String colCxt = pi.m_httpRequest.getParameter("Hidden_CollectionContext");
        String colName = pi.m_httpRequest.getParameter("Hidden_CollectionName");
        boolean isLDAP = pi.m_ndsNS.getUniqueID().equalsIgnoreCase("LDAP");
        if (isLDAP) {
            colName = RBSUtil.formatLDAPString(colName);
        }
        if (this.m_needsCreateCollection) {
            if (!CfgWizUtil.hasString(colCxt)) {
                throw new Exception(eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.Collection.MissingCxt", pi.m_taskContext));
            }
            if (!CfgWizUtil.hasString(colName)) {
                throw new Exception(eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.Collection.MissingName", pi.m_taskContext));
            }
            String msg = eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.Operation.CreatingCollection", pi.m_taskContext);
            Object[] args = new Object[]{colName};
            this.m_progressInfo.addElement(MessageFormat.format(msg, args));
            if (!RBSUtil.preCheckCreateCollection(pi.m_taskContext, pi.m_requestProperties, pi.m_treeOE, colCxt, colName)) {
                String msgBody = pi.m_requestProperties.getProperty("GeneralMsg.MsgBody");
                throw new Exception(msgBody);
            }
            this.showDebugInfo("Calling eMFrameComponentInstall.createRBSCollection(" + colCxt + colName + ")");
            try {
                installer.createRBSCollection(colCxt, colName, eMFrameUtils.getLocalizedString("com.novell.emframe.version", "version", pi.m_taskContext));
                this.m_collectionCreated = true;
            }
            catch (Exception exc) {
                D.log(exc);
                this.showDebugInfo("eMFrameComponentInstall.createRBSCollection(" + colCxt + colName + ") returns error (" + exc.toString() + ")");
                throw new Exception(exc);
            }
            this.showDebugInfo("Returned from eMFrameComponentInstall.createRBSCollection(" + colCxt + colName + ") OK");
        }
        this.m_collectionIndex = -1;
        CfgWizCollectionInfo ci = null;
        while (null != (ci = this.getNextSelectedCollection(this.m_collectionIndex))) {
            String collectionName = ci.m_collectionName;
            RBSRole[] beforeRoles = this.takeRolesSnapshot(pi, collectionName);
            if (ci.m_xmlUpdates.length > 0 || ci.m_selectedInstallIndexes.length > 0) {
                String collectionProgress = eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.Operation.UpdatingCollection", pi.m_taskContext);
                Object[] args = new Object[]{collectionName};
                this.m_progressInfo.addElement(MessageFormat.format(collectionProgress, args));
            }
            String modProgress = eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.ModUpdate.UpdatingModule", pi.m_taskContext);
            for (int j = 0; j < ci.m_xmlUpdates.length; ++j) {
                Object[] args;
                String moduleName = null;
                try {
                    moduleName = ci.m_xmlUpdates[j].getDisplayName();
                    String[] xmlFiles = ci.m_xmlUpdates[j].getFilePaths();
                    Document doc = ci.m_xmlUpdates[j].getDocument();
                    args = new Object[]{moduleName};
                    this.m_progressInfo.addElement(MessageFormat.format(modProgress, args));
                    this.showDebugInfo("Calling eMFrameComponentInstall.installPlugin(" + collectionName + "," + moduleName + ") for update");
                    try {
                        installer.installPlugin(collectionName, xmlFiles, doc, dynamicGroupSearchType);
                    }
                    catch (Exception exc) {
                        D.log(exc);
                        this.showDebugInfo("eMFrameComponentInstall.installPlugin(" + collectionName + "," + moduleName + ") for update returns error (" + exc.toString() + ")");
                        throw new Exception(exc);
                    }
                    this.showDebugInfo("Returning from eMFrameComponentInstall.installPlugin(" + collectionName + "," + moduleName + ") for update");
                    continue;
                }
                catch (Exception e) {
                    D.log(e);
                    String msg = eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.Error.ModuleUpdateEncountered", pi.m_taskContext);
                    this.m_vModulesWithErrors.addElement(moduleName);
                    args = new Object[]{moduleName, e.toString()};
                    this.m_progressInfo.addElement(MessageFormat.format(msg, args));
                }
            }
            InstallXMLInfo[] xmlFilesToInstall = ci.m_xmlInstalls;
            modProgress = eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.ModUpdate.InstallingModule", pi.m_taskContext);
            for (int j = 0; j < ci.m_selectedInstallIndexes.length; ++j) {
                Object[] args;
                String moduleName = null;
                try {
                    moduleName = xmlFilesToInstall[ci.m_selectedInstallIndexes[j]].getDisplayName();
                    String[] xmlFiles = xmlFilesToInstall[ci.m_selectedInstallIndexes[j]].getFilePaths();
                    Document doc = xmlFilesToInstall[ci.m_selectedInstallIndexes[j]].getDocument();
                    args = new Object[]{moduleName};
                    this.m_progressInfo.addElement(MessageFormat.format(modProgress, args));
                    this.showDebugInfo("Calling eMFrameComponentInstall.installPlugin(" + collectionName + "," + moduleName + ")");
                    try {
                        installer.installPlugin(collectionName, xmlFiles, doc, dynamicGroupSearchType);
                    }
                    catch (Exception exc) {
                        D.log(exc);
                        this.showDebugInfo("eMFrameComponentInstall.installPlugin(" + collectionName + "," + moduleName + ") returns error (" + exc.toString() + ")");
                        throw new Exception(exc);
                    }
                    this.showDebugInfo("Returned from eMFrameComponentInstall.installPlugin(" + collectionName + "," + moduleName + ") OK");
                    continue;
                }
                catch (Exception e) {
                    D.log(e);
                    String msg = eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.Error.ModuleUpdateEncountered", pi.m_taskContext);
                    this.m_vModulesWithErrors.addElement(moduleName);
                    args = new Object[]{moduleName, e.toString()};
                    this.m_progressInfo.addElement(MessageFormat.format(msg, args));
                }
            }
            if (ci.m_selectedInstallIndexes.length > 0) {
                RBSRole[] afterRoles = this.takeRolesSnapshot(pi, collectionName);
                RBSRole[] addedRoles = this.compareRolesSnapshots(beforeRoles, afterRoles);
                boolean bDoRoleAssignments = false;
                if (null != addedRoles) {
                    boolean bAssociateMember = CfgWizUtil.hasString(ci.m_scope);
                    ObjectEntry scopeOE = null;
                    if (bAssociateMember) {
                        bDoRoleAssignments = true;
                        try {
                            scopeOE = ci.m_scope.equalsIgnoreCase("[root]") ? pi.m_ndsNS.getObjectEntry(pi.m_treeOE.getName()) : pi.m_ndsNS.getObjectEntry(ci.m_scope);
                        }
                        catch (Exception e) {
                            D.log(e);
                            Object[] args = new Object[]{ci.m_scope};
                            throw new Exception(MessageFormat.format(eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.ErrMsg.InvalidScope", pi.m_taskContext), args));
                        }
                        this.m_progressInfo.addElement(eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.Operation.RoleAssignment", pi.m_taskContext));
                        this.showDebugInfo("Calling eMFrameComponentInstall.associateMemeberWithRoles()");
                        boolean controlPreviouslySet = true;
                        try {
                            controlPreviouslySet = RBSUtil.setAliasControl(pi.m_ndsNS);
                            String errEx = installer.associateMemeberWithRoles(pi.m_userOE, addedRoles, scopeOE, ci.m_scopeInherited, ci.m_assignRights, dynamicGroupSearchType);
                            this.showDebugInfo("Returned from eMFrameComponentInstall.associateMemeberWithRoles()");
                            if (errEx != null) {
                                this.showDebugInfo("eMFrameComponentInstall.associateMemeberWithRoles() returns error (" + errEx + ")");
                                throw new Exception(errEx);
                            }
                        }
                        finally {
                            RBSUtil.clearAliasControl(pi.m_ndsNS, controlPreviouslySet);
                        }
                    }
                }
                if (!bDoRoleAssignments) {
                    this.m_progressInfo.addElement(eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.Operation.SkippingRoleAssignment", pi.m_taskContext));
                }
            }
            if (!this.m_needToMigrateRoleAssociations) continue;
            this.m_progressInfo.addElement(eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.Operation.MigratingRoleAssoications", pi.m_taskContext));
            this.showDebugInfo("Calling MigrateRoleAssociations.migrateRoleAssociations)");
            String colOneName = pi.m_httpRequest.getParameter("Hidden_CollectionOne_Name");
            MigrateRoleAssociations mra = new MigrateRoleAssociations(pi.m_treeOE, pi.m_taskContext, this.m_migrateRoleReport);
            try {
                String[] tasks;
                mra.migrateRoleAssociations(colOneName, RBSUtil.concatStr(pi.m_ndsNS, colName, colCxt), dynamicGroupSearchType);
                this.showDebugInfo("Returning from MigrateRoleAssociations.migrateRoleAssociations)");
                String[] pages = this.m_migrateRoleReport.getPages();
                if (pages != null) {
                    this.m_progressInfo.addElement(eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.Operation.MigratingMissingPages", pi.m_taskContext));
                    for (int i = 0; i < pages.length; ++i) {
                        this.m_progressInfo.addElement("     " + pages[i]);
                        this.showDebugInfo("Missing page: " + pages[i]);
                    }
                }
                if ((tasks = this.m_migrateRoleReport.getTasks()) == null) continue;
                this.m_progressInfo.addElement(eMFrameUtils.getLocalizedString("FwResources", "CfgWiz.Operation.MigratingMissingTasks", pi.m_taskContext));
                for (int i = 0; i < tasks.length; ++i) {
                    this.m_progressInfo.addElement("     " + tasks[i]);
                    this.showDebugInfo("Missing task: " + tasks[i]);
                }
            }
            catch (Exception ex) {
                D.log(ex);
            }
        }
    }

    public String[] getRoleNamesFromXMLFiles(CfgWizPanelInfo pi, String[] xmlFiles) throws Exception {
        String[] roleNames = new String[]{};
        try {
            for (int i = 0; i < xmlFiles.length; ++i) {
                File file = new File(xmlFiles[i]);
                SAXBuilder saxBuilder = new SAXBuilder(false);
                saxBuilder.setFeature("http://xml.org/sax/features/external-general-entities", false);
                saxBuilder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                saxBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                saxBuilder.setFactory((JDOMFactory)iManagerJDOMFactory.getInstance());
                Document doc = saxBuilder.build(file);
                Element root = doc.getRootElement();
                String strType = root.getName();
                if (!strType.equals("install")) continue;
                List roles = root.getChildren("role");
                ListIterator li = roles.listIterator();
                if (roles == null) continue;
                roleNames = new String[roles.size()];
                int j = 0;
                while (li.hasNext()) {
                    Element e = (Element)li.next();
                    String theId = e.getChild("id").getTextTrim();
                    if (theId == null) continue;
                    roleNames[j++] = theId;
                }
            }
        }
        catch (Exception e) {
            D.log(e);
            throw e;
        }
        return roleNames;
    }

    private RBSRole[] takeRolesSnapshot(CfgWizPanelInfo pi, String rbsCollectionDN) {
        RBSRole[] rbsRoles = null;
        try {
            ObjectEntry rbsCollectionOE = pi.m_ndsNS.getObjectEntry(pi.m_treeOE, rbsCollectionDN);
            RBSCollection rbsCollection = new RBSCollection(rbsCollectionOE);
            rbsRoles = rbsCollection.getRoles();
        }
        catch (SPIException e) {
            D.log(e);
        }
        return rbsRoles;
    }

    private RBSRole[] compareRolesSnapshots(RBSRole[] before, RBSRole[] after) {
        Object[] addedRoles = null;
        Vector<RBSRole> vAddedRoles = new Vector<RBSRole>();
        if (before == null) {
            return after;
        }
        if (after == null) {
            return null;
        }
        for (int i = 0; i < after.length; ++i) {
            RBSRole afterRole = after[i];
            ObjectEntry afterOE = afterRole.getObjectEntry();
            boolean bFound = false;
            for (int j = 0; j < before.length; ++j) {
                RBSRole beforeRole = before[j];
                ObjectEntry beforeOE = beforeRole.getObjectEntry();
                if (!afterOE.getFullName().equalsIgnoreCase(beforeOE.getFullName())) continue;
                bFound = true;
                break;
            }
            if (bFound) continue;
            vAddedRoles.addElement(afterRole);
        }
        if (vAddedRoles.size() > 0) {
            addedRoles = new RBSRole[vAddedRoles.size()];
            vAddedRoles.copyInto(addedRoles);
        }
        return addedRoles;
    }

    private void showDebugInfo(String s) {
        if (this.m_showDebug) {
            D.log("-----ConfigWizardTask----- (" + new Date().toString() + ")" + s);
        }
    }

    private ConfigWizardInfo getAllAvailableModulesForNewCollection(TaskContext context, AdminNamespace ns) throws SPIException, NamespaceException {
        ConfigWizardInfo configWizardInfo = new ConfigWizardInfo();
        InstallXMLInfo[] installXMLInfo = RBSUtil.getAllPlugins(context, ns);
        if (installXMLInfo != null && installXMLInfo.length > 0) {
            CollectionInfo collectionInfo = new CollectionInfo();
            collectionInfo.setCollectionName("");
            for (int i = 0; i < installXMLInfo.length; ++i) {
                InstallXMLInfo installInfo = installXMLInfo[i].copy();
                installInfo.setIsUpgrade(false);
                collectionInfo.addInstallXMLInfo(installInfo);
            }
            configWizardInfo.addCollectionInfo(collectionInfo);
        }
        return configWizardInfo;
    }

    private ConfigWizardInfo getAllOwnedCollectionInformation(CfgWizPanelInfo pi) throws SPIException, JDOMException, IOException, NamespaceException {
        ConfigWizardInfo configWizardInfo = new ConfigWizardInfo();
        InstallXMLInfo[] installXMLInfo = RBSUtil.getAllPlugins(pi.m_taskContext, pi.m_ndsNS);
        RBSAssociatedObject rbsAssociatedObject = new RBSAssociatedObject(pi.m_userOE);
        RBSCollection[] rbsCollection = rbsAssociatedObject.getAllOwnedCollections2();
        if (rbsCollection != null && rbsCollection.length > 0) {
            for (int j = 0; j < rbsCollection.length; ++j) {
                int i;
                CollectionInfo collectionInfo = new CollectionInfo();
                collectionInfo.setCollectionName(pi.m_ndsNS.getUnrootedName(rbsCollection[j].getObjectEntry()));
                RBSModule[] rbsModules = rbsCollection[j].getAllModules();
                if (rbsModules != null && rbsModules.length > 0) {
                    if (installXMLInfo != null && installXMLInfo.length > 0) {
                        for (i = 0; i < installXMLInfo.length; ++i) {
                            String fileVersion = installXMLInfo[i].getVersion();
                            String moduleID = installXMLInfo[i].getModuleName();
                            if (rbsModules == null || rbsModules.length <= 0) continue;
                            boolean found = false;
                            for (int k = 0; k < rbsModules.length; ++k) {
                                String modName = rbsModules[k].getObjectEntry().getName();
                                if (!moduleID.equalsIgnoreCase(modName)) continue;
                                found = true;
                                String objectVersion = RBSUtil.getVersionFromElement(rbsModules[k].getrbsXMLInfo("version"));
                                if (objectVersion == null) {
                                    D.log("The version element for " + pi.m_ndsNS.getUnrootedName(rbsModules[k].getObjectEntry()) + " has not been set.  Initializing to 0.0.0.");
                                    objectVersion = "0.0.0";
                                }
                                if (!RBSUtil.isModuleUpdateNeeded(objectVersion, fileVersion)) break;
                                InstallXMLInfo installInfo = installXMLInfo[i].copy();
                                installInfo.setIsUpgrade(true);
                                collectionInfo.addInstallXMLInfo(installInfo);
                                break;
                            }
                            if (found) continue;
                            InstallXMLInfo installInfo = installXMLInfo[i].copy();
                            installInfo.setIsUpgrade(false);
                            collectionInfo.addInstallXMLInfo(installInfo);
                        }
                    }
                    if (collectionInfo.getinstallXMLInfoSize() <= 0) continue;
                    configWizardInfo.addCollectionInfo(collectionInfo);
                    continue;
                }
                if (installXMLInfo == null || installXMLInfo.length <= 0) continue;
                for (i = 0; i < installXMLInfo.length; ++i) {
                    InstallXMLInfo installInfo = installXMLInfo[i].copy();
                    installInfo.setIsUpgrade(false);
                    collectionInfo.addInstallXMLInfo(installInfo);
                }
                configWizardInfo.addCollectionInfo(collectionInfo);
            }
        }
        return configWizardInfo;
    }

    private boolean isSchemaValid(CfgWizPanelInfo pi) {
        boolean isSchemaValid = false;
        try {
            RBSSchemaVerifier rbsVerifier = new RBSSchemaVerifier(pi.m_treeOE);
            isSchemaValid = rbsVerifier.isSchemaValid();
        }
        catch (Exception ex) {
            D.log(ex);
            this.showDebugInfo("rbsVerifier.isSchemaValid returns error (" + ex.toString() + ")");
        }
        return isSchemaValid;
    }

    private String setTemplateToCollection(CfgWizPanelInfo pi) {
        String collectionContainmentTypes = "";
        try {
            collectionContainmentTypes = RBSUtil.getCollectionContainmentTypes(pi.m_taskContext, pi.m_treeOE);
        }
        catch (Exception exc) {
            D.log(exc);
            eMFrameUtils.setErrorMessage(exc, pi.m_taskContext);
        }
        pi.m_requestProperties.put("CollectionContainmentTypes", collectionContainmentTypes);
        return "fw.CfgWizCollection";
    }

    public class InstallXMLInfoSort
    implements Comparator {
        Collator m_collator = null;
        TaskContext m_context = null;

        public InstallXMLInfoSort(TaskContext context) {
            this.m_context = context;
            this.m_collator = Collator.getInstance(this.m_context.getLocale());
        }

        public int compare(Object object1, Object object2) {
            String str1 = ((InstallXMLInfo)object1).getDisplayName();
            String str2 = ((InstallXMLInfo)object2).getDisplayName();
            return this.m_collator.compare(str1, str2);
        }
    }

    private class ProgressThread
    extends Thread {
        private CfgWizPanelInfo pi;

        ProgressThread(CfgWizPanelInfo pi) {
            this.pi = pi;
        }

        @Override
        public void run() {
            ConfigWizardTask.this.m_threadFatalError = null;
            try {
                ConfigWizardTask.this.doUpdate(this.pi);
            }
            catch (Exception e) {
                D.log(e);
                ConfigWizardTask.this.m_threadFatalError = e.toString();
                this.pi.setErrorMsg(e.toString());
            }
            ConfigWizardTask.this.m_opActive = false;
        }
    }

    private class CfgWizCollectionInfo {
        public String m_collectionName;
        public boolean m_collectionSelected;
        public InstallXMLInfo[] m_xmlInstalls;
        public InstallXMLInfo[] m_xmlUpdates;
        public int[] m_selectedInstallIndexes;
        public String m_scope;
        public boolean m_scopeInherited;
        public boolean m_assignRights;

        CfgWizCollectionInfo(TaskContext taskContext, String name, InstallXMLInfo[] installFiles, InstallXMLInfo[] updateFiles, boolean selected) {
            this.m_collectionName = name;
            this.m_collectionSelected = selected;
            this.m_xmlInstalls = installFiles == null ? new InstallXMLInfo[]{} : installFiles;
            InstallXMLInfo[] installXMLInfoArray = this.m_xmlUpdates = updateFiles == null ? new InstallXMLInfo[]{} : updateFiles;
            if (this.m_xmlInstalls.length > 1) {
                int j;
                ArrayList<InstallXMLInfo> al = new ArrayList<InstallXMLInfo>();
                for (j = 0; j < this.m_xmlInstalls.length; ++j) {
                    al.add(this.m_xmlInstalls[j]);
                }
                Collections.sort(al, new InstallXMLInfoSort(taskContext));
                this.m_xmlInstalls = new InstallXMLInfo[al.size()];
                for (j = 0; j < al.size(); ++j) {
                    this.m_xmlInstalls[j] = (InstallXMLInfo)al.get(j);
                }
            }
            this.m_selectedInstallIndexes = new int[this.m_xmlInstalls.length];
            for (int i = 0; i < this.m_selectedInstallIndexes.length; ++i) {
                this.m_selectedInstallIndexes[i] = i;
            }
            this.m_scope = null;
            this.m_scopeInherited = true;
            this.m_assignRights = true;
        }

        public String getPackedSelectedInstallFiles(TaskContext context) {
            String[] strSelected = new String[this.m_selectedInstallIndexes.length];
            for (int i = 0; i < this.m_selectedInstallIndexes.length; ++i) {
                strSelected[i] = new Integer(this.m_selectedInstallIndexes[i]).toString();
            }
            return eMFrameUtils.pack(strSelected, context);
        }
    }
}

