/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.GlobalRegistry;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.MTask;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.Registry;
import com.novell.emframe.fw.util.FwTaskUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;

public class CreateObjectTask
extends MTask {
    public static final String HTMLPARAM_OBJECT_TYPES = "objectTypeName";
    public static final String HTMLPARAM_SELECTED_CLASS = "SelectedClass";
    public static final String HTMLPARAM_SHOW_ALL_CLASSES = "showAllClasses";
    private HttpServletRequest m_req;
    private MContext m_context;
    MTask m_creator;
    private AdminNamespace m_namespace;
    private String m_sShowModify;

    @Override
    public void execute(MContext context) {
        this.m_context = context;
        this.m_req = this.m_context.getRequest();
        String nextState = this.m_req.getParameter("nextState");
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            this.m_sShowModify = this.m_req.getParameter("ShowModifyObject");
            if (null == this.m_sShowModify || this.m_sShowModify.length() == 0) {
                this.m_sShowModify = "true";
            }
            if (!this.outputSchemaClasses()) {
                D.log("Unable to load schema classes");
                eMFrameUtils.setMessage("error", "", "", context);
            }
        } else {
            this.m_creator.execute(this.m_context);
        }
    }

    private boolean outputSchemaClasses() {
        ArrayList<String[]> objArray = new ArrayList<String[]>();
        ArrayList<String> locArray = new ArrayList<String>();
        ArrayList objTypes = null;
        String ovObjType = null;
        ObjectEntry ovOE = null;
        SchemaDefinition sd = null;
        String[] schemaClassArray = null;
        boolean haveOV = false;
        String showAllClasses = this.m_req.getParameter(HTMLPARAM_SHOW_ALL_CLASSES);
        try {
            if (this.m_namespace == null) {
                AuthenticationBroker broker = this.m_context.getAuthenticationBroker();
                ObjectEntry treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
                this.m_namespace = treeOE.getAdminNamespace();
            }
            if (null != (ovOE = this.getOvObjectEntry())) {
                ovObjType = ovOE.getObjectType().getName();
                sd = this.m_namespace.getSchemaDefinition(ovOE);
                haveOV = true;
            }
            schemaClassArray = this.getSchemaclasses();
        }
        catch (SPIException e) {
            D.log(e);
            this.getRequest().setAttribute("GeneralMsg.MsgBodyId", (Object)eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context));
            return false;
        }
        catch (AuthBrokerException e) {
            D.log(e);
            this.getRequest().setAttribute("GeneralMsg.MsgBodyId", (Object)eMFrameUtils.getExceptionMessage(e, this.m_context));
            return false;
        }
        objTypes = this.getObjectTypes();
        for (int i = 0; i < schemaClassArray.length; ++i) {
            Document doc;
            boolean containementFlag = true;
            if (haveOV) {
                boolean canContain = sd.canContain(ovObjType, schemaClassArray[i]);
                if (schemaClassArray[i].equals("Alias")) {
                    canContain = true;
                }
                boolean bl = containementFlag = haveOV && canContain;
            }
            if (objTypes != null && objTypes.size() != 0 && !objTypes.contains(schemaClassArray[i]) || !containementFlag) continue;
            Document creatorDoc = GlobalRegistry.getCreatorDoc(schemaClassArray[i], this.m_context);
            String creatorId = null;
            String helpStr = "";
            if (creatorDoc != null && (doc = this.checkForCustomTask(creatorDoc)) != null) {
                creatorDoc = doc;
            }
            if (creatorDoc != null) {
                D.log(creatorDoc);
                creatorId = creatorDoc.getRootElement().getChildTextTrim("id");
                this.getRequest().setAttribute("isunRegisteredObject", (Object)"false");
            } else {
                D.log("**** No Doc in Registry for : " + schemaClassArray[i]);
            }
            if (creatorId != null) {
                String helpId = creatorDoc.getRootElement().getChildTextTrim("help-file");
                if (helpId != null) {
                    helpStr = "&TaskHeader.helpFile=" + helpId;
                }
            } else if (null != showAllClasses && showAllClasses.equals("true")) {
                creatorId = "base.GenericCreator";
                this.getRequest().setAttribute("showAllClassesHidden", (Object)showAllClasses);
            }
            if (creatorId == null) continue;
            String[] objAndTask = new String[2];
            objAndTask[0] = schemaClassArray[i];
            String transClass = this.m_context.getDirUtils().getObjectTypeDisplayName(schemaClassArray[i], this.m_context);
            String gifName = this.m_context.getDirUtils().getObjectTypeImageName(schemaClassArray[i]);
            String url = "webacc?NPService=fw.LaunchService&NPAction=Delegate&delegate=" + creatorId + "&TranslatedClass=" + eMFrameUtils.urlEncode(transClass, this.m_context) + "&SelectedClass=" + eMFrameUtils.urlEncode(schemaClassArray[i], this.m_context) + "&GifName=" + gifName + helpStr + "&launcher=" + FwTaskUtils.getMTaskWrapper(this).getPrimary().getGadgetInstanceID() + "&lifecycle=Recreate&repeatable=true&ShowModifyObject=" + this.m_sShowModify;
            String targetNames = this.m_req.getParameter("targetNames");
            if (targetNames != null && targetNames.length() > 0) {
                url = url + "&targetNames=" + eMFrameUtils.urlEncode(targetNames, this.m_context);
            }
            objAndTask[1] = url;
            objArray.add(objAndTask);
            locArray.add(this.m_context.getDirUtils().getObjectTypeDisplayName(schemaClassArray[i], this.m_context));
        }
        int size = locArray.size();
        this.getRequest().setAttribute("Sch_ClassList.Count", (Object)Integer.toString(size));
        eMFrameUtils.sortKeyValues(locArray, objArray, this.m_context);
        if (size == 0) {
            String strFailure = eMFrameUtils.getLocalizedString("BaseResources", "CreateObject.InitialTaskFailure", this.m_context);
            String strCommonError = eMFrameUtils.getLocalizedString("BaseResources", "CreateObject.InitialTaskFailureExplain", this.m_context);
            eMFrameUtils.setMessage("error", strFailure, strCommonError, this.m_context);
            return false;
        }
        if (size == 1 && objArray != null && (((String[])objArray.get(0))[0].equals("Group") || ((String[])objArray.get(0))[0].equals("rbsModule2"))) {
            String[] tmp = (String[])objArray.get(0);
            String url = tmp[1];
            this.getRequest().setAttribute("UrlTask.url", (Object)url);
            this.setUIPage("fw/UrlTask.jsp");
        } else {
            for (int i = 0; i < size; ++i) {
                this.getRequest().setAttribute("Sch_ClassList.displayname." + i, (Object)this.m_context.getDirUtils().getObjectTypeDisplayName((String)locArray.get(i), this.m_context));
                String[] tmp = (String[])objArray.get(i);
                this.getRequest().setAttribute("Sch_ClassList.name." + i, (Object)tmp[0]);
                this.getRequest().setAttribute("Sch_ClassList.createObjectUrl." + i, (Object)tmp[1]);
            }
        }
        return true;
    }

    public Document checkForCustomTask(Document creatorDoc) {
        File jspFile;
        boolean isCustomTask = false;
        Element root = creatorDoc.getRootElement();
        String id = root.getChildText("id");
        String className = root.getChildText("class-name");
        String merge = root.getChildText("merge-template");
        if (!(id != null && className != null && merge != null & id.startsWith("base.CreateCustom") && className.endsWith("eDirAccessService") && merge.startsWith("custom."))) {
            return null;
        }
        isCustomTask = true;
        if (merge.startsWith("custom.")) {
            merge = merge.substring(merge.indexOf(".") + 1, merge.length());
        }
        if ((jspFile = new File(eMFrameUtils.getModulesBasePath() + "/custom/skins/default/devices/default/" + merge + ".jsp")).exists()) {
            return null;
        }
        String objectType = root.getChildText("object-type-name");
        D.log("The JSP page for the customized Create Task for the ObjectType " + objectType + " was  not found.");
        D.log("Hence resetting it to the default Create task.");
        Element objectTypeElement = this.getElementForClass(objectType);
        if (objectTypeElement != null) {
            Registry reg = Registry.getRegistry("Global");
            reg.removeCreator(creatorDoc);
            Document newCreatorDoc = reg.getPluginDocument(objectTypeElement.getChildText("id"));
            reg.registerCreator(newCreatorDoc);
            return newCreatorDoc;
        }
        return null;
    }

    public Element getElementForClass(String inpObjectType) {
        File creatorFile = new File(eMFrameUtils.getModulesBasePath() + "/fw/plugins/creator.xml");
        if (creatorFile.exists()) {
            try {
                Document creatorDoc = Registry.parseXMLFile(creatorFile);
                Element ele = creatorDoc.getRootElement();
                List childrenElements = ele.getChildren("object-creator");
                for (int i = 0; i < childrenElements.size(); ++i) {
                    Element child = (Element)childrenElements.get(i);
                    String objectType = child.getChildText("object-type-name");
                    if (!inpObjectType.equals(objectType)) continue;
                    return child;
                }
            }
            catch (Exception e) {
                D.log(e.getMessage());
            }
        }
        return null;
    }

    private ObjectEntry getOvObjectEntry() throws SPIException {
        AuthenticationBroker broker = this.m_context.getAuthenticationBroker();
        ObjectEntry treeOE = null;
        try {
            treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
        }
        catch (AuthBrokerException e) {
            D.log(e);
            return null;
        }
        this.m_namespace = treeOE.getAdminNamespace();
        ObjectEntry ovOE = null;
        String[] ovSelectedObject = null;
        String ovTargets = this.m_req.getParameter("targetNames");
        if (null != ovTargets && ovTargets.length() > 0 && ((ovSelectedObject = eMFrameUtils.unpack(ovTargets, this.m_context))[0] != null || ovSelectedObject[0].length() != 0)) {
            ovOE = treeOE.getName().equalsIgnoreCase(ovSelectedObject[0]) ? this.m_namespace.getObjectEntry(ovSelectedObject[0]) : this.m_namespace.getObjectEntry(treeOE, ovSelectedObject[0]);
        }
        return ovOE;
    }

    private ArrayList getObjectTypes() {
        ArrayList<String> list = new ArrayList<String>();
        String objectTypes = this.m_req.getParameter(HTMLPARAM_OBJECT_TYPES);
        if (objectTypes != null && objectTypes.length() > 0) {
            StringTokenizer st = new StringTokenizer(objectTypes, ",", false);
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
        }
        return list;
    }

    private String[] getSchemaclasses() throws SPIException, AuthBrokerException {
        SchemaDefinition schemaDef = null;
        AuthenticationBroker broker = this.m_context.getAuthenticationBroker();
        ObjectEntry treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
        this.m_namespace = treeOE.getAdminNamespace();
        schemaDef = this.m_namespace.getSchemaDefinition(treeOE);
        ClassDefinition[] classDef = schemaDef.getClassDefinitions();
        ArrayList<String> objArray = new ArrayList<String>();
        for (int i = 0; i < classDef.length; ++i) {
            String temp = classDef[i].getName();
            if (classDef[i].isAuxiliary() || temp.equalsIgnoreCase("[Anything]") || temp.equalsIgnoreCase("[Nothing]") || temp.equalsIgnoreCase("Top") || temp.equalsIgnoreCase("Unknown") || temp.equalsIgnoreCase("Tree Root") || !classDef[i].isEffective() || temp.equals("Bindery Object") || temp.equals("Bindery Queue") || temp.equals("Deleted File")) continue;
            objArray.add(classDef[i].getName());
        }
        String[] classDefArray = new String[objArray.size()];
        for (int j = 0; j < objArray.size(); ++j) {
            classDefArray[j] = objArray.get(j).toString();
        }
        return classDefArray;
    }
}

