/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.FacadeParameterException;
import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.SimpleSPIException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.LongValue;
import com.novell.admin.ns.NSFileNamespace;
import com.novell.admin.ns.NSFileObject;
import com.novell.admin.ns.NSFileRights;
import com.novell.admin.ns.NSFileTrustee;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.NDSAttributeDefinition;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSObjectAttribute;
import com.novell.admin.ns.nds.NDSSchemaDefinition;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.admin.ns.nds.ObjectACLFacade;
import com.novell.admin.ns.nds.PathFacade;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectType;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.CreatorSilent;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.PluginException;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.dev.rights.eDirPropertyRightsData;
import com.novell.emframe.dev.rights.eDirRightsObject;
import com.novell.emframe.fw.Registry;
import com.novell.nps.utils.Utils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import org.jdom.Document;

public class CreateObjectUtils {
    private static final String MEMBERS_OF_TEMPLATE = "Members Of Template";
    private static final String NEW_OBJECTS_DS_RIGHTS = "New Object's DS Rights";
    private static final String TRUSTEES_OF_NEW_OBJECT = "Trustees Of New Object";
    private static final String NEW_OBJECTS_SELF_RIGHTS = "New Object's Self Rights";
    private static final String HOME_DIR_RIGHTS = "Home Directory Rights";
    private static final String PASSWORD_EXPTIME = "Password Expiration Time";
    private static final String PASSWORD_MINIMUM_LENGTH = "Password Minimum Length";
    private static final String NEW_OBJECTS_FS_RIGHTS = "New Object's FS Rights";
    private static final String VOLUME_SPACE_RESTRICTIONS = "Volume Space Restrictions";
    private static final String ENGLISH = "ENGLISH";
    private static final String PORTUGESE = "PORTUGE";
    private static final String FRENCH = "FRANCAIS";
    private static final String ITALIAN = "ITALIANO";
    private static final String GERMAN = "DEUTSCH";
    private static final String SPANISH = "ESPANOL";
    private static final String JAPANESE = "NIHONGO";
    private static final String CHINESE_SIMPLIFIED = "CHINESES";
    private static final String CHINESE_TRADITIONAL = "CHINESET";
    private static final String RUSSIAN = "RUSSKI";

    public static void doPostCreateClone(String containerName, String username, NSObject sourceNSObj, AdminNamespace ns, MContext context) throws PluginException {
        try {
            ObjectAttribute acl;
            ObjectEntry sourceOE = sourceNSObj.getObjectEntry();
            ObjectEntry targetOE = ns.createObjectEntry(ns.getObjectEntry(containerName), username, "User");
            NSObject newNSObj = ns.getDetails(targetOE);
            if (sourceOE.getObjectType().getName().equals("Template")) {
                CreateObjectUtils.updateMembersOfTemplate(ns, targetOE, sourceNSObj);
                CreateObjectUtils.newObjectDSRights(ns, newNSObj, sourceNSObj);
                CreateObjectUtils.trusteesOfNewObject(newNSObj, sourceNSObj);
                ns.update(newNSObj);
                CreateObjectUtils.newObjectSelfRights(ns, newNSObj, sourceNSObj);
                ns.update(newNSObj);
            }
            if (sourceOE.getObjectType().getName().equals("User") && (acl = sourceNSObj.getAttribute("ACL")) != null) {
                CreateObjectUtils.modifyACL(ns.getUnrootedName(sourceOE), ns.getUnrootedName(targetOE), acl);
                newNSObj.deleteAttribute("ACL");
                ns.update(newNSObj);
                newNSObj.addAttribute(acl);
                ns.update(newNSObj);
            }
            CreateObjectUtils.makeSecurityEqualsLinks(ns, newNSObj, sourceNSObj);
            CreateObjectUtils.makeGroupMembershipLinks(ns, newNSObj, sourceNSObj);
        }
        catch (Exception e) {
            throw new PluginException(e);
        }
    }

    public static void modifyACL(String source, String target, ObjectAttribute acl) {
        if (acl != null) {
            Enumeration myenum = acl.getValueComponents();
            while (myenum.hasMoreElements()) {
                ObjectACLFacade oacl = (ObjectACLFacade)((ValueList)myenum.nextElement()).createFacade();
                if (!oacl.getSubjectName().equalsIgnoreCase(source)) continue;
                try {
                    oacl.setSubjectName(target);
                }
                catch (FacadeParameterException facadeParameterException) {}
            }
        }
    }

    public static ObjectAttribute replaceACL(String source, ObjectEntry targetOE, ObjectAttribute acl, AdminNamespace ns) throws NamespaceException, ComponentCreationException, SPIException {
        Vector<ValueComponent> components = new Vector<ValueComponent>();
        try {
            if (acl != null) {
                AttributeDefinition attrDef = ns.getAttributeDefinition(targetOE, "ACL");
                ObjectAttribute tmpACL = new ObjectAttribute(attrDef);
                Enumeration myenum = acl.getValueComponents();
                String target = ns.getUnrootedName(targetOE);
                while (myenum.hasMoreElements()) {
                    Vector<Object> list;
                    ObjectACLFacade oacl = (ObjectACLFacade)((ValueList)myenum.nextElement()).createFacade();
                    if (oacl.getSubjectName().equalsIgnoreCase(source)) {
                        list = new Vector<Object>();
                        list.addElement(oacl.getProtectedAttrName());
                        list.addElement(target);
                        list.addElement(new Long(oacl.getPrivileges()));
                        components.addElement(attrDef.getSyntax().createValueComponent(list));
                        continue;
                    }
                    if (oacl.getSubjectName().equalsIgnoreCase(target) || oacl.getSubjectName().equalsIgnoreCase(source)) continue;
                    list = new Vector();
                    list.addElement(oacl.getProtectedAttrName());
                    list.addElement(oacl.getSubjectName());
                    list.addElement(new Long(oacl.getPrivileges()));
                    components.addElement(attrDef.getSyntax().createValueComponent(list));
                }
                Object[] vc = new ValueComponent[components.size()];
                components.copyInto(vc);
                tmpACL.addComponents((ValueComponent[])vc);
                return tmpACL;
            }
        }
        catch (FacadeParameterException facadeParameterException) {
            // empty catch block
        }
        return null;
    }

    private static void trusteesOfNewObject(NSObject newNSO, NSObject templateObj) {
        eDirRightsObject rObj = new eDirRightsObject(newNSO);
        NDSObjectAttribute attr = (NDSObjectAttribute)templateObj.getAttribute(TRUSTEES_OF_NEW_OBJECT);
        if (attr != null) {
            Enumeration e = attr.getValueComponents();
            while (e.hasMoreElements()) {
                ValueList vl = (ValueList)e.nextElement();
                ObjectACLFacade facade = (ObjectACLFacade)vl.createFacade();
                rObj.setPropertyRights(facade.getProtectedAttrName(), facade.getSubjectName(), (int)facade.getPrivileges(), (int)facade.getPrivileges());
            }
        }
    }

    private static void makeSecurityEqualsLinks(AdminNamespace ns, NSObject newObject, NSObject templateObj) {
        ObjectAttribute toMeAttrib = templateObj.getAttribute("Equivalent To Me");
        try {
            ObjectAttribute equalsAttrib;
            if (toMeAttrib != null && newObject != null) {
                Enumeration e = toMeAttrib.getValueComponents();
                while (e.hasMoreElements()) {
                    ValueComponent vc = (ValueComponent)e.nextElement();
                    ObjectEntry oe = ns.getObjectEntry(newObject.getObjectEntry().getRoot(), vc.toString());
                    NSObject nsobj = ns.getDetails(oe);
                    ObjectAttribute attr = nsobj.getAttribute("Security Equals");
                    if (attr == null) {
                        attr = new NDSObjectAttribute((NDSAttributeDefinition)ns.getAttributeDefinition(newObject.getObjectEntry(), "Security Equals"));
                        attr.addComponent(NDSSyntax.SYN_DIST_NAME.createValueComponent((Object)ns.getUnrootedName(newObject.getObjectEntry())));
                        nsobj.addAttribute(attr);
                    } else {
                        attr.addComponent(NDSSyntax.SYN_DIST_NAME.createValueComponent((Object)ns.getUnrootedName(newObject.getObjectEntry())));
                    }
                    ns.update(nsobj);
                }
            }
            if ((equalsAttrib = templateObj.getAttribute("Security Equals")) != null && newObject != null) {
                Enumeration e = equalsAttrib.getValueComponents();
                while (e.hasMoreElements()) {
                    ValueComponent vc = (ValueComponent)e.nextElement();
                    ObjectEntry oe = ns.getObjectEntry(newObject.getObjectEntry().getRoot(), vc.toString());
                    NSObject nsobj = ns.getDetails(oe);
                    ObjectAttribute attr = nsobj.getAttribute("Equivalent To Me");
                    if (attr == null) {
                        attr = new NDSObjectAttribute((NDSAttributeDefinition)ns.getAttributeDefinition(newObject.getObjectEntry(), "Equivalent To Me"));
                        attr.addComponent(NDSSyntax.SYN_DIST_NAME.createValueComponent((Object)ns.getUnrootedName(newObject.getObjectEntry())));
                        nsobj.addAttribute(attr);
                    } else {
                        attr.addComponent(NDSSyntax.SYN_DIST_NAME.createValueComponent((Object)ns.getUnrootedName(newObject.getObjectEntry())));
                    }
                    ns.update(nsobj);
                }
            }
        }
        catch (Exception exception) {
            D.log(exception);
        }
    }

    private static void makeGroupMembershipLinks(AdminNamespace ns, NSObject newObject, NSObject templateObj) {
        ObjectAttribute attrib = templateObj.getAttribute("Group Membership");
        if (attrib != null && newObject != null) {
            Enumeration e = attrib.getValueComponents();
            while (e.hasMoreElements()) {
                try {
                    ValueComponent vc = (ValueComponent)e.nextElement();
                    ObjectEntry oe = ns.getObjectEntry(newObject.getObjectEntry().getRoot(), vc.toString());
                    NSObject nsobj = ns.getDetails(oe);
                    ObjectAttribute attr = nsobj.getAttribute("Member");
                    if (attr == null) {
                        attr = new NDSObjectAttribute((NDSAttributeDefinition)ns.getAttributeDefinition(newObject.getObjectEntry(), "Member"));
                        attr.addComponent(NDSSyntax.SYN_DIST_NAME.createValueComponent((Object)ns.getUnrootedName(newObject.getObjectEntry())));
                        nsobj.addAttribute(attr);
                    } else {
                        attr.addComponent(NDSSyntax.SYN_DIST_NAME.createValueComponent((Object)ns.getUnrootedName(newObject.getObjectEntry())));
                    }
                    ns.update(nsobj);
                }
                catch (Exception exception) {
                    D.log(exception);
                }
            }
        }
    }

    private static void newObjectSelfRights(AdminNamespace ns, NSObject newNSO, NSObject templateObj) {
        eDirRightsObject rObj = new eDirRightsObject(newNSO);
        ObjectAttribute attr = templateObj.getAttribute(NEW_OBJECTS_SELF_RIGHTS);
        if (attr != null) {
            Enumeration e = attr.getValueComponents();
            while (e.hasMoreElements()) {
                ValueList vl = (ValueList)e.nextElement();
                ObjectACLFacade facade = (ObjectACLFacade)vl.createFacade();
                Vector v = rObj.getAssignedPropertyRights(ns.getUnrootedName(newNSO.getObjectEntry()), facade.getProtectedAttrName());
                if (v == null) {
                    rObj.setPropertyRights(facade.getProtectedAttrName(), ns.getUnrootedName(newNSO.getObjectEntry()), (int)facade.getPrivileges(), (int)facade.getPrivileges());
                    continue;
                }
                rObj.setPropertyRights(facade.getProtectedAttrName(), ns.getUnrootedName(newNSO.getObjectEntry()), (int)facade.getPrivileges(), ((eDirPropertyRightsData)v.elementAt(0)).getRights());
            }
        }
    }

    private static void newObjectDSRights(AdminNamespace ns, NSObject newNSO, NSObject templateObj) {
        ObjectAttribute attr = templateObj.getAttribute(NEW_OBJECTS_DS_RIGHTS);
        if (attr != null) {
            Enumeration e = attr.getValueComponents();
            while (e.hasMoreElements()) {
                ValueList vl = (ValueList)e.nextElement();
                ObjectACLFacade facade = (ObjectACLFacade)vl.createFacade();
                try {
                    ObjectEntry oeParent = newNSO.getObjectEntry().getRoot();
                    ObjectEntry oe = ns.getObjectEntry(oeParent, facade.getSubjectName());
                    if (oe == null) continue;
                    eDirRightsObject rObj = new eDirRightsObject(ns.getDetails(oe));
                    rObj.setPropertyRights(facade.getProtectedAttrName(), ns.getUnrootedName(newNSO.getObjectEntry()), (int)facade.getPrivileges(), (int)facade.getPrivileges());
                    rObj.updateData();
                }
                catch (SPIException spie) {
                    D.log(spie);
                }
            }
        }
    }

    private static void updateMembersOfTemplate(AdminNamespace ns, ObjectEntry newOE, NSObject templateObj) {
        try {
            String newName = ns.getUnrootedName(newOE);
            ObjectAttribute attrib = templateObj.getAttribute(MEMBERS_OF_TEMPLATE);
            if (attrib != null) {
                ValueComponent vc = NDSSyntax.SYN_DIST_NAME.createValueComponent((Object)newName);
                attrib.addComponent(vc);
            } else {
                AttributeDefinition def = ns.getAttributeDefinition(newOE, MEMBERS_OF_TEMPLATE);
                attrib = new ObjectAttribute(def);
                ValueComponent vc = NDSSyntax.SYN_DIST_NAME.createValueComponent((Object)newName);
                attrib.addComponent(vc);
                templateObj.addAttribute(attrib);
            }
            ns.update(templateObj);
        }
        catch (Exception e) {
            D.log(e);
        }
    }

    public static void updatePwdExpirationTime(AdminNamespace ns, NSObject newObjNS, MContext context) {
        try {
            ObjectAttribute attribTemplate = CreateObjectUtils.getTemplatePwdExpirationTime(context);
            ObjectAttribute attrib = newObjNS.getAttribute(PASSWORD_EXPTIME);
            if (attrib != null) {
                Enumeration valueSet = attrib.getValueComponents();
                if (valueSet.hasMoreElements()) {
                    ValueComponent newvc;
                    ValueComponent old = (ValueComponent)valueSet.nextElement();
                    if (!old.equals((Object)(newvc = (ValueComponent)attribTemplate.getValueComponents().nextElement()))) {
                        attrib.replaceComponent(old, newvc);
                    }
                } else {
                    ValueComponent newvc = (ValueComponent)attribTemplate.getValueComponents().nextElement();
                    attrib.addComponent(newvc);
                }
            }
            ns.update(newObjNS);
        }
        catch (Exception e) {
            D.log(e);
        }
    }

    public static void setPassword(ObjectEntry targetOE, String password, MContext context) throws PluginException {
        ObjectEntry treeOE = (ObjectEntry)context.getAuthenticationBroker().getProtocolObject("AdminNamespace");
        AdminNamespace namespace = treeOE.getAdminNamespace();
        try {
            if (password == null || password.length() == 0) {
                password = "";
            }
            namespace.setPassword(targetOE, password);
        }
        catch (SPIException e) {
            D.log(e);
            if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -216) {
                String format = eMFrameUtils.getLocalizedString("BaseResources", "CreateUser.MinPasswordRequired", context);
                String title = eMFrameUtils.getLocalizedString("BaseResources", "CreateUser.CredentialFailure", context);
                String details = eMFrameUtils.getLocalizedString("BaseResources", "CreateUser.CredentialFailureExplain", context);
                String formatDetails = eMFrameUtils.formatMessage(details, new String[]{targetOE.getName()});
                String body = eMFrameUtils.formatMessage(format, new String[]{formatDetails});
                throw new PluginException(title, body, -216);
            }
            if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -222) {
                String title = eMFrameUtils.getLocalizedString("BaseResources", "CreateUser.CredentialFailure", context);
                String body = eMFrameUtils.getLocalizedString("BaseResources", "CreateUser.CredentialPolicyFailure", context);
                throw new PluginException(title, body, -222);
            }
            if (e instanceof SimpleSPIException && ((SimpleSPIException)e).getErrorId() == "spi16") {
                String title = eMFrameUtils.getLocalizedString("BaseResources", "CreateUser.CredentialFailure", context);
                String body = eMFrameUtils.getLocalizedString("BaseResources", "CreateUser.CredentialLinkageError", context);
                body = body + e.getMessage();
                throw new PluginException(title, body);
            }
            throw new PluginException((Exception)((Object)e));
        }
    }

    public static void setSimplePassword(ObjectEntry targetOE, String simplepassword, MContext context) throws PluginException {
        try {
            if (simplepassword == null || simplepassword.length() == 0) {
                return;
            }
            ObjectEntry treeOE = (ObjectEntry)context.getAuthenticationBroker().getProtocolObject("AdminNamespace");
            context.getDirUtils().setSimplePassword(treeOE.getName(), targetOE.getFullName(), simplepassword, true);
        }
        catch (PluginException e) {
            D.log(e);
            String title = eMFrameUtils.getLocalizedString("BaseResources", "SimplePassword.SimplePasswordFailure", context);
            String body = eMFrameUtils.getLocalizedString("BaseResources", "SimplePassword.SimplePasswordFailureExplain", context);
            body = body + "\n" + e.getMessage();
            throw new PluginException(title, body);
        }
    }

    public static String buildSearchFilter(String objectClass, MContext context) {
        AuthenticationBroker broker = context.getAuthenticationBroker();
        ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        NDSNamespace ns = (NDSNamespace)treeOE.getNamespace();
        ClassDefinition[] containment = new ClassDefinition[]{};
        try {
            NDSSchemaDefinition schemaDef = (NDSSchemaDefinition)ns.getSchemaDefinition(treeOE);
            containment = schemaDef.getContainmentClasses(objectClass);
        }
        catch (SPIException e) {
            D.log(e);
            return "*";
        }
        catch (NamespaceException e) {
            D.log(e);
            return "*";
        }
        String creatorFilter = "";
        for (int m = 0; m < containment.length; ++m) {
            if (containment[m].getName().equals("Tree Root")) {
                creatorFilter = creatorFilter + "[root],";
                continue;
            }
            if (containment[m].getName().equals("Top")) continue;
            creatorFilter = creatorFilter + containment[m].getName() + ",";
        }
        if (creatorFilter.equals("")) {
            creatorFilter = "*";
        }
        return creatorFilter;
    }

    public static void appendACL(String source, String target, ObjectAttribute acl) throws ComponentCreationException, NamespaceException {
        Vector<ValueComponent> components = new Vector<ValueComponent>();
        Enumeration myenum = acl.getValueComponents();
        while (myenum.hasMoreElements()) {
            ObjectACLFacade oacl = (ObjectACLFacade)((ValueList)myenum.nextElement()).createFacade();
            if (!oacl.getSubjectName().equalsIgnoreCase(source)) continue;
            Vector<Object> list = new Vector<Object>();
            list.addElement(oacl.getProtectedAttrName());
            list.addElement(target);
            list.addElement(new Long(oacl.getPrivileges()));
            components.addElement(NDSSyntax.SYN_OBJECT_ACL.createValueComponent(list));
        }
        Object[] vc = new ValueComponent[components.size()];
        components.copyInto(vc);
        acl.addComponents((ValueComponent[])vc);
    }

    public static void doPreCreateClone(String source, ObjectEntry targetOE, Vector nonCloneAttrs, Vector initalAttributes, MContext context) throws SPIException, PluginException, NamespaceException, ComponentCreationException {
        ObjectEntry treeOE = (ObjectEntry)context.getAuthenticationBroker().getAPIObject("NDSNamespace");
        NDSNamespace ns = (NDSNamespace)treeOE.getNamespace();
        ObjectEntry sourceOE = ns.getObjectEntry(source);
        context.addToHistory(sourceOE);
        String sourceType = sourceOE.getObjectType().getName();
        if (!sourceType.equals("Template") && !DirUtils.isOfType(sourceOE.getObjectType(), "User", true)) {
            String title = eMFrameUtils.getLocalizedString("BaseResources", "CreateUser.Failure", context);
            String format = eMFrameUtils.getLocalizedString("BaseResources", "CreateUser.InvalidObjectType", context);
            String body = eMFrameUtils.formatMessage(format, new String[]{sourceType});
            throw new PluginException(title, body);
        }
        NSObject sourceNSObj = ns.getDetails(sourceOE);
        ArrayList<String> classList = new ArrayList<String>();
        classList.add(targetOE.getObjectType().getName());
        ObjectType[] ot = targetOE.getSubTypes();
        for (int i = 0; i < ot.length; ++i) {
            classList.add(ot[i].getName());
        }
        ObjectAttribute sourceOC = sourceNSObj.getAttribute("Object Class");
        if (sourceOC != null) {
            Enumeration enumValueComponents = sourceOC.getValueComponents();
            while (enumValueComponents.hasMoreElements()) {
                String classname = ((ValueComponent)enumValueComponents.nextElement()).toString();
                ClassDefinition cd = ns.getSchemaDefinition(treeOE).getClassDefinition(classname);
                if (!cd.isAuxiliary()) continue;
                classList.add(classname);
            }
        }
        ValueComponent[] vc = new ValueComponent[classList.size()];
        for (int i = 0; i < vc.length; ++i) {
            vc[i] = NDSSyntax.SYN_CLASS_NAME.createValueComponent(classList.get(i));
        }
        AttributeDefinition attrdef = ns.getSchemaDefinition(treeOE).getAttributeDefinition("Object Class");
        ObjectAttribute oa = new ObjectAttribute(attrdef, vc);
        initalAttributes.addElement(oa);
        ClassDefinition[] classDefs = new ClassDefinition[classList.size()];
        for (int i = 0; i < classDefs.length; ++i) {
            classDefs[i] = ns.getSchemaDefinition(treeOE).getClassDefinition((String)classList.get(i));
        }
        String[] sourceAttrs = sourceNSObj.getAttributes();
        for (int i = 0; i < sourceAttrs.length; ++i) {
            Enumeration e;
            boolean readonly = ns.getAttributeDefinition(targetOE, sourceAttrs[i]).isReadOnly();
            if (readonly || nonCloneAttrs.contains(sourceAttrs[i])) continue;
            boolean validAttr = false;
            for (int j = 0; j < classDefs.length; ++j) {
                if (!classDefs[j].isClassUsingAttribute(sourceAttrs[i])) continue;
                validAttr = true;
                break;
            }
            if (!validAttr) continue;
            initalAttributes.addElement(sourceNSObj.getAttribute(sourceAttrs[i]));
            D.log(sourceAttrs[i], 2);
            if (sourceAttrs[i].equals("Login Grace Limit") && (NDSObjectAttribute)sourceNSObj.getAttribute("Login Grace Remaining") == null && (e = sourceNSObj.getAttribute(sourceAttrs[i]).getValueComponents()).hasMoreElements()) {
                ValueComponent[] vcArray = new ValueComponent[1];
                ValueComponent newvc = (ValueComponent)e.nextElement();
                LongValue lv = (LongValue)newvc;
                AttributeDefinition ad = ns.getAttributeDefinition(targetOE, "Login Grace Remaining");
                vcArray[0] = NDSSyntax.SYN_COUNTER.createValueComponent((Object)lv.getLongValue());
                NDSObjectAttribute loginGraceRemainingAttr = new NDSObjectAttribute(ad, vcArray);
                initalAttributes.addElement(loginGraceRemainingAttr);
            }
            if (sourceAttrs[i].equals(PASSWORD_EXPTIME)) {
                ObjectAttribute PwdExpirationTime = sourceNSObj.getAttribute(sourceAttrs[i]);
                context.setAuthAttribute("Password_Expiration_Time", PwdExpirationTime);
            }
            if (!sourceAttrs[i].equals(PASSWORD_MINIMUM_LENGTH)) continue;
            ObjectAttribute PwdMinLen = sourceNSObj.getAttribute(sourceAttrs[i]);
            context.setAuthAttribute("Password_Minimum_Length", PwdMinLen);
        }
    }

    private static ObjectAttribute getTemplatePwdExpirationTime(MContext context) {
        ObjectAttribute tmp = (ObjectAttribute)context.getAuthAttribute("Password_Expiration_Time");
        context.removeAuthAttribute("Password_Expiration_Time");
        return tmp;
    }

    public static long getTemplatePwdMinimumLength(MContext context) {
        Enumeration myenum;
        ObjectAttribute objAttr = (ObjectAttribute)context.getAuthAttribute("Password_Minimum_Length");
        context.removeAuthAttribute("Password_Minimum_Length");
        if (null != objAttr && (myenum = objAttr.getValueComponents()).hasMoreElements()) {
            ValueComponent newvc = (ValueComponent)myenum.nextElement();
            LongValue tmp = (LongValue)newvc;
            return tmp.getValue();
        }
        return 0L;
    }

    private static PluginException makePluginException(String bundle, String titleKey, String bodyFormatKey, String param0, MContext context) {
        String title = eMFrameUtils.getLocalizedString(bundle, titleKey, context);
        String format = eMFrameUtils.getLocalizedString(bundle, bodyFormatKey, context);
        String body = eMFrameUtils.formatMessage(format, new String[]{param0});
        return new PluginException(title, body);
    }

    public static void validateContainment(String objectClass, String strContext, MContext context) throws PluginException {
        ObjectEntry treeOE = (ObjectEntry)context.getAuthenticationBroker().getProtocolObject("AdminNamespace");
        AdminNamespace m_ns = treeOE.getAdminNamespace();
        if (strContext.equalsIgnoreCase("[root]") || strContext.equals("")) {
            strContext = treeOE.getName();
        }
        ObjectEntry parentEntry = null;
        try {
            parentEntry = treeOE.getName().equalsIgnoreCase(strContext) ? m_ns.getObjectEntry(strContext) : m_ns.getObjectEntry(treeOE, strContext);
            context.addToHistory(parentEntry);
        }
        catch (SPIException e) {
            D.log(e);
            throw CreateObjectUtils.makePluginException("BaseResources", "CreateUser.Failure", "Common.ContainerNotFound", strContext, context);
        }
        ObjectType ot = parentEntry.getObjectType();
        if (!ot.isContainer()) {
            throw CreateObjectUtils.makePluginException("BaseResources", "CreateUser.Failure", "Common.NotAContainer", strContext, context);
        }
        try {
            String strParentType = parentEntry.getObjectType().getName();
            SchemaDefinition sd = m_ns.getSchemaDefinition(parentEntry);
            boolean canContain = sd.canContain(strParentType, objectClass);
            if (!canContain) {
                String title = eMFrameUtils.getLocalizedString("BaseResources", "CreateUser.Failure", context);
                String format = eMFrameUtils.getLocalizedString("FwResources", "FwConsts.RES_INVALID_OBJECTTYPE", context);
                String body = eMFrameUtils.formatMessage(format, new String[]{objectClass});
                throw new PluginException(title, body);
            }
        }
        catch (SPIException e) {
            D.log(e);
            throw new PluginException((Exception)((Object)e));
        }
    }

    public static String fixPath(String pathStr) {
        int len;
        if (pathStr.equals("\\") || pathStr.equals("") || pathStr.equals("/")) {
            return "";
        }
        if ((pathStr = Utils.replaceWith((String)pathStr, (String)"/", (String)"\\")).substring((len = pathStr.length()) - 1).equals("\\")) {
            pathStr = pathStr.substring(0, len - 1);
        }
        if (pathStr.substring(0, 1).equals("\\")) {
            pathStr = pathStr.substring(1, pathStr.length());
        }
        return pathStr;
    }

    public static String getNWLanguage(Locale loc) {
        String lang = loc.getLanguage();
        if (lang.equals("en")) {
            return ENGLISH;
        }
        if (lang.equals("pt")) {
            return PORTUGESE;
        }
        if (lang.equals("fr")) {
            return FRENCH;
        }
        if (lang.equals("it")) {
            return ITALIAN;
        }
        if (lang.equals("de")) {
            return GERMAN;
        }
        if (lang.equals("es")) {
            return SPANISH;
        }
        if (lang.equals("ja")) {
            return JAPANESE;
        }
        if (lang.equals("zh")) {
            if (loc.getCountry().equals("CN")) {
                return CHINESE_SIMPLIFIED;
            }
            return CHINESE_TRADITIONAL;
        }
        if (lang.equals("ru")) {
            return RUSSIAN;
        }
        return ENGLISH;
    }

    public static void runSilentPostCreationRegistration(ObjectEntry oe, String objType, MContext context) {
        Document silentCreatorDoc = null;
        ArrayList silentCreatorArray = Registry.getRegistry("Global").getCreatorSilentChainingPlugins(objType);
        for (int j = 0; j < silentCreatorArray.size(); ++j) {
            try {
                silentCreatorDoc = (Document)silentCreatorArray.get(j);
                String silentClassName = silentCreatorDoc.getRootElement().getChildTextTrim("class-name");
                Class<?> c = Class.forName(silentClassName);
                CreatorSilent newCreator = (CreatorSilent)c.newInstance();
                newCreator.doSilentPostCreate(oe, context);
                continue;
            }
            catch (InstantiationException e) {
                D.log("CreateUserAcctTask:InstantiationException for one of the registered silent creator plugins", 2);
                D.log(e);
                continue;
            }
            catch (IllegalAccessException e) {
                D.log("CreateUserAcctTask:IllegalAccessException for one of the registered silent creator plugins", 2);
                D.log(e);
                continue;
            }
            catch (ClassNotFoundException e) {
                D.log("CreateUserAcctTask:ClassNotFoundException for one of the registered silent creator plugins", 2);
                D.log(e);
            }
        }
    }

    public static void setNewObjectFSRights(ObjectEntry userOE, NSObject templateNSObj) {
        ObjectAttribute fsRightsAttr;
        if (templateNSObj != null && null != (fsRightsAttr = templateNSObj.getAttribute(NEW_OBJECTS_FS_RIGHTS))) {
            AdminNamespace ns = userOE.getAdminNamespace();
            NSFileNamespace filens = (NSFileNamespace)ns;
            Enumeration myenum = fsRightsAttr.getValueComponents();
            while (myenum.hasMoreElements()) {
                ValueList vl = (ValueList)myenum.nextElement();
                PathFacade facade = (PathFacade)vl.createFacade();
                String path = "";
                try {
                    ObjectEntry volumeOE = ns.getObjectEntry(userOE.getRoot(), facade.getVolume());
                    if (facade.getPath().indexOf("\\") != -1) {
                        path = facade.getPath().substring(facade.getPath().indexOf("\\"));
                        path = path.replace('\\', '/');
                    } else {
                        path = facade.getPath();
                    }
                    Long rights = new Long(facade.getType());
                    NSFileRights fileRights = filens.newNSFileRights(rights.intValue());
                    NSFileTrustee trusteeObject = filens.newNSFileTrustee(ns.getUnrootedName(userOE), fileRights);
                    NSFileObject fileObject = filens.newNSFileObject(path);
                    filens.addNSFileTrustee(volumeOE, fileObject, trusteeObject, 45);
                }
                catch (SPIException spi) {
                    D.log("Could not set the File System Trustees for directory:  " + facade.getVolume() + ":" + path);
                    D.log(spi);
                }
            }
        }
    }

    public static void createHomeDirectoryAndSetRights(String volumeStr, String pathStr, ObjectEntry userOE, NSFileRights homeDirectoryRights, MContext context) throws PluginException {
        try {
            AdminNamespace ns = userOE.getAdminNamespace();
            ObjectEntry volOE = ns.getObjectEntry(userOE.getRoot(), volumeStr);
            NSFileNamespace filens = (NSFileNamespace)ns;
            NSFileObject fileObject = filens.newNSFileObject(pathStr, 2);
            filens.createNSFileObject(volOE, fileObject);
            if (homeDirectoryRights != null) {
                NSFileTrustee trusteeObject = filens.newNSFileTrustee(ns.getUnrootedName(userOE), homeDirectoryRights);
                filens.addNSFileTrustee(volOE, fileObject, trusteeObject, 45);
            }
        }
        catch (SPIException e) {
            D.log(e);
            String title = eMFrameUtils.getLocalizedString("BaseResources", "CreateUser.CreateDirFailure", context);
            String body = eMFrameUtils.getLocalizedString("BaseResources", "CreateUser.CreateDirFailureExplain", context);
            throw new PluginException(title, body);
        }
    }

    public static void setVolumeSpaceRestrictions(ObjectEntry userOE, NSObject templateNSObj) {
        ObjectAttribute volumeSpaceRestrictionsAttr;
        if (templateNSObj != null && null != (volumeSpaceRestrictionsAttr = templateNSObj.getAttribute(VOLUME_SPACE_RESTRICTIONS))) {
            AdminNamespace ns = userOE.getAdminNamespace();
            NSFileNamespace filens = (NSFileNamespace)ns;
            Enumeration myenum = volumeSpaceRestrictionsAttr.getValueComponents();
            while (myenum.hasMoreElements()) {
                ValueList vl = (ValueList)myenum.nextElement();
                PathFacade facade = (PathFacade)vl.createFacade();
                try {
                    ObjectEntry volumeOE = ns.getObjectEntry(userOE.getRoot(), facade.getVolume());
                    Long limit = new Long(facade.getType());
                    filens.setTrusteeRestriction(volumeOE, userOE, limit.intValue());
                }
                catch (SPIException spi) {
                    D.log("Could not set the Volume Space Restrictions for:  " + facade.getVolume());
                    D.log(spi);
                }
            }
        }
    }

    public static NSFileRights getHomeDirectoryRightsAttribute(AdminNamespace ns, NSObject templateNSObj) {
        NSFileRights fileRights = null;
        NSFileNamespace filens = (NSFileNamespace)ns;
        try {
            ObjectAttribute homeDirRightsAttr;
            if (templateNSObj != null && (homeDirRightsAttr = templateNSObj.getAttribute(HOME_DIR_RIGHTS)) != null) {
                fileRights = filens.newNSFileRights(homeDirRightsAttr);
            }
            if (fileRights == null) {
                int newRights = 251;
                fileRights = filens.newNSFileRights(newRights);
            }
        }
        catch (Exception e) {
            D.log("Cannot get the \"Home Diectory Rights\" from the template object.", 2);
            D.log(e);
        }
        return fileRights;
    }
}

