/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.Version;
import com.novell.emframe.fw.Entry;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.studio.TemplateBuilderUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class CustomNpmFile {
    private Document m_installXml = null;
    private Document m_pluginsXml = null;
    private File m_srcFile = null;
    private ArrayList m_entries = new ArrayList();
    private Properties m_manifest = null;

    public CustomNpmFile(MContext context) throws IOException, JDOMException {
        File packagesDirectory = new File(context.getWebappHome(), "packages");
        if (!packagesDirectory.exists()) {
            packagesDirectory.mkdir();
        }
        this.init(packagesDirectory, "custom.npm");
    }

    public CustomNpmFile(File packagesDirectory, String filename) throws IOException, JDOMException {
        this.init(packagesDirectory, filename);
    }

    private void init(File packagesDirectory, String filename) throws IOException, JDOMException {
        this.m_srcFile = new File(packagesDirectory, filename);
        if (this.m_srcFile.exists()) {
            ZipFile zipFile = new ZipFile(this.m_srcFile);
            Enumeration<? extends ZipEntry> myenum = zipFile.entries();
            while (myenum.hasMoreElements()) {
                SAXBuilder saxBuilder;
                ZipEntry zipEntry = myenum.nextElement();
                BufferedInputStream inStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                String name = zipEntry.getName();
                if (name.endsWith("plugins.xml")) {
                    saxBuilder = new SAXBuilder(false);
                    saxBuilder.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    saxBuilder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    saxBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                    this.m_pluginsXml = saxBuilder.build((InputStream)inStream);
                    ((InputStream)inStream).close();
                    continue;
                }
                if (name.endsWith("install.xml")) {
                    saxBuilder = new SAXBuilder(false);
                    saxBuilder.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    saxBuilder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    saxBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                    this.m_installXml = saxBuilder.build((InputStream)inStream);
                    ((InputStream)inStream).close();
                    continue;
                }
                if (name.toUpperCase().endsWith("MANIFEST.MF")) {
                    this.m_manifest = CustomNpmFile.parseManifest(inStream);
                    ((InputStream)inStream).close();
                    continue;
                }
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                FwUtils.copyData(inStream, outStream);
                byte[] bytes = outStream.toByteArray();
                this.addNpmEntry(zipEntry.getName(), bytes);
                ((InputStream)inStream).close();
            }
            zipFile.close();
        }
    }

    private static String nextVersion(String previousVersion) {
        if (previousVersion != null && previousVersion.length() > 0) {
            Version version = new Version(previousVersion);
            version.incrementVersion(0, 0, 1);
            return version.toString();
        }
        return "1.0.0";
    }

    private static Properties parseManifest(InputStream inputStream) {
        Properties properties = new Properties();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            String sLine = reader.readLine();
            while (null != sLine) {
                try {
                    int iIndex = sLine.indexOf(58);
                    String sKey = sLine.substring(0, iIndex);
                    String sValue = sLine.substring(iIndex + 1).trim();
                    properties.setProperty(sKey, sValue);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                sLine = reader.readLine();
            }
            reader.close();
        }
        catch (Exception e) {
            D.log("Error reading the manifest from custom.npm");
        }
        return properties;
    }

    public void addNpmEntry(String name, byte[] bytes) {
        this.m_entries.add(new Entry(name, bytes));
    }

    public void addNpmEntry(String name, InputStream stream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        FwUtils.copyData(stream, outputStream);
        this.m_entries.add(new Entry(name, outputStream.toByteArray()));
    }

    public void addPluginXml(Element element) {
        if (this.m_pluginsXml == null) {
            Element root = new Element("plugins");
            this.m_pluginsXml = new Document(root);
        }
        this.m_pluginsXml.getRootElement().addContent(element);
    }

    public boolean removePluginXml(String id) {
        return this.removeXmlImpl(id, this.m_pluginsXml);
    }

    public boolean removeInstallXml(String id) {
        return this.removeXmlImpl(id, this.m_installXml);
    }

    private boolean removeXmlImpl(String id, Document doc) {
        if (doc == null) {
            return true;
        }
        Element root = doc.getRootElement();
        List list = root.getChildren();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (!element.getChildTextTrim("id").equals(id)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public static Element makeModuleElement(String version) {
        Element module = new Element("module");
        module.addContent(TemplateBuilderUtils.newElement("id", "custom"));
        module.addContent(TemplateBuilderUtils.newElement("required-version", "2.0.0.0"));
        module.addContent(TemplateBuilderUtils.newElement("resource-properties-file", ""));
        module.addContent(TemplateBuilderUtils.newElement("version", version));
        module.addContent(TemplateBuilderUtils.newElement("description", ""));
        return module;
    }

    public void addInstallXml(Element task) {
        Element root;
        Element module;
        String version = this.getNextVersion().toString();
        if (this.m_installXml == null) {
            this.m_installXml = new Document(new Element("install"));
        }
        if ((module = (root = this.m_installXml.getRootElement()).getChild("module")) == null) {
            module = CustomNpmFile.makeModuleElement(version);
            root.addContent(module);
        } else {
            Element versionElement = module.getChild("version");
            if (versionElement != null) {
                versionElement.setText(version);
            } else {
                module.addContent(new Element("version").setText(version));
            }
        }
        root.addContent(task);
    }

    public void writeFile() throws IOException {
        this.writeFile(false);
    }

    public Version getNextVersion() {
        if (this.m_manifest != null) {
            String versionString = CustomNpmFile.nextVersion(this.m_manifest.getProperty("Implementation-Version"));
            return new Version(versionString);
        }
        return new Version("1.0.0");
    }

    public void writeFile(boolean addOn) throws IOException {
        ZipOutputStream outStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.m_srcFile)));
        String version = "1.0.0";
        if (this.m_manifest != null) {
            version = CustomNpmFile.nextVersion(this.m_manifest.getProperty("Implementation-Version"));
        }
        String name = "META-INF/MANIFEST.MF";
        outStream.putNextEntry(new ZipEntry(name));
        PrintWriter pw = new PrintWriter(outStream);
        pw.println("Module-ID: custom");
        pw.println("Implementation-Title: Custom Plugins");
        pw.println("Implementation-Description: Custom plugins created using iManager development tools.");
        pw.println("Implementation-Version: " + version);
        pw.println("Min-iManager-Version:2.7.0");
        pw.flush();
        outStream.closeEntry();
        for (Entry entry : this.m_entries) {
            outStream.putNextEntry(new ZipEntry(entry.m_name));
            ByteArrayInputStream inStream = new ByteArrayInputStream(entry.m_bytes);
            FwUtils.copyData(inStream, outStream);
            outStream.closeEntry();
        }
        XMLOutputter outputter = new XMLOutputter("   ", true);
        outputter.setLineSeparator(System.getProperty("line.separator"));
        outputter.setTrimAllWhite(true);
        if (addOn) {
            CustomNpmFile.outputXml(outputter, outStream, this.m_installXml, "currentwebapp/portal/modules/custom/install/install" + TemplateBuilderUtils.getDatePostfix() + ".xml", "install");
            CustomNpmFile.outputXml(outputter, outStream, this.m_pluginsXml, "currentwebapp/portal/modules/custom/plugins/plugins" + TemplateBuilderUtils.getDatePostfix() + ".xml", "plugins");
        } else {
            CustomNpmFile.outputXml(outputter, outStream, this.m_installXml, "currentwebapp/portal/modules/custom/install/install.xml", "install");
            CustomNpmFile.outputXml(outputter, outStream, this.m_pluginsXml, "currentwebapp/portal/modules/custom/plugins/plugins.xml", "plugins");
        }
        outStream.close();
    }

    private static void outputXml(XMLOutputter outputter, ZipOutputStream outStream, Document doc, String path, String rootName) throws IOException {
        if (doc == null) {
            Element root = new Element(rootName);
            doc = new Document(root);
        }
        outStream.putNextEntry(new ZipEntry(path));
        outputter.output(doc, (OutputStream)outStream);
        outStream.closeEntry();
    }

    public static Element findPlugin(File customXmlFile, String pageId) throws IOException, JDOMException {
        FileInputStream fis = null;
        String pluginsDirStr = customXmlFile.getParent();
        File pluginsDir = new File(pluginsDirStr);
        if (pluginsDir.isDirectory()) {
            File[] f = pluginsDir.listFiles();
            for (int i = 0; i < f.length; ++i) {
                if (!f[i].getName().endsWith(".xml")) continue;
                fis = new FileInputStream(f[i]);
                BufferedInputStream inStream = new BufferedInputStream(fis);
                SAXBuilder saxBuilder = new SAXBuilder(false);
                saxBuilder.setFeature("http://xml.org/sax/features/external-general-entities", false);
                saxBuilder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                saxBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                Document pluginsDoc = saxBuilder.build((InputStream)inStream);
                inStream.close();
                fis.close();
                Element pluginElement = CustomNpmFile.findPluginXmlImpl(pluginsDoc.getRootElement(), pageId);
                if (pluginElement == null) continue;
                return pluginElement;
            }
        }
        return null;
    }

    private static Element findPluginXmlImpl(Element root, String pageId) {
        List list = root.getChildren();
        for (Element element : list) {
            String id = element.getChildTextTrim("id");
            if (id == null || !id.equals(pageId)) continue;
            return element;
        }
        return null;
    }

    public Element findPluginXml(String pluginId) {
        if (this.m_pluginsXml == null) {
            return null;
        }
        return CustomNpmFile.findPluginXmlImpl(this.m_pluginsXml.getRootElement(), pluginId);
    }

    public Element findInstallXml(String pluginId) {
        if (this.m_installXml == null) {
            return null;
        }
        return CustomNpmFile.findPluginXmlImpl(this.m_installXml.getRootElement(), pluginId);
    }

    public void removeEntry(String name) {
        Iterator iter = this.m_entries.iterator();
        while (iter.hasNext()) {
            Entry entry = (Entry)iter.next();
            if (entry.m_name.indexOf(name) == -1) continue;
            iter.remove();
            return;
        }
    }
}

