/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.PluginException;
import com.novell.emframe.dev.config.ConfigException;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.nps.WebappUtil;
import com.novell.nps.debug.DebugLogEvent;
import com.novell.nps.event.PortalEvent;
import com.novell.nps.event.PortalEventListener;
import com.novell.nps.event.PortalEventManager;
import com.novell.webaccess.common.JSPConduit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class DebugLogging
implements PortalEventListener {
    private static final String LOGGING_PRIORITY = "System.Logging.Priority";
    private static final String LOGGING_FILE = "System.Logging.File";
    private static final String LOGGING_OUTPUT = "System.Logging.Output";
    private static final String DEFAULT_LOGGING_FILE = "debug.html";
    private static boolean m_bLog = false;
    private static boolean m_bOutputFile = true;
    private static boolean m_bOutputErr = false;
    private static boolean m_bOutputOut = true;
    private static int m_iLevel = 1;
    private static String m_sFile = "debug.html";
    private static File m_fLog = null;
    private static PrintWriter m_p = null;
    private static HashMap m_hmModules = null;
    private static String m_lineColor = "#f5f5f5";
    private static DebugLogging theDebugInstance = null;

    private DebugLogging() {
    }

    public static void init() {
        SystemConfig config;
        String sSetting = null;
        if (theDebugInstance == null) {
            theDebugInstance = new DebugLogging();
            PortalEventManager.registerEventListener((PortalEventListener)theDebugInstance, (String)"com.novell.nps.debug.DebugLogEvent");
        }
        if ((sSetting = (config = new SystemConfig()).getSetting(LOGGING_FILE)) != null) {
            m_sFile = sSetting;
        }
        ServletContext sc = WebappUtil.getStaticServletContext();
        String sPath = null;
        sPath = sc != null ? WebappUtil.getRealPath((String)"/WEB-INF/logs") + "/" + m_sFile : m_sFile;
        m_fLog = new File(sPath);
        sSetting = config.getSetting(LOGGING_PRIORITY);
        if (sSetting != null) {
            try {
                m_iLevel = Integer.parseInt(sSetting);
                m_bLog = m_iLevel > 0;
            }
            catch (NumberFormatException e) {
                D.log("Error reading System.Logging.Priority", 2);
                D.log(e);
            }
        }
        String[] settings = config.getSettings(LOGGING_OUTPUT);
        for (int i = 0; settings != null && i < settings.length; ++i) {
            String string = settings[i];
            if (string.equalsIgnoreCase("err")) {
                m_bOutputErr = true;
            }
            if (string.equalsIgnoreCase("out")) {
                m_bOutputOut = true;
            }
            if (!string.equalsIgnoreCase("file")) continue;
            m_bOutputFile = true;
        }
        DebugLogging.start();
    }

    public static void saveToConfig(SystemConfig config) throws ConfigException {
        config.setSetting(LOGGING_PRIORITY, String.valueOf(m_iLevel));
        Vector<String> vOutputs = new Vector<String>();
        if (m_bOutputErr) {
            vOutputs.add("err");
        }
        if (m_bOutputOut) {
            vOutputs.add("out");
        }
        if (m_bOutputFile) {
            vOutputs.add("file");
        }
        String[] saOutputs = new String[1];
        config.setSetting(LOGGING_OUTPUT, vOutputs.toArray(saOutputs));
        config.writeSettings();
    }

    public static boolean isLoggable(int iLevel) {
        boolean bRet = false;
        if (m_bLog && iLevel <= m_iLevel) {
            bRet = true;
        }
        return bRet;
    }

    public static void log(HttpServletRequest req) {
        String logMsg = req.getParameter("logMsg");
        String fw_fromId = req.getParameter("fw_fromId");
        String taskId = req.getParameter("taskId");
        if (logMsg != null && D.isDebugEnabled(3)) {
            PortalEventManager.postEvent((PortalEvent)new DebugLogEvent(3, taskId + "jslog..from" + fw_fromId + "..>>>>", logMsg + "<<<<", null));
        }
    }

    protected void writeDebugLogEvent(DebugLogEvent debugEvent) {
        if (DebugLogging.isLoggable(debugEvent.getDebugLevel())) {
            StringBuffer sb;
            String infoColor;
            switch (debugEvent.getDebugLevel()) {
                case 1: {
                    infoColor = "red";
                    break;
                }
                case 2: {
                    infoColor = "darkblue";
                    break;
                }
                default: {
                    infoColor = "green";
                }
            }
            String sourceTag = debugEvent.getSourceTag();
            String timeTag = debugEvent.getTimeTag();
            String errStr = debugEvent.toString();
            if (m_hmModules != null && m_hmModules.size() > 0 && m_hmModules.get(sourceTag) == null) {
                return;
            }
            if (m_bOutputFile && m_p != null) {
                Throwable e = debugEvent.getException();
                StringBuffer sb2 = new StringBuffer();
                if (e == null) {
                    m_lineColor = m_lineColor.equals("#f5f5f5") ? "#ffffff" : "#f5f5f5";
                    sb2.append("<tr class='rule2' bgcolor='").append(m_lineColor).append("'>");
                    sb2.append("<td class='nonproportional' style='font-size:.6em; color:").append(infoColor).append("'><nobr>").append(timeTag).append("</nobr></td>");
                    sb2.append("<td class='nonproportional' style='font-size:.6em; color:").append(infoColor).append("'>").append(sourceTag).append("</td>");
                    sb2.append("<td class='nonproportional' style='padding-left:20px'>").append(JSPConduit.toHTML(errStr)).append("</td>");
                    sb2.append("</tr>");
                    m_p.println(sb2.toString());
                } else {
                    m_lineColor = m_lineColor.equals("#f5f5f5") ? "#ffffff" : "#f5f5f5";
                    sb2 = new StringBuffer();
                    sb2.append("<tr class='rule2' bgcolor='").append(m_lineColor).append("'>");
                    sb2.append("<td class='nonproportional' style='font-size:.6em; color:red'><nobr>").append(timeTag).append("</nobr></td>");
                    sb2.append("<td class='nonproportional' style='font-size:.6em; color:red'>").append(sourceTag).append("</td>");
                    sb2.append("<td class='nonproportional' style='font-size:.8em; line-height:1.1em; padding-left:20px; color:red'><pre>");
                    m_p.println(sb2.toString());
                    StringWriter errors = new StringWriter();
                    e.printStackTrace(new PrintWriter(errors));
                    m_p.println(JSPConduit.toHTML(errors.toString()) + "</pre></td></tr>");
                }
            }
            if (m_bOutputErr) {
                sb = new StringBuffer(timeTag);
                sb.append("  ");
                sb.append(sourceTag);
                sb.append("::");
                sb.append(JSPConduit.toHTML(errStr));
                System.err.println(sb.toString());
                Throwable e = debugEvent.getException();
                if (e != null) {
                    while (e instanceof PluginException && ((PluginException)e).getException() != null) {
                        e = ((PluginException)e).getException();
                    }
                    try {
                        Method m;
                        Throwable rootCause;
                        if (e.getClass().getName().equals("org.apache.jasper.JasperException") && (rootCause = (Throwable)(m = e.getClass().getMethod("getRootCause", new Class[0])).invoke((Object)e, new Object[0])) != null) {
                            e = rootCause;
                        }
                    }
                    catch (Throwable m) {
                        // empty catch block
                    }
                    e.printStackTrace(System.err);
                }
            }
            if (m_bOutputOut) {
                sb = new StringBuffer(errStr);
                int i = sb.indexOf("\n", 0);
                while (i > -1) {
                    sb.insert(i + 1, "                         ");
                    i += 3;
                    i = sb.indexOf("\n", i);
                }
                System.out.println(JSPConduit.toHTML(sourceTag + sb.toString()));
                Throwable e = debugEvent.getException();
                if (e != null) {
                    e.printStackTrace(System.out);
                }
            }
        }
    }

    public static void start() {
        if (m_bOutputFile) {
            try {
                FileOutputStream fos = new FileOutputStream(m_fLog.getPath(), true);
                m_p = new PrintWriter(new OutputStreamWriter((OutputStream)fos, "UTF8"));
                if (m_fLog.length() == 0L) {
                    m_p.println("<table border='0' cellpadding='3' cellspacing='0'>");
                    m_p.println("<tr class='rule2' bgcolor='#EFEEE9'>");
                    m_p.println("   <td style='font-size:.9em; padding-top: 3px; border-top: 1px solid #babdb6'><b>Time</b></td>");
                    m_p.println("   <td style='font-size:.9em; padding-top: 3px; border-top: 1px solid #babdb6'><b>Source</b></td>");
                    m_p.println("   <td style='font-size:.9em; padding-top: 3px; border-top: 1px solid #babdb6; padding-left:20px'><b>Message</b></td>");
                    m_p.println("</tr>");
                }
            }
            catch (IOException ioe) {
                m_bOutputFile = false;
                System.err.println("Unable to open logging file:");
                System.err.print(ioe.toString());
            }
        }
    }

    public static void stop() {
        if (m_bLog && m_p != null) {
            m_p.flush();
            m_p.close();
            m_p = null;
        }
    }

    public static void flush() {
        if (m_bLog && m_p != null) {
            m_p.flush();
        }
    }

    public static void deinit() {
        DebugLogging.stop();
        m_bLog = false;
    }

    static void copyData(Reader source, Writer dest) throws IOException {
        int bCnt;
        char[] data = new char[1000];
        while ((bCnt = source.read(data, 0, 1000)) != -1) {
            dest.write(data, 0, bCnt);
        }
    }

    public static void writeDebugLogToWriter(Writer out) {
        String sFile = DebugLogging.getLogFileName();
        if (sFile != null && sFile.length() != 0) {
            DebugLogging.stop();
            try {
                BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sFile), "UTF8"));
                DebugLogging.copyData(input, out);
                input.close();
            }
            catch (IOException ex) {
                D.log(ex);
            }
            finally {
                DebugLogging.start();
            }
        }
    }

    public void onPortalEvent(PortalEvent event) {
        this.writeDebugLogEvent((DebugLogEvent)event);
    }

    public static boolean getLoggingToFile() {
        return m_bOutputFile;
    }

    public static void setLoggingToFile(boolean bSet) {
        m_bOutputFile = bSet;
    }

    public static boolean getLoggingToErr() {
        return m_bOutputErr;
    }

    public static void setLoggingToErr(boolean bSet) {
        m_bOutputErr = bSet;
    }

    public static boolean getLoggingToOut() {
        return m_bOutputOut;
    }

    public static void setLoggingToOut(boolean bSet) {
        m_bOutputOut = bSet;
    }

    public static int getLoggingLevel() {
        return m_iLevel;
    }

    public static void setLoggingLevel(int iLevel) {
        m_iLevel = iLevel;
    }

    public static String getLogFileName() {
        if (m_fLog != null) {
            return m_fLog.getPath();
        }
        return null;
    }

    public static long getLogFileSize() {
        if (m_fLog != null) {
            DebugLogging.flush();
            return m_fLog.length();
        }
        return 0L;
    }
}

