/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.DateValue;
import com.novell.admin.ns.HexValue;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.Value;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ldap.LDAPSyntax;
import com.novell.admin.ns.nds.BackLinkFacade;
import com.novell.admin.ns.nds.CaseIgnoreListFacade;
import com.novell.admin.ns.nds.EmailAddressFacade;
import com.novell.admin.ns.nds.FaxNumberFacade;
import com.novell.admin.ns.nds.HoldFacade;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.admin.ns.nds.NetAddressFacade;
import com.novell.admin.ns.nds.ObjectACLFacade;
import com.novell.admin.ns.nds.OctetListFacade;
import com.novell.admin.ns.nds.PathFacade;
import com.novell.admin.ns.nds.PostalAddressFacade;
import com.novell.admin.ns.nds.ReplicaPointerFacade;
import com.novell.admin.ns.nds.TimeStampFacade;
import com.novell.admin.ns.nds.TypedNameFacade;
import com.novell.admin.ns.nds.UnknownFacade;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DataHandlerHelper;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.XmlUtils;
import com.novell.emframe.dev.eDirAccessServiceException;
import com.novell.emframe.fw.FwUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Element;

public class DefaultSyntaxHandler
extends DataHandlerHelper {
    @Override
    protected void valueComponentToXml(ValueComponent vc, StringBuffer resultValue, String attrName, Syntax syntax) throws eDirAccessServiceException {
        resultValue.append("<value>");
        if (vc instanceof Value) {
            this.vcToXmlSimple(resultValue, vc, attrName);
        } else if (vc instanceof ValueList) {
            this.vcToXmlComplex(syntax, vc, resultValue);
        }
        resultValue.append("</value>");
    }

    private final void vcToXmlComplex(Syntax syntax, ValueComponent vc, StringBuffer resultValue) {
        if (syntax == NDSSyntax.SYN_BACK_LINK || syntax == LDAPSyntax.SYN_TAGGED_NAME) {
            long aLong = ((BackLinkFacade)((ValueList)vc).createFacade()).getRemoteId();
            resultValue.append("<remote-id>" + aLong + "</remote-id>");
            String value = ((BackLinkFacade)((ValueList)vc).createFacade()).getObjectName();
            resultValue.append("<object-name>" + XmlUtils.xmlEncode(value) + "</object-name>");
        } else if (syntax == NDSSyntax.SYN_CI_LIST || syntax == LDAPSyntax.SYN_CI_LIST) {
            String[] strList = ((CaseIgnoreListFacade)((ValueList)vc).createFacade()).getStrings();
            if (strList.length > 0) {
                resultValue.append(XmlUtils.xmlEncode(strList[0]));
            }
            for (int i = 1; i < strList.length; ++i) {
                resultValue.append("</value><value>");
                resultValue.append(XmlUtils.xmlEncode(strList[i]));
            }
        } else if (syntax == NDSSyntax.SYN_EMAIL_ADDRESS || syntax == LDAPSyntax.SYN_TAGGED_STRING) {
            String value = ((EmailAddressFacade)((ValueList)vc).createFacade()).getAddress();
            resultValue.append(XmlUtils.xmlEncode(value));
        } else if (syntax == NDSSyntax.SYN_FAX_NUMBER || syntax == LDAPSyntax.SYN_FAX_NUMBER) {
            String value = ((FaxNumberFacade)((ValueList)vc).createFacade()).getTeleNumber();
            resultValue.append(XmlUtils.xmlEncode(value));
        } else if (syntax == NDSSyntax.SYN_HOLD) {
            int aInt = ((HoldFacade)((ValueList)vc).createFacade()).getAmount();
            resultValue.append("<amount>" + aInt + "</amount>");
            String value = ((HoldFacade)((ValueList)vc).createFacade()).getSubject();
            resultValue.append("<subject>" + XmlUtils.xmlEncode(value) + "</subject>");
        } else if (syntax == NDSSyntax.SYN_OBJECT_ACL || syntax == LDAPSyntax.SYN_NDS_ACL) {
            long aLong = ((ObjectACLFacade)((ValueList)vc).createFacade()).getPrivileges();
            resultValue.append("<privileges>" + aLong + "</privileges>");
            String value = ((ObjectACLFacade)((ValueList)vc).createFacade()).getProtectedAttrName();
            resultValue.append("<protected-attr-name>" + XmlUtils.xmlEncode(value) + "</protected-attr-name>");
            value = ((ObjectACLFacade)((ValueList)vc).createFacade()).getSubjectName();
            resultValue.append("<subject>" + XmlUtils.xmlEncode(value) + "</subject>");
        } else if (syntax == LDAPSyntax.SYN_NVDS_ACL) {
            ObjectACLFacade fac = (ObjectACLFacade)((ValueList)vc).createFacade();
            long aLong = fac.getNVDSPrivileges();
            resultValue.append("<nvds-privileges>" + aLong + "</nvds-privileges>");
            aLong = fac.getNVDSModifier();
            resultValue.append("<nvds-modifier>" + aLong + "</nvds-modifier>");
            String value = fac.getNVDSTrustee();
            resultValue.append("<nvds-trustee>" + XmlUtils.xmlEncode(value) + "</nvds-trustee>");
            value = fac.getNVDSFilter();
            resultValue.append("<nvds-filter>" + XmlUtils.xmlEncode(value) + "</nvds-filter>");
            value = fac.getNVDSScope();
            resultValue.append("<nvds-scope>" + XmlUtils.xmlEncode(value) + "</nvds-scope>");
            value = fac.getNVDSClassName();
            resultValue.append("<nvds-classname>" + XmlUtils.xmlEncode(value) + "</nvds-classname>");
            value = fac.getNVDSAttributeName();
            resultValue.append("<nvds-attributename>" + XmlUtils.xmlEncode(value) + "</nvds-attributename>");
        } else if (syntax == NDSSyntax.SYN_OCTET_LIST || syntax == LDAPSyntax.SYN_OCTET_LIST) {
            byte[][] theByteList = ((OctetListFacade)((ValueList)vc).createFacade()).getOctets();
            for (int i = 0; i < theByteList.length; ++i) {
                String value = new String(theByteList[i]);
                resultValue.append("<item>" + XmlUtils.xmlEncode(value) + "</item>");
            }
        } else if (syntax == NDSSyntax.SYN_PATH || syntax == LDAPSyntax.SYN_TAGGED_NAME_AND_STRING) {
            long aLong = ((PathFacade)((ValueList)vc).createFacade()).getType();
            resultValue.append("<type>" + aLong + "</type>");
            String value = ((PathFacade)((ValueList)vc).createFacade()).getVolume();
            resultValue.append("<volume>" + XmlUtils.xmlEncode(value) + "</volume>");
            value = ((PathFacade)((ValueList)vc).createFacade()).getPath();
            resultValue.append("<path>" + XmlUtils.xmlEncode(value) + "</path>");
        } else if (syntax == NDSSyntax.SYN_PO_ADDRESS || syntax == LDAPSyntax.SYN_POSTAL_ADDRESS) {
            String[] strList = ((PostalAddressFacade)((ValueList)vc).createFacade()).getLines();
            for (int i = 0; i < strList.length; ++i) {
                resultValue.append("<item>" + XmlUtils.xmlEncode(strList[i]) + "</item>");
            }
        } else if (syntax == NDSSyntax.SYN_REPLICA_POINTER || syntax == LDAPSyntax.SYN_NDS_REPLICA_POINTER) {
            long aLong = ((ReplicaPointerFacade)((ValueList)vc).createFacade()).getReplicaType();
            resultValue.append("<replica-type>" + aLong + "</replica-type>");
            aLong = ((ReplicaPointerFacade)((ValueList)vc).createFacade()).getReplicaCount();
            resultValue.append("<replica-count>" + aLong + "</replica-count>");
            aLong = ((ReplicaPointerFacade)((ValueList)vc).createFacade()).getReplicaNumber();
            resultValue.append("<replica-number>" + aLong + "</replica-number>");
            String value = ((ReplicaPointerFacade)((ValueList)vc).createFacade()).getServerName();
            resultValue.append("<server-name>" + XmlUtils.xmlEncode(value) + "</server-name>");
            NetAddressFacade nFacade = ((ReplicaPointerFacade)((ValueList)vc).createFacade()).getNetworkAddressHint();
            resultValue.append("<net-address-hint>");
            aLong = nFacade.getAddressType();
            resultValue.append("<address-type>" + aLong + "</address-type>");
            byte[] bytes = nFacade.getAddress();
            value = new String(bytes);
            resultValue.append("<address>" + XmlUtils.xmlEncode(value) + "</address>");
            value = nFacade.getAddressString();
            resultValue.append("<address-string>" + XmlUtils.xmlEncode(value) + "</address-string>");
            resultValue.append("</net-address-hint>");
        } else if (syntax == NDSSyntax.SYN_TIMESTAMP || syntax == LDAPSyntax.SYN_NDS_TIMESTAMP) {
            long aInt = ((TimeStampFacade)((ValueList)vc).createFacade()).getSeconds();
            resultValue.append("<seconds>" + aInt + "</seconds>");
            aInt = ((TimeStampFacade)((ValueList)vc).createFacade()).getReplica();
            resultValue.append("<replica>" + aInt + "</replica>");
            aInt = ((TimeStampFacade)((ValueList)vc).createFacade()).getEvent();
            resultValue.append("<event>" + aInt + "</event>");
        } else if (syntax == NDSSyntax.SYN_TYPED_NAME || syntax == LDAPSyntax.SYN_TYPED_NAME || syntax == LDAPSyntax.SYN_NVDS_TYPED_NAME) {
            String value = ((TypedNameFacade)((ValueList)vc).createFacade()).getObject();
            resultValue.append("<distinguished-name>" + XmlUtils.xmlEncode(value) + "</distinguished-name>");
            long aLong = ((TypedNameFacade)((ValueList)vc).createFacade()).getLevel();
            resultValue.append("<level>" + aLong + "</level>");
            aLong = ((TypedNameFacade)((ValueList)vc).createFacade()).getInterval();
            resultValue.append("<interval>" + aLong + "</interval>");
        } else if (syntax == NDSSyntax.SYN_UNKNOWN || syntax == LDAPSyntax.SYN_UNKNOWN) {
            String value = ((UnknownFacade)((ValueList)vc).createFacade()).getAttributeName();
            resultValue.append("<attribute-name>" + XmlUtils.xmlEncode(value) + "</attribute-name>");
            int aInt = ((UnknownFacade)((ValueList)vc).createFacade()).getSyntaxId();
            resultValue.append("<syntax-id>" + aInt + "</syntax-id>");
            byte[] bytes = ((UnknownFacade)((ValueList)vc).createFacade()).getBytes();
            value = new String(bytes);
            resultValue.append("<bytes>" + XmlUtils.xmlEncode(value) + "</bytes>");
        }
    }

    private void vcToXmlSimple(StringBuffer sb, ValueComponent vc, String attrName) throws eDirAccessServiceException {
        String value;
        if (vc instanceof HexValue) {
            byte[] bytes = ((HexValue)vc).getValue();
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < bytes.length; ++i) {
                String hex;
                int val = bytes[i];
                if (val < 0) {
                    val += 256;
                }
                if ((hex = Integer.toHexString(val)).length() == 1) {
                    hexString.append("0");
                }
                hexString.append(hex.toUpperCase());
            }
            value = hexString.toString();
            if (((HexValue)vc).isInteger64()) {
                ByteBuffer bfRev = ByteBuffer.allocate(8);
                bfRev.put(bytes);
                value = Long.toString(bfRev.getLong(0));
            }
        } else if (vc instanceof DateValue) {
            Date theDate = ((DateValue)vc).getValue();
            value = Long.toString(theDate.getTime());
        } else {
            value = vc.toString();
        }
        String encodedValue = XmlUtils.xmlEncode(value);
        sb.append(encodedValue);
    }

    @Override
    protected ValueComponent xmlToValueComponent(AttributeDefinition attributeDefinition, Element xml, MContext context) throws ComponentCreationException, IncompatibleComponentException, eDirAccessServiceException {
        Syntax syntax = attributeDefinition.getSyntax();
        ValueComponent vc = null;
        if (syntax == NDSSyntax.SYN_CI_STRING || syntax == LDAPSyntax.SYN_CI_STRING || syntax == LDAPSyntax.SYN_ATTRIBUTE_TYPE_DESCRIPTION || syntax == LDAPSyntax.SYN_COUNTRY_STRING || syntax == LDAPSyntax.SYN_DELIVERY_METHOD || syntax == LDAPSyntax.SYN_DIRECTORY_STRING || syntax == LDAPSyntax.SYN_DIT_CONTENT_RULE_DESCRIPTION || syntax == LDAPSyntax.SYN_DIT_STRUCTURAL_RULE_DESCRIPT || syntax == LDAPSyntax.SYN_GUIDE || syntax == LDAPSyntax.SYN_MATCHING_RULE_DESCRIPTION || syntax == LDAPSyntax.SYN_MATCHING_RULE_USE_DESCRIPTION || syntax == LDAPSyntax.SYN_MAIL_PREFERENCE || syntax == LDAPSyntax.SYN_MHS_OR_ADDRESS || syntax == LDAPSyntax.SYN_NAME_UID || syntax == LDAPSyntax.SYN_NAME_FORM_DESCRIPTION || syntax == LDAPSyntax.SYN_OBJECT_CLASS_DESCRIPTION || syntax == LDAPSyntax.SYN_OID || syntax == LDAPSyntax.SYN_OTHER_MAILBOX) {
            vc = syntax.createValueComponent((Object)xml.getText());
        } else if (syntax == NDSSyntax.SYN_CE_STRING || syntax == LDAPSyntax.SYN_IA5_STRING) {
            vc = syntax.createValueComponent((Object)xml.getText());
        } else if (syntax == NDSSyntax.SYN_BOOLEAN || syntax == LDAPSyntax.SYN_BOOLEAN) {
            vc = syntax.createValueComponent((Object)xml.getText());
        } else if (syntax == NDSSyntax.SYN_CI_LIST || syntax == LDAPSyntax.SYN_CI_LIST) {
            List theElements = xml.getChildren("item");
            ListIterator iter = theElements.listIterator();
            String[] items = new String[theElements.size()];
            int i = 0;
            while (iter.hasNext()) {
                Element element = (Element)iter.next();
                items[i++] = element.getText();
            }
            vc = CaseIgnoreListFacade.createValueList((String[])items, (Syntax)syntax);
        } else if (syntax == NDSSyntax.SYN_BACK_LINK || syntax == LDAPSyntax.SYN_TAGGED_NAME) {
            String objectName = xml.getChildTextTrim("object-name");
            long remoteId = Long.parseLong(xml.getChildTextTrim("remote-id"));
            vc = BackLinkFacade.createValueList((String)objectName, (long)remoteId, (Syntax)syntax);
        } else if (syntax == NDSSyntax.SYN_CLASS_NAME || syntax == LDAPSyntax.SYN_CLASS_NAME) {
            vc = syntax.createValueComponent((Object)xml.getText());
        } else if (syntax == NDSSyntax.SYN_COUNTER || syntax == LDAPSyntax.SYN_COUNTER) {
            String val = xml.getTextTrim();
            if (val.charAt(0) == '+') {
                val = val.substring(1);
            }
            vc = syntax.createValueComponent((Object)val);
        } else if (syntax == NDSSyntax.SYN_DIST_NAME || syntax == LDAPSyntax.SYN_DN) {
            vc = syntax.createValueComponent((Object)xml.getText());
        } else if (syntax == NDSSyntax.SYN_EMAIL_ADDRESS || syntax == LDAPSyntax.SYN_TAGGED_STRING) {
            vc = EmailAddressFacade.createValueList((long)0L, (String)xml.getText(), (Syntax)syntax);
        } else if (syntax == NDSSyntax.SYN_FAX_NUMBER || syntax == LDAPSyntax.SYN_FAX_NUMBER) {
            vc = FaxNumberFacade.createValueList((long)0L, (String)xml.getText(), (Syntax)syntax);
        } else if (syntax == NDSSyntax.SYN_HOLD) {
            String subject = xml.getChildTextTrim("subject");
            long amount = Long.parseLong(xml.getChildTextTrim("amount"));
            vc = HoldFacade.createValueList((String)subject, (long)amount);
        } else if (syntax == NDSSyntax.SYN_INTEGER || syntax == LDAPSyntax.SYN_INTEGER) {
            String val = xml.getTextTrim();
            if (val.charAt(0) == '+') {
                val = val.substring(1);
            }
            vc = syntax.createValueComponent((Object)val);
        } else if (syntax == NDSSyntax.SYN_INTERVAL) {
            String val = xml.getTextTrim();
            if (val.charAt(0) == '+') {
                val = val.substring(1);
            }
            vc = syntax.createValueComponent((Object)val);
        } else if (syntax == NDSSyntax.SYN_TEL_NUMBER || syntax == LDAPSyntax.SYN_TELEPHONE_NUMBER) {
            vc = syntax.createValueComponent((Object)xml.getText());
        } else if (syntax == NDSSyntax.SYN_TIME || syntax == LDAPSyntax.SYN_GENERALIZEDTIME) {
            vc = syntax.createValueComponent((Object)new Date(Long.parseLong(xml.getText())));
        } else if (syntax == NDSSyntax.SYN_TYPED_NAME || syntax == LDAPSyntax.SYN_TYPED_NAME || syntax == LDAPSyntax.SYN_NVDS_TYPED_NAME) {
            vc = TypedNameFacade.createValueList((String)xml.getChildTextTrim("distinguished-name"), (long)Long.parseLong(xml.getChildTextTrim("level")), (long)Long.parseLong(xml.getChildTextTrim("interval")), (Syntax)syntax);
        } else if (syntax != NDSSyntax.SYN_NET_ADDRESS && syntax != LDAPSyntax.SYN_NET_ADDRESS) {
            if (syntax == NDSSyntax.SYN_NU_STRING || syntax == LDAPSyntax.SYN_NUMERIC_STRING) {
                vc = syntax.createValueComponent((Object)xml.getText());
            } else if (syntax == NDSSyntax.SYN_OBJECT_ACL || syntax == LDAPSyntax.SYN_NDS_ACL) {
                String subject = xml.getChildTextTrim("subject");
                long privileges = Long.parseLong(xml.getChildTextTrim("privileges"));
                String attributeName = xml.getChildTextTrim("protected-attr-name");
                vc = ObjectACLFacade.createValueList((String)attributeName, (String)subject, (long)privileges, (Syntax)syntax);
            } else if (syntax == LDAPSyntax.SYN_NVDS_ACL) {
                long privileges = 0L;
                String str = xml.getChildTextTrim("nvds-privileges");
                if (str != null) {
                    privileges = Long.parseLong(str);
                }
                long modifier = 0L;
                str = xml.getChildTextTrim("nvds-modifier");
                if (str != null) {
                    modifier = Long.parseLong(str);
                }
                String trustee = xml.getChildTextTrim("nvds-trustee");
                String filter = xml.getChildTextTrim("nvds-filter");
                String scope = xml.getChildTextTrim("nvds-scope");
                String classname = xml.getChildTextTrim("nvds-classname");
                String attributename = xml.getChildTextTrim("nvds-attributename");
                vc = ObjectACLFacade.createValueList((long)privileges, (long)modifier, (String)trustee, (String)filter, (String)scope, (String)classname, (String)attributename, (Syntax)syntax);
            } else if (syntax == NDSSyntax.SYN_OCTET_LIST || syntax == LDAPSyntax.SYN_OCTET_LIST) {
                List theElements = xml.getChildren("item");
                Element tempElem = null;
                byte[][] theBytes = new byte[theElements.size()][];
                for (int i = 0; i < theElements.size(); ++i) {
                    tempElem = (Element)theElements.get(i);
                    theBytes[i] = new String(tempElem.getText()).getBytes();
                }
                vc = OctetListFacade.createValueList((byte[][])theBytes, (Syntax)syntax);
            } else if (syntax == NDSSyntax.SYN_OCTET_STRING || syntax == LDAPSyntax.SYN_ACI || syntax == LDAPSyntax.SYN_ACCESS_POINT || syntax == LDAPSyntax.SYN_AUDIO || syntax == LDAPSyntax.SYN_BIT_STRING || syntax == LDAPSyntax.SYN_CERTIFICATE || syntax == LDAPSyntax.SYN_CERTIFICATE_LIST || syntax == LDAPSyntax.SYN_CERTIFICATE_PAIR || syntax == LDAPSyntax.SYN_DATA_QUALITY_SYNTAX || syntax == LDAPSyntax.SYN_DL_SUBMIT_PERMISSION || syntax == LDAPSyntax.SYN_DSA_QUALITY_SYNTAX || syntax == LDAPSyntax.SYN_DSE_TYPE || syntax == LDAPSyntax.SYN_ENHANCED_GUIDE || syntax == LDAPSyntax.SYN_FAX || syntax == LDAPSyntax.SYN_JPEG || syntax == LDAPSyntax.SYN_MASTER_SHADOW_ACCESS_POINTS || syntax == LDAPSyntax.SYN_OCTET_STRING || syntax == LDAPSyntax.SYN_PRESENTATION_ADDRESS || syntax == LDAPSyntax.SYN_PROTOCOL_INFORMATION || syntax == LDAPSyntax.SYN_SUBTREE_SPECIFICATION || syntax == LDAPSyntax.SYN_SUPPLIER_INFORMATION || syntax == LDAPSyntax.SYN_SUPPLIER_OR_CONSUMER || syntax == LDAPSyntax.SYN_SUPPLIER_AND_CONSUMER || syntax == LDAPSyntax.SYN_SUPPORTED_ALGORITHM || syntax == LDAPSyntax.SYN_TELETEX_TERMINAL_IDENTIFIER || syntax == LDAPSyntax.SYN_TELEX_NUMBER || syntax == LDAPSyntax.SYN_UTC_TIME) {
                String src = xml.getAttributeValue("src");
                if (src != null && src.equals("file-upload")) {
                    String paramName = xml.getAttributeValue("fileParam");
                    HttpServletRequest req = context.getRequest();
                    String fileName = req.getParameter(paramName);
                    try {
                        BufferedInputStream in = new BufferedInputStream(new FileInputStream(FwUtils.getTempFilesPath(context.getWebappHome()) + "/tempFiles/" + fileName));
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        FwUtils.copyData(in, out);
                        vc = syntax.createValueComponent((Object)out.toByteArray());
                    }
                    catch (IOException e) {
                        throw new eDirAccessServiceException(e);
                    }
                }
                String hexString = xml.getText();
                byte[] bytes = new byte[hexString.length() / 2];
                try {
                    for (int i = 0; i < bytes.length; ++i) {
                        bytes[i] = (byte)Integer.parseInt(hexString.substring(i * 2, i * 2 + 2), 16);
                    }
                }
                catch (NumberFormatException e) {
                    D.log(e);
                }
                vc = syntax.createValueComponent((Object)bytes);
            } else if (syntax == NDSSyntax.SYN_INTEGER_64) {
                String val = xml.getText();
                if (val.charAt(0) == '+') {
                    val = val.substring(1);
                }
                ByteBuffer bf = ByteBuffer.allocate(8);
                bf.putLong(Long.parseLong(val));
                byte[] bytes = new byte[8];
                bytes = bf.array();
                vc = syntax.createValueComponent((Object)bytes);
            } else if (syntax == NDSSyntax.SYN_PATH || syntax == LDAPSyntax.SYN_TAGGED_NAME_AND_STRING) {
                vc = PathFacade.createValueList((long)Long.parseLong(xml.getChildTextTrim("type")), (String)xml.getChildTextTrim("volume"), (String)xml.getChildTextTrim("path"), (Syntax)syntax);
            } else if (syntax == NDSSyntax.SYN_PO_ADDRESS || syntax == LDAPSyntax.SYN_POSTAL_ADDRESS) {
                List theElements = xml.getChildren("item");
                Element tempElem = null;
                String[] theLines = new String[theElements.size()];
                for (int i = 0; i < theElements.size(); ++i) {
                    tempElem = (Element)theElements.get(i);
                    theLines[i] = new String(tempElem.getText());
                }
                vc = PostalAddressFacade.createValueList((String[])theLines, (Syntax)syntax);
                if (vc.toString().length() == 0) {
                    vc = null;
                }
            } else if (syntax == NDSSyntax.SYN_PR_STRING || syntax == LDAPSyntax.SYN_PRINTABLE_STRING) {
                vc = syntax.createValueComponent((Object)xml.getText());
            } else if (syntax == NDSSyntax.SYN_REPLICA_POINTER || syntax == LDAPSyntax.SYN_NDS_REPLICA_POINTER) {
                List theElements = xml.getChildren("net-address-hint");
                Element tempElem = (Element)theElements.get(0);
                ValueList nfvl = NetAddressFacade.createValueList((long)Long.parseLong(tempElem.getChildTextTrim("address-type")), (byte[])tempElem.getChildTextTrim("address").getBytes(), (Syntax)syntax);
                NetAddressFacade naf = new NetAddressFacade(nfvl);
                vc = ReplicaPointerFacade.createValueList((String)xml.getChildTextTrim("server-name"), (int)Integer.parseInt(xml.getChildTextTrim("replica-type")), (int)Integer.parseInt(xml.getChildTextTrim("replica-number")), (int)Integer.parseInt(xml.getChildTextTrim("replica-count")), (NetAddressFacade)naf, (Syntax)syntax);
            } else if (syntax == NDSSyntax.SYN_TIMESTAMP || syntax == LDAPSyntax.SYN_NDS_TIMESTAMP) {
                long seconds = Long.parseLong(xml.getChildTextTrim("seconds"));
                int replica = Integer.parseInt(xml.getChildTextTrim("replica"));
                int event = Integer.parseInt(xml.getChildTextTrim("event"));
                vc = TimeStampFacade.createValueList((long)seconds, (int)replica, (int)event, (Syntax)syntax);
            } else if (syntax == NDSSyntax.SYN_UNKNOWN || syntax == LDAPSyntax.SYN_UNKNOWN) {
                vc = UnknownFacade.createValueList((String)xml.getChildTextTrim("attribute-name"), (int)Integer.parseInt(xml.getChildTextTrim("syntax-id")), (byte[])xml.getChildTextTrim("bytes").getBytes(), (Syntax)syntax);
            }
        }
        return vc;
    }
}

