/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.AdminNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.PluginContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.RBSUtil;
import com.novell.nps.utils.Utils;
import com.novell.rbs.RBSCategory;
import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class DeleteCategories
extends Task {
    private static final long serialVersionUID = 1L;
    private TaskContext m_context;
    private Properties m_resultStrings;
    private AdminNamespace m_ns;
    private ObjectEntry m_treeOE;
    private HttpServletRequest m_req;
    private ArrayList m_errors = new ArrayList();
    private DeleteThread m_deleteThread;
    private boolean m_stopThread;
    private boolean m_threadDone;
    private String m_mainProgressMessage = "";
    private String m_alreadyMessage = "";
    private String m_abortMessage = "";
    private String[] m_categoryList;
    private int m_categoriesNotDeleted = 0;
    private int m_totalCategoryCount = 0;
    private int m_DeletingCount = 0;

    @Override
    public boolean execute(TaskContext context, Properties resultStrings) {
        this.m_context = context;
        this.m_resultStrings = resultStrings;
        this.m_treeOE = RBSUtil.getTreeOE(this.m_context);
        this.m_ns = this.m_treeOE.getAdminNamespace();
        this.m_req = this.m_context.getRequest();
        String nextState = this.m_req.getParameter("nextState");
        if (nextState == null || nextState.equals("initialState")) {
            return this.initialState();
        }
        if (nextState.equalsIgnoreCase("refresh")) {
            return this.refresh();
        }
        if (nextState.equalsIgnoreCase("cancel")) {
            return this.cancel();
        }
        if (nextState.equalsIgnoreCase("finished")) {
            return this.finished();
        }
        return true;
    }

    public boolean initialState() {
        this.m_categoryList = eMFrameUtils.unpack(this.m_req.getParameter("PackedCategoriesToDelete"), this.m_context);
        if (this.m_categoryList.length > 0) {
            this.m_mainProgressMessage = eMFrameUtils.getLocalizedString("FwResources", "RBS.DeleteCategories", this.m_context.getLocale());
            this.m_abortMessage = eMFrameUtils.getLocalizedString("FwResources", "RBS.AbortStop", this.m_context.getLocale());
            this.m_totalCategoryCount = this.m_categoryList.length;
            this.m_alreadyMessage = eMFrameUtils.getLocalizedString("FwResources", "RBS.Initializing", this.m_context.getLocale());
            String url = new String("webacc?taskId=" + eMFrameUtils.urlEncode(this.m_req.getParameter("taskId"), this.m_context) + "&merge=fw.GenericProgress&User.context=" + this.m_req.getParameter("User.context") + "&nextState=refresh&progressCount=&mainProgressMessage=" + this.m_mainProgressMessage + "&alreadyMessage=" + this.m_alreadyMessage + "&abortMessage=" + this.m_abortMessage);
            this.m_resultStrings.put("UrlTask.url", url);
            Utils.setMergeTemplate((PluginContext)this.m_context, (String)"fw.UrlTask");
            this.m_stopThread = false;
            this.m_threadDone = false;
            this.m_deleteThread = new DeleteThread();
            this.m_deleteThread.start();
        }
        return true;
    }

    private boolean refresh() {
        String taskId = this.m_req.getParameter("taskId");
        String userContext = this.m_req.getParameter("User.context");
        if (!this.m_threadDone) {
            this.m_resultStrings.put("progressCount", "");
            if (this.m_DeletingCount == 0) {
                this.m_alreadyMessage = eMFrameUtils.getLocalizedString("FwResources", "RBS.Initializing", this.m_context.getLocale());
            } else {
                Object[] values = new String[]{Integer.toString(this.m_DeletingCount), Integer.toString(this.m_totalCategoryCount)};
                this.m_alreadyMessage = eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "RBS.DeleteCategoryNumber", this.m_context.getLocale()), values);
            }
            this.m_resultStrings.put("mainProgressMessage", this.m_mainProgressMessage);
            this.m_resultStrings.put("alreadyMessage", this.m_alreadyMessage);
            this.m_resultStrings.put("abortMessage", this.m_abortMessage);
        } else {
            String url = new String("webacc?taskId=" + eMFrameUtils.urlEncode(taskId, this.m_context) + "&User.context=" + userContext + "&nextState=finished");
            url = this.m_errors.isEmpty() ? url + "&merge=dev.GenMsg&GeneralMsg.Mode=success&dev.refreshOV=true" : url + "&merge=dev.MooGenErr&GeneralMsg.Mode=error";
            this.m_resultStrings.put("UrlTask.url", url);
            Utils.setMergeTemplate((PluginContext)this.m_context, (String)"fw.UrlTask");
        }
        return true;
    }

    private boolean cancel() {
        this.m_stopThread = true;
        String strTitle = eMFrameUtils.getLocalizedString("FwResources", "RBS.DeleteCategoryRequestAborted", this.m_context.getLocale());
        String strBody = "\n" + eMFrameUtils.getLocalizedString("FwResources", "RBS.NumberDeleteCategory", this.m_context.getLocale()) + "\n";
        Object[] values = new String[]{Integer.toString(this.m_DeletingCount), Integer.toString(this.m_totalCategoryCount)};
        eMFrameUtils.setMessage("success", strTitle, eMFrameUtils.formatMessage(strBody, values), this.m_context);
        return true;
    }

    private boolean finished() {
        if (this.m_errors.isEmpty()) {
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "RBS.DeleteCategoryRequestSucceeded", this.m_context.getLocale());
            String strBody = "\n" + eMFrameUtils.getLocalizedString("FwResources", "RBS.NumberDeleteCategory", this.m_context.getLocale()) + "\n";
            Object[] values = new String[]{Integer.toString(this.m_DeletingCount), Integer.toString(this.m_totalCategoryCount)};
            eMFrameUtils.setMessage("success", strTitle, eMFrameUtils.formatMessage(strBody, values), this.m_context);
        } else {
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "RBS.DeleteCategoryRequestError", this.m_context.getLocale());
            String strBody = "\n" + eMFrameUtils.getLocalizedString("FwResources", "RBS.NumberDeleteCategory", this.m_context.getLocale()) + "\n" + eMFrameUtils.getLocalizedString("FwResources", "RBS.CategoriesNotDeleted", this.m_context.getLocale());
            Object[] values = new String[]{Integer.toString(this.m_totalCategoryCount - this.m_categoriesNotDeleted), Integer.toString(this.m_totalCategoryCount)};
            eMFrameUtils.setMooErrorMessage(this.m_resultStrings, strTitle, eMFrameUtils.formatMessage(strBody, values), this.m_errors);
        }
        return true;
    }

    private void doCategoryDelete() {
        this.m_errors.clear();
        int index = 0;
        while (index < this.m_categoryList.length && !this.m_stopThread) {
            ObjectEntry categoryOE = null;
            this.m_DeletingCount = index + 1;
            try {
                categoryOE = this.m_ns.getObjectEntry(this.m_treeOE, this.m_categoryList[index]);
            }
            catch (Exception exc) {
                D.log(exc);
                ++this.m_categoriesNotDeleted;
                this.m_errors.add(new String[]{this.m_categoryList[index], eMFrameUtils.getLocalizedString("FwResources", "RBS.DeleteCategoryRequestFailed", this.m_context.getLocale()), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
                ++index;
                continue;
            }
            RBSCategory rbsCategory = new RBSCategory(categoryOE);
            try {
                rbsCategory.setRoleMembers(null);
                rbsCategory.update();
                FwUtils.refreshCRTCategories(this.m_context);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.m_ns.delete(rbsCategory.getObjectEntry());
            }
            catch (Exception exc) {
                D.log(exc);
                this.m_errors.add(new String[]{this.m_ns.getUnrootedName(rbsCategory.getObjectEntry()), eMFrameUtils.getLocalizedString("FwResources", "RBS.DeleteCategoryRequestFailed", this.m_context.getLocale()), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
            }
            ++index;
        }
    }

    class DeleteThread
    extends Thread {
        public DeleteThread() {
            this.setPriority(4);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            DeleteCategories.this.doCategoryDelete();
            DeleteCategories.this.m_threadDone = true;
        }
    }
}

