/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.GlobalRegistry;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameFactory;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.Registry;
import com.novell.emframe.fw.util.iManagerJDOMFactory;
import com.novell.webaccess.common.I18NServletRequest;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.JDOMFactory;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class DeleteCreatorClassTask
extends Task {
    private static final long serialVersionUID = 1L;
    public static final String HTMLPARAM_OBJECT_TYPES = "objectTypeName";
    public static final String HTMLPARAM_SELECTED_CLASS = "SelectedClass";
    HttpServletRequest m_req;
    TaskContext m_context;
    Properties m_resultStrings;
    Task m_creator;
    AdminNamespace m_namespace;

    @Override
    public boolean execute(TaskContext context, Properties resultStrings) {
        this.m_context = context;
        this.m_resultStrings = resultStrings;
        this.m_req = this.m_context.getRequest();
        String nextState = this.m_req.getParameter("nextState");
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            if (!this.outputSchemaClasses()) {
                D.log("There was an error getting the classes", 2);
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "DeleteCreator.FailureTitle", this.m_context);
                String strBody = eMFrameUtils.getLocalizedString("FwResources", "FwConsts.RES_ERROR_READING_CALSSES", this.m_context);
                eMFrameUtils.setMessage("error", strTitle, strBody, context);
                ((I18NServletRequest)this.m_req).setParameter("merge", "dev.GenErr");
                return false;
            }
            return true;
        }
        if (nextState.equalsIgnoreCase("deleteFromCreationList")) {
            D.log("Now delete from creation List!", 2);
            String selectedClass = this.m_req.getParameter(HTMLPARAM_SELECTED_CLASS);
            return this.deleteFromCreationList(selectedClass);
        }
        return true;
    }

    private boolean outputSchemaClasses() {
        ArrayList<String> objArray = new ArrayList<String>();
        String[] schemaClassArray = null;
        try {
            schemaClassArray = this.getSchemaclasses();
        }
        catch (Exception e) {
            D.log(e);
            this.m_resultStrings.put("GeneralMsg.MsgBodyId", eMFrameUtils.getExceptionMessage(e, this.m_context));
            return false;
        }
        for (int i = 0; i < schemaClassArray.length; ++i) {
            Document creatorDoc = GlobalRegistry.getCreatorDoc(schemaClassArray[i], this.m_context);
            String creatorId = null;
            if (creatorDoc != null) {
                creatorId = creatorDoc.getRootElement().getChildTextTrim("id");
            }
            if (creatorId == null) continue;
            objArray.add(schemaClassArray[i]);
        }
        int size = objArray.size();
        this.m_resultStrings.put("Sch_ClassList.Count", Integer.toString(size));
        eMFrameUtils.sortKeyValues(objArray, objArray, this.m_context);
        for (int i = 0; i < size; ++i) {
            this.m_resultStrings.put("Sch_ClassList.displayname." + i, objArray.get(i));
            this.m_resultStrings.put("Sch_ClassList.name." + i, objArray.get(i));
        }
        return true;
    }

    private String[] getSchemaclasses() throws Exception {
        String[] classDefArray = null;
        SchemaDefinition schemaDef = null;
        ObjectEntry treeOE = null;
        AuthenticationBroker broker = this.m_context.getAuthenticationBroker();
        treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
        this.m_namespace = treeOE.getAdminNamespace();
        schemaDef = this.m_namespace.getSchemaDefinition(treeOE);
        ClassDefinition[] classDef = schemaDef.getClassDefinitions();
        classDefArray = new String[classDef.length];
        for (int i = 0; i < classDef.length; ++i) {
            classDefArray[i] = classDef[i].getName();
        }
        return classDefArray;
    }

    private boolean deleteFromCreationList(String objClass) {
        boolean success = true;
        Document creatorDoc = GlobalRegistry.getCreatorDoc(objClass, this.m_context);
        String creatorId = creatorDoc.getRootElement().getChildTextTrim("id");
        if (creatorDoc == null) {
            success = false;
        } else {
            success = this.removeFromRegistery(creatorDoc, objClass);
            if (success && !this.removeFromXML(creatorId, objClass)) {
                String safeObjectName = this.m_context.getDirUtils().getSafeName(eMFrameUtils.urlDecode(objClass, this.m_context));
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "DeleteCreator.FailureTitle", this.m_context);
                String strBody = eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "DeleteCreator.DeleteXMLError", this.m_context), new String[]{safeObjectName});
                eMFrameUtils.setMessage("error", strTitle, strBody, this.m_context);
                return false;
            }
        }
        if (success) {
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "DeleteCreator.SuccessTitle", this.m_context);
            String strBody = eMFrameUtils.getLocalizedString("FwResources", "DeleteCreator.DeleteTheCreatorXMLSuccess", this.m_context);
            eMFrameUtils.setMessage("success", strTitle, strBody, this.m_context);
            ((I18NServletRequest)this.m_req).setParameter("merge", "dev.GenConf");
            return true;
        }
        String safeObjectName = this.m_context.getDirUtils().getSafeName(eMFrameUtils.urlDecode(objClass, this.m_context));
        String strTitle = eMFrameUtils.getLocalizedString("FwResources", "DeleteCreator.FailureTitle", this.m_context);
        String strBody = eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "DeleteCreator.DeleteTheCreatorXMLError", this.m_context), new String[]{safeObjectName});
        eMFrameUtils.setMessage("error", strTitle, strBody, this.m_context);
        return false;
    }

    private boolean removeFromRegistery(Document creatorDoc, String objClass) {
        GlobalRegistry.removeNode(creatorDoc);
        return true;
    }

    private boolean removeFromXML(String creatorId, String objClass) {
        block8: {
            if (null == creatorId) {
                return false;
            }
            File xmlFile = Registry.getRegistry("Global").getPluginInfo(creatorId).getXMLFile();
            if (null == xmlFile) {
                return false;
            }
            SAXBuilder builder = new SAXBuilder(false);
            builder.setFeature("http://xml.org/sax/features/external-general-entities", false);
            builder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            builder.setFactory((JDOMFactory)iManagerJDOMFactory.getInstance());
            try {
                Document doc = builder.build(xmlFile);
                Element root = doc.getRootElement();
                List list = root.getChildren();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Element element = (Element)iterator.next();
                    if (!element.getChildTextTrim("object-type-name").equals(objClass)) continue;
                    D.log("Delete the registration from Creator XML file for " + objClass);
                    D.log(doc);
                    iterator.remove();
                }
                boolean successDelete = false;
                if (xmlFile.exists()) {
                    successDelete = xmlFile.delete();
                }
                if (successDelete) {
                    if (root.getChildren().size() > 0) {
                        return this.outputXMLFile(doc, xmlFile);
                    }
                    break block8;
                }
                D.log(xmlFile + " cannot be deleted!");
                return false;
            }
            catch (Exception e) {
                D.log(xmlFile + " is not well-formed.");
                D.log(e.getMessage());
                return false;
            }
        }
        return true;
    }

    private boolean outputXMLFile(Document doc, File xmlFile) {
        XMLOutputter outputter = new XMLOutputter("   ", true);
        try {
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(xmlFile));
            outputter.output(doc, (OutputStream)outputStream);
            outputStream.close();
        }
        catch (FileNotFoundException e) {
            D.log(e);
            eMFrameUtils.setMessage("error", eMFrameUtils.getLocalizedString("BaseResources", "DeleteCreator.FailureTitle", this.m_context), eMFrameUtils.getLocalizedString("BaseResources", "CreateObject.WizardError", this.m_context), this.m_context);
            return false;
        }
        catch (IOException e) {
            D.log(e);
            eMFrameUtils.setMessage("error", eMFrameUtils.getLocalizedString("BaseResources", "DeleteCreator.FailureTitle", this.m_context), eMFrameUtils.getLocalizedString("BaseResources", "CreateObject.WizardError", this.m_context), this.m_context);
            return false;
        }
        return true;
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        Task.shouldRun(req, sServiceName);
        if (!FwUtils.canConfigureiManager(req)) {
            TaskContext context = eMFrameFactory.getTaskContext(req);
            throw new Exception(eMFrameUtils.getLocalizedString("FwResources", "Configure.UserNotAuthorizedToConfigureiManager", context));
        }
    }
}

