/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.ObjectType;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.RBSUtil;
import com.novell.rbs.RBSAssociatedObject;
import com.novell.rbs.RBSAssociation;
import com.novell.rbs.RBSCollection;
import com.novell.rbs.RBSObject;
import com.novell.rbs.RBSRole;
import com.novell.rbs.RBSScope;
import com.novell.rbs.RBSTask;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public final class DeleteRBSObjectsTask
extends Task {
    private static final long serialVersionUID = 1L;
    private HttpServletRequest m_req;
    private TaskContext m_context;
    private Properties m_resultStrings;
    private ObjectEntry m_treeOE = null;
    private AdminNamespace m_ns = null;
    private ArrayList m_errors = new ArrayList();
    private Vector m_objectVector = null;
    private String m_strError = "";
    private boolean m_err = false;
    private int m_totalObjects = 0;

    @Override
    public boolean execute(TaskContext context, Properties resultStrings) {
        this.m_context = context;
        this.m_resultStrings = resultStrings;
        this.m_req = context.getRequest();
        this.m_treeOE = RBSUtil.getTreeOE(context);
        this.m_ns = this.m_treeOE.getAdminNamespace();
        String nextState = this.m_req.getParameter("nextState");
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            this.m_objectVector = this.getTargetObjects();
            String[] targetObjArray = this.m_objectVector.toArray(new String[this.m_objectVector.size()]);
            eMFrameUtils.setupTargetChooser(targetObjArray, context);
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("doDeleteObject")) {
            if (this.m_objectVector == null) {
                this.m_objectVector = this.getTargetObjects();
            }
            String objectName = this.m_req.getParameter("DeleteObjectName");
            return this.doDeleteObject(objectName, this.m_objectVector);
        }
        return this.showInitialForm();
    }

    private boolean showInitialForm() {
        return true;
    }

    private boolean cleanUpScopes(ObjectEntry roleObjectEntry) {
        boolean doUpdate = false;
        try {
            RBSScope[] scopesArrayFinal;
            RBSScope[] scopesArray;
            RBSRole role = new RBSRole(roleObjectEntry);
            RBSObject[] content = role.getContent();
            RBSAssociation[] members = role.getMembers();
            String dynamicGroupSearchType = FwUtils.getDynamicSearchType(this.m_context);
            if (members != null) {
                role.deleteMembers(members, dynamicGroupSearchType);
                doUpdate = true;
            }
            if (content != null) {
                role.deleteContent(content, dynamicGroupSearchType);
                doUpdate = true;
            }
            if (doUpdate) {
                role.update();
            }
            if ((scopesArray = role.getAllScopeObjects()) != null) {
                for (int i = 0; i < scopesArray.length; ++i) {
                    ObjectEntry[] scopeMemberArray = scopesArray[i].getMembers();
                    if (scopeMemberArray == null) continue;
                    for (int j = 0; j < scopeMemberArray.length; ++j) {
                        scopesArray[i].deleteMember(this.m_ns.getDetails(scopeMemberArray[j]));
                    }
                }
                role.update();
            }
            if ((scopesArrayFinal = role.getAllScopeObjects()) != null) {
                this.removeRemainingRBSScopeObjects(role);
                role.update();
            }
            return true;
        }
        catch (Exception e) {
            D.log(e);
            String strException = eMFrameUtils.getExceptionMessage(e, this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, strException, this.m_context);
            return false;
        }
    }

    private void removeRemainingRBSScopeObjects(RBSRole role) throws SPIException, SnapinVetoException {
        RBSScope[] rbsScopesArray = role.getAllScopeObjects();
        if (rbsScopesArray != null) {
            for (int i = 0; i < rbsScopesArray.length; ++i) {
                ((AdminNamespace)rbsScopesArray[i].getObjectEntry().getObjectType().getNamespace()).delete(rbsScopesArray[i].getObjectEntry());
            }
        }
    }

    private boolean doDeleteObject(String objectName, Vector validObjects) {
        String[] objArray = eMFrameUtils.unpack(objectName, this.m_context);
        ObjectEntry objectEntry = null;
        ObjectEntry childObjEntry = null;
        ObjectEntry taskObjEntry = null;
        ObjectType objectType = null;
        this.m_errors.clear();
        for (int i = 0; i < objArray.length; ++i) {
            block27: {
                try {
                    objectEntry = this.m_ns.getObjectEntry(this.m_treeOE, objArray[i]);
                    objectType = objectEntry.getObjectType();
                    boolean foundObj = false;
                    if (validObjects != null) {
                        for (int cnt = 0; cnt < validObjects.size(); ++cnt) {
                            if (!DirUtils.isOfType(objectType, (String)validObjects.elementAt(cnt), false)) continue;
                            foundObj = true;
                        }
                    }
                    if (!foundObj) {
                        this.m_err = true;
                        D.log("Cannot delete this type of object: " + objectType);
                        this.m_errors.add(new String[]{objArray[i], eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.Failure", this.m_context), eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.InvalidTargetObject", this.m_context)});
                    }
                    break block27;
                }
                catch (SPIException e) {
                    this.m_err = true;
                    D.log(e);
                    this.m_errors.add(new String[]{objArray[i], eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.Failure", this.m_context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.NotFound", this.m_context), new String[]{objArray[i]})});
                }
                continue;
            }
            String objectTypeName = objectType.getName();
            if (objectTypeName.equalsIgnoreCase("rbsCollection") || objectTypeName.equalsIgnoreCase("rbsCollection2")) {
                ObjectEntryEnumeration childrenEnum = null;
                ObjectEntryEnumeration moduleEnum = null;
                try {
                    childrenEnum = this.m_ns.getChildren(objectEntry);
                }
                catch (SPIException e) {
                    this.m_err = true;
                    D.log(e);
                    this.m_strError = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
                    this.m_errors.add(new String[]{objArray[i], eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.Failure", this.m_context), this.m_strError});
                    continue;
                }
                if (childrenEnum != null) {
                    while (childrenEnum.hasMoreElements()) {
                        childObjEntry = (ObjectEntry)childrenEnum.nextElement();
                        String childObjectTypeName = childObjEntry.getObjectType().getName();
                        if (childObjectTypeName.equalsIgnoreCase("rbsRole") || childObjectTypeName.equalsIgnoreCase("rbsRole2")) {
                            this.cleanUpScopes(childObjEntry);
                            boolean rVal = this.deleteObject(childObjEntry);
                            if (!rVal) continue;
                            ++this.m_totalObjects;
                            continue;
                        }
                        if (!childObjectTypeName.equalsIgnoreCase("rbsModule") && !childObjectTypeName.equalsIgnoreCase("rbsModule2")) continue;
                        try {
                            moduleEnum = this.m_ns.getChildren(childObjEntry);
                        }
                        catch (SPIException e) {
                            this.m_err = true;
                            D.log(e);
                            this.m_strError = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
                            this.m_errors.add(new String[]{objArray[i], eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.Failure", this.m_context), this.m_strError});
                            continue;
                        }
                        while (moduleEnum.hasMoreElements()) {
                            taskObjEntry = (ObjectEntry)moduleEnum.nextElement();
                            this.removeBookTaskAssociations(taskObjEntry);
                            boolean deleteValue = this.deleteObject(taskObjEntry);
                            if (!deleteValue) continue;
                            ++this.m_totalObjects;
                        }
                        boolean deleteValue = this.deleteObject(childObjEntry);
                        if (!deleteValue) continue;
                        ++this.m_totalObjects;
                    }
                } else {
                    boolean deleteValue = this.deleteObject(objectEntry);
                    if (deleteValue) {
                        ++this.m_totalObjects;
                    }
                }
            } else if (objectTypeName.equalsIgnoreCase("rbsRole") || objectTypeName.equalsIgnoreCase("rbsRole2")) {
                this.cleanUpScopes(objectEntry);
            } else if (objectTypeName.equalsIgnoreCase("rbsModule") || objectTypeName.equalsIgnoreCase("rbsModule2")) {
                ObjectEntryEnumeration moduleEnum = null;
                try {
                    moduleEnum = this.m_ns.getChildren(objectEntry);
                }
                catch (SPIException e) {
                    this.m_err = true;
                    D.log(e);
                    this.m_strError = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
                    this.m_errors.add(new String[]{objArray[i], eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.Failure", this.m_context), this.m_strError});
                    continue;
                }
                while (moduleEnum.hasMoreElements()) {
                    taskObjEntry = (ObjectEntry)moduleEnum.nextElement();
                    this.removeBookTaskAssociations(taskObjEntry);
                    boolean deleteValue = this.deleteObject(taskObjEntry);
                    if (!deleteValue) continue;
                    ++this.m_totalObjects;
                }
            } else if (objectTypeName.equalsIgnoreCase("rbsTask") || objectTypeName.equalsIgnoreCase("rbsTask2") || objectTypeName.equalsIgnoreCase("rbsBook") || objectTypeName.equalsIgnoreCase("rbsBook2")) {
                this.removeBookTaskAssociations(objectEntry);
            }
            boolean deleteValue = this.deleteObject(objectEntry);
            if (!deleteValue) continue;
            ++this.m_totalObjects;
        }
        if (this.m_err) {
            String strTitle = eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.Failure", this.m_context);
            String strBody = eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.ErrorForObject", this.m_context);
            eMFrameUtils.setMooErrorMessage(this.m_resultStrings, strTitle, eMFrameUtils.formatMessage(strBody, new String[]{Integer.toString(this.m_totalObjects)}), this.m_errors);
            this.m_errors.clear();
            this.m_err = false;
            return false;
        }
        String strTitle = eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.Success", this.m_context);
        String strBody = eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.SuccessForObject", this.m_context);
        eMFrameUtils.setMessage("success", strTitle, eMFrameUtils.formatMessage(strBody, new String[]{Integer.toString(this.m_totalObjects)}), this.m_context);
        return true;
    }

    private boolean deleteObject(ObjectEntry objectEntry) {
        String objectClassName = objectEntry.getObjectType().getName();
        if (objectClassName.equalsIgnoreCase("rbsCollection") || objectClassName.equalsIgnoreCase("rbsCollection2")) {
            ObjectEntry[] ownersOEs = null;
            RBSCollection rbsCollection = new RBSCollection(objectEntry);
            String deletedCollectionDN = this.m_ns.getUnrootedName(objectEntry);
            try {
                ownersOEs = rbsCollection.getOwners();
                if (ownersOEs != null) {
                    for (int i = 0; i < ownersOEs.length; ++i) {
                        RBSAssociatedObject rbsAssociatedObject = new RBSAssociatedObject(ownersOEs[i]);
                        RBSCollection[] rbsColl = objectClassName.equalsIgnoreCase("rbsCollection2") ? rbsAssociatedObject.getAllOwnedCollections2() : rbsAssociatedObject.getOwnedCollections();
                        if (rbsColl == null) continue;
                        Vector<RBSCollection> collectionV = new Vector<RBSCollection>();
                        for (int j = 0; j < rbsColl.length; ++j) {
                            String thisCollectionDN = this.m_ns.getUnrootedName(rbsColl[j].getObjectEntry());
                            if (deletedCollectionDN.equalsIgnoreCase(thisCollectionDN)) continue;
                            collectionV.add(rbsColl[j]);
                        }
                        rbsColl = null;
                        if (collectionV.size() > 0) {
                            rbsColl = collectionV.toArray(new RBSCollection[collectionV.size()]);
                        }
                        if (objectClassName.equalsIgnoreCase("rbsCollection2")) {
                            rbsAssociatedObject.setOwnedCollections2(rbsColl);
                        } else {
                            rbsAssociatedObject.setOwnedCollections(rbsColl);
                        }
                        rbsAssociatedObject.update();
                    }
                }
            }
            catch (Exception e) {
                D.log(e);
            }
        }
        try {
            this.m_ns.delete(objectEntry);
        }
        catch (SPIException e) {
            this.m_err = true;
            D.log(e);
            this.m_strError = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
            this.m_errors.add(new String[]{objectEntry.getName(), eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.Failure", this.m_context), this.m_strError});
            return false;
        }
        catch (SnapinVetoException e) {
            this.m_err = true;
            D.log(e);
            this.m_strError = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
            this.m_errors.add(new String[]{objectEntry.getName(), eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.Failure", this.m_context), this.m_strError});
            return false;
        }
        this.m_context.removeFromHistory(this.m_ns.getUnrootedName(objectEntry));
        return true;
    }

    private Vector getTargetObjects() {
        Vector<String> validObjects = new Vector<String>(5);
        String targetObjects = this.m_req.getParameter("objectTypeName");
        if (targetObjects != null) {
            StringTokenizer st = new StringTokenizer(targetObjects, ",");
            String strObject = null;
            while (st.hasMoreTokens()) {
                strObject = st.nextToken();
                validObjects.addElement(strObject);
            }
        } else {
            validObjects.addElement("rbsCollection2");
            validObjects.addElement("rbsModule2");
            validObjects.addElement("rbsRole2");
            validObjects.addElement("rbsTask2");
            validObjects.addElement("rbsBook2");
        }
        return validObjects;
    }

    private boolean removeBookTaskAssociations(ObjectEntry rbsObjEntry) {
        String objectTypeName = rbsObjEntry.getObjectType().getName();
        if (objectTypeName.equalsIgnoreCase("rbsTask") || objectTypeName.equalsIgnoreCase("rbsTask2") || objectTypeName.equalsIgnoreCase("rbsBook") || objectTypeName.equalsIgnoreCase("rbsBook2")) {
            RBSTask rbsTask = new RBSTask(rbsObjEntry);
            RBSRole[] roles = null;
            try {
                roles = rbsTask.getContentMembership();
            }
            catch (SPIException e) {
                D.log(e);
                eMFrameUtils.setErrorMessage(e, this.m_context);
                return false;
            }
            if (roles != null) {
                try {
                    String dynamicGroupSearchType = FwUtils.getDynamicSearchType(this.m_context);
                    rbsTask.deleteContentMembership(roles, dynamicGroupSearchType);
                    rbsTask.update();
                }
                catch (Exception e) {
                    D.log(e);
                    String strException = eMFrameUtils.getExceptionMessage(e, this.m_context);
                    String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                    eMFrameUtils.setMessage("error", strTitle, strException, this.m_context);
                    return false;
                }
            }
        }
        return true;
    }
}

