/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.AsyncContext;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.BasicCollectionAsyncWorker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.config.ModuleInfo;
import com.novell.emframe.fw.config.ModuleManager;
import com.novell.emframe.fw.config.SystemConfigManager;
import com.novell.emframe.fw.util.ModuleGet;
import com.novell.nps.WebappUtil;
import com.novell.nps.serviceProviders.PortalModuleInstallManager;
import java.io.File;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletContext;

public class DownloadAndInstallWorker
extends BasicCollectionAsyncWorker {
    ModuleGet moduleGetFromWeb;
    Vector vModules = new Vector(1);
    private File fPackages;
    private Hashtable htUpgrades;
    private String webAppPath;
    private Map htModules;
    private AsyncContext context;
    private MContext mcontext;
    private static String SUPPORT_PACK = "iman";

    public DownloadAndInstallWorker(List modulesToDownloadAndInstall, Map allModules, File fPackagesDir, MContext context) {
        super(modulesToDownloadAndInstall);
        this.htModules = allModules;
        this.vModules.add("ToBeReplaced");
        this.moduleGetFromWeb = new ModuleGet(ModuleManager.getiManagerVersion(), System.getProperty("os.name").toLowerCase(), fPackagesDir.getAbsolutePath());
        String sDescriptorUrl = SystemConfigManager.getSingleSetting(null, "ModuleDownloadDescriptorURL");
        if (null != sDescriptorUrl && sDescriptorUrl.length() > 0) {
            ModuleGet.setDescriptorUrl(sDescriptorUrl);
        }
        this.webAppPath = WebappUtil.getRealPath((String)"/");
        this.fPackages = ModuleManager.getPackagesDir();
        this.mcontext = context;
    }

    @Override
    protected void process(Object module, AsyncContext context) {
        String sFileName;
        Object moduleInfoObect;
        this.context = context;
        ModuleInfo moduleInfo = null;
        if (this.htModules.containsKey(module) && !(moduleInfo = (ModuleInfo)(moduleInfoObect = this.htModules.get(module))).isLocal()) {
            this.vModules.set(0, moduleInfo);
            context.addStatusMsg("<B>" + eMFrameUtils.getLocalizedString("FwResources", "ModulesToInstall.Downloading", context.getLocale()) + "</B>&nbsp;" + moduleInfo.getFilename() + " - " + moduleInfo.getDescription(context.getLocale().toString()) + " - " + moduleInfo.getModuleVersion());
            if (!this.moduleGetFromWeb.getModules(this.vModules)) {
                Throwable exception = moduleInfo.getException();
                if (exception != null) {
                    context.addErrorMsg(moduleInfo.getFilename() + " - " + exception.getLocalizedMessage());
                    D.log(exception);
                    return;
                }
                return;
            }
        }
        String sInfoString = sFileName = moduleInfo.getFilename();
        String[] strErr = null;
        if (!sFileName.equalsIgnoreCase("selectall")) {
            if (moduleInfo != null) {
                if (moduleInfo.getFilename() != null) {
                    sInfoString = moduleInfo.getFilename();
                }
                sInfoString = moduleInfo.getDescription(context.getLocale().toString()).length() > 0 ? sInfoString + " - " + moduleInfo.getDescription(context.getLocale().toString()) : sInfoString + " - " + moduleInfo.getModuleDescription();
                sInfoString = sInfoString + " - " + moduleInfo.getModuleVersion();
            }
            context.addStatusMsg("<B>" + eMFrameUtils.getLocalizedString("FwResources", "ModulesToInstall.Installing", context.getLocale()) + "</B>&nbsp;" + sInfoString);
            File fnpmFileName = new File(this.fPackages, sFileName);
            PortalModuleInstallManager portalModuleInstallManager = new PortalModuleInstallManager(fnpmFileName, new File(WebappUtil.getRealPath((String)"/")));
            portalModuleInstallManager.getData(null);
            ServletContext servletContext = null;
            try {
                servletContext = WebappUtil.getStaticServletContext();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (null != servletContext) {
                Object oTempDir = servletContext.getAttribute("javax.servlet.context.tempdir");
                this.htUpgrades = ModuleManager.getModulesToUpgrade();
                if (this.isUpgradable(this.htUpgrades, moduleInfo.getModuleID()) && moduleInfo.getModuleID().indexOf(SUPPORT_PACK) == -1) {
                    String updateInfoString = sFileName;
                    if (moduleInfo != null) {
                        updateInfoString = moduleInfo.getDescription(context.getLocale().toString()).length() > 0 ? updateInfoString + " - " + moduleInfo.getDescription(context.getLocale().toString()) : updateInfoString + " - " + moduleInfo.getModuleDescription();
                    }
                    D.log("Uninstalling the previous version of NPM:  " + updateInfoString);
                    context.addStatusMsg("<B>" + eMFrameUtils.getLocalizedString("FwResources", "ModulesToInstall.Uninstalling", context.getLocale()) + "</B>&nbsp;" + updateInfoString);
                    this.uninstall(fnpmFileName.getAbsolutePath(), context);
                    context.addStatusMsg("<B>" + eMFrameUtils.getLocalizedString("FwResources", "ModulesToInstall.Installing", context.getLocale()) + "</B>&nbsp;" + sInfoString);
                }
                this.updateSchemaExtensionInfo();
                String host = this.mcontext.getRequest().getHeader("X-FORWARDED-FOR");
                if (null == host) {
                    host = this.mcontext.getRequest().getRemoteHost();
                }
                if ((strErr = portalModuleInstallManager.install(this.webAppPath, oTempDir.toString(), this.mcontext.getAuthenticator().getUserId(this.mcontext), host)) != null && strErr.length > 0) {
                    if (strErr.length > 0 && strErr[0].equalsIgnoreCase(portalModuleInstallManager.getCurrentModule().getModuleTitle())) {
                        context.addStatusMsg("<B>" + eMFrameUtils.getLocalizedString("FwResources", "ModulesToInstall.ConfirmMessageTitlePlural", context.getLocale()) + "</B>&nbsp;");
                    } else {
                        context.addStatusMsg("<B>" + eMFrameUtils.getLocalizedString("FwResources", "ModulesToInstall.FailureInstalledModules", context.getLocale()) + "</B>&nbsp;" + sInfoString + " - " + strErr[0]);
                    }
                } else {
                    context.addStatusMsg("<B>" + eMFrameUtils.getLocalizedString("FwResources", "ModulesToInstall.ConfirmMessageTitlePlural", context.getLocale()) + "</B>&nbsp;");
                }
            }
        }
    }

    private void uninstall(String npmFileName, AsyncContext context) {
        try {
            if (null != npmFileName) {
                ModuleManager.externalUninstall(new File(WebappUtil.getRealPath((String)"/")), npmFileName);
            }
        }
        catch (Throwable t) {
            D.log(t);
            context.addErrorMsg(t.getLocalizedMessage());
        }
    }

    private void updateSchemaExtensionInfo() {
        AuthenticationBroker broker = this.mcontext.getAuthenticationBroker();
        String accessdomain = broker.getAuthLdapAccessDomain();
        String port = null;
        try {
            if (broker.getAuthUseLdapSSL()) {
                if (accessdomain.toLowerCase().indexOf("ldaps://") != -1 && accessdomain.toLowerCase().indexOf("[") != -1 && accessdomain.toLowerCase().indexOf("]") != -1) {
                    int portIndex = accessdomain.substring("ldaps://".length()).indexOf(93);
                    if (portIndex != -1) {
                        port = accessdomain.substring("ldaps://".length() + portIndex + 2);
                        accessdomain = accessdomain.substring("ldaps://".length(), "ldaps://".length() + portIndex + 1);
                    } else {
                        port = broker.getAuthLdapDefaultSSLPort();
                        accessdomain = accessdomain.substring("ldaps://".length());
                    }
                } else if (accessdomain.toLowerCase().indexOf("ldaps://") != -1) {
                    int portindex = accessdomain.substring("ldaps://".length()).indexOf(58);
                    if (portindex != -1) {
                        port = accessdomain.substring("ldaps://".length() + portindex + 1);
                        accessdomain = accessdomain.substring("ldaps://".length(), "ldaps://".length() + portindex);
                    } else {
                        port = broker.getAuthLdapDefaultSSLPort();
                        accessdomain = accessdomain.substring("ldaps://".length());
                    }
                } else {
                    port = broker.getAuthLdapDefaultSSLPort();
                }
            } else if (accessdomain.toLowerCase().indexOf("ldap://") != -1) {
                int portindex = accessdomain.substring("ldap://".length()).indexOf(58);
                if (portindex != -1) {
                    port = accessdomain.substring("ldap://".length() + portindex + 1);
                    accessdomain = accessdomain.substring("ldap://".length(), "ldap://".length() + portindex);
                } else {
                    port = broker.getAuthLdapDefaultClearPort();
                    accessdomain = accessdomain.substring("ldap://".length());
                }
            } else {
                port = broker.getAuthLdapDefaultClearPort();
            }
            D.log("accessdomain=" + accessdomain);
            PortalModuleInstallManager.setSchemaDetails((String)accessdomain, (String)broker.getAuthLdapName(), (String)broker.getAuthPIdentity(), (boolean)broker.getAuthUseLdapSSL(), (String)port);
        }
        catch (AuthBrokerException e1) {
            e1.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isUpgradable(Hashtable htUpgrades, String sFileName) {
        return htUpgrades.containsKey(sFileName);
    }

    public AsyncContext getContext() {
        return this.context;
    }
}

