/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.webaccess.common.Browser;
import com.novell.webaccess.common.I18NServletRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class DownloadFileTask
extends Task {
    private static final long serialVersionUID = 1L;
    private static final char cDefExtCharReplace = '!';
    I18NServletRequest req;
    TaskContext context;
    Properties resultStrings;

    public void setErrorReturn() {
        this.req.setParameter("merge", "dev.GenMsg");
        this.req.setParameter("GeneralMsg.Mode", "error");
        this.req.setParameter("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "DownloadFile.ErrorMessageHeader", this.context));
        String filename = this.req.getParameter("file");
        try {
            if (filename == null) {
                filename = "";
            } else {
                File f = new File(this.context.getWebappHome().getAbsolutePath() + "/" + filename);
                filename = f.getName();
            }
        }
        catch (Throwable t) {
            D.log(t);
        }
        String preFormattedMessage = eMFrameUtils.getLocalizedString("FwResources", "DownloadFile.ErrorMessageBody", this.context);
        String msg = eMFrameUtils.formatMessage(preFormattedMessage, new String[]{filename});
        this.req.setParameter("GeneralMsg.MsgBody", msg);
        D.log(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(TaskContext context, Properties resultStrings) {
        String mimeType;
        D.log("DownloadFileTask:: Starting execute()");
        this.context = context;
        this.resultStrings = resultStrings;
        this.req = (I18NServletRequest)context.getRequest();
        int size = 0;
        OutputStream out = null;
        FileInputStream in = null;
        byte[] b = new byte[2048];
        String sUA = this.req.getHeader("user-agent");
        Browser browser = null;
        if (sUA != null) {
            browser = Browser.getInstance((HttpServletRequest)this.req);
        }
        String sFilename = this.req.getParameter("file");
        Vector okFiles = (Vector)context.getAuthAttribute("dev.DownloadableFiles");
        boolean okToDownload = false;
        if (okFiles != null) {
            for (int i = 0; i < okFiles.size(); ++i) {
                if (!okFiles.get(i).equals(sFilename)) continue;
                okToDownload = true;
                break;
            }
        }
        if (!okToDownload) {
            D.log("File not allowed for download;  Has not been added to list.");
            this.setErrorReturn();
            return false;
        }
        sFilename = context.getWebappHome().getAbsolutePath() + "/" + sFilename;
        try {
            File canonFile = new File(sFilename);
            String canonName = canonFile.getCanonicalPath();
            String webappHomeCanonName = context.getWebappHome().getCanonicalPath();
            D.log("canonName = " + canonName + ", homeCanonName = " + webappHomeCanonName);
            if (!canonName.startsWith(webappHomeCanonName)) {
                this.setErrorReturn();
                return false;
            }
        }
        catch (Exception e) {
            D.log(e);
            this.setErrorReturn();
            return false;
        }
        if (sFilename == null) {
            D.log("DownloadFileTask::sFilename == null");
            this.setErrorReturn();
            return false;
        }
        int iDotPos = sFilename.lastIndexOf(".");
        if (iDotPos == -1 && !browser.getName().equals("MSIE")) {
            sFilename = sFilename + ".";
        }
        if ((mimeType = this.req.getParameter("mimetype")) != null) {
            D.log("DownloadFileTask::Setting content type to:" + mimeType);
            this.res.setContentType(mimeType);
        } else if (browser.getName().equals("MSIE") || browser.getName().equals("NSN") && Integer.parseInt(browser.getMajorVersion()) < 5) {
            this.res.setContentType("Novell/WebAccess-eMFrameNative");
        } else {
            this.res.setContentType("application/octet-stream");
        }
        try {
            D.log("DownloadFileTask:: Beginning to load file");
            in = new FileInputStream(sFilename);
            out = this.res.getOutputStream();
            File file = new File(sFilename);
            size = (int)file.length();
            this.res.setHeader("Content-Length", String.valueOf(size));
            D.log("DownloadFileTask:: Length of file:" + size);
            String m_sBrowserName = browser.getName();
            String shortName = file.getName();
            if (shortName != null) {
                if (m_sBrowserName.equals("NSN") || m_sBrowserName.equals("MOZILLA")) {
                    shortName = this.removeExtChars(shortName);
                    boolean bNeedQuotes = true;
                    if (sUA != null) {
                        browser = Browser.getInstance((HttpServletRequest)this.req);
                        int iMajorVer = 0;
                        try {
                            iMajorVer = Integer.parseInt(browser.getMajorVersion());
                            if (iMajorVer >= 5) {
                                bNeedQuotes = false;
                            }
                        }
                        catch (NumberFormatException e) {
                            bNeedQuotes = false;
                        }
                    }
                    if (bNeedQuotes) {
                        this.res.setHeader("Content-Disposition", "attachment; filename=\"" + shortName + "\"");
                    } else {
                        this.res.setHeader("Content-Disposition", "attachment; filename=" + shortName);
                    }
                } else {
                    this.res.setHeader("Content-Disposition", "attachment; filename=" + shortName);
                    this.res.setHeader("Pragma", "public");
                    this.res.setHeader("Cache-Control", "max-age=0");
                }
            }
            while (size != 0) {
                int iReadSize = in.read(b, 0, Math.min(size, b.length));
                size -= iReadSize;
                out.write(b, 0, iReadSize);
            }
        }
        catch (Exception e) {
            D.log(e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {
                D.log(e);
            }
            try {
                out.close();
            }
            catch (Exception e) {
                D.log(e);
            }
        }
        D.log("DownloadFileTask:: File sent");
        return true;
    }

    protected String removeExtChars(String sFilename) {
        return this.removeExtChars(sFilename, '!');
    }

    protected String removeExtChars(String sFilename, char cExtCharReplace) {
        StringBuffer sModName = new StringBuffer(sFilename);
        int nStrLen = sModName.length();
        byte[] bString = null;
        try {
            bString = sFilename.getBytes("8859_1");
        }
        catch (Exception e) {
            D.log(e);
        }
        if (cExtCharReplace == '\u0000' || cExtCharReplace == '?') {
            cExtCharReplace = (char)33;
        }
        for (int i = 0; i < nStrLen; ++i) {
            if (bString[i] != 63 && bString[i] >= 32 && bString[i] < 128) continue;
            sModName.setCharAt(i, cExtCharReplace);
        }
        return sModName.toString();
    }
}

