/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.fw.EmailEvent;
import com.novell.emframe.fw.EmailSMTPServer;
import com.novell.nps.WebappUtil;
import com.novell.nps.utils.Log;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.servlet.ServletContext;

public class EmailEventService {
    private static String DT = "EmailEventService";
    public static final String EMAIL_SMTP_SERVER = "Email.SMTPServer";
    public static final String EMAIL_SMTP_SENDER = "Email.SMTPSender";
    public static final String EVENT_ADMIN_ADDRS = "Email.EventAdminAddrs";
    public static final String EVENT_ALT_ADDRS = "Email.EventAltAddrs";
    public static final String EVENT_ADDR_OVERRIDE = "Email.EventAddrOverride";
    public static final String EVENT_SUBJECT = "Email.EventSubject";
    public static final String EVENT_MESSAGE = "Email.EventMessage";
    public static final String EVENTS_SELECTED = "Email.EventsSelected";
    private static LinkedList eventList = new LinkedList();
    private static Thread dispatchThread = new MailHandlerThead();
    public static SystemConfig sc = new SystemConfig();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void postEventEmail(EmailEvent event) {
        if (dispatchThread == null || !dispatchThread.isAlive()) {
            dispatchThread = new MailHandlerThead();
            Log.log((String)DT, (int)3, (String)"Starting Thread");
            D.log("Starting Thread");
            dispatchThread.start();
            dispatchThread.setPriority(7);
        }
        LinkedList linkedList = eventList;
        synchronized (linkedList) {
            eventList.addLast(event);
            eventList.notify();
        }
    }

    static {
        Log.log((String)DT, (int)3, (String)"Starting Thread");
        D.log("Starting Thread");
        dispatchThread.start();
        dispatchThread.setPriority(7);
    }

    private static class MailHandlerThead
    extends Thread {
        private MailHandlerThead() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            Vector vSelectedEvents = this.getSelectedEvents();
            while (true) {
                EmailEvent event = null;
                LinkedList linkedList = eventList;
                synchronized (linkedList) {
                    if (eventList.isEmpty()) {
                        try {
                            eventList.wait();
                            vSelectedEvents = this.getSelectedEvents();
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        event = (EmailEvent)eventList.removeFirst();
                        MailHandlerThead.sendMail(event, vSelectedEvents);
                    }
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    Log.log((String)DT, (int)3, (Throwable)e);
                    D.log(e);
                    continue;
                }
                break;
            }
        }

        private Vector getSelectedEvents() {
            Vector<String> temp = new Vector<String>();
            String[] saSelectedEvents = sc.getSettings(EmailEventService.EVENTS_SELECTED);
            if (saSelectedEvents != null) {
                for (int i = 0; i < saSelectedEvents.length; ++i) {
                    String saSelectedEvent = saSelectedEvents[i];
                    temp.add(saSelectedEvent);
                }
            }
            return temp;
        }

        private static void addSubcribers(Vector vTo, String eventID, Vector vSelectedEvents) {
            if (vSelectedEvents.contains(eventID)) {
                String s;
                StringTokenizer stringTokenizer;
                String emailList = sc.getSetting(EmailEventService.EVENT_ADMIN_ADDRS);
                String sOverrideAdmin = sc.getSetting("Email.EventAddrOverride." + eventID, "false");
                if (emailList != null && emailList.length() > 0 && sOverrideAdmin.equalsIgnoreCase("false")) {
                    stringTokenizer = new StringTokenizer(emailList, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        s = stringTokenizer.nextToken();
                        if (s.indexOf("@") <= 0) continue;
                        vTo.add(s);
                    }
                }
                if ((emailList = sc.getSetting("Email.EventAltAddrs." + eventID)) != null && emailList.length() > 0) {
                    stringTokenizer = new StringTokenizer(emailList, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        s = stringTokenizer.nextToken();
                        if (s.indexOf("@") <= 0) continue;
                        vTo.add(s);
                    }
                }
            }
        }

        private static void sendMail(EmailEvent event, Vector vSelectedEvents) {
            Vector vTo;
            Properties props = System.getProperties();
            Object oSMTPServer = sc.getObjectSetting("Email.SMTPServer1");
            if (oSMTPServer == null) {
                return;
            }
            EmailSMTPServer server = (EmailSMTPServer)oSMTPServer;
            String sSMTPServer = server.getServer();
            String sUsername = server.getUsername();
            String sPassword = server.getPassword();
            if (sUsername != null && sPassword != null) {
                props.setProperty("mail.smtp.auth", "true");
            }
            if ((vTo = event.getSendToAddrs()) == null) {
                vTo = new Vector();
            }
            MailHandlerThead.addSubcribers(vTo, event.getEventID(), vSelectedEvents);
            if (vTo.isEmpty()) {
                return;
            }
            Enumeration myenum = vTo.elements();
            while (myenum.hasMoreElements()) {
                Object obj = myenum.nextElement();
                if (!(obj instanceof String)) continue;
                String destinationAddress = (String)obj;
                try {
                    Session mailSession = Session.getInstance((Properties)props, null);
                    MimeMessage replyMessage = new MimeMessage(mailSession);
                    InternetAddress from = new InternetAddress();
                    if (event.getSenderAddr() != null) {
                        from.setAddress(event.getSenderAddr());
                    }
                    if (event.getSenderCN() != null) {
                        from.setPersonal(event.getSenderCN());
                    }
                    replyMessage.setFrom((Address)from);
                    if (event.getSubjectString() != null && event.getSubjectString().length() > 0) {
                        replyMessage.setSubject(event.getSubjectString());
                    }
                    InternetAddress address = new InternetAddress(destinationAddress);
                    replyMessage.setRecipient(Message.RecipientType.TO, (Address)address);
                    MailHandlerThead.addAttachments((Message)replyMessage, event.getMessageString(), null);
                    Transport tr = mailSession.getTransport("smtp");
                    Log.log((String)DT, (int)3, (String)(sUsername + " is Connecting to SMTP server: " + sSMTPServer));
                    D.log(sUsername + " is Connecting to SMTP server: " + sSMTPServer);
                    tr.connect(sSMTPServer, sUsername, sPassword);
                    replyMessage.saveChanges();
                    tr.sendMessage((Message)replyMessage, replyMessage.getAllRecipients());
                    tr.close();
                }
                catch (AddressException e) {
                    Log.log((String)DT, (int)1, (String)("Invalid address, skipping: " + (Object)((Object)e)));
                    D.log("Invalid address, skipping: " + (Object)((Object)e));
                }
                catch (UnsupportedEncodingException e) {
                    Log.log((String)DT, (int)1, (String)("Encoding error: " + e));
                    D.log("Encoding error: " + e);
                }
                catch (MessagingException e) {
                    Log.log((String)DT, (int)1, (String)("Error sending message to: " + destinationAddress + " error: " + (Object)((Object)e)));
                    D.log("Error sending message to: " + destinationAddress + " error: " + (Object)((Object)e));
                }
            }
        }

        private static boolean addAttachments(Message msg, String msgBody, Vector attachments) {
            boolean rcode = false;
            MimeMultipart mp = new MimeMultipart();
            if (msgBody != null) {
                try {
                    MimeBodyPart mbp1 = new MimeBodyPart();
                    if (msgBody.indexOf("<html>") > -1) {
                        mbp1.setContent((Object)msgBody.toString(), "text/html");
                    } else {
                        mbp1.setText(msgBody.toString());
                    }
                    mp.addBodyPart((BodyPart)mbp1);
                    rcode = true;
                }
                catch (Exception e) {
                    Log.log((String)DT, (int)1, (String)"Attach Message Error:");
                    D.log("Attach Message Error:");
                    Log.log((String)DT, (int)1, (Throwable)e);
                    D.log(e);
                }
            }
            try {
                if (attachments != null) {
                    Enumeration loop = attachments.elements();
                    while (loop.hasMoreElements()) {
                        FileInputStream fis;
                        String fileName = (String)loop.nextElement();
                        try {
                            fis = new FileInputStream(fileName);
                        }
                        catch (FileNotFoundException e) {
                            Log.log((String)DT, (int)1, (Throwable)e);
                            D.log(e);
                            continue;
                        }
                        MimeBodyPart mbp2 = new MimeBodyPart((InputStream)fis);
                        mbp2.setFileName(fileName.substring(fileName.lastIndexOf("/") + 1, fileName.length()));
                        mp.addBodyPart((BodyPart)mbp2);
                        try {
                            fis.close();
                        }
                        catch (IOException ioe) {
                            Log.log((String)DT, (int)1, (Throwable)ioe);
                            D.log(ioe);
                        }
                    }
                }
                msg.setContent((Multipart)mp);
            }
            catch (MessagingException mex) {
                Log.log((String)DT, (int)1, (Throwable)mex);
                D.log(mex);
            }
            return rcode;
        }

        private static String getFileType(String fileName) {
            String mimeType = null;
            ServletContext sc = WebappUtil.getStaticServletContext();
            if (sc != null) {
                mimeType = sc.getMimeType(fileName);
            }
            if (mimeType != null) {
                return mimeType;
            }
            return new String("application/octet-stream");
        }
    }
}

