/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.RBSUtil;
import com.novell.rbs.RBSSchemaVerifier;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class ExtendSchemaTask
extends Task {
    private static final long serialVersionUID = 1L;
    HttpServletRequest req;
    TaskContext context;
    Properties resultStrings;

    @Override
    public boolean execute(TaskContext context, Properties resultStrings) {
        this.context = context;
        this.resultStrings = resultStrings;
        this.req = context.getRequest();
        String nextState = this.req.getParameter("nextState");
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("doExtendSchema")) {
            return this.doExtendSchema();
        }
        return this.showInitialForm();
    }

    private boolean showInitialForm() {
        this.setRepeatable(false);
        ObjectEntry treeOE = RBSUtil.getTreeOE(this.context);
        try {
            RBSSchemaVerifier rbsVerifier = new RBSSchemaVerifier(treeOE);
            this.context.setAuthAttribute("RBSSchemaVerifier", rbsVerifier);
            if (!rbsVerifier.isSchemaValid()) {
                this.resultStrings.put("Schema.Extended", "False");
            } else {
                this.resultStrings.put("Schema.Extended", "True");
            }
        }
        catch (Exception e) {
            D.log(e);
            eMFrameUtils.setErrorMessage(e, this.context);
            return false;
        }
        return true;
    }

    private boolean doExtendSchema() {
        this.resultStrings.put("TaskAfterGenConf", "fw.HomePage");
        this.resultStrings.put("MergeAfterGenConf", "fw.HomePage");
        try {
            RBSSchemaVerifier rbsVerifier = (RBSSchemaVerifier)this.context.getAuthAttribute("RBSSchemaVerifier");
            rbsVerifier.extendSchema();
            this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.EXTEND_SCHEMA_SUCCESS", this.context));
            this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.EXTEND_SCHEMA", this.context));
            return true;
        }
        catch (Exception e) {
            D.log(e);
            eMFrameUtils.setErrorMessage(e, this.context);
            return false;
        }
    }
}

