/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.AsyncContext;
import com.novell.emframe.dev.AsyncWorker;
import com.novell.emframe.dev.Countable;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MTask;
import com.novell.emframe.fw.AsyncProgressFormat;
import com.novell.emframe.fw.FwUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class FwAsyncContext
implements AsyncContext {
    ArrayList errors = new ArrayList();
    ArrayList status = new ArrayList();
    long startTime;
    boolean isComplete = false;
    private AsyncWorker worker;
    Thread thread = null;
    MTask task = null;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private HttpSession session;
    private Locale locale;
    private AsyncProgressFormat format;

    public FwAsyncContext(AsyncWorker worker, MTask task, HttpSession session) {
        this.worker = worker;
        this.task = task;
        this.session = session;
        this.locale = FwUtils.getCurrentLocale(session);
    }

    public void setRequest(HttpServletRequest req) {
        this.request = req;
    }

    @Override
    public void addStatusMsg(String msg) {
        this.status.add(msg);
    }

    @Override
    public List getStatusMsgs() {
        return this.status;
    }

    @Override
    public void addErrorMsg(String msg) {
        this.errors.add(msg);
    }

    @Override
    public List getErrorMsgs() {
        return this.errors;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }

    public void setIsComplete(boolean complete) {
        this.isComplete = complete;
        D.log("Thread: " + this.thread.getName() + " has completed.");
    }

    public void start() {
        this.thread = new FwAsyncThread(this);
        this.thread.start();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public boolean isCountable() {
        return this.worker instanceof Countable;
    }

    public int getTotal() {
        return this.isCountable() ? ((Countable)((Object)this.worker)).getTotalCount(this) : -1;
    }

    public int getNumberCompleted() {
        return this.isCountable() ? ((Countable)((Object)this.worker)).getCompletedCount(this) : -1;
    }

    public void interrupt() {
        this.worker.onInterrupt(this);
    }

    public void updateUI() {
        this.worker.updateUI(this);
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public void setFormat(AsyncProgressFormat format) {
        this.format = format;
    }

    public AsyncProgressFormat getProgressFormat() {
        return this.format;
    }

    class FwAsyncThread
    extends Thread {
        FwAsyncContext context;

        public FwAsyncThread(FwAsyncContext context) {
            super(context.task.getTaskInstanceId());
            this.context = context;
        }

        @Override
        public void run() {
            FwAsyncContext.this.worker.run(this.context);
            this.context.setIsComplete(true);
        }
    }
}

