/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.authDev.iMgrAuthenticatorImpl;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.authenticator.iMgrAuthenticator;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.authenticator.FwAuthUtils;
import com.novell.emframe.fw.servlet.FwRequest;
import com.novell.emframe.fw.servlet.FwSession;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class FwAttr {
    public static void setFwRequestAttribute(String key, Object value, HttpServletRequest req) {
        FwAttributeHolder attrHolder = null;
        if (req instanceof FwRequest) {
            attrHolder = (FwAttributeHolder)((FwRequest)req).getAttribute("fw.internalData", false, false);
        } else {
            if (FwUtils.showDeveloperWarnings()) {
                D.log("*************** Developer Warning ***************");
                D.log("****Attempting to access Framework request attributes from a request that is not a Framework Request.");
            }
            attrHolder = (FwAttributeHolder)req.getAttribute("fw.internalData");
        }
        if (attrHolder == null) {
            attrHolder = new FwAttributeHolder();
            req.setAttribute("fw.internalData", (Object)attrHolder);
        }
        attrHolder.setAttribute(key, value);
    }

    public static Object getFwRequestAttribute(String key, HttpServletRequest req) {
        FwAttributeHolder attrHolder = null;
        if (req instanceof FwRequest) {
            attrHolder = (FwAttributeHolder)((FwRequest)req).getAttribute("fw.internalData", false, false);
        } else {
            if (FwUtils.showDeveloperWarnings()) {
                D.log("*************** Developer Warning ***************");
                D.log("****Attempting to access Framework request attributes from a request that is not a Framework Request.");
            }
            attrHolder = (FwAttributeHolder)req.getAttribute("fw.internalData");
        }
        if (attrHolder != null) {
            return attrHolder.getAttribute(key);
        }
        return null;
    }

    public static Object removeFwRequestAttribute(String key, HttpServletRequest req) {
        FwAttributeHolder attrHolder = (FwAttributeHolder)req.getAttribute("fw.internalData");
        if (attrHolder != null) {
            return attrHolder.removeAttribute(key);
        }
        return null;
    }

    public static void setFwSessionAttribute(String key, Object value, HttpSession session) {
        FwAttributeHolder attrHolder = (FwAttributeHolder)session.getAttribute("fw.internalData");
        D.assrt(attrHolder != null, "FwAttr.initFwSessionAttributes must be called before FwAttr.setFwSessionAttribute.");
        attrHolder.setAttribute(key, value);
    }

    public static Object getFwSessionAttribute(String key, HttpSession session) {
        FwAttributeHolder attrHolder = (FwAttributeHolder)((FwSession)session).getAttribute("fw.internalData", false);
        if (attrHolder != null) {
            return attrHolder.getAttribute(key);
        }
        return null;
    }

    public static Object removeFwSessionAttribute(String key, HttpSession session) {
        FwAttributeHolder attrHolder = (FwAttributeHolder)session.getAttribute("fw.internalData");
        if (attrHolder != null) {
            return attrHolder.removeAttribute(key);
        }
        return null;
    }

    public static void initFwSessionAttributes(HttpSession session) {
        FwAttributeHolder attrHolder = (FwAttributeHolder)session.getAttribute("fw.internalData");
        if (attrHolder == null) {
            attrHolder = new FwAttributeHolder();
            session.setAttribute("fw.internalData", (Object)attrHolder);
        }
    }

    public static void clearFwSessionAttributesOnLogout(HttpSession session) {
        try {
            if (session.getAttribute("fw.internalData") != null) {
                session.removeAttribute("fw.internalData");
            }
            FwAttr.initFwSessionAttributes(session);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static String dumpFwAttrs(HttpServletRequest req) {
        StringBuffer sb = new StringBuffer("Auth attrs:\n");
        for (Map.Entry authEntry : FwAuthUtils.getSessionAuthenticators(req.getSession()).entrySet()) {
            String authName = (String)authEntry.getKey();
            iMgrAuthenticatorImpl auth = (iMgrAuthenticatorImpl)authEntry.getValue();
            sb.append(authName);
            sb.append("\n");
            FwAttributeHolder attrHolder = (FwAttributeHolder)auth.getAttribute("fw.internalData");
            for (Map.Entry entry : attrHolder.map.entrySet()) {
                sb.append(entry.toString());
                sb.append("\n");
            }
        }
        FwAttributeHolder attrHolder = (FwAttributeHolder)req.getAttribute("fw.internalData");
        for (Map.Entry entry : attrHolder.map.entrySet()) {
            sb.append(entry.toString());
            sb.append("\n");
        }
        attrHolder = (FwAttributeHolder)req.getSession().getAttribute("fw.internalData");
        for (Map.Entry entry : attrHolder.map.entrySet()) {
            sb.append(entry.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void setFwAuthAttribute(String key, Object value, iMgrAuthenticator auth) {
        FwAttributeHolder attrHolder = (FwAttributeHolder)auth.getAttribute("fw.internalData");
        D.assrt(attrHolder != null, "FwAttr.initFwAuthAttributes must be called before FwAttr.setFwAuthAttribute.");
        attrHolder.setAttribute(key, value);
    }

    public static Object getFwAuthAttribute(String key, iMgrAuthenticator auth) {
        FwAttributeHolder attrHolder = (FwAttributeHolder)auth.getAttribute("fw.internalData");
        if (attrHolder != null) {
            return attrHolder.getAttribute(key);
        }
        return null;
    }

    public static void setFwAuthAttr(String key, Object value, HttpServletRequest req) {
        FwAttr.setFwAuthAttribute(key, value, FwUtils.getMContext(req).getAuthenticator());
    }

    public static void setFwAuthAttr(String key, Object value, MContext context) {
        FwAttr.setFwAuthAttribute(key, value, context.getAuthenticator());
    }

    public static Object getFwAuthAttr(String key, HttpServletRequest req) {
        return FwAttr.getFwAuthAttribute(key, FwUtils.getMContext(req).getAuthenticator());
    }

    public static Object getFwAuthAttr(String key, MContext context) {
        return FwAttr.getFwAuthAttribute(key, context.getAuthenticator());
    }

    public static Object removeFwAuthAttribute(String key, iMgrAuthenticator auth) {
        FwAttributeHolder attrHolder = (FwAttributeHolder)auth.getAttribute("fw.internalData");
        if (attrHolder != null) {
            return attrHolder.removeAttribute(key);
        }
        return null;
    }

    public static Object removeFwAuthAttr(String key, HttpServletRequest req) {
        return FwAttr.getFwAuthAttribute(key, FwUtils.getMContext(req).getAuthenticator());
    }

    public static Object removeFwAuthAttr(String key, MContext context) {
        return FwAttr.removeFwAuthAttribute(key, context.getAuthenticator());
    }

    public static void initFwAuthAttributes(iMgrAuthenticator auth) {
        FwAttributeHolder attrHolder = (FwAttributeHolder)auth.getAttribute("fw.internalData");
        if (attrHolder == null) {
            attrHolder = new FwAttributeHolder();
            auth.setAttribute("fw.internalData", attrHolder);
        }
    }

    private static class FwAttributeHolder {
        private HashMap map = new HashMap();

        private FwAttributeHolder() {
        }

        void setAttribute(String key, Object value) {
            this.map.put(key, value);
        }

        Object getAttribute(String key) {
            return this.map.get(key);
        }

        Object removeAttribute(String key) {
            return this.map.remove(key);
        }
    }
}

