/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.HistoryNode;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.MTask;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.authenticator.AuthContext;
import com.novell.emframe.dev.authenticator.iMgrAuthenticator;
import com.novell.emframe.dev.config.UserConfig;
import com.novell.emframe.fw.FwAttr;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.MTaskWrapper;
import com.novell.emframe.fw.ObjectNameHistory;
import com.novell.emframe.fw.ServiceSyncLock;
import com.novell.emframe.fw.authenticator.AuthLoader;
import com.novell.emframe.fw.authenticator.DirAuthenticator;
import com.novell.emframe.fw.iManager;
import com.novell.emframe.fw.legacySupport.LegacyTask;
import com.novell.emframe.fw.npsCompat.NPSCompatUtils;
import com.novell.emframe.fw.servlet.FwRequest;
import com.novell.webaccess.common.I18NLocale;
import com.novell.webaccess.common.I18NServletRequest;
import com.novell.webaccess.common.UserInfo;
import java.io.File;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jdom.Document;

public class FwTaskContext
implements MContext {
    protected static String sm_contextPath = null;
    protected HttpServletRequest m_httpServletRequest;
    protected HttpSession m_session;
    protected I18NLocale m_i18nLocale;
    protected DirAuthenticator m_dirAuth;
    protected iMgrAuthenticator m_authenticator;
    protected LegacyTask m_legacyTask;
    private static final String FW_SESSIONLOCK = "fw.SessionLock";

    public FwTaskContext(HttpServletRequest req, LegacyTask bgi, boolean bTemporary) {
        if (req instanceof I18NServletRequest) {
            this.m_httpServletRequest = req;
        } else {
            D.log("Request was not an FwRequest.  Creating FwRequest.");
            FwRequest fwRequest = new FwRequest(req, null);
            this.m_httpServletRequest = fwRequest;
        }
        if (this.m_httpServletRequest != null) {
            this.m_session = this.m_httpServletRequest.getSession();
            this.m_dirAuth = DirAuthenticator.getDirAuth(req);
            this.m_authenticator = AuthLoader.getPrimaryAuthenticator(req);
            FwTaskContext fakeContext = (FwTaskContext)FwAttr.getFwRequestAttribute("FakeTaskContext", req);
            if (bTemporary) {
                D.assrt(fakeContext == null, "A second fake context has been created.");
                FwAttr.setFwRequestAttribute("FakeTaskContext", this, req);
            } else {
                FwAttr.setFwRequestAttribute("fw.Context", this, this.m_httpServletRequest);
                if (fakeContext != null) {
                    FwAttr.removeFwRequestAttribute("FakeTaskContext", req);
                }
            }
        }
        if (sm_contextPath == null) {
            sm_contextPath = this.m_httpServletRequest.getContextPath();
        }
        this.m_legacyTask = bgi;
        this.m_authenticator = AuthLoader.getPrimaryAuthenticator(req);
    }

    public FwTaskContext(HttpServletRequest req) {
        this(req, (LegacyTask)FwAttr.getFwRequestAttribute("BGI", req), false);
    }

    protected FwTaskContext() {
    }

    public void makeLike(FwTaskContext context) {
        this.m_httpServletRequest = context.getRequest();
        this.m_session = this.m_httpServletRequest.getSession();
        this.m_legacyTask = context.getLegacyTask();
        this.m_dirAuth = DirAuthenticator.getDirAuth(context.getRequest());
        this.m_authenticator = context.getAuthenticator();
    }

    @Override
    public iMgrAuthenticator getAuthenticator() {
        return this.m_authenticator;
    }

    public UserInfo getUserInfo() {
        return new UserInfo(this);
    }

    @Override
    public Object getAuthAttribute(Object attrKey) {
        this.m_authenticator = this.getAuthenticator();
        if (this.m_authenticator != null) {
            AuthContext ac = this.m_authenticator.getAuthContext();
            return ac.get(attrKey);
        }
        return this.m_dirAuth.getAttribute(attrKey);
    }

    @Override
    public void setAuthAttribute(Object attrKey, Object attrValue) {
        this.m_authenticator = this.getAuthenticator();
        if (this.m_authenticator != null) {
            AuthContext ac = this.m_authenticator.getAuthContext();
            ac.put(attrKey, attrValue);
        } else {
            this.m_dirAuth.setAttribute(attrKey, attrValue);
        }
    }

    @Override
    public void removeAuthAttribute(Object attrKey) {
        this.m_authenticator = this.getAuthenticator();
        if (this.m_authenticator != null) {
            AuthContext ac = this.m_authenticator.getAuthContext();
            ac.remove(attrKey);
        } else {
            this.m_dirAuth.removeAttribute(attrKey);
        }
    }

    @Override
    public Locale getLocale() {
        return FwUtils.getCurrentLocale(this.m_session);
    }

    @Override
    public File getWebappHome() {
        return iManager.sm_fileWebAppHome;
    }

    @Override
    public void addToHistory(ObjectEntry oe) {
        this.getObjectNameHistory().add(oe);
    }

    @Override
    public void addToHistory(String objectTypeName, String objectName) {
        this.getObjectNameHistory().add(objectTypeName, objectName);
    }

    public void addToHistory(String objectName) {
        AdminNamespace ns = DirUtils.getAdminNamespace(this);
        D.assrt(ns != null, "addToHistory can't get AdminNamespace");
        if (ns != null) {
            try {
                ObjectEntry oe = ns.getObjectEntry(objectName);
                D.assrt(oe != null, "addToHistory can't create oe for " + objectName);
                if (oe != null) {
                    this.addToHistory(oe.getTypeName(), objectName);
                }
            }
            catch (SPIException e) {
                D.log(e);
            }
        }
    }

    @Override
    public void removeFromHistory(String objectName) {
        this.getObjectNameHistory().remove(objectName);
    }

    protected ObjectNameHistory getObjectNameHistory() {
        ObjectNameHistory history = (ObjectNameHistory)this.m_dirAuth.getAttribute("fw.ObjectNameHistory");
        if (history == null) {
            history = new ObjectNameHistory(this);
            this.m_dirAuth.setAttribute("fw.ObjectNameHistory", history);
        }
        return history;
    }

    @Override
    public void clearHistory() {
        this.getObjectNameHistory().clear();
    }

    @Override
    public HistoryNode[] getHistory(String[] objectTypeNames) {
        return this.getObjectNameHistory().getHistory(objectTypeNames);
    }

    @Override
    public boolean isTaskAvailable(String taskId) {
        Document doc = FwUtils.getTaskDocument(this, taskId);
        if (doc == null) {
            return false;
        }
        return FwUtils.callVerifyForDeviceMethod(this, doc) == null;
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.m_httpServletRequest;
    }

    @Override
    public DirUtils getDirUtils() {
        return this.m_dirAuth.getDirUtils();
    }

    @Override
    public AuthenticationBroker getAuthenticationBroker() {
        if (this.m_dirAuth == null) {
            return null;
        }
        return this.m_dirAuth.getAuthenticationBroker();
    }

    public AuthenticationBroker getAuthenticationBroker(String authName) {
        return this.m_dirAuth.getAuthenticationBroker(authName);
    }

    public HttpServletResponse getResponse() {
        return ((FwRequest)this.getRequest()).getResponse();
    }

    public Properties getResultStrings() {
        return ((FwRequest)this.getRequest()).getResultStrings();
    }

    @Override
    public String getDeviceType() {
        return FwUtils.getDeviceType(this.getRequest().getSession());
    }

    @Override
    public String getContextPath() {
        return this.m_httpServletRequest.getContextPath();
    }

    @Override
    public String getModulesPath() {
        return this.getContextPath() + "/portal/modules";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceSyncLock getSynchLock() {
        HttpSession httpSession = this.m_session;
        synchronized (httpSession) {
            ServiceSyncLock lock = (ServiceSyncLock)this.m_session.getAttribute(FW_SESSIONLOCK);
            if (lock == null) {
                lock = new ServiceSyncLock();
                this.m_session.setAttribute(FW_SESSIONLOCK, (Object)lock);
            }
            return lock;
        }
    }

    @Override
    public HttpSession getSession() {
        return this.m_session;
    }

    @Override
    public String getTaskId() {
        return this.m_legacyTask.getTaskId();
    }

    @Override
    public Task getLiveTask(String taskId) {
        LegacyTask task = NPSCompatUtils.getLegacyTask(taskId, this.m_session);
        D.assrt(task instanceof Task, "The task '" + task + "' is not a task and can not be returned from get live task.");
        if (task instanceof Task) {
            return (Task)((Object)task);
        }
        return null;
    }

    public MTask getLiveMTask(String taskId) {
        Task gadget = this.getLiveTask(taskId);
        return ((MTaskWrapper)gadget).getMTask();
    }

    @Override
    public void setPersistentData(String configID, String keyId, String data) {
        if (configID == null) {
            configID = this.createConfigID();
        }
        try {
            UserConfig uc = UserConfig.getUserConfig(configID, this);
            uc.setSetting(keyId, data);
            uc.writeSettings();
        }
        catch (Exception e) {
            D.log(e);
        }
    }

    @Override
    public String getPersistentData(String configID, String keyId) {
        if (configID == null) {
            configID = this.createConfigID();
        }
        UserConfig uc = UserConfig.getUserConfig(configID, this);
        return uc.getSetting(keyId);
    }

    private String createConfigID() {
        String sRet = "";
        String sTaskId = this.getTaskId();
        if (sTaskId != null) {
            String sTask = null;
            String sModule = null;
            int i = sTaskId.lastIndexOf(46);
            if (i != -1) {
                sTask = sTaskId.substring(i + 1);
                sModule = sTaskId.substring(0, i);
            } else {
                sTask = sTaskId;
                sModule = "UnknownModule";
            }
            sRet = sModule + "::" + sTask;
        }
        return sRet;
    }

    public LegacyTask getLegacyTask() {
        return this.m_legacyTask;
    }
}

