/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.MTask;
import com.novell.emframe.dev.MUtils;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.LookAndFeelDefaults;
import com.novell.emframe.fw.authenticator.FwAuthUtils;
import com.novell.emframe.fw.config.ModuleManager;
import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class HomePageTask
extends MTask {
    @Override
    public void execute(MContext context) {
        ArrayList array;
        HttpServletRequest req = context.getRequest();
        SystemConfig config = SystemConfig.getSystemConfig(context);
        Properties resultStrings = new Properties();
        this.readHomeImageInfo(req, resultStrings, config);
        this.setUIPage("fw/HomePage.jsp");
        if (!FwUtils.isParamTrue("firstTime", context) && (array = (ArrayList)context.getAuthAttribute("fw.HiddenTasks")) != null && array.size() > 0) {
            context.getRequest().setAttribute("hiddenTasks", (Object)"true");
        }
        String modeKey = null;
        String mode = eMFrameUtils.getAccessMode(context);
        modeKey = "Unrestricted".equals(mode) ? "HomePage.UnrestrictedAccessWithAccess" : ("CollectionOwner".equals(mode) ? "HomePage.CollectionOwnerAccessWithAccess" : ("Assigned".equals(mode) ? "HomePage.AssignedAccessWithAccess" : "HomePage.TreeDownAccessWithAccess"));
        String modeWithAccess = eMFrameUtils.getLocalizedString("FwResources", modeKey, context);
        String logginMessagePattern = eMFrameUtils.getLocalizedString("FwResources", "HomePage.LoginMessage", context);
        Object[] loginMessageParams = new String[3];
        loginMessageParams[0] = "<b>" + eMFrameUtils.toDisplay(FwAuthUtils.getFriendlyHostName(context.getRequest())) + "</b>";
        loginMessageParams[1] = "<b>" + eMFrameUtils.toDisplay(FwAuthUtils.getUserFullId(context.getRequest())) + "</b>";
        String modeStr = modeWithAccess;
        if ("browser".equals(FwUtils.getDeviceType(context.getSession()))) {
            modeStr = "<a href=\"#\" onClick=\"javascript:toggleDivDisplay('modeDetails')\">" + modeWithAccess + "</a>";
        }
        loginMessageParams[2] = modeStr;
        String loginMessage = eMFrameUtils.formatMessage(logginMessagePattern, loginMessageParams);
        context.getRequest().setAttribute("loginMessage", (Object)loginMessage);
        context.getRequest().setAttribute("modeWithAccess", (Object)modeWithAccess);
        if (!context.getRequest().getScheme().equals("https")) {
            String sWarnNonSecure = SystemConfig.getSystemConfig(context).getSetting("Security.Warn.nonSecure");
            context.getRequest().setAttribute("warnNonSecure", (Object)sWarnNonSecure);
        }
        boolean bShowModulesToInstall = FwUtils.canConfigureiManager(context.getRequest()) && ModuleManager.areNewModulesPresent();
        context.getRequest().setAttribute("showModuleInstall", (Object)String.valueOf(bShowModulesToInstall));
        context.getRequest().setAttribute("modulesUrl", (Object)MUtils.getModulesUrl(context));
    }

    private void readHomeImageInfo(HttpServletRequest req, Properties resultStrings, SystemConfig config) {
        String imageLoc = config.getSetting("LookAndFeel_HomeImage", LookAndFeelDefaults.HomeImage);
        Boolean bShowHomeImage = new Boolean(true);
        bShowHomeImage = Boolean.valueOf(config.getSetting("LookAndFeel_ShowHomeImage", String.valueOf(bShowHomeImage)));
        req.setAttribute("LookAndFeel_ShowHomeImage", (Object)String.valueOf(bShowHomeImage));
        req.setAttribute("LookAndFeel_HomeImage", (Object)imageLoc);
    }
}

