/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.MTask;
import com.novell.emframe.dev.MUtils;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwTaskContext;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.HiddenPluginsInfo;
import com.novell.emframe.fw.LookAndFeelDefaults;
import com.novell.emframe.fw.ManageFavorites;
import com.novell.emframe.fw.Registry;
import com.novell.emframe.fw.RoleList;
import com.novell.emframe.fw.TaskInfoMap;
import com.novell.emframe.fw.authenticator.FwAuthUtils;
import com.novell.emframe.fw.util.infos.RoleInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;

public class LaunchTask
extends MTask {
    private static final String WEBAPP_HOME_FULL_URL_MACRO = "$(WebApp.Home.Full.url)";
    private static final String LANG_MACRO_NAME = "$(lang)";
    MContext m_context = null;
    HttpServletRequest m_req = null;
    int m_iCatCount = 0;
    int m_iRoleCount = 0;
    int m_iTaskCount = 0;
    Map m_mapURLsById = new HashMap();
    ArrayList m_hiddenTasks = new ArrayList();

    @Override
    public void execute(MContext context) {
        String view;
        this.m_context = context;
        this.m_req = context.getRequest();
        Object deviceType = context.getSession().getAttribute("DeviceType");
        if (deviceType != null && deviceType.equals("pocket")) {
            this.setUIPage("fw/Launch.jsp");
        }
        if (D.isDebugEnabled()) {
            this.m_req.setAttribute("eMFrame.Debug.enable", (Object)"true");
        }
        if ((view = context.getRequest().getParameter("view")) == null || view.equals("")) {
            view = "Tasks";
        }
        try {
            String headingText = eMFrameUtils.getLocalizedString("FwResources", "Header." + view + "Hint", this.m_context);
            this.m_req.setAttribute("Launch.HeadingText", (Object)headingText);
        }
        catch (NullPointerException e) {
            this.m_req.setAttribute("Launch.HeadingText", (Object)"Roles and Tasks");
        }
        SystemConfig config = SystemConfig.getSystemConfig(context);
        HttpServletRequest req = context.getRequest();
        req.setAttribute("headerColor", (Object)config.getSetting("LookAndFeel_MenuHeaderColor", LookAndFeelDefaults.MenuHeaderColor));
        req.setAttribute("menuColor", (Object)config.getSetting("LookAndFeel_MenuColor", LookAndFeelDefaults.MenuColor));
        req.setAttribute("menuTitleColor", (Object)config.getSetting("LookAndFeel_MenuTitleColor", LookAndFeelDefaults.MenuTitleColor));
        String hGif = req.getParameter("view");
        if (hGif == null || hGif.equals("AllTasks") || hGif.equals("Disconn")) {
            hGif = "Tasks";
        }
        hGif = hGif + "Heading.gif";
        hGif = MUtils.getModulesUrl(context) + "/fw/images/" + hGif;
        req.setAttribute("hGif", (Object)hGif);
        this.m_req.setAttribute("view", (Object)view);
        this.m_hiddenTasks.clear();
        this.m_context.setAuthAttribute("fw.HiddenTasks", this.m_hiddenTasks);
        String category = context.getRequest().getParameter("category");
        if (category == null || category.length() == 0) {
            category = "All";
        }
        if (view.equals("Favorites")) {
            this.createFavoritesMenu(this.m_context);
        } else if (view.equals("Tasks")) {
            this.createTasksMenu(category, this.m_context);
        } else {
            this.createMenu(view, category, this.m_context);
        }
    }

    private void createFavoritesMenu(MContext context) {
        String favoritesRoleDisplayName = eMFrameUtils.getLocalizedString("FwResources", "Favorites.FavoritesTitle", context);
        this.m_req.setAttribute("Task_Role_0_Name", (Object)favoritesRoleDisplayName);
        this.m_req.setAttribute("Task_Role_0_Id", (Object)"Favorites");
        String pack = context.getPersistentData("fwPrefs", "fw.favoriteTaskIds");
        String[] taskIds = null;
        if (pack != null) {
            taskIds = eMFrameUtils.unpack(pack, context);
        }
        this.m_iRoleCount = 0;
        this.m_iTaskCount = 0;
        if (taskIds != null) {
            Collection availableTasks = ManageFavorites.discoverAvailableTasks(context);
            for (int i = 0; i < taskIds.length; ++i) {
                Document doc;
                TaskInfoMap taskInfoMap = new TaskInfoMap(taskIds[i], "");
                if (!availableTasks.contains(taskInfoMap) || (doc = FwUtils.getTaskDocument(context, taskIds[i])) == null) continue;
                Throwable error = FwUtils.checkTask(doc, taskIds[i], this.m_context);
                if (error == null) {
                    if (this.processTask(doc, this.m_iRoleCount, this.m_iTaskCount)) {
                        ++this.m_iTaskCount;
                    } else {
                        error = new Exception(eMFrameUtils.getLocalizedString("FwResources", "PluginError.UrlNotAvailable", context));
                    }
                }
                if (error == null) continue;
                HiddenPluginsInfo thi = new HiddenPluginsInfo(error, doc, favoritesRoleDisplayName);
                this.m_hiddenTasks.add(thi);
                D.log("Not adding task, taskId = " + taskIds[i] + ", reason= " + error.getMessage());
            }
        }
        this.m_req.setAttribute("Task_Role_0_Task_Count", (Object)new Integer(this.m_iTaskCount));
        this.m_req.setAttribute("Task_Role_Count", (Object)new Integer(1));
        this.m_req.setAttribute("expandFirstRole", (Object)"true");
    }

    private void createMenu(String view, String categoryId, MContext context) {
        String registry = "Global";
        if (view.equals("Config")) {
            FwAuthUtils.invalidateRolesAndTasksForAllAuths((FwTaskContext)context);
        }
        ArrayList roleDocs = Registry.getRegistry(registry).getSortedRolesInView(view, context);
        this.m_iRoleCount = 0;
        for (int i = 0; i < roleDocs.size(); ++i) {
            List assignedCats;
            boolean bDisplayRole;
            Document roleDoc = (Document)roleDocs.get(i);
            Element root = roleDoc.getRootElement();
            String roleId = root.getChildTextTrim("id");
            boolean bl = bDisplayRole = categoryId == null || categoryId.equals("All");
            if (!bDisplayRole && (assignedCats = root.getChildren("role-category-assignment")) != null) {
                for (Element el : assignedCats) {
                    String assignedCatName = el.getTextTrim();
                    if (assignedCatName == null || !assignedCatName.equalsIgnoreCase(categoryId)) continue;
                    bDisplayRole = true;
                    break;
                }
            }
            if (!bDisplayRole) continue;
            String roleDisplayName = eMFrameUtils.getDisplayName(roleDoc, context);
            ArrayList taskDocs = Registry.getRegistry(registry).getSortedTasksInRole(roleId, context);
            this.m_iTaskCount = 0;
            for (int i2 = 0; i2 < taskDocs.size(); ++i2) {
                String classname;
                Document taskDoc = (Document)taskDocs.get(i2);
                String taskType = taskDoc.getRootElement().getChildTextTrim("type");
                if ((taskType == null || !taskType.equals("url")) && ((classname = eMFrameUtils.getClassName(taskDoc)) == null || classname.length() < 1)) continue;
                String taskId = taskDoc.getRootElement().getChildTextTrim("id");
                Throwable error = FwUtils.checkTask(taskDoc, taskId, this.m_context);
                if (error == null) {
                    if (this.processTask(taskDoc, this.m_iRoleCount, this.m_iTaskCount)) {
                        ++this.m_iTaskCount;
                    } else {
                        error = new Exception(eMFrameUtils.getLocalizedString("FwResources", "PluginError.UrlNotAvailable", context));
                    }
                }
                if (error == null) continue;
                HiddenPluginsInfo thi = new HiddenPluginsInfo(error, taskDoc, roleDisplayName);
                this.m_hiddenTasks.add(thi);
                D.log("Not adding task, taskId = " + taskId + ", reason= " + error.getMessage());
            }
            if (this.m_iTaskCount <= 0) continue;
            this.m_req.setAttribute("Task_Role_" + this.m_iRoleCount + "_Name", (Object)roleDisplayName);
            this.m_req.setAttribute("Task_Role_" + this.m_iRoleCount + "_Task_Count", (Object)new Integer(this.m_iTaskCount));
            ++this.m_iRoleCount;
        }
        if (this.m_hiddenTasks.size() > 0) {
            this.m_req.setAttribute("Launch.ShowHiddenTasksMessage", (Object)"true");
            this.m_req.setAttribute("Launch-ShowHiddenTasksMessage", (Object)"true");
        }
        this.m_req.setAttribute("Task_Role_Count", (Object)new Integer(this.m_iRoleCount));
    }

    private boolean createTasksMenu(String categoryId, MContext context) {
        this.m_iRoleCount = 0;
        D.log("Updating roles and tasks");
        RoleList roleList = RoleList.getInstance(context);
        if (roleList != null) {
            this.processRoles(categoryId, roleList.getRolesByIdSortedByValue(context).values().iterator(), this.m_hiddenTasks);
        }
        if (this.m_hiddenTasks != null && this.m_hiddenTasks.size() > 0 && context.getRequest().getParameter("Launch.ShowHiddenTasksMessage") == null) {
            this.m_req.setAttribute("Launch.ShowHiddenTasksMessage", (Object)"true");
        }
        this.m_req.setAttribute("Task_Role_Count", (Object)new Integer(this.m_iRoleCount));
        return true;
    }

    void processRoles(String categoryId, Iterator enumRoles, ArrayList hiddenTasks) {
        while (enumRoles.hasNext()) {
            RoleInfo roleInfo = (RoleInfo)enumRoles.next();
            if (!categoryId.equals("All") && !roleInfo.isInCategory(categoryId)) {
                D.log("skipping role = " + roleInfo.getDisplayName(this.m_context) + "; not in category " + categoryId);
                continue;
            }
            this.processRole(hiddenTasks, roleInfo);
        }
    }

    private void processRole(ArrayList hiddenTasks, RoleInfo roleInfo) {
        D.log("role = " + roleInfo.getDisplayName(this.m_context) + "...");
        try {
            roleInfo.sortTasks(this.m_context);
            HashMap htSortedTaskDocsById = roleInfo.getTaskDocsById();
            Iterator iterTaskIds = htSortedTaskDocsById.keySet().iterator();
            this.m_iTaskCount = 0;
            while (iterTaskIds.hasNext()) {
                try {
                    String classname;
                    String taskId = (String)iterTaskIds.next();
                    Document taskDoc = (Document)htSortedTaskDocsById.get(taskId);
                    String taskType = taskDoc.getRootElement().getChildTextTrim("type");
                    if ((taskType == null || !taskType.equals("url")) && ((classname = eMFrameUtils.getClassName(taskDoc)) == null || classname.length() < 1)) continue;
                    Throwable error = FwUtils.checkTask(taskDoc, taskId, this.m_context);
                    if (error == null) {
                        if (this.processTask(taskDoc, this.m_iRoleCount, this.m_iTaskCount)) {
                            ++this.m_iTaskCount;
                        } else {
                            error = new Exception(eMFrameUtils.getLocalizedString("FwResources", "PluginError.UrlNotAvailable", this.m_context));
                        }
                    }
                    if (error != null) {
                        HiddenPluginsInfo thi = new HiddenPluginsInfo(error, taskDoc, roleInfo.getDisplayName(this.m_context));
                        hiddenTasks.add(thi);
                        D.log("Not adding task, taskId = " + taskId + ", reason= " + error.getMessage());
                    }
                    D.log("   task = " + taskId);
                }
                catch (Exception e) {
                    D.log(e);
                }
            }
        }
        catch (Exception e) {
            D.log(e);
        }
        if (this.m_iTaskCount > 0) {
            this.m_req.setAttribute("Task_Role_" + this.m_iRoleCount + "_Name", (Object)roleInfo.getDisplayName(this.m_context));
            this.m_req.setAttribute("Task_Role_" + this.m_iRoleCount + "_Id", (Object)roleInfo.getId());
            this.m_req.setAttribute("Task_Role_" + this.m_iRoleCount + "_Task_Count", (Object)new Integer(this.m_iTaskCount));
            ++this.m_iRoleCount;
        }
    }

    boolean processTask(Document doc, int roleIdx, int taskIdx) {
        Element root = doc.getRootElement();
        String taskType = root.getChildTextTrim("type");
        if (taskType != null && taskType.equals("url")) {
            String url = this.getUrl(doc, this.m_context);
            if (url == null) {
                return false;
            }
            this.m_req.setAttribute("Task_Role_" + roleIdx + "_Task_" + taskIdx + "_Url", (Object)url);
        }
        this.m_req.setAttribute("Task_Role_" + roleIdx + "_Task_" + taskIdx + "_Name", (Object)eMFrameUtils.getDisplayName(doc, this.m_context));
        this.m_req.setAttribute("Task_Role_" + roleIdx + "_Task_" + taskIdx + "_TaskId", (Object)root.getChildTextTrim("id"));
        return true;
    }

    private String getUrl(Document doc, MContext context) {
        Element root = doc.getRootElement();
        String id = root.getChildTextTrim("id");
        String url = (String)this.m_mapURLsById.get(id);
        if (url == null) {
            url = root.getChildTextTrim("url");
            int index = url.indexOf(WEBAPP_HOME_FULL_URL_MACRO);
            int langIndex = url.indexOf(LANG_MACRO_NAME);
            if (index != -1 && langIndex != -1) {
                String npsRoot;
                String path;
                Locale locale = context.getLocale();
                String newUrl = this.testLocale(locale, path = (npsRoot = eMFrameUtils.getRealPath(null)) + url.substring(index += WEBAPP_HOME_FULL_URL_MACRO.length()), url);
                if (newUrl == null) {
                    newUrl = this.testLocale(Locale.getDefault(), path, url);
                }
                url = newUrl;
            }
            if (url != null && index != -1) {
                url = eMFrameUtils.replaceSubString(url, WEBAPP_HOME_FULL_URL_MACRO, context.getContextPath());
            }
            this.m_mapURLsById.put(id, url);
        }
        return url;
    }

    private String testLocale(Locale locale, String path, String url) {
        String localeString = locale.getLanguage() + "_" + locale.getCountry();
        String newUrl = null;
        if (!locale.getCountry().equals("")) {
            newUrl = this.testLocaleString(localeString, path, url);
        }
        if (newUrl == null) {
            localeString = locale.getLanguage();
            newUrl = this.testLocaleString(localeString, path, url);
        }
        return newUrl;
    }

    private String testLocaleString(String localeString, String path, String url) {
        String testFile = eMFrameUtils.replaceSubString(path, LANG_MACRO_NAME, localeString);
        if (new File(testFile).exists()) {
            return eMFrameUtils.replaceSubString(url, LANG_MACRO_NAME, localeString);
        }
        return null;
    }
}

