/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.MTask;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameFactory;
import com.novell.emframe.fw.FwAsyncContext;
import com.novell.emframe.fw.FwAttr;
import com.novell.emframe.fw.FwTaskContext;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.legacySupport.LegacyTask;
import com.novell.emframe.fw.servlet.FwRequest;
import com.novell.emframe.fw.servlet.FwSession;
import com.novell.emframe.fw.util.FwAsyncUtils;
import com.novell.emframe.fw.util.FwTaskUtils;
import com.novell.nps.gadgetManager.GadgetInstance;
import com.novell.nps.gadgetManager.GadgetInstanceException;
import com.novell.nps.sessionManager.PortalSession;
import com.novell.webaccess.common.I18NServletRequest;
import java.io.BufferedWriter;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom.Document;

public class MTaskWrapper
extends Task {
    private static final long serialVersionUID = 1L;
    MTask task = null;
    boolean initialized = false;

    public MTaskWrapper(MTask task) {
        this.task = task;
    }

    public MTask getMTask() {
        return this.task;
    }

    public void processRequest(HttpServletRequest req) throws GadgetInstanceException {
        MTaskWrapper.processRequestImpl(this, req);
    }

    @Override
    public boolean execute(TaskContext context, Properties resultStrings) {
        D.assrt(false, " MTaskWrapper.execute should never be called.");
        return false;
    }

    public static void processRequestImpl(MTaskWrapper mTaskWrapper, HttpServletRequest req) throws GadgetInstanceException {
        FwTaskContext context = (FwTaskContext)((Object)eMFrameFactory.getTaskContext(req));
        HttpServletResponse response = ((FwRequest)req).getResponse();
        mTaskWrapper.setUIPage(null);
        String taskId = mTaskWrapper.getInstanceId();
        Document doc = FwUtils.getTaskDocument(context, taskId);
        FwUtils.setBGI(req, (LegacyTask)((Object)mTaskWrapper));
        String taskComplete = req.getParameter("taskComplete");
        if (taskId != null && taskId.equals(req.getParameter(taskId)) && taskComplete != null && taskComplete.equals("true")) {
            MTaskWrapper.endTask(mTaskWrapper, req, context, response);
            return;
        }
        if (!mTaskWrapper.isInitialized()) {
            try {
                Task.addAllUrlParams(doc, (I18NServletRequest)req);
                mTaskWrapper.task.init(context, doc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            mTaskWrapper.setInitialized(true);
        }
        if (FwAsyncUtils.isAsync(context.getSession())) {
            FwAsyncContext asContext = FwAsyncUtils.getAsyncContext(context.getSession());
            asContext.setRequest(context.getRequest());
            if (FwAsyncUtils.isInteruptRequest(context)) {
                asContext.interrupt();
            }
            asContext.updateUI();
            if (asContext.isComplete()) {
                FwAttr.removeFwSessionAttribute("AsyncContext", context.getSession());
            }
        } else {
            mTaskWrapper.task.execute(context);
        }
        req.setAttribute("taskId", (Object)taskId);
        req.setAttribute("GI_ID", (Object)taskId);
        if (mTaskWrapper.task.getTaskComplete()) {
            MTaskWrapper.endTask(mTaskWrapper, req, context, response);
        } else {
            mTaskWrapper.task.render(context, response);
        }
    }

    public String getInstanceId() {
        return this.getGadgetInstanceID();
    }

    private static void endTask(MTaskWrapper mTaskWrapper, HttpServletRequest req, MContext context, HttpServletResponse response) throws GadgetInstanceException {
        mTaskWrapper.returnToPrimary(req, null);
        if (mTaskWrapper.task.getUIPage() != null) {
            mTaskWrapper.task.render(context, response);
        }
    }

    @Override
    public void release() {
        this.task.release();
    }

    public void callGetData(GadgetInstance gInst, HttpServletRequest instRequest, BufferedWriter out, org.w3c.dom.Document dom) throws GadgetInstanceException {
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public String getPreferredDataType() {
        return "text/html";
    }

    public void setSession(PortalSession session) {
        super.setSession(session);
        this.task.init((FwSession)session);
        FwTaskUtils.setMTaskWrapper(this);
    }
}

