/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.MTask;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwAttr;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.Registry;
import com.novell.emframe.fw.RoleList;
import com.novell.emframe.fw.TaskDisplayNameComparator;
import com.novell.emframe.fw.TaskInfoMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;

public class ManageFavorites
extends MTask {
    @Override
    public void execute(MContext context) {
        HttpServletRequest req = context.getRequest();
        String nextState = req.getParameter("nextState");
        if (nextState == null || nextState.equals("initialState")) {
            this.doInitialState(context);
        } else if (nextState.equals("save")) {
            this.doSave(req, context);
        }
    }

    private void doInitialState(MContext context) {
        this.setUIPage("fw/ManageFavorites.jsp");
        String primaryViewId = context.getPersistentData("fwPrefs", "fw.primaryViewId");
        if (primaryViewId != null && primaryViewId.equals("fw.FavoritesView")) {
            context.getRequest().setAttribute("viewSelected", (Object)"true");
        } else {
            context.getRequest().setAttribute("viewSelected", (Object)"false");
        }
        String pack = context.getPersistentData("fwPrefs", "fw.favoriteTaskIds");
        ArrayList<TaskInfoMap> favorites = new ArrayList<TaskInfoMap>();
        if (pack != null) {
            String[] list = new String[]{};
            try {
                list = eMFrameUtils.unpack(pack, context);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (int i = 0; i < list.length; ++i) {
                String displayName = list[i];
                try {
                    Document doc = FwUtils.getTaskDocument(context, list[i]);
                    displayName = eMFrameUtils.getDisplayName(doc, context);
                }
                catch (Exception e) {
                    D.log(e);
                }
                favorites.add(new TaskInfoMap(list[i], displayName));
            }
        }
        context.getRequest().setAttribute("selectedIds", favorites);
        Collection tasks = ManageFavorites.discoverAvailableTasks(context);
        Iterator iter = tasks.iterator();
        while (iter.hasNext()) {
            if (!favorites.contains(iter.next())) continue;
            iter.remove();
        }
        context.getRequest().setAttribute("taskIds", (Object)tasks);
    }

    private void doSave(HttpServletRequest req, MContext context) {
        String pack = req.getParameter("favoriteIds");
        context.setPersistentData("fwPrefs", "fw.favoriteTaskIds", pack);
        String setPrimaryView = req.getParameter("setPrimaryView");
        if (setPrimaryView != null && setPrimaryView.equals("true")) {
            context.setPersistentData("fwPrefs", "fw.primaryViewId", "fw.FavoritesView");
        } else {
            String viewId = context.getPersistentData("fwPrefs", "fw.primaryViewId");
            if (viewId != null && viewId.equals("fw.FavoritesView")) {
                context.setPersistentData("fwPrefs", "fw.primaryViewId", "");
            }
        }
        String title = eMFrameUtils.getLocalizedString("FwResources", "Success", context);
        String body = eMFrameUtils.getLocalizedString("FwResources", "Favorites.successRelogin", context);
        eMFrameUtils.setMessage("success", title, body, context);
        this.setUIPage("dev/GenConf.jsp");
    }

    public static Collection discoverAvailableTasks(MContext context) {
        TreeSet tasks = new TreeSet(new TaskDisplayNameComparator());
        ArrayList viewIds = (ArrayList)FwAttr.getFwSessionAttribute("ViewIdList", context.getSession());
        if (viewIds == null) {
            return tasks;
        }
        if (viewIds.contains("fw.TasksView")) {
            ManageFavorites.discoverRbsTasks(context, tasks);
        }
        if (viewIds.contains("fw.ConfigureView")) {
            ManageFavorites.discoverTaskInView("Global", "Config", tasks, context);
        }
        if (viewIds.contains("fw.DeveloperView")) {
            ManageFavorites.discoverTaskInView("Global", "Dev", tasks, context);
        }
        return new ArrayList(tasks);
    }

    private static void discoverRbsTasks(MContext context, Collection taskInfos) {
        RoleList roleList = RoleList.getInstance(context);
        if (roleList != null) {
            for (Document taskDoc : roleList.getAllTasksById().values()) {
                if (!FwUtils.isPluginSupportedByAnyAuths(taskDoc, context)) continue;
                TaskInfoMap taskInfo = ManageFavorites.convertToTaskInfoMap(taskDoc, context);
                taskInfos.add(taskInfo);
            }
        }
    }

    private static void discoverTaskInView(String registry, String view, Collection tasks, MContext context) {
        ArrayList roles = Registry.getRegistry(registry).getRolesInView(view);
        for (int i = 0; i < roles.size(); ++i) {
            Document roleDoc = (Document)roles.get(i);
            Element root = roleDoc.getRootElement();
            String roleId = root.getChildTextTrim("id");
            ArrayList tasksFromFilesystem = Registry.getRegistry(registry).getTasksInRole(roleId);
            for (Document taskDoc : tasksFromFilesystem) {
                if (!FwUtils.isPluginSupportedByAnyAuths(taskDoc, context)) continue;
                TaskInfoMap taskInfo = ManageFavorites.convertToTaskInfoMap(taskDoc, context);
                tasks.add(taskInfo);
            }
        }
    }

    private static TaskInfoMap convertToTaskInfoMap(Document doc, MContext context) {
        String id = doc.getRootElement().getChildTextTrim("id");
        String displayName = eMFrameUtils.getDisplayName(doc, context);
        return new TaskInfoMap(id, displayName);
    }
}

