/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.BookInfo;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.RBSUtil;
import com.novell.rbs.RBSBook;
import com.novell.rbs.RBSRights;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class ModifyBookObjectTypeTask
extends Task {
    private static final long serialVersionUID = 1L;
    private HttpServletRequest req;
    private TaskContext context;
    private Properties resultStrings;
    private AdminNamespace namespace;
    private ObjectEntry treeOE;
    private String bookDisplayName;

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        FwUtils.verifyRbsInstalled(req, sServiceName);
    }

    @Override
    public boolean execute(TaskContext context, Properties resultStrings) {
        this.context = context;
        this.resultStrings = resultStrings;
        this.req = context.getRequest();
        this.treeOE = RBSUtil.getTreeOE(context);
        this.namespace = this.treeOE.getAdminNamespace();
        String nextState = this.req.getParameter("nextState");
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("showBookObjectType")) {
            return this.showBookObjectType();
        }
        if (nextState.equalsIgnoreCase("showBookPageList")) {
            return this.showBookPageList();
        }
        if (nextState.equalsIgnoreCase("saveBookPageList")) {
            return this.saveBookPageList();
        }
        return false;
    }

    private boolean showInitialForm() {
        this.resultStrings.put("DisplayNameTitle", eMFrameUtils.getLocalizedString("FwResources", "ModifyBookObjectType", this.context));
        this.resultStrings.put("Merge.Template", "fw.ModifyBookObjectType");
        this.resultStrings.put("Next.State", "showBookObjectType");
        return true;
    }

    private boolean showBookObjectType() {
        BookInfo bookInfo = new BookInfo();
        String selectedContext = this.req.getParameter("BookName");
        String[] strings = eMFrameUtils.unpack(selectedContext, this.context);
        selectedContext = strings[0];
        try {
            ObjectEntry bookOE = this.namespace.getObjectEntry(this.treeOE, selectedContext);
            this.bookDisplayName = RBSUtil.getLocalizedDisplayName(this.context, bookOE);
            String objectType = bookOE.getObjectType().getName();
            if (!objectType.equals("rbsBook2")) {
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "Error", this.context));
                this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "GetBookName.WrongClass", this.context));
                return false;
            }
            this.context.addToHistory(bookOE);
            bookInfo.setContext(selectedContext);
            bookInfo.setContextOE(bookOE);
            RBSBook rbsBook = new RBSBook(bookOE);
            String[] assignedObjectTypes = rbsBook.getTargetObjectType();
            if (assignedObjectTypes != null) {
                if (assignedObjectTypes.length == 1 && assignedObjectTypes[0].equals("*")) {
                    this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "Warning", this.context));
                    this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "Book.CannotModifyTypes", this.context));
                    return false;
                }
                bookInfo.setAssignedObjectTypes(assignedObjectTypes);
            }
            String[] assignedPages = rbsBook.getPageMemebership();
            bookInfo.setAssignedPages(assignedPages);
            String[] availableObjectTypes = RBSUtil.readObjectClassTypes(this.treeOE, this.context);
            availableObjectTypes = RBSUtil.removeAssignedFromAvailable(availableObjectTypes, assignedObjectTypes);
            bookInfo.setAvailableObjectTypes(availableObjectTypes);
            String[] availablePages = FwUtils.getAllPageIds(this.context, bookInfo.getAssignedObjectTypes());
            availablePages = RBSUtil.removeAssignedFromAvailable(availablePages, assignedPages);
            bookInfo.setAvailablePages(availablePages);
        }
        catch (Exception e) {
            D.log(e);
            eMFrameUtils.setErrorMessage(e, this.context);
            return false;
        }
        RBSUtil.putAvailableObjectTypes(bookInfo, this.resultStrings);
        RBSUtil.putAssignedObjectTypes(bookInfo, this.resultStrings);
        this.resultStrings.put("BookName_Value", this.bookDisplayName);
        this.context.setAuthAttribute("BookInfo", bookInfo);
        return true;
    }

    private boolean showBookPageList() {
        String assignedObjectTypes = this.req.getParameter("AssignedObjectTypesString");
        if (assignedObjectTypes == null || assignedObjectTypes.length() == 0) {
            this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "CreateBook.ObjectTypeErrorTitle", this.context));
            this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "BookObjectType.NoAssignedTypes", this.context));
            return false;
        }
        SchemaDefinition schemaDef = null;
        BookInfo bookInfo = (BookInfo)this.context.getAuthAttribute("BookInfo");
        String formChanged = this.req.getParameter("BookObjectTypeFormChanged");
        if (formChanged.equals("true")) {
            RBSUtil.getAssignedObjectTypes(bookInfo, this.req);
            String[] availablePages = null;
            try {
                schemaDef = this.namespace.getSchemaDefinition(this.treeOE);
                availablePages = FwUtils.getAllPageIds(this.context, bookInfo.getAssignedObjectTypes());
            }
            catch (Exception e) {
                D.log(e);
                eMFrameUtils.setErrorMessage(e, this.context);
                return false;
            }
            String[] assignedPages = RBSUtil.removePagesThatDontExist(availablePages, bookInfo.getAssignedPages());
            if (availablePages != null) {
                Vector<String> availablePagesV = new Vector<String>();
                for (int i = 0; i < availablePages.length; ++i) {
                    boolean add = true;
                    RBSRights[] rights = FwUtils.getPagesRights(new String[]{availablePages[i]}, this.treeOE);
                    if (rights != null) {
                        for (int j = 0; j < rights.length; ++j) {
                            if (rights[j].getProtectedAttrName().equalsIgnoreCase("[Entry Rights]") || rights[j].getProtectedAttrName().equalsIgnoreCase("[All Attributes Rights]") || rights[j].getProtectedAttrName().equalsIgnoreCase("[No Self Rights Assignment]") || schemaDef.isAttributeDefined(rights[j].getProtectedAttrName())) continue;
                            D.log("--  Discarding page: " + availablePages[i] + " attribute undefined: " + rights[j].getProtectedAttrName());
                            add = false;
                            break;
                        }
                    }
                    if (!add) continue;
                    availablePagesV.addElement(availablePages[i]);
                }
                if (availablePagesV.size() > 0) {
                    availablePages = availablePagesV.toArray(new String[availablePagesV.size()]);
                }
            }
            availablePages = RBSUtil.removeAssignedFromAvailable(availablePages, assignedPages);
            bookInfo.setAvailablePages(availablePages);
            bookInfo.setAssignedPages(assignedPages);
        }
        RBSUtil.putAvailablePages(bookInfo, this.resultStrings, this.context);
        RBSUtil.putAssignedPages(bookInfo, this.resultStrings, this.context);
        this.resultStrings.put("BookName_Value", this.bookDisplayName);
        this.context.setAuthAttribute("BookInfo", bookInfo);
        this.context.setAuthAttribute("BookObjectTypeFormChanged", formChanged);
        return true;
    }

    private boolean saveBookPageList() {
        this.resultStrings.put("TaskAfterGenConf", "fw.HomePage");
        this.resultStrings.put("MergeAfterGenConf", "fw.HomePage");
        BookInfo bookInfo = (BookInfo)this.context.getAuthAttribute("BookInfo");
        String bookObjectTypeFormChanged = (String)this.context.getAuthAttribute("BookObjectTypeFormChanged");
        String formChanged = this.req.getParameter("BookPageFormChanged");
        if (formChanged.equals("true") || bookObjectTypeFormChanged.equals("true")) {
            RBSUtil.getAssignedPages(bookInfo, this.req);
            RBSBook rbsBook = new RBSBook(bookInfo.getContextOE());
            try {
                rbsBook.setTargetObjectType(bookInfo.getAssignedObjectTypes());
                rbsBook.setPageMembership(bookInfo.getAssignedPages());
                RBSRights[] rights = FwUtils.getPagesRights(bookInfo.getAssignedPages(), this.treeOE);
                rbsBook.setRights(rights);
                String dynamicGroupSearchType = FwUtils.getDynamicSearchType(this.context);
                rbsBook.setContentMembership(rbsBook.getContentMembership(), dynamicGroupSearchType);
                rbsBook.update();
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "ModifyBookPageList", this.context));
                this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "GetBookName.ADD_PAGE_RBSBOOK", this.context));
            }
            catch (Exception e) {
                D.log(e);
                eMFrameUtils.setErrorMessage(e, this.context);
                return false;
            }
        } else {
            this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "ModifyBookPageList", this.context));
            this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "GetBookName.NO_UPDATE_PAGE_RBSBOOK", this.context));
        }
        return true;
    }
}

