/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.AdminNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.BookInfo;
import com.novell.emframe.fw.BookRoleInfo;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.RBSUtil;
import com.novell.rbs.RBSBook;
import com.novell.rbs.RBSRole;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class ModifyBookRoleAssignmentTask
extends Task {
    private static final long serialVersionUID = 1L;
    private HttpServletRequest req;
    private TaskContext context;
    private Properties resultStrings;
    private AdminNamespace namespace;
    private ObjectEntry treeOE;

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        FwUtils.verifyRbsInstalled(req, sServiceName);
    }

    @Override
    public boolean execute(TaskContext context, Properties resultStrings) {
        this.context = context;
        this.resultStrings = resultStrings;
        this.req = context.getRequest();
        this.treeOE = RBSUtil.getTreeOE(context);
        this.namespace = this.treeOE.getAdminNamespace();
        String nextState = this.req.getParameter("nextState");
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("showBookRoleAssignment")) {
            return this.showBookRoleAssignment();
        }
        if (nextState.equalsIgnoreCase("saveBookRoleAssignment")) {
            return this.saveBookRoleAssignment();
        }
        return this.showInitialForm();
    }

    private boolean showInitialForm() {
        this.resultStrings.put("DisplayNameTitle", eMFrameUtils.getLocalizedString("FwResources", "ModifyBookRoleAssignment", this.context));
        this.resultStrings.put("Merge.Template", "fw.ModifyBookRoleAssignment");
        this.resultStrings.put("Next.State", "showBookRoleAssignment");
        return true;
    }

    private boolean showBookRoleAssignment() {
        String bookDisplayName;
        BookInfo bookInfo = new BookInfo();
        String selectedContext = this.req.getParameter("BookName");
        String[] strings = eMFrameUtils.unpack(selectedContext, this.context);
        selectedContext = strings[0];
        try {
            ObjectEntry bookOE = this.namespace.getObjectEntry(this.treeOE, selectedContext);
            bookInfo.setContextOE(bookOE);
            bookInfo.setContext(selectedContext);
            bookDisplayName = RBSUtil.getLocalizedDisplayName(this.context, bookOE);
            String objectType = bookOE.getObjectType().getName();
            if (!objectType.equals("rbsBook2")) {
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "Error", this.context));
                this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "GetBookName.WrongClass", this.context));
                return false;
            }
            this.context.addToHistory(bookOE);
            RBSBook rbsBook = new RBSBook(bookOE);
            RBSRole[] rbsRoles = rbsBook.getContentMembership();
            BookRoleInfo[] bookAssignedRoleInfo = RBSUtil.readAssignedRoleInfo(rbsRoles, this.namespace, this.context);
            bookInfo.setAssignedRoles(bookAssignedRoleInfo);
            BookRoleInfo[] bookAvailableRoleInfo = RBSUtil.readAvailableRoles(bookInfo, this.treeOE, this.context);
            bookInfo.setAvailableRoles(bookAvailableRoleInfo);
        }
        catch (Exception e) {
            D.log(e);
            eMFrameUtils.setErrorMessage(e, this.context);
            return false;
        }
        bookInfo.setAvailableRoles(RBSUtil.removeAssignedRolesFromAvailableRoles(bookInfo.getAvailableRoles(), bookInfo.getAssignedRoles()));
        RBSUtil.putAvailableRoles(bookInfo, this.resultStrings);
        RBSUtil.putAssignedRoles(bookInfo, this.resultStrings);
        this.resultStrings.put("BookName_Value", bookDisplayName);
        this.context.setAuthAttribute("BookInfo", bookInfo);
        return true;
    }

    private boolean saveBookRoleAssignment() {
        this.resultStrings.put("TaskAfterGenConf", "fw.HomePage");
        this.resultStrings.put("MergeAfterGenConf", "fw.HomePage");
        BookInfo bookInfo = (BookInfo)this.context.getAuthAttribute("BookInfo");
        String formChanged = this.req.getParameter("BookRoleFormChanged");
        if (formChanged.equals("true")) {
            RBSUtil.getAssignedRoles(bookInfo, this.req);
            RBSBook rbsBook = new RBSBook(bookInfo.getContextOE());
            try {
                BookRoleInfo[] roleList = bookInfo.getAssignedRoles();
                RBSRole[] roles = null;
                if (roleList != null && roleList.length > 0) {
                    roles = new RBSRole[roleList.length];
                    for (int i = 0; i < roleList.length; ++i) {
                        String roleName = roleList[i].getFullName();
                        ObjectEntry roleOE = this.namespace.getObjectEntry(roleName + this.treeOE.getName());
                        roles[i] = new RBSRole(roleOE);
                    }
                }
                String dynamicGroupSearchType = FwUtils.getDynamicSearchType(this.context);
                rbsBook.setContentMembership(roles, dynamicGroupSearchType);
                rbsBook.update();
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "ModifyBookPageList", this.context));
                this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "GetBookName.ADD_PAGE_RBSBOOK", this.context));
            }
            catch (Exception e) {
                D.log(e);
                eMFrameUtils.setErrorMessage(e, this.context);
                return false;
            }
        } else {
            this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "ModifyBookPageList", this.context));
            this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "GetBookName.NO_UPDATE_PAGE_RBSBOOK", this.context));
        }
        return true;
    }
}

