/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.AdminNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.RBSUtil;
import com.novell.emframe.fw.RoleData;
import com.novell.emframe.fw.VersionInfo;
import com.novell.emframe.fw.iManager;
import com.novell.rbs.RBSCategory;
import com.novell.rbs.RBSCollection;
import com.novell.rbs.RBSRole;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class ModifyCategoryRoleAssignment
extends Task {
    private static final long serialVersionUID = 1L;
    private HttpServletRequest m_req;
    private TaskContext m_context;
    private Properties m_resultStrings;
    private AdminNamespace m_ns;
    private ObjectEntry m_treeOE;
    private ArrayList m_availableRoleList = new ArrayList();
    private ArrayList m_assignedRoleList = new ArrayList();
    private ObjectEntry m_categoryOE;

    @Override
    public boolean execute(TaskContext context, Properties resultStrings) {
        this.m_context = context;
        this.m_resultStrings = resultStrings;
        this.m_req = context.getRequest();
        this.m_treeOE = RBSUtil.getTreeOE(this.m_context);
        this.m_ns = this.m_treeOE.getAdminNamespace();
        String nextState = this.m_req.getParameter("nextState");
        if (nextState.equalsIgnoreCase("showCategoryRoleAssignment")) {
            return this.showCategoryRoleAssignment();
        }
        if (nextState.equalsIgnoreCase("saveCategoryRoleAssignment")) {
            return this.saveCategoryRoleAssignment();
        }
        return false;
    }

    private boolean showCategoryRoleAssignment() {
        block14: {
            String selectedCollectionName = this.m_req.getParameter("selectedCollectionName");
            String[] strings = eMFrameUtils.unpack(selectedCollectionName, this.m_context);
            selectedCollectionName = strings[0];
            String categoryName = this.m_req.getParameter("CategoryName");
            strings = eMFrameUtils.unpack(categoryName, this.m_context);
            categoryName = strings[0];
            try {
                ObjectEntry collectionOE;
                RBSCollection rbsCollection;
                RBSRole[] rbsRole;
                this.m_categoryOE = this.m_ns.getObjectEntry(this.m_treeOE, categoryName);
                String categoryDisplayName = RBSUtil.getLocalizedDisplayName(this.m_context, this.m_categoryOE);
                this.m_resultStrings.put("CategoryDisplayName", categoryDisplayName);
                RBSCategory rbsCategory = new RBSCategory(this.m_categoryOE);
                ObjectEntry[] roleOEs = rbsCategory.getRoleMembers();
                if (roleOEs != null) {
                    for (int i = 0; i < roleOEs.length; ++i) {
                        RBSRole rbsRole2 = new RBSRole(roleOEs[i]);
                        ObjectEntry roleOE = rbsRole2.getObjectEntry();
                        String roleName = RBSUtil.getLocalizedDisplayName(this.m_context, rbsRole2.getObjectEntry());
                        String roleFDN = this.m_ns.getUnrootedName(roleOE);
                        String roleDesc = null;
                        try {
                            roleDesc = rbsRole2.getDescription();
                            if (roleDesc == null) {
                                roleDesc = eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.NO_DESCRIPTION", this.m_context.getLocale());
                            }
                        }
                        catch (Exception exc) {
                            roleDesc = "";
                        }
                        RoleData roleData = new RoleData(roleFDN, roleName, "", "", "", roleDesc, "", "", "");
                        this.m_assignedRoleList.add(roleData);
                    }
                }
                if ((rbsRole = (rbsCollection = new RBSCollection(collectionOE = this.m_ns.getObjectEntry(this.m_treeOE, selectedCollectionName))).getSpecifiedRoles(new String[]{"iManager"})) == null) break block14;
                for (int i = 0; i < rbsRole.length; ++i) {
                    VersionInfo iManagerVersionInfo;
                    VersionInfo expiredVersionInfo;
                    boolean add = true;
                    ObjectEntry roleOE = rbsRole[i].getObjectEntry();
                    String roleFDN = this.m_ns.getUnrootedName(roleOE);
                    boolean found = false;
                    if (this.m_assignedRoleList.size() > 0) {
                        for (int j = 0; j < this.m_assignedRoleList.size(); ++j) {
                            RoleData roleData = (RoleData)this.m_assignedRoleList.get(j);
                            if (!roleData.getObjectFDN().equalsIgnoreCase(roleFDN)) continue;
                            found = true;
                            break;
                        }
                    }
                    if (found) continue;
                    String roleName = RBSUtil.getLocalizedDisplayName(this.m_context, roleOE);
                    String roleDesc = null;
                    try {
                        roleDesc = rbsRole[i].getDescription();
                        if (roleDesc == null) {
                            roleDesc = eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.NO_DESCRIPTION", this.m_context.getLocale());
                        }
                    }
                    catch (Exception exc) {
                        roleDesc = "";
                    }
                    String parameters = rbsRole[i].getParameters();
                    String expiredVersion = RBSUtil.getKeyFromParameters(parameters, "expired-version");
                    if (expiredVersion != null && (expiredVersionInfo = new VersionInfo(expiredVersion)).compareTo(iManagerVersionInfo = new VersionInfo(iManager.getVersionString())) <= 0) {
                        add = false;
                    }
                    if (!add) continue;
                    RoleData roleData = new RoleData(roleFDN, roleName, "", "", "", roleDesc, "", "", "");
                    this.m_availableRoleList.add(roleData);
                }
            }
            catch (Exception e) {
                D.log(e);
                eMFrameUtils.setErrorMessage(e, this.m_context);
                return false;
            }
        }
        this.putAvailableRoles();
        this.putAssignedRoles();
        return true;
    }

    private boolean saveCategoryRoleAssignment() {
        this.m_resultStrings.put("TaskAfterGenConf", "fw.HomePage");
        this.m_resultStrings.put("MergeAfterGenConf", "fw.HomePage");
        String formChanged = this.m_req.getParameter("CategoryRoleFormChanged");
        if (formChanged.equals("true")) {
            this.getAssignedRoles();
            RBSCategory rbsCategory = new RBSCategory(this.m_categoryOE);
            try {
                if (this.m_assignedRoleList.size() > 0) {
                    ObjectEntry[] roleOEs = new ObjectEntry[this.m_assignedRoleList.size()];
                    for (int i = 0; i < this.m_assignedRoleList.size(); ++i) {
                        RoleData roleData = (RoleData)this.m_assignedRoleList.get(i);
                        roleOEs[i] = this.m_ns.getObjectEntry(this.m_treeOE, roleData.getObjectFDN());
                    }
                    rbsCategory.setRoleMembers(roleOEs);
                } else {
                    rbsCategory.setRoleMembers(null);
                }
                rbsCategory.update();
                FwUtils.refreshCRTCategories(this.m_context);
                this.m_resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "ModifyTaskRoleAssignment", this.m_context.getLocale()));
                this.m_resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "CreateCategory.Modified", this.m_context.getLocale()));
            }
            catch (Exception e) {
                D.log(e);
                eMFrameUtils.setErrorMessage(e, this.m_context);
                return false;
            }
        } else {
            this.m_resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "ModifyTaskRoleAssignment", this.m_context.getLocale()));
            this.m_resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "GetBookName.NO_UPDATE_PAGE_RBSBOOK", this.m_context.getLocale()));
        }
        return true;
    }

    private void putAvailableRoles() {
        this.m_resultStrings.put("AvailableRole.Count", Integer.toString(this.m_availableRoleList.size()));
        for (int i = 0; i < this.m_availableRoleList.size(); ++i) {
            RoleData roleData = (RoleData)this.m_availableRoleList.get(i);
            this.m_resultStrings.put("AvailableRoles." + i + ".ShortName", roleData.getDisplayName());
            this.m_resultStrings.put("AvailableRoles." + i + ".FullName", roleData.getObjectFDN());
            this.m_resultStrings.put("AvailableRoles." + i + ".Description", roleData.getRoleDesc());
        }
    }

    private void putAssignedRoles() {
        this.m_resultStrings.put("AssignedRole.Count", Integer.toString(this.m_assignedRoleList.size()));
        for (int i = 0; i < this.m_assignedRoleList.size(); ++i) {
            RoleData roleData = (RoleData)this.m_assignedRoleList.get(i);
            this.m_resultStrings.put("AssignedRoles." + i + ".ShortName", roleData.getDisplayName());
            this.m_resultStrings.put("AssignedRoles." + i + ".FullName", roleData.getObjectFDN());
            this.m_resultStrings.put("AssignedRoles." + i + ".Description", roleData.getRoleDesc());
        }
    }

    private void getAssignedRoles() {
        this.m_assignedRoleList.clear();
        String assignedRoleFullName = this.m_req.getParameter("AssignedRoleFullName");
        String assignedRoleShortName = this.m_req.getParameter("AssignedRoleShortName");
        String assignedRoleDescription = this.m_req.getParameter("AssignedRoleDescription");
        StringTokenizer fullNameTokenizer = new StringTokenizer(assignedRoleFullName, ";");
        StringTokenizer shortNameTokenizer = new StringTokenizer(assignedRoleShortName, ";");
        StringTokenizer descriptionTokenizer = new StringTokenizer(assignedRoleDescription, ";");
        if (fullNameTokenizer.countTokens() == shortNameTokenizer.countTokens() && fullNameTokenizer.countTokens() == descriptionTokenizer.countTokens() && shortNameTokenizer.countTokens() == descriptionTokenizer.countTokens() && shortNameTokenizer.countTokens() > 0) {
            while (shortNameTokenizer.hasMoreTokens()) {
                RoleData roleData = new RoleData();
                roleData.setDisplayName(eMFrameUtils.urlDecode(shortNameTokenizer.nextToken(), this.m_req.getCharacterEncoding()));
                roleData.setObjectFDN(eMFrameUtils.urlDecode(fullNameTokenizer.nextToken(), this.m_req.getCharacterEncoding()));
                roleData.setRoleDesc(eMFrameUtils.urlDecode(descriptionTokenizer.nextToken(), this.m_req.getCharacterEncoding()));
                this.m_assignedRoleList.add(roleData);
            }
        }
    }
}

