/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.NamespaceException;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.RBSUtil;
import com.novell.rbs.RBSObject;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class ModifyRBSObjectDescriptionTask
extends Task {
    private static final long serialVersionUID = 1L;
    public static final String HTMLPARAM_RBSOBJECTNAME = "ModifyRBSObjectDescriptionName";
    public static final String HTMLPARAM_DESCRIPTIONCHANGED = "ModifyRBSObjectDescriptionChanged";
    public static final String HTMLPARAM_DESCRIPTION = "ModifyRBSObjectDescription";
    public static final String HTMLPARAM_CHANGEDRBSOBJECTDESCRIPTION = "ChangedRBSObjectDescription";
    private HttpServletRequest req;
    private TaskContext context;
    private Properties resultStrings;
    private String strException = "";
    private ObjectEntry m_treeOE;
    private AdminNamespace m_ns;
    private String localizedDisplayName;

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        FwUtils.verifyRbsInstalled(req, sServiceName);
    }

    @Override
    public boolean execute(TaskContext context, Properties resultStrings) {
        this.context = context;
        this.resultStrings = resultStrings;
        this.req = context.getRequest();
        this.m_treeOE = RBSUtil.getTreeOE(context);
        this.m_ns = this.m_treeOE.getAdminNamespace();
        String nextState = this.req.getParameter("nextState");
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("showModifyForm")) {
            return this.showModifyForm();
        }
        if (nextState.equalsIgnoreCase("doModifications")) {
            return this.doModifications();
        }
        return this.showInitialForm();
    }

    private boolean showInitialForm() {
        return true;
    }

    private boolean showModifyForm() {
        String bookName;
        String sRBSObjectName = this.req.getParameter(HTMLPARAM_RBSOBJECTNAME);
        String[] strings = eMFrameUtils.unpack(sRBSObjectName, this.context);
        sRBSObjectName = strings[0];
        boolean isRBSObject = false;
        this.resultStrings.put(HTMLPARAM_RBSOBJECTNAME, sRBSObjectName);
        ObjectEntry rbsObjectOE = null;
        try {
            rbsObjectOE = this.m_ns.getObjectEntry(this.m_treeOE, sRBSObjectName);
        }
        catch (SPIException e) {
            D.log(e);
            this.strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.context);
            this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "Error", this.context));
            this.resultStrings.put("GeneralMsg.MsgBody", this.strException);
            return false;
        }
        String rbsObjectTypeName = rbsObjectOE.getObjectType().getName();
        if (rbsObjectTypeName.equals("rbsCollection2")) {
            this.localizedDisplayName = RBSUtil.getLocalizedDisplayName(this.context, rbsObjectOE);
            this.resultStrings.put("LocalizedDisplayName", this.localizedDisplayName);
            String collectionName = eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.MODIFY_DESCRIPTION_COLLECTION", this.context);
            this.resultStrings.put("RBSObjectTypeDispalyName", collectionName);
            isRBSObject = true;
        } else if (rbsObjectTypeName.equals("rbsRole2")) {
            this.localizedDisplayName = RBSUtil.getLocalizedDisplayName(this.context, rbsObjectOE);
            this.resultStrings.put("LocalizedDisplayName", this.localizedDisplayName);
            String roleName = eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.MODIFY_DESCRIPTION_ROLE", this.context);
            this.resultStrings.put("RBSObjectTypeDispalyName", roleName);
            isRBSObject = true;
        } else if (rbsObjectTypeName.equals("rbsModule2")) {
            this.localizedDisplayName = RBSUtil.getLocalizedModuleDisplayName(this.context, rbsObjectOE.getName());
            this.resultStrings.put("LocalizedDisplayName", this.localizedDisplayName);
            String moduleName = eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.MODIFY_DESCRIPTION_MODULE", this.context);
            this.resultStrings.put("RBSObjectTypeDispalyName", moduleName);
            isRBSObject = true;
        } else if (rbsObjectTypeName.equals("rbsTask2")) {
            this.localizedDisplayName = RBSUtil.getLocalizedDisplayName(this.context, rbsObjectOE);
            this.resultStrings.put("LocalizedDisplayName", this.localizedDisplayName);
            String taskName = eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.MODIFY_DESCRIPTION_TASK", this.context);
            this.resultStrings.put("RBSObjectTypeDispalyName", taskName);
            isRBSObject = true;
        } else if (rbsObjectTypeName.equals("rbsBook2")) {
            this.localizedDisplayName = RBSUtil.getLocalizedDisplayName(this.context, rbsObjectOE);
            this.resultStrings.put("LocalizedDisplayName", this.localizedDisplayName);
            bookName = eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.MODIFY_DESCRIPTION_BOOK", this.context);
            this.resultStrings.put("RBSObjectTypeDispalyName", bookName);
            isRBSObject = true;
        } else if (rbsObjectTypeName.equals("rbsCategory2")) {
            this.localizedDisplayName = RBSUtil.getLocalizedDisplayName(this.context, rbsObjectOE);
            this.resultStrings.put("LocalizedDisplayName", this.localizedDisplayName);
            bookName = eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.MODIFY_DESCRIPTION_CATEGORY", this.context);
            this.resultStrings.put("RBSObjectTypeDispalyName", bookName);
            isRBSObject = true;
        }
        if (!isRBSObject) {
            this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("BaseResources", "ModifyRBSObjectDescription.Title", this.context));
            this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("BaseResources", "ModifyRBSObjectDescription.NotRBSObject", this.context) + sRBSObjectName);
            return false;
        }
        this.context.addToHistory(rbsObjectOE);
        RBSObject rbsObject = new RBSObject(rbsObjectOE);
        try {
            String description = rbsObject.getDescription();
            if (description != null) {
                this.resultStrings.put("RBSObject.ModifyDescription", description);
            } else {
                this.resultStrings.put("RBSObject.ModifyDescription", "");
            }
        }
        catch (SPIException e) {
            D.log(e);
            this.strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.context);
            this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "Error", this.context));
            this.resultStrings.put("GeneralMsg.MsgBody", this.strException);
            return false;
        }
        catch (NamespaceException e) {
            D.log(e);
            this.strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.context);
            this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "Error", this.context));
            this.resultStrings.put("GeneralMsg.MsgBody", this.strException);
            return false;
        }
        return true;
    }

    private boolean doModifications() {
        ObjectEntry rbsObjectOE = null;
        String strRBSObjectName = this.req.getParameter(HTMLPARAM_RBSOBJECTNAME);
        try {
            rbsObjectOE = this.m_ns.getObjectEntry(this.m_treeOE, strRBSObjectName);
        }
        catch (SPIException e) {
            return false;
        }
        String strDescription = this.req.getParameter(HTMLPARAM_CHANGEDRBSOBJECTDESCRIPTION);
        String strDescriptionChanged = this.req.getParameter(HTMLPARAM_DESCRIPTIONCHANGED);
        boolean bDescriptionChanged = false;
        if (null == strDescriptionChanged || !strDescriptionChanged.equals("true")) {
            return false;
        }
        bDescriptionChanged = true;
        if (strDescription.length() > 1024) {
            strDescription = strDescription.substring(0, 1024);
        }
        String[] attrs = new String[]{"Description"};
        String[] attrVals = new String[attrs.length];
        attrVals[0] = strDescription;
        try {
            if (bDescriptionChanged) {
                DirUtils.attributeWriter(rbsObjectOE, attrs, attrVals);
            }
        }
        catch (SPIException e) {
            D.log(e);
            this.strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.context);
            this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "Error", this.context));
            this.resultStrings.put("GeneralMsg.MsgBody", this.strException);
            return false;
        }
        catch (NamespaceException e) {
            D.log(e);
            this.strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.context);
            this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "Error", this.context));
            this.resultStrings.put("GeneralMsg.MsgBody", this.strException);
            return false;
        }
        catch (SnapinVetoException e) {
            D.log(e);
            this.strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.context);
            this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "Error", this.context));
            this.resultStrings.put("GeneralMsg.MsgBody", this.strException);
            return false;
        }
        catch (ComponentCreationException e) {
            D.log(e);
            this.strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.context);
            this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "Error", this.context));
            this.resultStrings.put("GeneralMsg.MsgBody", this.strException);
            return false;
        }
        String strTitle = eMFrameUtils.getLocalizedString("BaseResources", "ModifyRBSObjectDescription.Title", this.context);
        String strBody = eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("BaseResources", "ModifyRBSObjectDescription.Success", this.context), new String[]{this.localizedDisplayName});
        eMFrameUtils.setMessage("success", strTitle, strBody, this.context);
        return true;
    }
}

