/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.RBSUtil;
import com.novell.emframe.fw.Registry;
import com.novell.rbs.RBSObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class ModifyRBSObjectTargetChooserMode
extends Task {
    private static final long serialVersionUID = 1L;
    public static final String HTMLPARAM_RBSOBJECTNAME = "ModifyRBSObjectDescriptionName";
    public static final String HTMLPARAM_DESCRIPTIONCHANGED = "ModifyRBSObjectDescriptionChanged";
    public static final String HTMLPARAM_DESCRIPTION = "ModifyRBSObjectDescription";
    public static final String HTMLPARAM_CHANGEDRBSOBJECTDESCRIPTION = "ChangedRBSObjectDescription";
    private HttpServletRequest req;
    private TaskContext context;
    private Properties resultStrings;
    private String strException = "";
    private ObjectEntry m_treeOE;
    private AdminNamespace m_ns;
    private String localizedDisplayName;

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        FwUtils.verifyRbsInstalled(req, sServiceName);
    }

    @Override
    public boolean execute(TaskContext context, Properties resultStrings) {
        this.context = context;
        this.resultStrings = resultStrings;
        this.req = context.getRequest();
        this.m_treeOE = RBSUtil.getTreeOE(context);
        this.m_ns = this.m_treeOE.getAdminNamespace();
        String nextState = this.req.getParameter("nextState");
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("showTargetChooserMode")) {
            return this.showModifyForm();
        }
        if (nextState.equalsIgnoreCase("doModifications")) {
            return this.doModifications();
        }
        return this.showInitialForm();
    }

    private boolean showInitialForm() {
        return true;
    }

    private boolean showModifyForm() {
        String bookName;
        String sRBSObjectName = this.req.getParameter(HTMLPARAM_RBSOBJECTNAME);
        String[] strings = eMFrameUtils.unpack(sRBSObjectName, this.context);
        sRBSObjectName = strings[0];
        boolean isRBSObject = false;
        this.resultStrings.put(HTMLPARAM_RBSOBJECTNAME, sRBSObjectName);
        ObjectEntry rbsObjectOE = null;
        try {
            rbsObjectOE = this.m_ns.getObjectEntry(this.m_treeOE, sRBSObjectName);
        }
        catch (SPIException e) {
            D.log(e);
            this.strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.context);
            this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "Error", this.context));
            this.resultStrings.put("GeneralMsg.MsgBody", this.strException);
            return false;
        }
        String rbsObjectTypeName = rbsObjectOE.getObjectType().getName();
        if (rbsObjectTypeName.equals("rbsCollection2")) {
            this.localizedDisplayName = RBSUtil.getLocalizedDisplayName(this.context, rbsObjectOE);
            this.resultStrings.put("LocalizedDisplayName", this.localizedDisplayName);
            String collectionName = eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.MODIFY_DESCRIPTION_COLLECTION", this.context);
            this.resultStrings.put("RBSObjectTypeDispalyName", collectionName);
            isRBSObject = true;
        } else if (rbsObjectTypeName.equals("rbsRole2")) {
            this.localizedDisplayName = RBSUtil.getLocalizedDisplayName(this.context, rbsObjectOE);
            this.resultStrings.put("LocalizedDisplayName", this.localizedDisplayName);
            String roleName = eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.MODIFY_DESCRIPTION_ROLE", this.context);
            this.resultStrings.put("RBSObjectTypeDispalyName", roleName);
            isRBSObject = true;
        } else if (rbsObjectTypeName.equals("rbsModule2")) {
            this.localizedDisplayName = RBSUtil.getLocalizedModuleDisplayName(this.context, rbsObjectOE.getName());
            this.resultStrings.put("LocalizedDisplayName", this.localizedDisplayName);
            String moduleName = eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.MODIFY_DESCRIPTION_MODULE", this.context);
            this.resultStrings.put("RBSObjectTypeDispalyName", moduleName);
            isRBSObject = true;
        } else if (rbsObjectTypeName.equals("rbsTask2")) {
            this.localizedDisplayName = RBSUtil.getLocalizedDisplayName(this.context, rbsObjectOE);
            this.resultStrings.put("LocalizedDisplayName", this.localizedDisplayName);
            String taskName = eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.MODIFY_DESCRIPTION_TASK", this.context);
            this.resultStrings.put("RBSObjectTypeDispalyName", taskName);
            isRBSObject = true;
        } else if (rbsObjectTypeName.equals("rbsBook2")) {
            this.localizedDisplayName = RBSUtil.getLocalizedDisplayName(this.context, rbsObjectOE);
            this.resultStrings.put("LocalizedDisplayName", this.localizedDisplayName);
            bookName = eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.MODIFY_DESCRIPTION_BOOK", this.context);
            this.resultStrings.put("RBSObjectTypeDispalyName", bookName);
            isRBSObject = true;
        } else if (rbsObjectTypeName.equals("rbsCategory2")) {
            this.localizedDisplayName = RBSUtil.getLocalizedDisplayName(this.context, rbsObjectOE);
            this.resultStrings.put("LocalizedDisplayName", this.localizedDisplayName);
            bookName = eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.MODIFY_DESCRIPTION_CATEGORY", this.context);
            this.resultStrings.put("RBSObjectTypeDispalyName", bookName);
            isRBSObject = true;
        }
        if (!isRBSObject) {
            this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("BaseResources", "ModifyRBSObjectDescription.Title", this.context));
            this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("BaseResources", "ModifyRBSObjectDescription.NotRBSObject", this.context) + sRBSObjectName);
            return false;
        }
        this.context.addToHistory(rbsObjectOE);
        RBSObject rbsObject = new RBSObject(rbsObjectOE);
        try {
            String[] attrs;
            String[] val;
            Document doc = Registry.parseXMLFile(new File(eMFrameUtils.getModulesBasePath() + File.separator + "base" + File.separator + "install" + File.separator + "iManager.xml"));
            Element root = doc.getRootElement();
            String strType = root.getName();
            List books = root.getChildren("book");
            Iterator i = books.iterator();
            boolean found = false;
            boolean bookfound = false;
            String tcMode = null;
            while (i.hasNext()) {
                Element book = (Element)i.next();
                Element id = book.getChild("id");
                if (id.getTextTrim().equals(RBSUtil.getModuleDisplayName(this.context, rbsObjectOE))) {
                    bookfound = true;
                    List url_params = book.getChildren("url-param");
                    if (url_params != null) {
                        for (Element url_param : url_params) {
                            Element param_key = url_param.getChild("param-key");
                            if (!param_key.getTextTrim().equals("TC.mode")) continue;
                            found = true;
                            Element param_value = url_param.getChild("param-value");
                            tcMode = param_value.getTextTrim();
                            if (tcMode != null) break;
                            tcMode = "single";
                            break;
                        }
                    }
                }
                if (!found) continue;
                break;
            }
            if (!bookfound && (val = DirUtils.attributeReader(rbsObjectOE, attrs = new String[]{"rbsParameters"}))[0].lastIndexOf("TC.mode=") != -1) {
                int index = val[0].lastIndexOf("TC.mode=");
                int index1 = val[0].indexOf(";", index + 8);
                tcMode = index1 != -1 ? val[0].substring(index + 8, index1) : val[0].substring(index + 8);
            }
            if (tcMode == null) {
                tcMode = "single";
            }
            this.req.setAttribute("tcvalue", (Object)tcMode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private boolean doModifications() {
        ObjectEntry rbsObjectOE = null;
        String strRBSObjectName = this.req.getParameter(HTMLPARAM_RBSOBJECTNAME);
        try {
            rbsObjectOE = this.m_ns.getObjectEntry(this.m_treeOE, strRBSObjectName);
        }
        catch (SPIException e) {
            return false;
        }
        try {
            String tcMode = this.req.getParameter("defaultTcMode");
            if (tcMode == null) {
                tcMode = "single";
            }
            Document doc = Registry.parseXMLFile(new File(eMFrameUtils.getModulesBasePath() + File.separator + "base" + File.separator + "install" + File.separator + "iManager.xml"));
            Element root = doc.getRootElement();
            String strType = root.getName();
            List books = root.getChildren("book");
            boolean found = false;
            boolean bookfound = false;
            for (Element book : books) {
                Element id = book.getChild("id");
                if (!id.getTextTrim().equals(RBSUtil.getModuleDisplayName(this.context, rbsObjectOE))) continue;
                bookfound = true;
                List url_params = book.getChildren("url-param");
                if (url_params != null) {
                    for (Element url_param : url_params) {
                        Element param_key = url_param.getChild("param-key");
                        if (!param_key.getTextTrim().equals("TC.mode")) continue;
                        found = true;
                        Element param_value = url_param.getChild("param-value");
                        param_value.setText(tcMode);
                        XMLOutputter fmt = new XMLOutputter(" ", true);
                        fmt.output(doc, (OutputStream)System.out);
                        File outputFile = new File(eMFrameUtils.getModulesBasePath() + File.separator + "base" + File.separator + "install" + File.separator + "iManager.xml");
                        FileOutputStream out = new FileOutputStream(outputFile);
                        fmt.output(doc, (OutputStream)out);
                        out.flush();
                        out.close();
                        break;
                    }
                }
                if (found) continue;
                Element url_param = new Element("url-param");
                Element param_key = new Element("param-key");
                param_key.setText("TC.mode");
                Element param_value = new Element("param-value");
                param_value.setText(tcMode);
                url_param.addContent(param_key).addContent(param_value);
                book.addContent(url_param);
                XMLOutputter fmt = new XMLOutputter(" ", true);
                fmt.output(doc, (OutputStream)System.out);
                File outputFile = new File(eMFrameUtils.getModulesBasePath() + File.separator + "base" + File.separator + "install" + File.separator + "iManager.xml");
                FileOutputStream out = new FileOutputStream(outputFile);
                fmt.output(doc, (OutputStream)out);
                out.flush();
                out.close();
                break;
            }
            if (!bookfound) {
                String completetc = "TC.mode=" + tcMode;
                String[] attrs = new String[]{"rbsParameters"};
                String[] attrVals = new String[attrs.length];
                String[] val = DirUtils.attributeReader(rbsObjectOE, attrs);
                attrVals[0] = val[0] + ";" + completetc;
                DirUtils.attributeWriter(rbsObjectOE, attrs, attrVals);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        String strTitle = eMFrameUtils.getLocalizedString("BaseResources", "ModifyRBSObjectDescription.Title", this.context);
        String strBody = eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("BaseResources", "ModifyRBSObjectDescription.Success", this.context), new String[]{this.localizedDisplayName});
        eMFrameUtils.setMessage("success", strTitle, strBody, this.context);
        return true;
    }
}

